// /home/tarai/Projects/gsaw/gsaw/RenderingJob.cs created with MonoDevelop
// User: tarai at 15:56 2008/05/24
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation.Processor {
	using Holo.Image;
	
	public class CompositeJob {
		public enum JobStatus {
			Finished, Pending, Aborted
		};
		public delegate void JobEventHandler(CompositeJob job);		

		private ISurfaceIterator[] inputIterators;
		private ISurfaceIterator dest;
		private double opacity;
		private int x, y;
		private int w, h;
		private CompositeOperation.CompositeOperator opr;
		private int dependantCount;
		private JobEventHandler onFinishJob;
		private JobEventHandler onAvailable;
		private bool onTopOfSurface;
		
		public JobEventHandler OnFinishJob {
			get { return onFinishJob; }
			set { onFinishJob = value; }
		}
		
		public JobEventHandler OnAvailable {
			get { return onAvailable; }
			set { onAvailable = value; }
		}
		
		public int Amount {
			get {
				return dest.Raster.PixelStride * w * h;
			}
		}
		
		public CompositeJob(CompositeOperation.CompositeOperator opr, ISurfaceIterator src, ISurfaceIterator aux,
		                    ISurfaceIterator mask, ISurfaceIterator dest, int x, int y, int w, int h, double opacity) {
			if (mask != null) {
				inputIterators = new ISurfaceIterator[3];
				inputIterators[0] = src;
				inputIterators[1] = aux;
				inputIterators[2] = mask;
			} else {
				inputIterators = new ISurfaceIterator[2];
				inputIterators[0] = src;
				inputIterators[1] = aux;
			}
			this.dest = dest;
			this.x = x;
			this.y = y;
			this.w = w;
			this.h = h;
			this.opacity = opacity;
			this.opr = opr;
			dependantCount = 0;
			onTopOfSurface = true;
		}
		
		
		private void OnFinish(CompositeJob job) {
			lock(this) {
				dependantCount --;
				if (dependantCount == 0 && onAvailable != null)
					onAvailable(this);
			}
		}
		
		
		public bool ConstructDependencyChain(CompositeJob job) {
			bool result = false;
			if (!job.onTopOfSurface)
				return false;
			lock(this) {
				result = x < job.x + job.w && y < job.y + job.h &&
					x + w > job.x && y + h > job.y;
				
				if (result) {
//					Console.WriteLine("{0}: depend on {1}",id, job.id);
					dependantCount ++;
					lock(job) {
						job.onFinishJob += OnFinish;
					}
				}
				
				if (x <= job.x && y <= job.y &&
				    x + w >= job.x + job.w && y + h >= job.y + job.h) {
					job.onTopOfSurface = false;
				}
			}
			return result;
		}

		
		private int ReadyThenLock() {
			lock(this) {
				bool ready = dependantCount == 0;
				if (ready) {
					dependantCount --;
				}
			}
			return dependantCount;
		}
		
		public bool Available {
			get { lock(this) { return dependantCount == 0; } }
		}
		
		public JobStatus Run(object context) {
			int locked = ReadyThenLock();
			if (locked == -1) {
//				Console.WriteLine("{4}:Run {0},{1}, {2},{3}", x/64, y/64, w/64, h/64, context);
				if (inputIterators.Length == 3)
					opr(inputIterators[0], inputIterators[1], inputIterators[2], dest, w, h, opacity);
				else
					opr(inputIterators[0], inputIterators[1], null, dest, w, h, opacity);
				
				if (onFinishJob != null)
					onFinishJob(this);
				onFinishJob = null;

				return JobStatus.Finished;
			} else if (locked > 0) {
				Console.WriteLine("{4}:Pend {0},{1}, {2},{3}", x/64, y/64, w/64, h/64, context);
//				Console.WriteLine("pend");
				return JobStatus.Pending;
			}
			if (onFinishJob != null)
				onFinishJob(this);
			return JobStatus.Aborted;
		}
		
		public void RunInThread(object context) {
			Run(context);
		}
		
	}
}
