// /home/tarai/Projects/gsaw/gsaw/EraseOperation.cs created with MonoDevelop
// User: tarai at 15:15 2008/05/04
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {
	using Holo.Image;
	
	public class EraseOperation : BasicOperation {
		
		public EraseOperation() {
		}
		
		public void Apply(ISurfaceIterator surfIter, ISurfaceIterator auxIter, ISurfaceIterator maskIter, ISurfaceIterator destIter, 
		                    int w, int h, double opacity) {
			TripleIterator iter = new TripleIterator(auxIter, surfIter, destIter, w);
			bool surfHasAlpha = surfIter.Raster.HasAlpha;
			bool auxHasAlpha  = auxIter.Raster.HasAlpha;
			bool destHasAlpha = destIter.Raster.HasAlpha;
			
//			bool destHasColor = destIter.Raster.HasColorChannels;

			int surfChannels = surfIter.Raster.NumChannels;
			int destChannels = destIter.Raster.NumChannels;
			int auxChannels = auxIter.Raster.NumChannels;
			
			double auxAlpha = 0, surfAlpha = 0;

			// Initial Color Value Setting
			
			// Initial Alpha Value Setting
			if (!surfHasAlpha)
				surfAlpha = surfIter.Raster.PrimaryAlphaValue[0] / 255.0;

			if (!auxHasAlpha)
				auxAlpha = auxIter.Raster.PrimaryAlphaValue[0] * opacity / 255.0;
			

			for (int y = 0; y < h; y ++) {
				for (int x = 0; x < w; x ++) {
					if (auxHasAlpha)
						auxAlpha = iter.src1Pixels[iter.src1Offset + auxChannels - 1] * opacity;
					
					if (surfHasAlpha)
						surfAlpha = iter.src2Pixels[iter.src2Offset + surfChannels - 1];
					
					double alpha = Math.Max(surfAlpha - auxAlpha, 0);

					if (destHasAlpha) {
						iter.destPixels[iter.destOffset + destChannels - 1] = (byte)(alpha + 0.5);
					} else {
						// TBD.
					}
					
					iter.NextX();
				}
				iter.NextY();
			}
		}
		
	}
}