// /home/tarai/Projects/gsaw/gsaw/Surface.cs created with MonoDevelop
// User: tarai at 1:05 2008/04/22
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image {
	
	public delegate void ISurfaceUpdateAreaHandler(int minX, int minY, int maxX, int maxY);
	
	public interface ISurface {
		int OffsetX { get; set; }
		int OffsetY { get; set; }
		int Width { get; }
		int Height { get; }
		int TileWidth { get; }
		int TileHeight { get; }
		IRasterFactory RasterFactory { get; set; }
		
		void MakeRastersReadOnly(int x, int y, int width, int height);
		void MakeRastersWriteable(int x, int y, int width, int height);
		void MakeRastersReadable(int x, int y, int width, int height);
		void FillRasters(int x, int y, int width, int height, byte[] color, byte[] alpha);
		ISurfaceIterator GetIteratorAt(int x, int y);
		void SetRasterAt(ISurfaceIterator iter, IRaster raster);
		void Resize(int width, int height);

		ISurfaceUpdateAreaHandler OnUpdateArea { get; set; }
	}
}
