// /home/tarai/Projects/gsaw/gsaw/Layer.cs created with MonoDevelop
// User: tarai at 23:56 2008/04/22
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image {

	using Holo.Operation;
	using Holo.Image.Generic;
	using Holo.Operation.Processor;
	
	public class Layer {
		private ISurface surface;
		private ISurface mask;
		private CompositeOperation operation;
		private bool visible;
		private string name;
		private bool clipped;
		
		private Image owner;
		
		public ISurface Surface {
			get { return surface; }
		}
		
		public ISurface Mask {
			get { return mask; }
		}
		
		public CompositeOperation Operation {
			get { return operation; }
			set { operation = value; }
		}
		
		public bool Visible {
			get { return visible; }
			set { 
				visible = value; 
				if (surface.OnUpdateArea != null)
					surface.OnUpdateArea(surface.OffsetX, surface.OffsetY, surface.OffsetX + surface.Width, surface.OffsetY + surface.Height);
			}
		}
		
		public bool Clipped {
			get { return clipped; }
			set {
				clipped = value;
				if (surface.OnUpdateArea != null)
					surface.OnUpdateArea(surface.OffsetX, surface.OffsetY, surface.OffsetX + surface.Width, surface.OffsetY + surface.Height);
			}
		}
		
		public string Name {
			get { return name; }
			set { name = value; }
		}
			
		public Layer(Image owner, int x, int y, int width, int height) {
			CompositeOperation operation = new CompositeOperation();
			ISurface surface = new GenericSurface(x, y, width, height, true);
			Initialize(owner, surface, "Layer",operation);
		}
		
		public Layer(Image owner, ISurface surface) {
			CompositeOperation operation = new CompositeOperation();
			Initialize(owner, surface, "Layer", operation);
		}

		private void Initialize(Image owner, ISurface surface, string name, CompositeOperation operation) {
			this.operation = operation;
			this.surface = surface;
			this.owner = owner;
			this.name = name;
			this.visible = true;
			this.clipped = false;
			this.mask = null;
			surface.OnUpdateArea = this.owner.QueueUpdatedArea;
		}
		
		public void ApplyToSurface(ISurface baseSurface) {
			operation.Apply(baseSurface, surface, mask, baseSurface); 
		}

		public void ApplyToSurface(ISurface baseSurface, int minX, int minY, int maxX, int maxY, ISurface clip, JobProcessor processor) {
			if (!visible)
				return;
			
			minX = Math.Max(baseSurface.OffsetX, Math.Max(surface.OffsetX, minX));
			minY = Math.Max(baseSurface.OffsetY, Math.Max(surface.OffsetY, minY));
			maxX = Math.Min(baseSurface.OffsetX + baseSurface.Width, Math.Min(surface.OffsetX + surface.Width, maxX));
			maxY = Math.Min(baseSurface.OffsetY + baseSurface.Height, Math.Min(surface.OffsetY + surface.Height, maxY));
			operation.Apply(baseSurface, surface, (clip != null)? clip: mask, minX, minY, maxX, maxY, baseSurface, processor);
		}
	}
}
