// /home/tarai/Projects/gsaw/gsaw/BlendOperation.cs created with MonoDevelop
// User: tarai at 19:43 2008/04/29
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {
	using Holo.Image;
	
	public class OverOperation : BasicOperation {
		
		public OverOperation() {
		}
		
#if USE_UNSAFE_OPS || USE_EXTERNAL_OPS
		// Faster but unsafe implementation.
		unsafe private void UnsafeOver(byte[] src1Pixels, int src1Offset, int src1RowStride, int src1PixelStride,
						                  bool src1HasAlpha, bool src1HasColor, int src1Channels,
						                  byte[] src1Color, byte src1PrimaryAlpha,
						                  byte[] src2Pixels, int src2Offset, int src2RowStride, int src2PixelStride,
						                  bool src2HasAlpha, bool src2HasColor, int src2Channels,
						                  byte[] src2Color, byte src2PrimaryAlpha,
						                  byte[] destPixels, int destOffset, int destRowStride, int destPixelStride,
						                  bool destHasAlpha, bool destHasColor, int destChannels,
						                  int width, int height, double opacity) {
			
			int src1AlphaStride = src1PixelStride;
			int src2AlphaStride = src2PixelStride;
			int src1AlphaRowStride = src1RowStride;
			int src2AlphaRowStride = src2RowStride;
			byte[] dummy = new byte[1];
			
			if (!src1HasAlpha)
				src1AlphaStride = 0;
			if (!src2HasAlpha)
				src2AlphaStride = 0;
			
			if (src1Pixels == null)
				src1Pixels = dummy;
			if (src2Pixels == null)
				src2Pixels = dummy;
			if (destPixels == null)
				return;
			if (src1Color == null)
				src1Color = dummy;
			if (src2Color == null)
				src2Color = dummy;

			fixed(byte* pSrc1Pixels = src1Pixels, 
			      pSrc2Pixels = src2Pixels, 
			      pDestPixels = destPixels, 
			      pSrc1Color = src1Color, 
			      pSrc2Color = src2Color) {
				byte* pDestColorValue;
				byte* pSrc1ColorValue;
				byte* pSrc2ColorValue;
				byte* pSrc1AlphaValue;
				byte* pSrc2AlphaValue;

				// Color buffer setting
				if (src1HasColor) {
					pSrc1ColorValue = pSrc1Pixels + src1Offset;
				} else {
					pSrc1ColorValue = pSrc1Color;
					src1PixelStride = 0;
					src1RowStride = 0;
				}
				if (src2HasColor) {
					pSrc2ColorValue = pSrc2Pixels + src2Offset;
				} else {
					pSrc2ColorValue = pSrc2Color;
					src2PixelStride = 0;
					src2RowStride = 0;
				}
				pDestColorValue = pDestPixels + destOffset;

				// Alpha buffer setting
				if (src1HasAlpha) {
					pSrc1AlphaValue = pSrc1Pixels + src1Offset + src1Channels - 1;
				} else {
					pSrc1AlphaValue = &src1PrimaryAlpha;
					src1AlphaStride = 0;
					src1AlphaRowStride = 0;
				}
				if (src2HasAlpha) {
					pSrc2AlphaValue = pSrc2Pixels + src2Offset + src2Channels - 1;
				} else {
					pSrc2AlphaValue = &src2PrimaryAlpha;
					src2AlphaStride = 0;
					src2AlphaRowStride = 0;
				}

				for (int y = 0; y < height; y ++) {
					for (int x = 0; x < width; x ++) {
						int src1Alpha = (int)(*pSrc1AlphaValue * opacity);
						int src2Alpha = (int)(*pSrc2AlphaValue);
						
						int alpha = (int)src2Alpha + src1Alpha - ((int)src1Alpha * src2Alpha) / 255;
						if (alpha < 0)
							alpha = 0;
						if (src1Alpha == 255) {
							for (int c = 0; c < destChannels; c ++)
								*(pDestColorValue + c) = *(pSrc1ColorValue + c);
						} else if (src1Alpha == 0) {
							if (src2Pixels != destPixels) {
								for (int c = 0; c < destChannels; c ++) 
									*(pDestColorValue + c) = *(pSrc2ColorValue + c);
							}
						} else {
							// default path
							if (!destHasAlpha && alpha != 255)
								Console.WriteLine("caution:dest alpha isn't 255: alpha={0}", alpha);
							for (int c = 0; c < destChannels; c ++) {
								pDestColorValue[c] = (byte)Math.Min(255, ((int)pSrc1ColorValue[c] + (255 - src1Alpha) * pSrc2ColorValue[c] / 255 ) );
							}
						}
						if (destHasAlpha)
							*(pDestColorValue + destChannels - 1) = (byte)(Math.Min(255, alpha));

						pDestColorValue += destPixelStride;
						pSrc1ColorValue += src1PixelStride;
						pSrc2ColorValue += src2PixelStride;
						pSrc1AlphaValue += src1AlphaStride;
						pSrc2AlphaValue += src2AlphaStride;
					}
					pDestColorValue += destRowStride - (width * destPixelStride);
					pSrc1ColorValue += src1RowStride - (width * src1PixelStride);
					pSrc2ColorValue += src2RowStride - (width * src2PixelStride);
					pSrc1AlphaValue += src1AlphaRowStride - (width * src1AlphaStride);
					pSrc2AlphaValue += src2AlphaRowStride - (width * src2AlphaStride);
				}
			}
		}
#else
		private void Over(byte[] src1Pixels, int src1Offset, int src1RowStride, int src1PixelStride,
		                  bool src1HasAlpha, bool src1HasColor, int src1Channels,
		                  byte[] src1Color, int src1Alpha,
		                  byte[] src2Pixels, int src2Offset, int src2RowStride, int src2PixelStride,
		                  bool src2HasAlpha, bool src2HasColor, int src2Channels,
		                  byte[] src2Color, int src2Alpha,
		                  byte[] destPixels, int destOffset, int destRowStride, int destPixelStride,
		                  bool destHasAlpha, bool destHasColor, int destChannels,
		                  int width, int height, double opacity) {

			for (int y = 0; y < height; y ++) {
				for (int x = 0; x < width; x ++) {
					if (src1HasAlpha)
						src1Alpha = (int)(src1Pixels[src1Offset + src1Channels - 1] * opacity);
					
					if (src2HasAlpha)
						src2Alpha = src2Pixels[src2Offset + src2Channels - 1];
					
					int alpha = (int)src2Alpha + src1Alpha * (255 - src2Alpha) / 255;
					if (alpha < 0)
						alpha = 0;

					if (destHasAlpha) {
						if (alpha > 0) {
							for (int c = 0; c < destChannels - 1; c ++) {
								if (src2HasColor)
										src2Color[c] = src2Pixels[src2Offset + c];
								if (src1HasColor)
										src1Color[c] = src1Pixels[src1Offset + c];
								destPixels[destOffset+c] = (byte)Math.Min(255, src2Color[c] + src1Alpha * (src1Color[c] - src2Color[c]) / alpha );
							}
						} else {
							Array.Clear(destPixels, destOffset, destChannels - 1);
						}
						
						destPixels[destOffset + destChannels - 1] = (byte)Math.Min(255, alpha);
					} else {
						// dest pixels does not have alpha channels
						if (src1Alpha == 255) {
							for (int c = 0; c < destChannels; c ++) {
								if (src1HasColor)
										src1Color[c] = src1Pixels[src1Offset + c];
								destPixels[destOffset+c] = src1Color[c];
							}
						} else if (src1Alpha == 0) {
							if (src2Pixels != destPixels) {
								for (int c = 0; c < destChannels; c ++) {
									if (src2HasColor)
											src2Color[c] = src2Pixels[src2Offset + c];
									destPixels[destOffset+c] = src2Color[c];
								}
							}
						} else {
							// default path
							for (int c = 0; c < destChannels; c ++) {
								if (src2HasColor)
										src2Color[c] = src2Pixels[src2Offset + c];
								if (src1HasColor)
										src1Color[c] = src1Pixels[src1Offset + c];
								destPixels[destOffset+c] = (byte)Math.Min(255, src2Color[c] + src1Alpha * (src1Color[c] - src2Color[c]) / 255 );
							}
						}
					}
					
					destOffset += destPixelStride;
					src1Offset += src1PixelStride;
					src2Offset += src2PixelStride;
				}
				destOffset += destRowStride - (width * destPixelStride);
				src1Offset += src1RowStride - (width * src1PixelStride);
				src2Offset += src2RowStride - (width * src2PixelStride);
			}
		}
#endif
		public void Apply(ISurfaceIterator surfIter, ISurfaceIterator auxIter, ISurfaceIterator maskIter, ISurfaceIterator destIter, 
		                    int w, int h, double opacity) {
//			TripleIterator iter = new TripleIterator(auxIter, surfIter, destIter, w);
			bool surfHasAlpha = surfIter.Raster.HasAlpha;
			bool auxHasAlpha  = auxIter.Raster.HasAlpha;
			bool destHasAlpha = destIter.Raster.HasAlpha;
			
			bool surfHasColor = surfIter.Raster.HasColorChannels;
			bool auxHasColor = auxIter.Raster.HasColorChannels;
			bool destHasColor = destIter.Raster.HasColorChannels;

			int surfChannels = surfIter.Raster.NumChannels;
			int destChannels = destIter.Raster.NumChannels;
			int auxChannels = auxIter.Raster.NumChannels;
			
			byte auxAlpha = 0, surfAlpha = 0;
			byte[]  surfColor;
			byte[]  auxColor;

			// Initial Color Value Setting
			if (!surfHasColor)
				surfColor = surfIter.Raster.PrimaryColor;
			else
				surfColor = new byte[surfIter.Raster.PixelStride];

			if (!auxHasColor)
				auxColor = auxIter.Raster.PrimaryColor;
			else
				auxColor = new byte[auxIter.Raster.PixelStride];
			

			// Initial Alpha Value Setting
			if (!surfHasAlpha) {
				surfAlpha = surfIter.Raster.PrimaryAlphaValue[0];
			}

			if (!auxHasAlpha) {
				byte alphaValue = auxIter.Raster.PrimaryAlphaValue[0];
				// Short-cut path
				if (alphaValue * opacity == 0) {
					if (surfIter.Raster == destIter.Raster)
						return;
					else
						; // TBD. Should be memory copy.
				}
				auxAlpha = (byte)(alphaValue * opacity);
			}
			
#if USE_EXTERNAL_OPS || USE_UNSAFE_OPS
			UnsafeOver(
#else
			Over(
#endif
			     auxIter.Raster.Buffer, auxIter.OffsetInBuffer, auxIter.Raster.RowStride, auxIter.Raster.PixelStride,
			     auxHasAlpha, auxHasColor, auxChannels,
                 auxColor, auxAlpha,
			     surfIter.Raster.Buffer, surfIter.OffsetInBuffer, surfIter.Raster.RowStride, surfIter.Raster.PixelStride,
			     surfHasAlpha, surfHasColor, surfChannels,
                 surfColor, surfAlpha,
			     destIter.Raster.Buffer, destIter.OffsetInBuffer, destIter.Raster.RowStride, destIter.Raster.PixelStride,
			     destHasAlpha, destHasColor, destChannels,
			     w, h, opacity);
		}
		
	}
}