// /home/tarai/Projects/gsaw/gsaw/Preview.cs created with MonoDevelop
// User: tarai at 1:19 2008/05/14
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Lawrence.View {
	using Holo.Image;
	using Holo.Image.Generic;
	using Holo.Operation;
	
	public class Thumbnail {
		public delegate void RefreshHandler(Thumbnail sender);
		
		private ISurface attachedSurface;
		private GenericSurface previewSurface;
		private TransformOperation rescaler;
		private RefreshHandler onRefresh;
		const int DEFAULT_WIDTH = 64;
		const int DEFAULT_HEIGHT = 64;
		
		public RefreshHandler OnRefresh {
			get { return onRefresh; }
			set { onRefresh = value; }
		}
		
		public byte[] Buffer {
			get { return previewSurface.Raster.Buffer; }
		}
		
		public Thumbnail(ISurface attachedSurface) {
			previewSurface = new GenericSurface(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT, true);
			previewSurface.MakeRastersReadable(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
			rescaler = new NearestNeighborRescaleOperator();
			Attach(attachedSurface);
		}
		
		public void Attach(ISurface surface) {
			if (attachedSurface != null)
				Detach();
			attachedSurface = surface;
//			surfaceHandler = this.OnUpdateArea;
//			attachedSurface.OnUpdateArea += surfaceHandler;
			OnUpdateArea(attachedSurface.OffsetX, attachedSurface.OffsetY,
			             attachedSurface.OffsetX + attachedSurface.Width, attachedSurface.OffsetY + attachedSurface.Height);
		}
		
		public void Detach() {
			if (attachedSurface != null) {
//				attachedSurface.OnUpdateArea -= surfaceHandler;
				attachedSurface = null;
//				surfaceHandler = null;
			}
		}
		
		public void OnUpdateArea(int minX, int minY, int maxX, int maxY) {
			if (attachedSurface.Width >= attachedSurface.Height) {
				rescaler.DestScale = DEFAULT_WIDTH;
				rescaler.SourceScale = attachedSurface.Width;
			} else {
				rescaler.DestScale = DEFAULT_HEIGHT;
				rescaler.SourceScale = attachedSurface.Height;
			}
			int destX = (minX - attachedSurface.OffsetX) * rescaler.DestScale / rescaler.SourceScale;
			int destY = (minY - attachedSurface.OffsetY) * rescaler.DestScale / rescaler.SourceScale;
			rescaler.Apply(attachedSurface, minX, minY, maxX, maxY, destX, destY, previewSurface);
		}
		
		public void Refresh() {
			OnUpdateArea(attachedSurface.OffsetX, attachedSurface.OffsetY,
			             attachedSurface.OffsetX + attachedSurface.Width, attachedSurface.OffsetY + attachedSurface.Height);
			if (onRefresh != null)
				onRefresh(this);
		}
		
	}
}
