// /home/tarai/Projects/gsaw/gsaw/CompositeOperation.cs created with MonoDevelop
// User: tarai at 2:02 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Operation {	
	using Holo.Image;
	using Holo.Operation.Processor;
	
	public class CompositeOperation {

		public delegate void CompositeOperator(ISurfaceIterator surfIter, ISurfaceIterator auxIter, ISurfaceIterator maskIter, ISurfaceIterator destIter, int width, int height, double opacity);
		private CompositeOperator opr;
		private double opacity;
		
		public double Opacity {
			get { return opacity; }
			set { opacity = value; }
		}
		
		public CompositeOperator Operator {
			get { return opr; }
			set { opr = value; }
		}
		
		public CompositeOperation() {
			opacity = 1.0;
		}
		
		private class Area {
			public int minX;
			public int minY;
			public int maxX;
			public int maxY;
		}
		
		private Area CalcIntersection(ISurface[] surfaces) {
			Area area = null;
			foreach (ISurface surface in surfaces) {
				if (surface == null)
					continue;
				if (area == null) {
					area = new Area();
					area.minX = surface.OffsetX;
					area.minY = surface.OffsetY;
					area.maxX = surface.OffsetX + surface.Width;
					area.maxY = surface.OffsetY + surface.Height;
				} else {
					area.minX = Math.Max(area.minX, surface.OffsetX);
					area.minY = Math.Max(area.minY, surface.OffsetY);
					area.maxX = Math.Min(area.maxX, surface.OffsetX + surface.Width);
					area.maxY = Math.Min(area.maxY, surface.OffsetY + surface.Height);
				}
			}
			return area;			
		}
		
		public virtual void Apply(ISurface surface, ISurface aux, ISurface mask, ISurface dest) {
			Apply(surface, aux, mask, dest, null);
		}
		
		public virtual void Apply(ISurface surface, ISurface aux, ISurface mask, ISurface dest, JobProcessor processor) {
			ISurface[] surfaces = { surface, aux, mask, dest };
			Area intersection = CalcIntersection(surfaces);
			Apply(surface, aux, mask, intersection.minX, intersection.minY, intersection.maxX, intersection.maxY, dest, processor);
		}
		
		public virtual void Apply(ISurface surface, ISurface aux, ISurface mask, int minX, int minY, int maxX, int maxY, ISurface dest) {
			Apply(surface, aux, mask, minX, minY, maxX, maxY, dest, null);
		}
		
		public virtual void Apply(ISurface surface, ISurface aux, ISurface mask, int minX, int minY, int maxX, int maxY, ISurface dest, JobProcessor processor) {
			try {
			D.StopWatches.CompositeOperation_Apply.Start();
			ISurface[] surfaces = { surface, aux, mask, dest };
			Area intersection = CalcIntersection(surfaces);
			minX = Math.Max(minX, intersection.minX);
			minY = Math.Max(minY, intersection.minY);
			maxX = Math.Min(maxX, intersection.maxX);
			maxY = Math.Min(maxY, intersection.maxY);
			
			if (minX >= maxX || minY >= maxY)
				return;

//			Console.WriteLine("apply:"+minX+","+minY+"-"+maxX+","+maxY);
			
			int width = maxX - minX;
			int height = maxY - minY;
			surface.MakeRastersReadable(minX, minY, width, height);
			aux.MakeRastersReadable(minX, minY, width, height);
			dest.MakeRastersWriteable(minX, minY, width, height);

			ISurfaceIterator surfaceIter = surface.GetIteratorAt(minX, minY);
			ISurfaceIterator auxIter     = aux.GetIteratorAt(minX, minY);
			ISurfaceIterator destIter    = dest.GetIteratorAt(minX, minY);
			ISurfaceIterator maskIter    = null;
			ISurfaceIterator[] iterators;
			if (mask != null) {
				maskIter = mask.GetIteratorAt(minX, minY);
				mask.MakeRastersReadable(minX, minY, width, height);
				ISurfaceIterator[] definition = { surfaceIter, auxIter, maskIter, destIter };
				iterators = definition;
			} else {
				ISurfaceIterator[] definition = { surfaceIter, auxIter, destIter };
				iterators = definition;
			}

			MultipleSurfaceIterator mIter;
			mIter = new MultipleSurfaceIterator(iterators, minX, minY, maxX, maxY);

			while (!mIter.IsYEnded()) {
				int h = mIter.HeightOfRaster;
				while (!mIter.IsXEnded()) {
					int w = mIter.WidthOfRaster;
//					Console.WriteLine("Operator:("+surfaceIter.OffsetX+","+surfaceIter.OffsetY+"), w,h="+w+","+h+":OffsetInRaster="+surfaceIter.OffsetXInRaster+","+surfaceIter.OffsetYInRaster+",SizeOfRaster"+surfaceIter.WidthOfRaster+","+surfaceIter.HeightOfRaster);
					if (opr != null) {
						if (processor == null) {
							opr(surfaceIter, auxIter, maskIter, destIter, w, h, opacity);
						} else {
							ISurfaceIterator surfIterClone = surfaceIter.Clone();
							ISurfaceIterator auxIterClone = auxIter.Clone();
							ISurfaceIterator maskIterClone = (maskIter != null)? maskIter.Clone(): null;
							ISurfaceIterator destIterClone = destIter.Clone();
							processor.Add(new CompositeJob(opr, surfIterClone, 
							                               auxIterClone, maskIterClone, destIterClone,
							                               surfaceIter.OffsetX, surfaceIter.OffsetY, w, h, opacity));
						}
					}
					mIter.AddX(w);
				}
				mIter.ResetXAndAddY(h);
			}
			if (dest.OnUpdateArea != null)
				dest.OnUpdateArea(minX, minY, maxX, maxY);
			} finally {
				D.StopWatches.CompositeOperation_Apply.Stop();
			}
		}
	}
}