// /home/tarai/Projects/gsaw/gsaw/GenericSurfaceIterator.cs created with MonoDevelop
// User: tarai at 17:43 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image.Generic
{
	using Holo.Image;
	
	public class GenericSurfaceIterator : ISurfaceIterator
	{
		private int minX;
		private int minY;
		private int maxX;
		private int maxY;
		private int offsetX;
		private int offsetY;
		private GenericSurface surface;
		
		public GenericSurfaceIterator(GenericSurface surface, int offsetX, int offsetY) {
			this.surface = surface;
			this.minX = surface.OffsetX;
			this.minY = surface.OffsetY;
			this.maxX = surface.OffsetX + surface.Width;
			this.maxY = surface.OffsetY + surface.Height;
			this.offsetX = offsetX;
			this.offsetY = offsetY;
		}
		
		public GenericSurfaceIterator(GenericSurface surface, int minX, int minY, int maxX, int maxY, int offsetX, int offsetY) {
			this.surface = surface;
			this.minX = minX;
			this.minY = minY;
			this.maxX = maxX;
			this.maxY = maxY;
			this.offsetX = offsetX;
			this.offsetY = offsetY;
		}
		
		public GenericSurfaceIterator(GenericSurfaceIterator src) {
			this.surface = src.surface;
			this.minX = src.minX;
			this.minY = src.minY;
			this.maxX = src.maxX;
			this.maxY = src.maxY;
			this.offsetX = src.offsetX;
			this.offsetY = src.offsetY;
			if (this.offsetX < this.minX)
				this.offsetX = this.minX;
			if (this.offsetY < this.minY)
				this.offsetY = this.minY;
		}

		public GenericSurfaceIterator(GenericSurfaceIterator src, int minX, int minY, int maxX, int maxY) {
			this.surface = src.surface;
			this.minX = minX;
			this.minY = minY;
			this.maxX = maxX;
			this.maxY = maxY;
			this.offsetX = src.offsetX;
			this.offsetY = src.offsetY;
			if (this.offsetX < this.minX)
				this.offsetX = this.minX;
			if (this.offsetY < this.minY)
				this.offsetY = this.minY;
		}
		
		public void SetRange(int minX, int minY, int maxX, int maxY) {
			this.minX = minX;
			this.minY = minY;
			this.maxX = maxX;
			this.maxY = maxY;
		}

		public int OffsetX {
			get { return offsetX; }
		}
		
		public int OffsetY {
			get { return offsetY; }
		}
		
		public IRaster Raster {
			get { return surface.Raster; }
		}
		
		public int OffsetXInRaster {
			get { return offsetX - surface.OffsetX; }
		}
		
		public int OffsetYInRaster {
			get { return offsetY - surface.OffsetY; }
		}
		
		public int WidthOfRaster {
			get { return surface.Width - OffsetXInRaster; }
		}
		
		public int HeightOfRaster {
			get { return surface.Height - OffsetYInRaster; }
		}
		
		public int OffsetInBuffer {
			get { return Raster.RowStride * OffsetYInRaster + Raster.PixelStride * OffsetXInRaster; }
		}
		
		public void AddX(int x) {
			offsetX += x;
		}
		
		public void SubX(int x) {
			offsetX -= x;
		}

		public void AddY(int y) {
			offsetY += y;
		}
		
		public void SubY(int y) {
			offsetY -= y;
		}

		public void ResetXAndAddY(int y) {
			offsetX = minX;
			offsetY += y;
		}

		public bool IsXEnded() {
			return offsetX >= maxX;
		}

		public bool IsXBelowMin() {
			return offsetX < minX;
		}
		
		public bool IsYEnded() {
			return offsetY >= maxY;			
		}
		
		public bool IsYBelowMin() {
			return offsetY < minY;
		}
		
		public ISurfaceIterator Clone() {
			return new GenericSurfaceIterator(this);
		}
		
		public bool GetCurrentColor(out byte[] color, out int offset) {
			if (Raster == null || IsXBelowMin() || IsYBelowMin() || IsXEnded() || IsYEnded()) {
				color = null;
				offset = 0;
				return false;
			}
			if (Raster.HasColorChannels) {
				color = Raster.Buffer;
				offset = OffsetInBuffer;
			} else {
				color = Raster.PrimaryColor;
				offset = 0;
			}
			return true;
		}
		
		public bool GetCurrentAlpha(out byte[] alpha, out int offset) {
			if (Raster == null || IsXBelowMin() || IsYBelowMin() || IsXEnded() || IsYEnded()) {
				alpha = null;
				offset = 0;
				return false;
			}
			if (Raster.HasAlpha) {
				alpha = Raster.Buffer;
				offset = OffsetInBuffer + Raster.NumChannels - 1;
			} else {
				alpha = Raster.PrimaryAlphaValue;
				offset = 0;
			}
			return true;
		}

		public void UpdateRaster() {
		}
		
	}
}
