// /home/tarai/Projects/gsaw/gsaw/GenericUndoInfo.cs created with MonoDevelop
// User: tarai at 14:46 2008/05/03
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace Lawrence.History {
	using Holo.Image;
	using Holo.Image.Tiled;
	using Lawrence.Common;
	
	public class GenericUndoInfo : IUndoInfo {
		private class Area {
			public int X;
			public int Y;
			public IRaster Raster;
			public Area(int x, int y, IRaster raster) {
				X = x;
				Y = y;
				Raster = raster;
			}
		};

		private Image image;
		private Layer layer;
		private ArrayList areaList;
		private object eventHandler;
		
		public GenericUndoInfo(PaintContext context) {
			areaList = new ArrayList();
			this.image = context.ActiveImage;
			this.layer = context.ActiveLayer;
		}
		
		private GenericUndoInfo(Image image, Layer layer, ArrayList areaList) {
			this.image = image;
			this.layer = layer;
			this.areaList = areaList;
		}
		
		public void Undo() {
//			Console.WriteLine("Undo!");
//			bool updateEnabled = image.EnableRealtimeUpdate;
//			image.EnableRealtimeUpdate = false;
			foreach (Area area in areaList) {
				TiledSurface surface = (TiledSurface)layer.Surface;
				ISurfaceIterator iter = surface.GetIteratorAt(area.X, area.Y);
//				Console.WriteLine("swap:"+area.X+","+area.Y);
				surface.SetRasterAt(iter, area.Raster);
				if (surface.OnUpdateArea != null)
					surface.OnUpdateArea(area.X, area.Y, area.X + area.Raster.Width, area.Y + area.Raster.Height);
			}
//			image.EnableRealtimeUpdate = updateEnabled;
		}
		
		public IUndoInfo CreateReverseUndoInfo() {
			ArrayList newAreaList = new ArrayList(areaList.Count);
			foreach (Area area in areaList) {
				if (area == null)
					continue;
				ISurfaceIterator iter = layer.Surface.GetIteratorAt(area.X, area.Y);
				if (iter == null || iter.Raster == null) {
					Console.WriteLine("CreateReverseInfo:error: Raster is null at "+area.X+","+area.Y);
					continue;
				}
				Area newArea = new Area(area.X, area.Y, iter.Raster);
				newAreaList.Add(newArea);
			}
			return new GenericUndoInfo(image, layer, newAreaList);
		}
		
		public void Attach() {
			TiledSurface surface = (TiledSurface)layer.Surface;
			
			surface.MakeRastersReadOnly(surface.OffsetX, surface.OffsetY, surface.Width, surface.Height);
			eventHandler = new TiledSurface.ReplaceTileHandler(this.OnReplaceRaster);
			surface.OnReplaceTile += (TiledSurface.ReplaceTileHandler)eventHandler;
		}
		
		public void Dettach() {
			TiledSurface surface = (TiledSurface)layer.Surface;
			surface.OnReplaceTile -= (TiledSurface.ReplaceTileHandler)eventHandler;
		}
		
		public void OnReplaceRaster(int x, int y, IRaster oldRaster, IRaster newRaster) {
			Area area = new Area(x, y, oldRaster);
			areaList.Add(area);
		}
	}
}
