// /home/tarai/Projects/gsaw/gsaw/IRasterIterator.cs created with MonoDevelop
// User: tarai at 17:22 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image {
	
	
	public interface ISurfaceIterator {
		int OffsetX { get; }
		int OffsetY { get; }
		IRaster Raster { get; }
		int OffsetXInRaster { get; }
		int OffsetYInRaster { get; }
		int WidthOfRaster { get; }
		int HeightOfRaster { get; }
		
		int OffsetInBuffer { get; }

		void AddX(int x);
		void SubX(int x);
		void AddY(int y);
		void SubY(int y);
		void ResetXAndAddY(int y);
		bool IsXEnded();
		bool IsXBelowMin();
		bool IsYEnded();
		bool IsYBelowMin();
		void SetRange(int minX, int minY, int maxX, int maxY);
		
		bool GetCurrentColor(out byte[] color, out int offset);
		bool GetCurrentAlpha(out byte[] alpha, out int offset);
		
		ISurfaceIterator Clone();
		
		void UpdateRaster();
	}
}
