// /home/tarai/Projects/gsaw/gsaw/JobProcessor.cs created with MonoDevelop
// User: tarai at 17:56 2008/05/24
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Threading;
using System.Collections;

namespace Holo.Operation.Processor {

	public class JobProcessor1 : JobProcessor {
		private int numThread;
		private ArrayList jobs;
		private ManualResetEvent[] finished;
		private Queue availableJobs;
		private int waitingJobs;

		
		public JobProcessor1(int numThread) {
			this.numThread = numThread;
			jobs = new ArrayList();
			availableJobs = new Queue();
			finished = new ManualResetEvent[numThread];
			for (int i = 0; i < numThread; i ++) {
				finished[i] = new ManualResetEvent(false);
			}
		}

		
		public void Add(CompositeJob newJob) {
			lock (jobs) {
				foreach (CompositeJob job in jobs) {
					newJob.ConstructDependencyChain(job);
				}
				newJob.OnAvailable = this.OnAvailable;
				jobs.Add(newJob);
			}
		}
		
		private void OnAvailable(CompositeJob job) {
			lock (this) {
				availableJobs.Enqueue(job);
				Monitor.PulseAll(this);
			}
		}
		
		
		public void ProcessSync() {
			foreach (CompositeJob job in jobs) {
				if (job.Available)
					availableJobs.Enqueue(job);
			}
			waitingJobs = jobs.Count;
//			Console.WriteLine("Start");
			while (true) {
				lock(this) {
					if (waitingJobs > 0) {
						for (int i = 0; i < numThread; i ++)
							ThreadPool.QueueUserWorkItem(Work, i);
					} else {
						break;
					}
				}
//				Console.WriteLine("wait all");
				WaitHandle.WaitAny(finished);
//				Console.WriteLine("reset");
				lock(this) {
					if (waitingJobs <= 0) {
						break;
					}
				}
			}
			lock (this) {
				Monitor.PulseAll(this);
			}
			WaitHandle.WaitAll(finished);
			foreach (ManualResetEvent e in finished)
				e.Reset();
			jobs.Clear();
		}
		
		
		protected void Work(object context) {
			int index = (int)context;
//			Console.WriteLine("start");
			while (true) {
				CompositeJob job = null;
				lock (this) {
					if (waitingJobs <= 0)
						break;
					try {
						job = (CompositeJob)availableJobs.Dequeue();
					} catch(Exception) {
//						if (waitingJobs <= 0)
//							break;
						Monitor.Wait(this);
					}
				}

				if (job != null) {
					CompositeJob.JobStatus result = job.Run(context);
					if (result == CompositeJob.JobStatus.Pending) {
						Console.WriteLine("Pend!");
					} else if (result == CompositeJob.JobStatus.Aborted) {
						Console.WriteLine("Abort");
					} else {
						lock (this) {
							waitingJobs --;
						}
					}
				}
			}
//			Console.WriteLine("done {0}", index);
			finished[index].Set();
		}
		
	}
}
