#include "libwilmaops.h"

#include <stdio.h>


#define SAMPLING_RATE_BITS 10
#define SAMPLING_RATE (1 << SAMPLING_RATE_BITS)

void CRotate(byte* srcPixels, int srcRowStride, int srcPixelStride, int srcOffsetX, int srcOffsetY, int srcWidth, int srcHeight,
             int srcStartX, int srcStartY,
             int dxInXAxis, int dyInXAxis, int dxInYAxis, int dyInYAxis,
             int srcMinX, int srcMinY, int srcMaxX, int srcMaxY, 
             byte* destPixels, int destRowStride, int destPixelStride, int destChannels,
             int destOriginX, int destOriginY,
             int destMinX, int destMinY, int destMaxX, int destMaxY,
             int destStartX, int destStartY, int destEndX, int destEndY) {
	
	int subsampledX, subsampledY;
	int xInDestCoords, yInDestCoords;
	int xInSrcCoords, yInSrcCoords;

	subsampledX = srcStartX;
	subsampledY = srcStartY;	
	{
		int destStartXDiff = destStartX & (SAMPLING_RATE - 1);
		int destStartYDiff = destStartY & (SAMPLING_RATE - 1);
		subsampledX -= (dxInXAxis * destStartXDiff + dxInYAxis * destStartYDiff) / SAMPLING_RATE;
		subsampledY -= (dyInXAxis * destStartXDiff + dyInYAxis * destStartYDiff) / SAMPLING_RATE;
		destStartX -= destStartXDiff;
		destStartY -= destStartYDiff;
	}

	for (yInDestCoords = destStartY; yInDestCoords < destEndY; yInDestCoords+=SAMPLING_RATE) {
		int lineSubsampledX = subsampledX;
		int lineSubsampledY = subsampledY;
		if (yInDestCoords >= destMinY  &&  yInDestCoords < destMaxY) {
			int destOffset = destRowStride * (yInDestCoords>>SAMPLING_RATE_BITS) + destPixelStride * (destStartX>>SAMPLING_RATE_BITS);
			for (xInDestCoords = destStartX; xInDestCoords < destEndX; xInDestCoords+=SAMPLING_RATE) {
				int c;
				int xWeight1, xWeight2, yWeight1, yWeight2;
				int prevX, prevY, nextX, nextY;
				int topLeftOffset, topRightOffset, bottomLeftOffset, bottomRightOffset;
				if (xInDestCoords >= destMinX  &&  xInDestCoords < destMaxX) {

					if (lineSubsampledX >= srcMinX  &&  lineSubsampledX < srcMaxX  &&
						lineSubsampledY >= srcMinY  &&  lineSubsampledY < srcMaxY) {

						xInSrcCoords = lineSubsampledX >> SAMPLING_RATE_BITS;
						yInSrcCoords = lineSubsampledY >> SAMPLING_RATE_BITS;
						xWeight2 = lineSubsampledX & (SAMPLING_RATE - 1);
						yWeight2 = lineSubsampledY & (SAMPLING_RATE - 1);
						prevX = xInSrcCoords - srcOffsetX; 
						prevY = yInSrcCoords  - srcOffsetY;
						topLeftOffset = srcRowStride * prevY + srcPixelStride * prevX;
						if (xWeight2 == 0 && yWeight2 == 0) {
							for (c = 0; c < destChannels; c ++) {
								destPixels[destOffset + c] = srcPixels[topLeftOffset + c];
							}
						} else {
							topRightOffset = bottomLeftOffset = bottomRightOffset = topLeftOffset;
							if (xInSrcCoords < srcOffsetX + srcWidth - 1) {
								topRightOffset    += srcPixelStride;
								bottomRightOffset += srcPixelStride;
							}
							if (yInSrcCoords < srcOffsetY + srcHeight - 1) {
								bottomLeftOffset  += srcRowStride;
								bottomRightOffset += srcRowStride;
							}
							for (c = 0; c < destChannels; c ++) {
								int topColor, bottomColor;
								int t1, t2, t3;
								topColor = INT_BLEND_WITH_BASE(srcPixels[topRightOffset + c], srcPixels[topLeftOffset + c] , xWeight2, SAMPLING_RATE_BITS, t1);
								bottomColor = INT_BLEND_WITH_BASE(srcPixels[bottomRightOffset + c], srcPixels[bottomLeftOffset + c], xWeight2, SAMPLING_RATE_BITS, t2);
								destPixels[destOffset + c] = (byte)(INT_BLEND_WITH_BASE(bottomColor, topColor, yWeight2, SAMPLING_RATE_BITS, t3));
							}
						}
					} else {
					}
				}
				lineSubsampledX += dxInXAxis;
				lineSubsampledY += dyInXAxis;
				destOffset += destPixelStride;
			}
		}
		subsampledX += dxInYAxis;
		subsampledY += dyInYAxis;
	}
}
