class RiderSkill 
{
	public static final int SKILL_POS_NONE            = 0x00000003;
	public static final int SKILL_POS_VANGUARD        = 0x00000001;
	public static final int SKILL_POS_REARGUARD       = 0x00000002;
	public static final int SKILL_POS_MASK            = 0x0000000F;
	public static final int SKILL_ATTR_NONE           = 0x00000000;
	public static final int SKILL_ATTR_SAME_AS_FELLOW = 0x00000010;
	public static final int SKILL_ATTR_SAME_AS_ENEMY  = 0x00000020;
	public static final int SKILL_ATTR_MASK           = 0x000000F0;
	public static final int SKILL_SPECIAL_RIDER       = 0x10000000;

	private int offense;
	private int defense;
	private int hitpoint;
	private int specialAttack;
	private int attackPoint;
	
	private int condition;
	
	RiderSkill(int offense, int defense, int hitpoint, int spAttack, int ap, int condition) {
		this.offense       = offense;
		this.defense       = defense;
		this.hitpoint      = hitpoint;
		this.specialAttack = spAttack;
		this.attackPoint   = ap;
		this.condition     = condition;
	}
	
	public boolean isSkillValid(Rider owner, Rider partner, boolean isVanguard) {
		int posMask = SKILL_POS_REARGUARD;
		if(isVanguard) posMask = SKILL_POS_VANGUARD;
		boolean isValid = ((condition & posMask) == posMask);
		if(isValid) {
			if((condition & SKILL_SPECIAL_RIDER) != SKILL_SPECIAL_RIDER) {
				int attrCond = (condition & SKILL_ATTR_MASK);
				if(attrCond == SKILL_ATTR_SAME_AS_ENEMY) {
					isValid = false;
				} else if(attrCond == SKILL_ATTR_SAME_AS_FELLOW) {
					isValid = ((owner.getAttribute() & partner.getAttribute()) != 0);
				}
			} else {
				// for Rider Specified Skill
				isValid = isRiderSpecifiedSkillValid(owner, partner);
			}
		}
		return isValid;
	}
	
	public boolean isRiderSpecifiedSkillValid(Rider owner, Rider partner) {
		boolean isValid = false;
		if(owner.getSeries().equals("8") && owner.getNumber() == 48) { //EK
			isValid = partner.getName().contains("R");
		} else if(owner.getSeries().equals("002") && owner.getNumber() == 44) { //W[J[
			isValid = partner.getName().contains("XJ");
		}
		return isValid;
	}

	/**
	 * @return the offense
	 */
	public int getOffense() {
		return offense;
	}

	/**
	 * @return the defense
	 */
	public int getDefense() {
		return defense;
	}

	/**
	 * @return the hitpoint
	 */
	public int getHitpoint() {
		return hitpoint;
	}

	/**
	 * @return the specialAttack
	 */
	public int getSpecialAttack() {
		return specialAttack;
	}

	/**
	 * @return the attackPoint
	 */
	public int getAttackPoint() {
		return attackPoint;
	}

	/**
	 * @return the condition
	 */
	public int getCondition() {
		return condition;
	}
}

public class Rider 
{
	private   String series;
	private   int    number;
	
	protected String name;
	protected int    offense;
	protected int    defense;
	protected int    hitpoint;
	protected int    specialAttack;
	protected int    rearGuardTactics;
	protected int[]  chemistry;
	protected RiderSkill riderSkill;
	protected int    attribute;
	protected int    rarity;
	
	public static final int GANGAN_SEMERO       = 0;
	public static final int AITE_WO_BUTTOBASE   = 1;
	public static final int SUPPORT_HA_MAKASERO = 2;
	public static final int AITE_WO_YOKUMIRO    = 3;
	public static final int GUARD_WO_KATAMERO   = 4;

	public static final int CHEMISTRY_INDEX_OFFENSE   = 0;
	public static final int CHEMISTRY_INDEX_DEFENSE   = 1;
	public static final int CHEMISTRY_INDEX_SP_ATTACK = 2;
	public static final int CHEMISTRY_INDEX_HITPOINT  = 3;
	public static final int CHEMISTRY_NUM = 4;
	
	public static final int ATTR_SPEED           = 0x00000001;
	public static final int ATTR_POWER           = 0x00000002;
	public static final int ATTR_TECHNIQUE       = 0x00000004;
	public static final int ATTR_SUPER_SPEED     = 0x10000001;
	public static final int ATTR_SUPER_POWER     = 0x10000002;
	public static final int ATTR_SUPER_TECHNIQUE = 0x10000004;
	public static final int ATTR_SUPER_MASK      = 0x10000000;
	
	public static final int RARITY_NORMAL        = 1;
	public static final int RARITY_RARE          = 2;
	public static final int RARITY_SP_CARD       = 3;
	public static final int RARITY_SUPER_RARE    = 4;
	public static final int RARITY_LEGEND_RARE   = 5;
	
	public static final int POS_VANGUARD         = 1;
	public static final int POS_SUPPORTER        = 2;
	public static final int POS_BREAKER          = 3;
	
	Rider(String name, int attribute, int offense, int defense, int hitpoint, int specialAttack,
			int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity) {
		this.name      = name;
		this.attribute = attribute;
		this.chemistry = new int[CHEMISTRY_NUM];
		this.offense   = offense;
		this.defense   = defense;
		this.hitpoint  = hitpoint;
		this.specialAttack    = specialAttack;
		this.rearGuardTactics = rearGuardTactics;
		for(int i = 0; i < CHEMISTRY_NUM; i++)
			this.chemistry[i] = chemistry[i];
		riderSkill = skill;
		this.rarity = rarity;
	}
	
	Rider(String series, int number, String name, int attribute, int offense, int defense, int hitpoint, int specialAttack,
			int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity) {
		this(name, attribute, offense, defense, hitpoint, specialAttack, rearGuardTactics, chemistry, skill, rarity);
		this.series = series;
		this.number = number;
	}
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the offense
	 */
	public int getOffense() {
		return offense;
	}

	/**
	 * @return the defense
	 */
	public int getDefense() {
		return defense;
	}

	/**
	 * @return the hitpoint
	 */
	public int getHitpoint() {
		return hitpoint;
	}

	/**
	 * @return the specialAttack
	 */
	public int getSpecialAttack() {
		return specialAttack;
	}

	/**
	 * @return the rearSkill
	 */
	public int getRearGuardTactics() {
		return rearGuardTactics;
	}	
	
	/**
	 * @return the chemistry
	 */
	public int getChemistry(int index) {
		return chemistry[index];
	}

	/**
	 * @return the attribute
	 */
	public int getAttribute() {
		return attribute;
	}
	
	public int getOffenseSkill() {
		return riderSkill.getOffense();
	}
	
	public int getDefenseSkill() {
		return riderSkill.getDefense();
	}
	
	public int getHitpointSkill() {
		return riderSkill.getHitpoint();
	}
	
	public int getSpecialAttackSkill() {
		return riderSkill.getSpecialAttack();
	}

	/**
	 * @return the series
	 */
	public String getSeries() {
		return series;
	}

	/**
	 * @return the number
	 */
	public int getNumber() {
		return number;
	}

	/**
	 * @return the rarity
	 */
	public int getRarity() {
		return rarity;
	}
	
	public boolean isVanguardSkillValid(Rider supporter, Rider breaker) {
		return riderSkill.isSkillValid(this, supporter, true) || riderSkill.isSkillValid(this, breaker, true);
	}

	public boolean isRearguardSkillValid(Rider vanguard, Rider anotherRider) {
		return riderSkill.isSkillValid(this, vanguard, false)|| riderSkill.isSkillValid(this, anotherRider, false);
	}
	
	public boolean isEqual(Rider rider) {
		return rider.getSeries().equals(this.series) && (rider.getNumber() == this.number);
	}
	
	public String toString() {
		return new String(name+"("+series+"-"+number+")");
	}
}
