///////////////////////////////////////////////////////////////
//Association.h
//֘At - CApplicationList, CAssociation

#if !defined(__ASSOCIATION_H_INCLUDED)
#define __ASSOCIATION_H_INCLUDED

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////
//INCLUDE
#include "resource.h"
#include <windows.h>
#include <winreg.h>

///////////////////////////////////////////////////////////////
//DEFINE
#define FINDTYPE_APPNAME		(0)
#define FINDTYPE_EXT			(1)

///////////////////////////////////////////////////////////////
//PROTOTYPE
LRESULT CALLBACK PPOptionFiletypeProc(HWND, UINT, WPARAM, LPARAM);

///////////////////////////////////////////////////////////////
//CLASS
class CApplicationList
{
private:
	LPTSTR lpszExt;
	LPTSTR lpszKeyName;
	LPTSTR lpszAppName;
	LPTSTR lpszAppPath;
	LPTSTR lpszCommand;
	LPTSTR lpszIconPath;
	int nIconID;
	int nImageIndex;
	CApplicationList *lpNext;
public:
	CApplicationList();
	CApplicationList(LPTSTR szExt, LPTSTR szKeyName, LPTSTR szAppName, LPTSTR szAppPath, LPTSTR szCommand, LPTSTR szIconPath, int IconID, int ImageIndex, CApplicationList* AlPrev = NULL);
	~CApplicationList();
	LPTSTR getExt();
	LPTSTR getKeyName();
	LPTSTR getAppName();
	LPTSTR getAppPath();
	LPTSTR getCommand();
	LPTSTR getIconPath();
	int getIconID();
	int getImageIndex();
	CApplicationList* getNext();
	void setExt(LPTSTR szExt);
	void setKeyName(LPTSTR szKeyName);
	void setAppName(LPTSTR szAppName);
	void setAppPath(LPTSTR szAppPath);
	void setCommand(LPTSTR szCommand);
	void setIconPath(LPTSTR szIconPath);
	void setIconID(int IconID);
	void setImageIndex(int ImageIndex);
	void setNext(CApplicationList* Next);
};

///////////////////////////////////////////////////////////////
class CAssociation
{
public:
	HWND				m_hparWnd;
	HINSTANCE			m_hInst;
	HWND				m_hWnd;
	BOOL				m_bReg;
	BOOL				m_bOpen;

	HWND				m_hListView;
	HWND				m_hListView2;
	HIMAGELIST			m_hImageList;
	CApplicationList*	m_lpAppList;
	CApplicationList*	m_lpActiveList;
	TCHAR				m_szCurrent[MAX_PATH];
	TCHAR				m_szName[MAX_PATH];
	TCHAR				m_szExtType[MAX_PATH];
	TCHAR				m_szNewFileType[MAX_PATH];
	LPTSTR				m_lpszExt;
	BOOL				m_nbSortRaise;

public:
	CAssociation(HWND,HINSTANCE);
	~CAssociation();
	void CreateAppList();
	void CreateAppList2();
	void DeleteAppList();

	BOOL SetApplication(LPTSTR,LPTSTR lpszKeyName=NULL,LPTSTR lpszAppName=NULL,LPTSTR lpszParam=NULL, LPTSTR lpszIconPath=NULL, int nIconID=0);
	BOOL SetAssociation(LPTSTR);
	BOOL DeleteSubKey(LPTSTR);

	void InitAppImageList(HWND);
	void DeleteAppImageList();
	void LoadAppList(LPTSTR szSelectAppPath=NULL);
	void LoadAppList2();
	CApplicationList* GetSelectItem(HWND, int, int nType = FINDTYPE_APPNAME);

	int OpenChoose(LPTSTR, LPTSTR, BOOL bReg = FALSE, BOOL bOpen = TRUE);
	void OnInitChoose();
	void OnEndChoose();
	void OnBrowseChoose();
	void OnOKChoose();

	void OnInitFiletype();
	void OnEndFiletype();
	void OnClickFiletype();
	void OnChangeFiletype(LPTSTR lpszExt = NULL);
	void OnColumnClick(NMLISTVIEW*);
	void OpenNewFiletype();
	void OnInitNewFiletype(HWND);
	BOOL OnOKNewFiletype(HWND);
	void OpenDeleteFiletype();
	void OpenDetailSetting();
	void OnInitDetailSetting(HWND);
	void OnChangeDetailSetting(HWND);
	BOOL OnOKDetailSetting(HWND);
	void OnSizeChoose();
	void OnSizeFiletype();
};

#endif // !defined(__ASSOCIATION_H_INCLUDED)