////////////////////////////////////////////////////////////////
// GSFinder.cpp : O[o֐`

////////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "MainWnd.h"
#include "OptionDlg.h"
#include "FolderDlgPPC.h"

HINSTANCE	g_hInst;					// ݂̃CX^X
CMainWnd	g_MainWnd;					//CEChE
HWND		g_hwndPrev = NULL;
BOOL		g_bCmdParam = FALSE;
LPTSTR		g_lpszFirstLoadFolder = NULL;
TCHAR		g_szRootName[MAX_PATH] = {0};
TCHAR		g_szDecSep[16] = _T(".");		//_؂蕶

BOOL		g_bMoving = FALSE;
BOOL		g_bDraging = FALSE;
int			g_nStartPos = 0;
int			g_nLastWidth = 0;
int			g_nLastHeight = 0;

SHACTIVATEINFO g_sai;
BOOL g_bIgureClick = FALSE;

////////////////////////////////////////////////////////////////
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	TCHAR szTemp2[MAX_PATH];
	GetTempPath(MAX_PATH, szTemp2);
	//R}hC𔻒
	if (_tcsncmp(lpCmdLine, APP_CMD_PARAM, APP_CMD_PARAM_LEN) == 0)
		g_lpszFirstLoadFolder = lpCmdLine + APP_CMD_PARAM_LEN;
	else if (_tcslen(lpCmdLine))
	{
		if (*lpCmdLine == _T('\"'))
		{
			g_lpszFirstLoadFolder = lpCmdLine + 1;
			LPTSTR lpszTemp = _tcschr(g_lpszFirstLoadFolder, _T('\"'));
			if (lpszTemp) *lpszTemp = _T('\0');
		}
		else
			g_lpszFirstLoadFolder = lpCmdLine;
	}

	//dN̖h~
	HANDLE hMutex = CreateMutex(NULL, NULL, APP_MUTEX_NAME);
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		HWND hPrevWnd = FindWindow(APP_CLASS_NAME, NULL);
		if (hPrevWnd)
		{
			SetForegroundWindow(hPrevWnd);
			if (g_lpszFirstLoadFolder)
			{
				COPYDATASTRUCT cds;
				cds.dwData = WM_DROPFILES;
				cds.lpData = g_lpszFirstLoadFolder;
				cds.cbData = (_tcslen(g_lpszFirstLoadFolder) + 1) * sizeof(TCHAR);
				SendMessage(hPrevWnd, WM_COPYDATA, NULL, (LPARAM)&cds);
			}
		}
		return 0;
	}

	MSG msg;
	HACCEL hAccelTable;

	GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_SDECIMAL, g_szDecSep, 16);

	//t@CύXʒm̊Jn
	InitUpdateNotify();

	//CEChE̍쐬
	g_hInst = hInstance;
	g_MainWnd.Init();
	g_MainWnd.ShowWindow();	
	g_hwndPrev = g_MainWnd.m_ListView.m_hWnd;

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDR_MAINFRAME);

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(g_MainWnd.m_hWnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	//t@CύXʒm̒~
	UninitUpdateNotify();

	return msg.wParam;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HWND hFocus = GetFocus();
	switch (message) 
	{
	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);

			if (wmId >= ID_FILE_OPEN_APP && wmId < (ID_FILE_OPEN_APP + MAX_OPENAPP))
			{
				g_MainWnd.m_ListView.OnFileOpenApp(wmId - ID_FILE_OPEN_APP);
				break;
			}
			if (wmId >= ID_TOOL_USERPATH_MENU && wmId < (ID_TOOL_USERPATH_MENU + MAX_OPENAPP))
			{
				g_MainWnd.m_ListView.OnToolUserPath(wmId - ID_TOOL_USERPATH_MENU);
				break;
			}
			if (wmId >= ID_TOOL_FAVORITES_LNK && wmId < ID_TOOL_FAVORITES_LNK + g_MainWnd.m_ListView.m_nFavoritesCount)
			{
				g_MainWnd.m_ListView.OnToolFavoritesLnk(wmId - ID_TOOL_FAVORITES_LNK);
				break;
			}
			if (wmId >= ID_FILE_SHELL_NEW_MENU && wmId < (ID_FILE_SHELL_NEW_MENU + MAX_OPENAPP))
			{
				g_MainWnd.m_ListView.OnFileShellNew(wmId - ID_FILE_SHELL_NEW_MENU);
				break;
			}

			//bZ[WID
			wmId = g_MainWnd.m_ListView.CheckMessageID(wmId);

			switch (wmId)
			{
			case ID_KEY_TAB:
				//tH[JXݒ
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
				{
					if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
						SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
					else
						SetFocus(g_MainWnd.m_TreeView.m_hWnd);
				}
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
				else
				{
					if (g_MainWnd.m_bShowFolder)
						SetFocus(g_MainWnd.m_TreeView.m_hWnd);
					else
						SetFocus(g_MainWnd.m_ListView.m_hWnd);
				}
				break;

			case ID_KEY_SFT_TAB:
				//tH[JXݒ(t)
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
				{
					if (g_MainWnd.m_bShowFolder)
						SetFocus(g_MainWnd.m_TreeView.m_hWnd);
					else if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
						SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
				}
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
						SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
					else
						SetFocus(g_MainWnd.m_ListView.m_hWnd);
				}
				else
				{
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
				}
				break;

			case ID_FILE_ABOUT:
				//o[W
				DialogBox(g_hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				break;

			case ID_FILE_EXIT:
				//I
				g_MainWnd.OnClose();
				break;

			case ID_EDIT_CONTROL_ON:
				//CTRLL[ON
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
				g_MainWnd.OnEditCtrlOn();
				break;

			case ID_EDIT_SHIFT_ON:
				//SHIFTL[ON
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
				g_MainWnd.OnEditShiftOn();
				break;

			case ID_EDIT_DRAGDROP:
				//hbO&hbv[hON/OFF
				g_MainWnd.OnDragDropMode();
				break;

			case ID_EDIT_CUT:
				//؂
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnEditCut();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnEditCut();
				else
				{
					SendMessage(hFocus, WM_CUT, 0, 0);
					g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE, FALSE);
				}
				break;

			case ID_EDIT_COPY:
				//Rs[
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnEditCopy();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnEditCopy();
				else
				{
					SendMessage(hFocus, WM_COPY, 0, 0);
					g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE, FALSE);
				}
				break;

			case ID_EDIT_PASTE:
				//\t
				if (hFocus == g_MainWnd.m_ListView.m_hWnd || hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_ListView.OnEditPaste();
				else
					SendMessage(hFocus, WM_PASTE, 0, 0);
				break;

			case ID_EDIT_PASTE_SHORTCUT:
				// V[gJbg̓\t
				g_MainWnd.m_ListView.OnEditPasteShortcut();
				break;

			case ID_EDIT_FILESEARCH:
				//t@C
				g_MainWnd.m_ListView.OnFileSearch();
				break;

			case ID_VIEW_STATUSBAR:
				//Xe[^Xo[̕\
				g_MainWnd.OnViewStatusBar();
				break;

			case ID_VIEW_TOOLBAR:
				//c[o[̕\
				g_MainWnd.m_CmdBands.OnViewToolBar();
				break;

			case ID_VIEW_ADDRESSBAR:
				//AhXo[̕\
				g_MainWnd.m_CmdBands.OnViewAddressBar();
				break;

			case ID_VIEW_LARGEICON:
				//Xg̃X^C
				g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_LARGEICON);
				break;

			case ID_VIEW_SMALLICON:
				//\`->ACR
				g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_SMALLICON);
				break;

			case ID_VIEW_LIST:
				//\`->ꗗ
				g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_LIST);
				break;

			case ID_VIEW_REPORT:
				//\`->ڍ
				g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_REPORT);
				break;

			case ID_VIEW_REPORTLINE:
				//\`->ڍ(sI)
				g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_REPORTLINE);
				break;

			case ID_VIEW_STYLE:
				//\`̕ύX
				g_MainWnd.m_ListView.OnListStyle();
				break;

			case ID_VIEW_SORT_NAME:
				//Xg̕בւ(O)
				g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_NAME);
				break;

			case ID_VIEW_SORT_EXT:
				//Xg̕בւ()
				g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_EXT);
				break;

			case ID_VIEW_SORT_SIZE:
				//Xg̕בւ(TCY)
				g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_SIZE);
				break;

			case ID_VIEW_SORT_TIME:
				//Xg̕בւ(XV)
				g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_TIME);
				break;

			case ID_VIEW_SORT_NOT_RAISE:
				//Xg̕בւ(~)
				g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_NOT_RAISE);
				break;

			case ID_VIEW_UPDATE:
				//ŐV̏ɍXV
				g_MainWnd.OnViewUpdate();
				break;

			case ID_VIEW_UPFOLDER:
				//̃tH_
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnViewUpFolder();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnViewUpFolder();
				break;

			case ID_VIEW_FOLDER:
				//tH_\ON/OFF
				g_MainWnd.OnViewFolder();
				break;

			case ID_VIEW_SIDE:
				//Eɕׂ
				if (g_MainWnd.m_bLandscapeMode)
					g_MainWnd.OnViewSideL();
				else
					g_MainWnd.OnViewSide();
				break;

			case ID_VIEW_HIGHRES:
				//nC]\
				g_MainWnd.OnViewHighRes(!g_MainWnd.m_bHighRresolutionMode);
				break;

			case ID_FILE_OPEN:
				//t@CJ
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileOpen();
				break;

			case ID_FILE_TO_APP:
				//AvP[V֑
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileToApp();
				break;


			case ID_FILE_OPEN_PARAM:
				//p[^tŊJ
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileOpenParam();
				break;

			case ID_FILE_CREATEFOLDER:
				//VKtH_쐬
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
				g_MainWnd.m_ListView.OnFileCreateFolder();
				break;

			case ID_FILE_CREATE_SHORTCUT:
				//V[gJbg쐬
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileCreateShortcut();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileCreateShortcut();
				break;

			case ID_FILE_CREATE_NEWSHORTCUT:
				//VKV[gJbg쐬
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
				g_MainWnd.m_ListView.OnFileCreateNewShortcut();
				break;

			case ID_FILE_DELETE:
				//폜
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileDelete();
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileDelete();
				break;

			case ID_FILE_RENAME:
				//O̕ύX
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileRename();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileRename();
				break;

			case ID_FILE_PROPERTY:
				//vpeB
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileProperty();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileProperty();
				break;

			case ID_FILE_IR_SEND:
				//ԊOM
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileIRSend();
				break;

			case ID_FILE_SHORTCUT_FOLDER:
				//w̃tH_փV[gJbg쐬
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileShortcutFolder();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileShortcutFolder();
				break;

			case ID_FILE_COPY_FOLDER:
				//wtH_Ƀt@CRs[
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileCopyFolder();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileCopyFolder();
				break;

			case ID_FILE_MOVE_FOLDER:
				//wtH_Ƀt@Cړ
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileMoveFolder();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileMoveFolder();
				break;

			case ID_FILE_COMPRESS:
				//k
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileCompress();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFileCompress();
				break;

			case ID_FILE_UNCOMPRESS:
				//
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileUnCompress();
				break;

			case ID_FILE_MAIL_SEND:
				//[M
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileMailSend();
				break;

			case ID_EDIT_COPY_FILE_NAME:
				//ORs[
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnEditCopyFileName();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnEditCopyFileName();
				break;

			case ID_EDIT_COPY_FILE_PATH:
				//pXRs[
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnEditCopyFilePath();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnEditCopyFilePath();
				break;

			case ID_EDIT_SELECTALL:
				//SđI
				if (hFocus == g_MainWnd.m_CmdBands.m_hEditBox)
				{
					//AhXo[ł̃ReLXgj[Ή
					SendMessage(g_MainWnd.m_CmdBands.m_hEditBox, EM_SETSEL, 0, -1);
				}
				else
				{
					ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, LVIS_SELECTED, LVIS_SELECTED);
				}
				break;

			case ID_EDIT_NOTSEL_ALL:
				//I
				ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_SELECTED);
				break;

			case ID_EDIT_SELECT_SWITCH:
				//I̐؂ւ
				g_MainWnd.m_ListView.OnEditSelectSwitch();
				break;

			//c[j[
			case ID_TOOL_NETWORK_COM:
				//lbg[Nڑ̊蓖
				g_MainWnd.OnNetworkDriveConnect();
				break;

			case ID_TOOL_NETWORK_DCOM:
				//lbg[Nڑ̐ؒf
				g_MainWnd.OnNetworkDriveDisconnect();
				break;

			case ID_TOOL_ACTIVESYNC:
				//ActiveSync
				g_MainWnd.OnToolActivesync();
				break;

			case ID_FILE_IRRECEIVE:
				//ԊOM
				g_MainWnd.OnToolIRRecive();
				break;

			case ID_TOOL_OPTION:
				{
					//IvV
					COptionDlg od;
					od.ShowOptionDlg();
				}
				break;

			case ID_GO_FRONT:
				//i
				g_MainWnd.m_ListView.OnGoFront();
				break;

			case ID_GO_BACK:
				//߂
				g_MainWnd.m_ListView.OnGoBack();
				break;

			case ID_FOCUS_MOVE:
				//tH_\/t@C\ֈړ
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
				else
					SetFocus(g_MainWnd.m_TreeView.m_hWnd);
				break;

			case ID_FAVORITES_ADD:
				//Cɓ֒ǉ
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFavoritesAdd();
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnFavoritesAdd();
				break;

			case ID_FAVORITES_ARG:
				//Cɓ̐
				g_MainWnd.m_ListView.OnFavoritesOrganize();
				break;

			case IDC_BTN_GOTOFOLDER:
				//c[{^hbv_E
				g_MainWnd.m_ListView.OnGotoFolderDropDown();
				break;

			case ID_TOOL_MYDOCUMENTS:
				//}ChLg
				g_MainWnd.m_ListView.OnViewUpdate(g_MainWnd.m_szMyDocumentPath);
				break;

			case ID_TOOL_STARTMENU:
				//X^[gj[
				g_MainWnd.m_ListView.OnViewUpdate(g_MainWnd.m_szStartMenuPath);
				break;

			case ID_TOOL_MYDEVICE:
				//}CRs[^
				g_MainWnd.m_ListView.OnViewUpdate(_T(""));
				break;

			case ID_TOOL_USERPATH:
				//[U[pX
				g_MainWnd.m_ListView.OnUserPath();
				break;

			default:
				break;
			}

			switch (wmEvent)
			{
			case CBN_SELENDOK:
				{
					//R{{bNX
					HWND hwndComboBox = (HWND) lParam;
					if (hwndComboBox == g_MainWnd.m_CmdBands.m_hComboBox)
					{
						g_MainWnd.m_ListView.OnSelEndOK();
					}
					break;
				}
			default:
				return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		}
	case WM_NOTIFY:
		{
			LPNMHDR pNmHdr = (LPNMHDR)lParam;
			switch (pNmHdr->code)
			{
			case GN_CONTEXTMENU:
				//^bvAhz[h
				if (g_bDraging)
					break;

				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnTapAndHold((NMRGINFO*)lParam);
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					//̂vXz[ĥGN_CONTEXTMENU2Ă΂Ă܂̂őΏ
					if (g_MainWnd.m_TreeView.m_bPressAndHoldCorrect)
						g_MainWnd.m_TreeView.m_bPressAndHoldCorrect = FALSE;
					else
						g_MainWnd.m_TreeView.OnTapAndHold((NMRGINFO*)lParam);
				}
				else if (hFocus == g_MainWnd.m_CmdBands.m_hEditBox)
				{
					//AhXo[ł̃ReLXgj[Ή
					g_MainWnd.m_CmdBands.OnTapAndHold((NMRGINFO*)lParam);
				}
				return TRUE;

			case NM_DBLCLK:
				//Xg_uNbN
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnFileOpen();
				break;

			case NM_CLICK:
				//XgVONbN
				if (g_MainWnd.m_ListView.m_Settings.bSingleClick
					&& pNmHdr->hwndFrom == g_MainWnd.m_ListView.m_hWnd)
				{
					//VONbNŎsw莞
					if (!(GetKeyState(VK_CONTROL)&0x8000) && !g_MainWnd.m_bControlKey
						&& !(GetKeyState(VK_SHIFT)&0x8000) && !g_MainWnd.m_bShiftKey
						&& !(GetKeyState(VK_MENU)&0x8000)
						&& !g_bIgureClick)
					{
						if (1 == ListView_GetSelectedCount(g_MainWnd.m_ListView.m_hWnd))
						{
							//IACe1݂̂̏ꍇ
							g_MainWnd.m_ListView.OnFileOpen();
							break;
						}
					}
					g_bIgureClick = FALSE;
				}

				//ENbN(Alt+NbN)ł͂Ȃꍇ
				if (!(!(GetKeyState(VK_CONTROL)&0x8000) && !g_MainWnd.m_bControlKey
					&& !(GetKeyState(VK_SHIFT)&0x8000) && !g_MainWnd.m_bShiftKey
					&& (GetKeyState(VK_MENU)&0x8000)))
				{
					break;
				}
				//ENbN̏ꍇNM_RCLICK̏p(breakȂ)

			case NM_RCLICK:
				//ENbN
				//ENbNj[\
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
				{
					LPNMLISTVIEW lpnmlv = (LPNMLISTVIEW)lParam;
					g_MainWnd.m_ListView.OnRClick(lpnmlv->ptAction.x, lpnmlv->ptAction.y);
				}
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					DWORD dwPos = GetMessagePos();
					g_MainWnd.m_TreeView.OnRClick(GET_X_LPARAM(dwPos), GET_Y_LPARAM(dwPos), TRUE);
				}
				break;

			case NM_RETURN:
				//Enter/Action
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
				{
					if (GetKeyState(VK_MENU)&0x8000)
						g_MainWnd.m_ListView.OnFileProperty();
				}
				else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					if (GetKeyState(VK_MENU)&0x8000)
						g_MainWnd.m_TreeView.OnFileProperty();
					else
					{
						SHRGINFO shrg;
						RECT rc;
						HTREEITEM hItem = TreeView_GetSelection(g_MainWnd.m_TreeView.m_hWnd);
						if (hItem)
						{
							TreeView_GetItemRect(g_MainWnd.m_TreeView.m_hWnd, hItem, &rc, TRUE);
							shrg.cbSize = sizeof(shrg);
							shrg.hwndClient = g_MainWnd.m_TreeView.m_hWnd;
							shrg.ptDown.x = rc.left + (RECT_WIDTH(&rc) / 2);
							shrg.ptDown.y = rc.top + (RECT_HEIGHT(&rc) / 2);
							shrg.dwFlags = SHRG_NOTIFYPARENT;
							g_MainWnd.m_TreeView.m_bPressAndHoldCorrect = TRUE;
							if (SHRecognizeGesture(&shrg))
								return TRUE;
						}
					}
				}
				return FALSE;

			case NM_SETFOCUS:
				//tH[JXݒ莞
				g_MainWnd.OnSetFocus((HWND)pNmHdr->hwndFrom);
				break;

			case NM_KILLFOCUS:
				//tH[JXݒ莞
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd) {
					g_MainWnd.m_TreeView.OnKillFocus();
				}
				break;

			case LVN_BEGINLABELEDIT:
				//O̕ύXJn
				g_MainWnd.m_ListView.m_bEditing = TRUE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteBef();
				break;

			case LVN_ENDLABELEDIT:
				//O̕ύXI
				g_MainWnd.m_ListView.m_bEditing = FALSE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteAft();
				return g_MainWnd.m_ListView.OnEndLabelEdit((LV_DISPINFO*)lParam);

			case LVN_ITEMCHANGED:
				//ACeI
				if (g_bDraging)
					break;
				if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnItemChanged((LPNMLISTVIEW)lParam);
				break;

			case LVN_COLUMNCLICK:
				//JNbN
				g_MainWnd.m_ListView.OnColumnClick((LPNMLISTVIEW)lParam);
				break;

			case LVN_GETDISPINFO:
				//ACRXV
				//ACRxǂݍ
				g_MainWnd.m_ListView.OnGetDispInfo((NMLVDISPINFO*)lParam);
				break;

			case LVN_BEGINDRAG:
				//hbO̊Jn
				g_bDraging = TRUE;
				g_MainWnd.OnBeginDrag((LPNMHDR)lParam);
				break;

			case TVN_BEGINDRAG:
				g_bDraging = TRUE;
				g_MainWnd.OnBeginDrag((LPNMHDR)lParam);
				break;

			case TVN_BEGINLABELEDIT:
				//O̕ύXJn
				g_MainWnd.m_TreeView.m_bEditing = TRUE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteBef();
				g_MainWnd.m_TreeView.GetCurrentFolder();
				break;

			case TVN_ENDLABELEDIT:
				//O̕ύXI
				g_MainWnd.m_TreeView.m_bEditing = FALSE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteAft();
				return g_MainWnd.m_TreeView.OnEndLabelEdit((TV_DISPINFO*)lParam);

			case TVN_SELCHANGED:
				// tH[JXݒ肳ꂽꍇ
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnSelChanged((NMTREEVIEW*)lParam);
				break;

			case TVN_ITEMEXPANDING:
				//c[WJ
				g_MainWnd.m_TreeView.OnItemExpanding((NMTREEVIEW*)lParam);
				break;

			case TVN_ITEMEXPANDED:
				//c[WJI
				g_MainWnd.m_TreeView.OnItemExpanded((NMTREEVIEW*)lParam);
				break;

			case LVN_MARQUEEBEGIN:
				g_bIgureClick = TRUE;
				break;

			case LVN_KEYDOWN:
				//Xgr[̃L[
				g_MainWnd.m_ListView.OnKeydown(hWnd, (NMLVKEYDOWN*)lParam);
				break;

			case TVN_KEYDOWN:
				//c[r[̃L[
				g_MainWnd.m_TreeView.OnKeydown(hWnd, (NMTVKEYDOWN*)lParam);
				break;

			default:
			   return DefWindowProc(hWnd, message, wParam, lParam);
			}
		}
		break;

	case WM_CREATE:
		//EBhE
		g_MainWnd.OnCreate();
		break;

	case WM_CLOSE:
		//EBhEN[Y
		g_MainWnd.OnClose();
		break;

	case WM_DESTROY:
		//EBhEj
		g_MainWnd.OnDestroy();
		break;

	case WM_SIZE:
		//EBhETCYύX
		//R}ho[Xe[^Xo[̃CAEgύX
		g_MainWnd.RecalcBarLayout(wParam, lParam);
		//EBhẼCAEgύX
		g_MainWnd.RecalcLayout();
		break;

	case WM_ACTIVATE:
		//EBhẼANeBu/ANeBu
		if (LOWORD(wParam) == WA_INACTIVE && g_bDraging)
		{
			g_MainWnd.OnDropCansel();
			g_bDraging = FALSE;
		}
		g_MainWnd.OnActivate(LOWORD(wParam));
		break;

	case WM_SETTINGCHANGE:
		SHHandleWMSettingChange(hWnd, wParam, lParam, &g_sai);
		g_MainWnd.OnSettingChange(wParam);
		break;

	case WM_DEVICECHANGE:
		// J[h̎F
		g_MainWnd.OnDeviceChange(TRUE);
		break;

	case WM_COPYDATA:
		{
			//Np[^L
			COPYDATASTRUCT* pcds = (COPYDATASTRUCT*)lParam;
			if (pcds->dwData == WM_DROPFILES)
			{
				DWORD dwAttr = GetFileAttributes((LPTSTR)pcds->lpData);
				if (dwAttr != 0xFFFFFFFF && (dwAttr & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
				{
					g_MainWnd.m_ListView.OnViewUpdate((LPCTSTR)pcds->lpData);
				}
			}
		}
		break;

	//Splitter
	case WM_LBUTTONDOWN:
		//}EX{^Jn
		SetCapture(hWnd);
		g_bMoving = TRUE;
		if (g_MainWnd.m_bLandscapeMode?g_MainWnd.m_bViewSideL:g_MainWnd.m_bViewSideP)
		{
			g_nStartPos = GET_X_LPARAM(lParam);
			g_nLastWidth = (g_MainWnd.m_bLandscapeMode? g_MainWnd.m_nTreeViewWidthL:g_MainWnd.m_nTreeViewWidthP);
		}
		else
		{
			g_nStartPos = GET_Y_LPARAM(lParam);
			g_nLastHeight = (g_MainWnd.m_bLandscapeMode? g_MainWnd.m_nTreeViewHeightL:g_MainWnd.m_nTreeViewHeightP);
		}
		break;

	case WM_MOUSEMOVE:
		//}EXړ
		if (g_bMoving)
			g_MainWnd.OnMouseMove(lParam, g_nStartPos, g_nLastWidth, g_nLastHeight);
		if (g_bDraging) {
			POINT pt = {GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam)};
			g_MainWnd.OnMouseMove(pt);
		}
		break;

	case WM_LBUTTONUP:
		//}EX{^I
		ReleaseCapture();
		if (g_bMoving)
		{
			ListView_Arrange(g_MainWnd.m_ListView.m_hWnd, LVA_DEFAULT);
			InvalidateRect(g_MainWnd.m_hWnd, NULL, FALSE);
		}
		if (g_bDraging)
			g_MainWnd.OnLButtopUp();
		g_bMoving = FALSE;
		g_bDraging = FALSE;
		break;

	case WM_SETFOCUS:
		//tH[JXݒ
		SetFocus(g_MainWnd.m_ListView.m_hWnd);
		break;

	case WM_RBUTTONDOWN:
		//}EX{^ENbN
		MessageBox(NULL,_T("CLICK"),_T("TEST"),MB_OK);
		break;

	case WM_ENTERMENULOOP:
		//|bvAbvj[I[v
		g_MainWnd.m_ListView.m_bThroughContextMenu = TRUE;
		if (g_MainWnd.m_bNumberShortcut)
		{
			g_MainWnd.SaveInputMode();
			g_MainWnd.SetInputMode(INPUTMODE_HAN_NUMERIC);
		}
		break;

	case WM_EXITMENULOOP:
		//|bvAbvj[N[Y
		if (g_MainWnd.m_bNumberShortcut)
			g_MainWnd.RestoreInputMode();
		break;

	case WM_UPDATENOTIFY:
		{
			MSG msg;
			while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
			g_MainWnd.OnDeviceChange(FALSE);
		}
		break;

	case WM_TIMER:
		//^C}ʒm
		if (wParam == ID_TIMER_TVSELECTED)
			g_MainWnd.m_TreeView.OnKillFocus();
		if (wParam == ID_TIMER_DEVICECHANGE)
			g_MainWnd.OnDeviceChange(FALSE, FALSE);
		//ȊOdef

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;
	DWORD size;
	TCHAR szTemp[1024];

	switch (message)
	{
	case WM_INITDIALOG:
		shidi.dwMask = SHIDIM_FLAGS;
		shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
		shidi.hDlg = hDlg;
		SHINITDIALOG(&shidi);

		//o[Wԍ̐ݒ
		GetModuleFileName(NULL, szTemp, MAX_PATH);
		size = GetFileVersionInfoSize(szTemp, NULL);
		if (size)
		{
			TCHAR *pv = new TCHAR[size/sizeof(TCHAR)];
			if (GetFileVersionInfo(szTemp, 0, size, pv))
			{
				UINT len, v1, v2, v3, v4;
				TCHAR *lpszTemp;
				VerQueryValue(pv, _T("\\StringFileInfo"), (LPVOID*)&lpszTemp, &len);
				_stprintf(szTemp, _T("\\StringFileInfo\\%s\\ProductVersion"), (LPTSTR)((BYTE*)lpszTemp+6));
				VerQueryValue(pv, szTemp, (LPVOID*)&lpszTemp, &len);
				_stscanf(lpszTemp, _T("%d, %d, %d, %d"), &v1, &v2, &v3, &v4);
				_stprintf(szTemp, _T("Ver.%d.%d.%d.%d"), v1, v2, v3, v4);
				SetWindowText(GetDlgItem(hDlg, IDC_VERSION), szTemp);
			}
			delete pv;
		}
		return TRUE;

	case WM_COMMAND:
		if ((LOWORD(wParam) == IDOK) || (LOWORD(wParam) == IDCANCEL))
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;

	case WM_PAINT:
		return DefDlgPaintProc(hDlg, wParam, lParam);

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

    return FALSE;
}

///////////////////////////////////////////////////////////////
void CenterWindow(HWND hWnd)
{
	RECT rctDesktop, rctWnd;
	GetWindowRect(g_MainWnd.m_hWnd, &rctDesktop);
	GetWindowRect(hWnd, &rctWnd);

	int nX = ((rctDesktop.right - rctDesktop.left)-(rctWnd.right - rctWnd.left))/2;
	int nY = ((rctDesktop.bottom - rctDesktop.top)-(rctWnd.bottom - rctWnd.top))/2;
	if (nY < 26) nY = 26;

	SetWindowPos(hWnd, HWND_TOP, nX, nY, 0, 0, SWP_NOSIZE|SWP_NOZORDER);
}

////////////////////////////////////////////////////////////////
void SetKickExt(LPTSTR lpszFileName)
{
	LPTSTR lpszTemp = _tcsrchr(lpszFileName, _T('.'));
	if (lpszTemp)
		*lpszTemp = _T('\0');
}

////////////////////////////////////////////////////////////////
void SetExtFromFileName(LPTSTR lpszFileName, LPTSTR lpszFileNameWithExt)
{
	LPTSTR lpszTemp = _tcsrchr(lpszFileNameWithExt, _T('.'));
	if (lpszTemp)
		_tcscat(lpszFileName, lpszTemp);
}

////////////////////////////////////////////////////////////////
DWORD GetIMStatus()
{
	SIPINFO si;
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	SipGetInfo(&si);
	return si.fdwFlags;
}

////////////////////////////////////////////////////////////////
void SetFormatInteger(LPTSTR lpszInt, UINT nSize)
{
	LPTSTR lpszTemp = new TCHAR[nSize];
	memset(lpszTemp, 0, sizeof(TCHAR)*nSize);
	GetNumberFormat(LOCALE_USER_DEFAULT, 0, lpszInt, NULL, lpszTemp, nSize);
	memset(lpszInt, 0, sizeof(TCHAR)*nSize);

	LPTSTR lpszSep = _tcschr(lpszTemp, g_szDecSep[0]);
	if (lpszSep)
		_tcsncpy(lpszInt, lpszTemp, lpszSep-lpszTemp);
	else
		_tcscpy(lpszInt, lpszTemp);
	delete[] lpszTemp;
}

////////////////////////////////////////////////////////////////
void SetFormatDouble(LPTSTR lpszDouble, UINT nSize)
{
	LPTSTR lpszTemp = new TCHAR[nSize];
	memset(lpszTemp, 0, sizeof(TCHAR)*nSize);
	GetNumberFormat(LOCALE_USER_DEFAULT, 0, lpszDouble, NULL, lpszTemp, nSize);
	memset(lpszDouble, 0, sizeof(TCHAR)*nSize);
	_tcscpy(lpszDouble, lpszTemp);
	delete[] lpszTemp;
}

////////////////////////////////////////////////////////////////
void SetFormatDateTime(SYSTEMTIME* lpst, LPTSTR lpszBuff, UINT nSize)
{
	memset(lpszBuff, 0, nSize * sizeof(TCHAR));

	//t/ԕ\
	GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, lpst, NULL, lpszBuff, nSize);
	_tcscat(lpszBuff, _T(" "));
	GetTimeFormat(LOCALE_USER_DEFAULT, 0, lpst, NULL, (lpszBuff+_tcslen(lpszBuff)), (nSize-_tcslen(lpszBuff)));
}

////////////////////////////////////////////////////////////////
UINT GetFileAndFolderCountInFolder(LPTSTR lpszPath)
{	
	UINT nFileCount = 0;
	TCHAR szTemp[MAX_PATH+4];
	_stprintf(szTemp, _T("%s\\*.*"), lpszPath);

	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		BOOL bRet = TRUE;
		do{
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				LPTSTR lpszChildPath = new TCHAR[_tcslen(lpszPath)+_tcslen(finddata.cFileName)+2];
				_stprintf(lpszChildPath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				nFileCount += GetFileAndFolderCountInFolder(lpszChildPath);
				nFileCount += 1;
				delete[] lpszChildPath;
			}
			else
				nFileCount += 1; //t@C
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	return nFileCount;
}

////////////////////////////////////////////////////////////////
UINT GetFileAndFolderCount(LPCTSTR lpszPath, LISTITEMINFO* lpliinfo, int nCount)
{
	UINT nFileCount = 0;
	for (int i=0; i<nCount; i++)
	{
		//TCY擾AJEgJn
		if (lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			TCHAR szPath[MAX_PATH];
			_stprintf(szPath, _T("%s\\%s"), lpszPath, lpliinfo[i].szName);
			nFileCount += GetFileAndFolderCountInFolder(szPath);
			nFileCount += 1;
		}
		else if (lpliinfo[i].nItem == LIST_ITEM_FILE)
			nFileCount += 1;
	}
	return nFileCount;
}

////////////////////////////////////////////////////////////////
//tH_̃N`FbN
BOOL IsFolderShortcut(LPCTSTR lpszPath, LPCTSTR lpszFileName)
{
	TCHAR szPath[MAX_PATH] = _T("");

	LPTSTR lpszExt = _tcsrchr(lpszFileName, _T('.'));
	if (lpszExt != NULL)
	{
		if (_tcsicmp(lpszExt, _T(".LNK")) == 0)
		{
			//Nt@CƔF
			TCHAR szBuf[MAX_PATH] = _T("");
			memset(szBuf, 0, sizeof(szBuf));
			_stprintf(szBuf, _T("%s\\%s"), lpszPath, lpszFileName);
			if (SHGetShortcutTarget(szBuf, szPath, MAX_PATH))
			{
				LPCTSTR lpszStart = szPath;
				if (szPath[0] == _T('\"'))
				{
					lpszStart++;
					memset(szBuf, 0, sizeof(szBuf));
					LPCTSTR lpszEnd = _tcsrchr(lpszStart, _T('\"'));
					if (lpszEnd)
						_tcsncpy(szBuf, lpszStart, lpszEnd-lpszStart);
					else
						_tcsncpy(szBuf, lpszStart, _tcslen(lpszStart)-1);
				}

				DWORD dwAttr = GetFileAttributes(szBuf);
				if ((dwAttr & FILE_ATTRIBUTE_DIRECTORY) && dwAttr != 0xFFFFFFFF)
					return TRUE; //tH_̃NƔF
			}
		}
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
int CALLBACK PropSheetCallback(HWND hwndDlg, UINT message, LPARAM lParam)
{
	switch (message) 
	{
	case PSCB_INITIALIZED:
		{
			HWND hwndChild = GetWindow(hwndDlg, GW_CHILD);
			while (hwndChild)
			{
				TCHAR szTemp[32];
				GetClassName(hwndChild, szTemp, 32);
				if (_tcscmp(szTemp, _T("SysTabControl32")) == 0)
					break;
				hwndChild = GetWindow(hwndChild, GW_HWNDNEXT);
			}
			if (hwndChild)
			{
				DWORD dwStyle = GetWindowLong(hwndChild, GWL_STYLE) | TCS_BOTTOM;
				::SetWindowLong(hwndChild, GWL_STYLE, dwStyle);
			}
			if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
			{
				//̃j[o[ǉ
				SHMENUBARINFO mbi;
				memset(&mbi, 0, sizeof(SHMENUBARINFO));
				mbi.cbSize = sizeof(SHMENUBARINFO);
				mbi.hwndParent = hwndDlg;
				mbi.nToolBarId = IDR_PROPSHEET;
				mbi.hInstRes = g_hInst;
				mbi.nBmpId = 0;
				mbi.cBmpImages = 0;
				//SHCREATEMENUBAR(&mbi);
				SHCreateMenuBar(&mbi);	//ifm_bIsSmartphoneFALSEł邱Ƃm肵Ă邽
			}
		}
		break;

	case PSCB_GETVERSION:
		return COMCTL32_VERSION;
		break;

	default:
		break;
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgPaintProc(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	DWORD bottom = (DWORD)(22 * g_MainWnd.m_fpHighResolutionScale);
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hDlg, &ps);
	POINT pt[2] = {{0, bottom},{GetSystemMetrics(SM_CXSCREEN),bottom}};
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	EndPaint(hDlg, &ps);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgPaintProc2(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	DWORD bottom1 = (DWORD)(22 * g_MainWnd.m_fpHighResolutionScale);
	DWORD bottom2 = (DWORD)(42 * g_MainWnd.m_fpHighResolutionScale);
	DWORD bottom3 = (DWORD)(98 * g_MainWnd.m_fpHighResolutionScale);

	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hDlg, &ps);
	POINT pt[2] = {{0, bottom1},{GetSystemMetrics(SM_CXSCREEN),bottom1}};
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	
	HPEN hPen = CreatePen(PS_SOLID, 1, RGB(192, 192, 192));
	HPEN hPenOld = (HPEN)SelectObject(hDC, hPen);
	int nWidth = GetSystemMetrics(SM_CXSCREEN);
	pt[0].y = pt[1].y = bottom2;
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	pt[0].y = pt[1].y = bottom3;
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	SelectObject(hDC, hPenOld);
	DeleteObject(hPen);
	EndPaint(hDlg, &ps);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgCtlColorStaticProc(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	HDC hDC = (HDC)wParam;
	if (GetDlgCtrlID((HWND)lParam) == IDC_TITLE	||
		GetDlgCtrlID((HWND)lParam) == IDC_TITLE2 ||
		GetDlgCtrlID((HWND)lParam) == IDC_TITLE3)
	{
		SetBkMode(hDC, TRANSPARENT);
		SetTextColor(hDC, GetSysColor(COLOR_HIGHLIGHT));
		return (long)GetStockObject(WHITE_BRUSH);
	}
	else
		return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////
void SetFormatSize(LONGLONG dwSize, TCHAR szBuff[64], LPTSTR lpszFmtKB, LPTSTR lpszFmtMB)
{
	double fSize;
	TCHAR szSize[64];
	if (dwSize < 1048576)
		fSize = (double)(dwSize/1024);
	else
		fSize = (double)(dwSize/1048576);
	_stprintf(szSize, _T("%f"), fSize);
	SetFormatDouble(szSize, 64);
		
	if (dwSize < 1048576)
		_stprintf(szBuff, lpszFmtKB, szSize);
	else
		_stprintf(szBuff, lpszFmtMB, szSize);
}

//////////////////////////////////////////////////////////////////////////////////////
LPCTSTR GetRootName()
{
	if (!_tcslen(g_szRootName))
		_tcscpy(g_szRootName, GetResourceString(IDS_ROOT_FOLDER_NAME));
	return g_szRootName;
}

//////////////////////////////////////////////////////////////////////////////////////
int AddRootIcon(HIMAGELIST hImageList)
{
	int nRet;
	HICON hIcon;
	if (g_MainWnd.m_bHighRresolutionMode || !g_MainWnd.m_bHighDpiHardware)
	{
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_S);
		nRet = ImageList_AddIcon(hImageList, hIcon);
	}
	else
	{
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_M);
		if (g_MainWnd.m_bIsSmartphone && !g_MainWnd.m_bDisableResizeSpIcon)
			nRet = MyAddResizeSpIcon(hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
		else
			nRet = ImageList_AddIcon(hImageList, hIcon);
	}
	DestroyIcon(hIcon);

	return nRet;
}

//////////////////////////////////////////////////////////////////////////////////////
HFONT MyCreateFont(int nHeight, BYTE dwCharSet, LPTSTR lpszName)
{
	LOGFONT logfont;
	logfont.lfHeight = nHeight;								//tHg
	logfont.lfWidth = 0;									//
	logfont.lfEscapement = 0;								//eLXg̊px
	logfont.lfOrientation = 0;								//x[XCƂƂ̊px
	logfont.lfWeight = FW_DONTCARE;							//tHg̏dij
	logfont.lfItalic = FALSE;								//C^bN
	logfont.lfUnderline = FALSE;							//A_[C
	logfont.lfStrikeOut = FALSE;							//ł
	logfont.lfCharSet = dwCharSet;							//Zbg
	logfont.lfOutPrecision = OUT_DEFAULT_PRECIS;			//o͐x
	logfont.lfClipPrecision = CLIP_DEFAULT_PRECIS;			//NbsOx
	logfont.lfQuality = DEFAULT_QUALITY;					//o͕i
	logfont.lfPitchAndFamily= DEFAULT_PITCH|FF_DONTCARE;	//sb`ƃt@~[
	if (lpszName)
		_tcscpy(logfont.lfFaceName, lpszName);				//̖

	return (CreateFontIndirect(&logfont));
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL g_bNotifyExit = FALSE;
BOOL g_bEnableNotify = FALSE;
HANDLE g_hNotifyThread = NULL;
HANDLE g_hUpdateNotify = INVALID_HANDLE_VALUE;
HANDLE g_hEventBreak = NULL;
DWORD g_dwNotifyThreadId = 0;
TCHAR g_szNotifyDir[MAX_PATH] = {0};
CRITICAL_SECTION g_csec;

////////////////////////////////////////////////////////////////
DWORD CALLBACK UpdateNotifyThreadProc(LPVOID pParam)
{
	DWORD dwRet;
	while (!g_bNotifyExit)
	{
		EnterCriticalSection(&g_csec);
		if (g_bEnableNotify)
		{
			g_hUpdateNotify = FindFirstChangeNotification(g_szNotifyDir, FALSE, 
											FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME);
		}
		LeaveCriticalSection(&g_csec);
		if (g_hUpdateNotify == INVALID_HANDLE_VALUE)
		{
			WaitForSingleObject(g_hEventBreak, INFINITE);
			ResetEvent(g_hEventBreak);
			continue;
		}

		if (WaitForSingleObject(g_hEventBreak, 5000) == WAIT_OBJECT_0)
		{
			ResetEvent(g_hEventBreak);
			FindCloseChangeNotification(g_hUpdateNotify);
			g_hUpdateNotify = INVALID_HANDLE_VALUE;
			continue;
		}

		HANDLE handles[] = {g_hEventBreak, g_hUpdateNotify};
		dwRet = WaitForMultipleObjects(sizeof(handles) / sizeof(HANDLE), handles, FALSE, INFINITE);
		if (dwRet - WAIT_OBJECT_0 == 0)
			ResetEvent(g_hEventBreak);
		else
		{
			EnterCriticalSection(&g_csec);
			//if (g_bEnableNotify)
			//{
			PostMessage(g_MainWnd.m_hWnd, WM_UPDATENOTIFY, 0, 0);
			//}
			LeaveCriticalSection(&g_csec);
		}
		FindCloseChangeNotification(g_hUpdateNotify);
		g_hUpdateNotify = INVALID_HANDLE_VALUE;
	}

	if (g_hUpdateNotify != INVALID_HANDLE_VALUE)
	{
		FindCloseChangeNotification(g_hUpdateNotify);
		g_hUpdateNotify = INVALID_HANDLE_VALUE;
	}
	return 0;
}
////////////////////////////////////////////////////////////////
void InitUpdateNotify()
{
	InitializeCriticalSection(&g_csec);
	g_hEventBreak = CreateEvent(0, TRUE, FALSE, NULL);
	g_hNotifyThread = CreateThread(NULL, 0, UpdateNotifyThreadProc, NULL, 0, &g_dwNotifyThreadId);
}

////////////////////////////////////////////////////////////////
void EnableUpdateNotify()
{
	MSG msg;
	EnterCriticalSection(&g_csec);
	g_bEnableNotify = TRUE;
	while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}

////////////////////////////////////////////////////////////////
void DisableUpdateNotify()
{
	MSG msg;
	EnterCriticalSection(&g_csec);
	g_bEnableNotify = FALSE;
	while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}

////////////////////////////////////////////////////////////////
void SetUpdateNotify(LPCTSTR pszDir)
{
	if (_tcsicmp(pszDir, g_szNotifyDir) == 0)
		return;

	EnterCriticalSection(&g_csec);
	_tcscpy(g_szNotifyDir, pszDir);
	if (!_tcslen(g_szNotifyDir))
		_tcscpy(g_szNotifyDir, _T("\\"));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}

////////////////////////////////////////////////////////////////
void UninitUpdateNotify()
{
	g_bNotifyExit = TRUE;
	SetEvent(g_hEventBreak);
	WaitForSingleObject(g_hNotifyThread, INFINITE);
	DeleteCriticalSection(&g_csec);
	CloseHandle(g_hEventBreak);
}

///////////////////////////////////////////////////////////////
void OnDlgPathBrowseFolder(HWND hDlg, int nEditId, int nTitleId)
{
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szFolderTo[MAX_PATH] = _T("");
	BOOL bQuote;
	
	//ꏊ擾
	GetWindowText(GetDlgItem(hDlg, nEditId), szTemp, sizeof(szTemp));
	bQuote = (szTemp[0] == _T('"'));
	if (!bQuote)
		_tcscpy(szFolderTo, szTemp);
	else
	{
		TCHAR *p;

		_tcscpy(szFolderTo, szTemp+1);
		p = _tcsrchr(szFolderTo, _T('"'));
		if (p)
			*p = _T('\0');
	}
	
	//tH_/t@Cw_CAOI[v
	CFolderDlg fd;
	int nRet = fd.ShowFolderDlg(GetResourceString(nTitleId), szFolderTo, sizeof(szFolderTo));
	if (nRet == IDOK)
	{
		if (_tcslen(szFolderTo) == 0)
			_tcscpy(szFolderTo, GetRootName());
		else
		{
			if (!bQuote)
				SetWindowText(GetDlgItem(hDlg, nEditId), szFolderTo);
			else
			{
				_stprintf(szTemp, _T("\"%s\""), szFolderTo);
				SetWindowText(GetDlgItem(hDlg, nEditId), szTemp);
			}
		}
	}
	SetFocus(hDlg);
}

///////////////////////////////////////////////////////////////
void OnDlgPathBrowseFile(HWND hDlg, int nEditId, int nTitleId, LPCTSTR szWildcard)
{
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szFolderTo[MAX_PATH] = _T("");
	BOOL bQuote;
	
	//ꏊ擾
	GetWindowText(GetDlgItem(hDlg, nEditId), szTemp, sizeof(szTemp));
	bQuote = (szTemp[0] == _T('"'));
	if (!bQuote)
		_tcscpy(szFolderTo, szTemp);
	else
	{
		TCHAR *p;

		_tcscpy(szFolderTo, szTemp+1);
		p = _tcsrchr(szFolderTo, _T('"'));
		if (p)
			*p = _T('\0');
	}
	
	//tH_/t@Cw_CAOI[v
	CFolderDlg fd;
	int nRet = fd.ShowFileDlg(GetResourceString(nTitleId), szFolderTo, sizeof(szFolderTo), szWildcard);
	if (nRet == IDOK)
	{
		//if (_tcslen(szFolderTo) == 0)
		//	_tcscpy(szFolderTo, GetRootName());
		if (!bQuote)
			SetWindowText(GetDlgItem(hDlg, nEditId), szFolderTo);
		else
		{
			_stprintf(szTemp, _T("\"%s\""), szFolderTo);
			SetWindowText(GetDlgItem(hDlg, nEditId), szTemp);
		}
	}
	SetFocus(hDlg);
}

///////////////////////////////////////////////////////////////
BOOL ProcessShortcutKey(HWND hwnd, WORD vk)
{
	WPARAM wp;

	if (GetKeyState(VK_CONTROL) & 0x8000)
	{
		switch (vk)
		{
		case 'Q':
			wp = ID_FILE_EXIT;
			break;
		case 'C':
			wp = ID_EDIT_COPY;
			break;
		case 'X':
			wp = ID_EDIT_CUT;
			break;
		case 'V':
			wp = ID_EDIT_PASTE;
			break;
		case 'A':
			wp = ID_EDIT_SELECTALL;
			break;
		case 'F':
			wp = ID_EDIT_FILESEARCH;
			break;
		case 'R':
			wp = ID_VIEW_UPDATE;
			break;
		case 'O':
			wp = ID_FILE_COPY_FOLDER;
			break;
		case 'T':
			wp = ID_FILE_MOVE_FOLDER;
			break;
		case 'S':
			wp = ID_FILE_SHORTCUT_FOLDER;
			break;
		case 'L':
			wp = ID_VIEW_STYLE;
			break;
		case 'P':
			wp = ID_FILE_PROPERTY;
			break;
		case 'D':
			wp = ID_FILE_DELETE;
			break;
		case 'N':
			wp = ID_FILE_CREATEFOLDER;
			break;
		case 'B':
			wp = ID_FILE_OPEN_PARAM;
			break;
		case 'I':
			wp = ID_FAVORITES_ADD;
			break;
		case 'U':
			wp = ID_TOOL_USERPATH;
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			wp = ID_FILE_OPEN_APP + (vk - '1');
			break;
		case '0':
			wp = ID_FILE_OPEN_APP + (9);
			break;
		default:
			wp = 0;
			break;
		}
	}
	else if (GetKeyState(VK_MENU) & 0x8000)
	{
		switch (vk)
		{
		case VK_RIGHT:
			wp = ID_GO_FRONT;
			break;
		case VK_LEFT:
			wp = ID_GO_BACK;
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			wp = ID_TOOL_USERPATH_MENU + (vk - '1');
			break;
		case '0':
			wp = ID_TOOL_USERPATH_MENU + (9);
			break;
		default:
			wp = 0;
			break;
		}
	}
	else
	{
		switch (vk)
		{
		case VK_BACK:
			wp = ID_VIEW_UPFOLDER;
			break;
		case VK_DELETE:
			wp = ID_FILE_DELETE;
			break;
		case VK_F3:
			wp = ID_EDIT_FILESEARCH;
			break;
		case VK_F4:
			wp = ID_TOOL_OPTION;
			break;
		case VK_F5:
			wp = ID_VIEW_UPDATE;
			break;
		default:
			wp = 0;
			break;
		}
	}
	if (wp)
	{
		PostMessage(hwnd, WM_COMMAND, wp, NULL);
		return TRUE;
	}

	return FALSE;
}
