//DeleteDlg.cpp
#include "GSFinder.h"
#include "DeleteDlg.h"

#define ID_THREAD_DELETE 2
CDeleteFileDlg* pdfd;
////////////////////////////////////////////////////////////////
typedef struct _tagDeleteThread
{
	int m_nCount;
	BOOL* m_pbCancel;
	LISTITEMINFO* m_lpliinfo;
	LPCTSTR m_lpszFolder;
	HWND m_hWnd; 
}DELETETHREAD;
/////////////////////////////////////////////////////////////////////////////
CDeleteFileDlg::CDeleteFileDlg()
{
	m_nCount = 0;
	m_bCancel = FALSE;
	m_lpliinfo = NULL;
	m_lpszFolder = NULL;
	m_hWnd = NULL;
	m_bTimerReset = TRUE;		//ADD TODA (from GSFinder ver.1.99)
}
/////////////////////////////////////////////////////////////////////////////
//t@C폜
BOOL DeleteFileWithMessage(LPCTSTR lpszPath, int* lpRetCode, HWND hDlg, BOOL* pbDone)
{
	if (pbDone)
		*pbDone = FALSE;

	//\
	LPTSTR lpszFileName = wcsrchr(lpszPath, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPath;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//mFbZ[W\
	if (*lpRetCode == RETCODE_YES || *lpRetCode == RETCODE_NO)
	{
		//MOD START TODA (from GSFinder ver.1.99)
		/*TCHAR szMsg[128];
		DWORD dwAttr = GetFileAttributes(lpszPath);
		if ((dwAttr&FILE_ATTRIBUTE_SYSTEM)==FILE_ATTRIBUTE_SYSTEM)
			wsprintf(szMsg, IDS_FMT_DEL_SYSTEM, lpszFileName);
		else if ((dwAttr&FILE_ATTRIBUTE_READONLY)==FILE_ATTRIBUTE_READONLY)
			wsprintf(szMsg, IDS_FMT_DEL_READONLY, lpszFileName);
		else
			wsprintf(szMsg, IDS_FMT_DEL_FILE, lpszFileName);
		SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
		*lpRetCode = pdfd->m_nRetCode;*/

		TCHAR szMsg[128];
		DWORD dwAttr = GetFileAttributes(lpszPath);
		if ((dwAttr&FILE_ATTRIBUTE_SYSTEM) == FILE_ATTRIBUTE_SYSTEM) {
			wsprintf(szMsg, IDS_FMT_DEL_SYSTEM, lpszFileName);
			SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
			*lpRetCode = pdfd->m_nRetCode;
		}
		else if ((dwAttr&FILE_ATTRIBUTE_READONLY) == FILE_ATTRIBUTE_READONLY) {
			wsprintf(szMsg, IDS_FMT_DEL_READONLY, lpszFileName);
			SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
			*lpRetCode = pdfd->m_nRetCode;
		}
		//MOD END
	}

	//̏ꍇ폜Ȃ
	if (*lpRetCode == RETCODE_NO || *lpRetCode == RETCODE_ALL_NO)
	{
		return TRUE;
	}

	//ۂ̍폜
	SetFileAttributes(lpszPath, FILE_ATTRIBUTE_NORMAL);
	if (!DeleteFile(lpszPath))
	{
		return FALSE;
	}

	TCHAR szTemp[32];
	pdfd->m_nExecCount += 1;
	wsprintf(szTemp, _T("%d/%d"), pdfd->m_nExecCount, pdfd->m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pdfd->m_nExecCount, 0);

	if (pbDone)
		*pbDone = TRUE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL DeleteFolder(LPCTSTR lpszPath, BOOL* lpCancelMode, int* lpRetCode, HWND hDlg, BOOL* pbDone)
{
	if (pbDone)
		*pbDone = FALSE;

	//\
	LPTSTR lpszFileName = wcsrchr(lpszPath, _T('\\'));
	if (!lpszFileName)
	{
		lpszFileName = (LPTSTR)lpszPath;
	}
	else
	{
		++lpszFileName;
	}
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//폜mF
	if (*lpRetCode == RETCODE_YES || *lpRetCode == RETCODE_NO)
	{
		TCHAR szMsg[128];
		wsprintf(szMsg, IDS_FMT_DEL_FOLDER, lpszFileName);
		
		SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
		*lpRetCode = pdfd->m_nRetCode;
	}
	//̏ꍇ폜Ȃ
	if (*lpRetCode == RETCODE_NO || *lpRetCode == RETCODE_ALL_NO)
	{
		return TRUE;
	}

	//폜tH_̃t@C
	TCHAR szTemp[MAX_PATH+4];
	wsprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do
		{
			int nRetCode = RETCODE_ALL_YES;
			if (*lpCancelMode){
				FindClose(hFind);
				return TRUE;
			}
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//tH_
				LPTSTR lpszFolderPath = new TCHAR[wcslen(lpszPath)+wcslen(finddata.cFileName)+2];
				wsprintf(lpszFolderPath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				if (!DeleteFolder(lpszFolderPath, lpCancelMode, &nRetCode, hDlg, NULL))
				{
					FindClose(hFind);
					delete[] lpszFolderPath;
					return FALSE;
				}
				delete[] lpszFolderPath;
			}
			else
			{
				//t@C
				LPTSTR lpszFilePath = new TCHAR[wcslen(lpszPath)+wcslen(finddata.cFileName)+2];
				wsprintf(lpszFilePath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				if (!DeleteFileWithMessage(lpszFilePath, &nRetCode, hDlg, NULL))
				{
					FindClose(hFind);
					delete[] lpszFilePath;
					return FALSE;
				}
				delete[] lpszFilePath;
			}
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	pdfd->m_nExecCount += 1;
	wsprintf(szTemp, _T("%d/%d"), pdfd->m_nExecCount, pdfd->m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pdfd->m_nExecCount, 0);

	BOOL bRet = RemoveDirectory(lpszPath);

	if (pbDone)
		*pbDone = bRet;
	return bRet;
}

/////////////////////////////////////////////////////////////////////////////
//폜̃[J[Xbh
DWORD WINAPI DeleteFileThread(LPVOID pParam)
{
	DELETETHREAD* pdt = (DELETETHREAD*)pParam;

	int nRetCode = RETCODE_YES;
	
	//MOD START TODA (from GSFinder ver.1.99)
//	if (pdt->m_nCount < 2 && pdt->m_lpliinfo[0].nItem == LIST_ITEM_FILE)
	if (pdt->m_nCount < 2)
	//MOD END
		nRetCode = RETCODE_ALL_YES;

//DEL START TODA
//	//\
//	TCHAR szTemp[MAX_PATH+4];
//	TCHAR szPath[MAX_PATH];
//	LPTSTR lpszTemp = wcsrchr(pdt->m_lpszFolder, _T('\\'));
//	if (lpszTemp)
//		wcscpy(szPath, ++lpszTemp);
//	else
//		wcscpy(szPath, _T("\\"));
//
//	wsprintf(szTemp, IDS_FMT_DELFROM, szPath);
//	SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FOLDER), szTemp);
//DEL END

	for (int i=0; i<pdt->m_nCount; i++)
	{
		if (*pdt->m_pbCancel)
		{
			SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
			SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}

		//ADD TODA
		//\
		TCHAR szTemp[MAX_PATH+4];
		TCHAR szPath[MAX_PATH];
		LPTSTR lpszTemp = wcsrchr(pdt->m_lpliinfo[i].szPath, _T('\\'));
		if (lpszTemp)
			wcscpy(szPath, ++lpszTemp);
		else
			wcscpy(szPath, _T("\\"));

		wsprintf(szTemp, IDS_FMT_DELFROM, szPath);
		SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FOLDER), szTemp);
		//ADD END

		memset(&szPath, 0, sizeof(szPath));
		//MOD START TODA
//		wsprintf(szPath, _T("%s\\%s"), pdt->m_lpszFolder, pdt->m_lpliinfo[i].szName);
		wsprintf(szPath, _T("%s\\%s"), pdt->m_lpliinfo[i].szPath, pdt->m_lpliinfo[i].szName);
		//MOD END

		//ۂ̍폜
		if (pdt->m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			//ADD START TODA (WindowstH_`FbN)
			if(wcsicmp(g_MainWnd.m_szWindowsPath, szPath) == 0)
			{
				MessageBox(pdt->m_hWnd, IDS_MSG_PASTEERROR3, NULL, MB_OK|MB_ICONSTOP);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_PASTEERROR3);
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
			//ADD END

			//tH_̍폜
			if (!DeleteFolder(szPath, pdt->m_pbCancel, &nRetCode, pdt->m_hWnd, &pdt->m_lpliinfo[i].bDone))
			{
				SendMessage(pdt->m_hWnd, WM_SHOWERRMSG, (WPARAM)pdt->m_lpliinfo[i].szName, 0);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		else if (pdt->m_lpliinfo[i].nItem == LIST_ITEM_FILE)
		{
			//t@C̍폜
			if (!DeleteFileWithMessage(szPath, &nRetCode, pdt->m_hWnd, &pdt->m_lpliinfo[i].bDone))
			{
				SendMessage(pdt->m_hWnd, WM_SHOWERRMSG, (WPARAM)pdt->m_lpliinfo[i].szName, 0);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		if (nRetCode == RETCODE_ALL_NO)
		{
			SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_CANCELED);
			SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}
	} // End of for
	
	SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), IDS_MSG_DONE);
	SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
	ExitThread(0);
	return 0;
}
////////////////////////////////////////////////////////////////
void CDeleteFileDlg::OnInitDialog(HWND hDlg)
{
	TCHAR szTemp[32];

	m_nExecCount = 0;
	m_bCancel = FALSE;
	m_hWnd = hDlg;
	CenterWindow(hDlg);

	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), IDS_MSG_PREP_DEL);
	m_nFileCount = GetFileAndFolderCount(m_lpszFolder, m_lpliinfo, m_nCount);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, m_nFileCount));	
	wsprintf(szTemp, _T("0/%d"), m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);

//DEL START TODA (from GSFinder ver.1.99)
//	if (m_nCount < 2)
//	{
//		m_nRetCode = RETCODE_ALL_YES;
//	}
//DEL END

	CenterWindow(hDlg);
	ShowWindow(hDlg, SW_SHOW);

	static DELETETHREAD DeleteThread;
	DeleteThread.m_nCount = m_nCount;
	DeleteThread.m_pbCancel = &m_bCancel;
	DeleteThread.m_lpliinfo = m_lpliinfo;
	DeleteThread.m_lpszFolder = m_lpszFolder;
	DeleteThread.m_hWnd = m_hWnd;
#ifndef __WCEEMULATION
	m_hThread = CreateThread(NULL, 0, DeleteFileThread, (LPVOID)&DeleteThread, 0, &m_dwThreadID);
#else
	EndDialog(hDlg, 0);
#endif
}
////////////////////////////////////////////////////////////////
LRESULT CALLBACK DeleteFileDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pdfd->OnInitDialog(hDlg);
			//ADD START TODA (from GSFinder ver.1.99)
			SetTimer(hDlg, ID_TIMER_RESETTIME, TIMER_RESETTIME_INT, NULL);
			//ADD END
			return TRUE;
		}
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
				case IDC_CANCELMODE:
				{
					pdfd->m_bCancel = TRUE;
					EnableWindow(GetDlgItem(hDlg, IDC_CANCELMODE), FALSE);
					SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), IDS_MSG_CANCELING);
					return TRUE;
				}
			}
			break;
		}
		case WM_DLGCLOSE:
		{
			CloseHandle(pdfd->m_hThread);
			//ADD START TODA (from GSFinder ver.1.99)
			KillTimer(hDlg, ID_TIMER_RESETTIME);
			//ADD END
			EndDialog(hDlg, 0);
			return TRUE;
		}
		case WM_SHOWMSG:
		{
			pdfd->ShowDeleteMessage((LPTSTR)wParam);
			return TRUE;
		}
		case WM_SHOWERRMSG:
		{
			pdfd->ShowErrorMessage((LPTSTR)wParam);
			return TRUE;
		}
		//ADD START TODA (from GSFinder ver.1.99)
		case WM_TIMER:
		{
			if (wParam == ID_TIMER_RESETTIME && pdfd->m_bTimerReset)
				SystemIdleTimerReset();
			return TRUE;
		}
		//ADD END
	}
	return FALSE;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK DeleteMsgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			CenterWindow(hDlg);
			pdfd->m_nRetCode = RETCODE_YES;
			SetWindowText(GetDlgItem(hDlg, IDC_DELETE_MSG), pdfd->m_szDeleteMsg);
			if (pdfd->m_bFirst)
			{
				ShowWindow(GetDlgItem(hDlg, IDC_BTN_ALL_YES), SW_HIDE);
				ShowWindow(GetDlgItem(hDlg, IDC_BTN_ALL_NO), SW_HIDE);
				RECT rc;
				GetWindowRect(hDlg, &rc);
				SetWindowPos(hDlg, HWND_TOP, 0, 0, rc.right-rc.left, rc.bottom-rc.top-22, SWP_NOMOVE|SWP_NOZORDER);
				CenterWindow(hDlg);
			}
			return TRUE;
		}
		case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDC_BTN_YES:
				pdfd->m_nRetCode = RETCODE_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;
			case IDC_BTN_NO:
				pdfd->m_nRetCode = RETCODE_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;
			case IDC_BTN_ALL_YES:
				pdfd->m_nRetCode = RETCODE_ALL_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;
			case IDC_BTN_ALL_NO:
				pdfd->m_nRetCode = RETCODE_ALL_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;
			}
		}
		case WM_CLOSE:
		{
			pdfd->m_nRetCode = RETCODE_NO;
			EndDialog(hDlg, IDCANCEL);
			return TRUE;
		}
	}
	return FALSE;
}
////////////////////////////////////////////////////////////////
void CDeleteFileDlg::ShowErrorMessage(LPTSTR lspzFileName)
{
	TCHAR szTemp[MAX_PATH];
	m_bTimerReset = FALSE;			//ADD TODA (from GSFinder ver.1.99)
	wsprintf(szTemp, IDS_FMT_DELERROR, lspzFileName);
	m_bTimerReset = TRUE;			//ADD TODA (from GSFinder ver.1.99)
	MessageBox(m_hWnd, szTemp, NULL, MB_OK|MB_ICONSTOP);
}
////////////////////////////////////////////////////////////////
int CDeleteFileDlg::ShowDeleteMessage(LPTSTR lpszMsg)
{
	wcscpy(m_szDeleteMsg, lpszMsg);
	m_bTimerReset = FALSE;			//ADD TODA (from GSFinder ver.1.99)
	DialogBox(g_hInst, (LPCTSTR)IDD_DELETEMSG_DLG, m_hWnd, (DLGPROC)DeleteMsgProc);
	m_bTimerReset = TRUE;			//ADD TODA (from GSFinder ver.1.99)
	return m_nRetCode;
}
////////////////////////////////////////////////////////////////
int CDeleteFileDlg::ShowDeleteFileDlg(LPCTSTR lpszFolder, LISTITEMINFO* lpliinfo, int nCount)
{
	pdfd = this;

	m_lpszFolder = lpszFolder;
	m_lpliinfo = lpliinfo;
	m_nCount = nCount;

	//ŏ̊mF
	m_bFirst = TRUE;
	if (m_nCount > 1)
		wsprintf(m_szDeleteMsg, IDS_FMT_DELOBJECTS, m_nCount);
	else
	{
		LPCTSTR lpszFileName = wcsrchr(m_lpliinfo[0].szName, _T('\\'));
		//MOD START TODA (from GSFinder ver.1.99)
//		if (lpszFileName)
//			wsprintf(m_szDeleteMsg, IDS_FMT_DELFILE, ++lpszFileName);
//		else
//			wsprintf(m_szDeleteMsg, IDS_FMT_DELFILE, m_lpliinfo[0].szName);
		if (m_lpliinfo[0].nItem == LIST_ITEM_FOLDER)
			wsprintf(m_szDeleteMsg, IDS_FMT_DEL_FOLDER, lpszFileName ? ++lpszFileName : m_lpliinfo[0].szName);
		else
			wsprintf(m_szDeleteMsg, IDS_FMT_DEL_FILE, lpszFileName ? ++lpszFileName : m_lpliinfo[0].szName);	
		//MOD END
	}
	int nRet = DialogBox(g_hInst, (LPCTSTR)IDD_DELETEMSG_DLG, g_MainWnd.m_hWnd, (DLGPROC)DeleteMsgProc);
	
	if (nRet == IDOK)
	{
		m_bFirst = FALSE;
		DisableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)
		DialogBox(g_hInst, (LPCTSTR)IDD_FILEDELETE_DLG, g_MainWnd.m_hWnd, (DLGPROC)DeleteFileDlgProc);
		EnableUpdateNotify();				//ADD TODA (t@CύXʒm from Y.Nagamidori)
	}

	pdfd = NULL;
	return nRet;
}
////////////////////////////////////////////////////////////////
