// GSFinder.cpp : O[o֐`

////////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "MainWnd.h"
#include "OptionDlg.h"

HINSTANCE	g_hInst;					// ݂̃CX^X
CMainWnd	g_MainWnd;					//CEChE
HWND		g_hwndPrev = NULL;				//ADD TODA
BOOL		g_bCmdParam = FALSE;
LPTSTR		g_lpszFirstLoadFolder = NULL;
TCHAR		g_szRootName[MAX_PATH] = {0};	//ADD TODA
TCHAR		g_szDecSep[16] = _T(".");		//_؂蕶

//ADD START TODA
BOOL		g_bMoving = FALSE;
BOOL		g_bDraging = FALSE;
int			g_nStartPos = 0;
int			g_nLastWidth = 0;
int			g_nLastHeight = 0;
//ADD END

SHACTIVATEINFO g_sai;
BOOL g_bIgureClick = FALSE;				//ADD TODA (from GSFinder ver.1.99)

static TCHAR	s_szStrBuf[MAX_PATH*2];	//ADD GORIPON

////////////////////////////////////////////////////////////////
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	//R}hC𔻒
	if (wcsncmp(lpCmdLine, APP_CMD_PARAM, APP_CMD_PARAM_LEN) == 0)
		g_lpszFirstLoadFolder = lpCmdLine + APP_CMD_PARAM_LEN;
	else if (wcslen(lpCmdLine))
	//MOD START TODA (_uNH[e[Vꍇ폜)
	{
		if(*lpCmdLine == _T('\"'))
		{
			g_lpszFirstLoadFolder = lpCmdLine + 1;
			LPTSTR lpszTemp = wcschr(g_lpszFirstLoadFolder, _T('\"'));
			if(lpszTemp) *lpszTemp = 0x00;
		}
		else
			g_lpszFirstLoadFolder = lpCmdLine;
	}
	//MOD END

	//dN̖h~
	HANDLE hMutex = CreateMutex(NULL, NULL, APP_MUTEX_NAME);
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		HWND hPrevWnd = FindWindow(APP_MUTEX_NAME, NULL);
		if (hPrevWnd)
		{
			SetForegroundWindow(hPrevWnd);
			if (g_lpszFirstLoadFolder)
			{
				COPYDATASTRUCT cds;
				cds.dwData = WM_DROPFILES;
				cds.lpData = g_lpszFirstLoadFolder;
				cds.cbData = (wcslen(g_lpszFirstLoadFolder) + 1) * sizeof(TCHAR);
				SendMessage(hPrevWnd, WM_COPYDATA, NULL, (LPARAM)&cds);
			}
		}
		return 0;
	}

	MSG msg;
	HACCEL hAccelTable;

	GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_SDECIMAL, g_szDecSep, 16);
	//ADD START TODA (t@CύXʒm from Y.Nagamidori)
	InitUpdateNotify();
	//ADD END

	//CEChE̍쐬
	g_hInst = hInstance;
	g_MainWnd.Init();
	g_MainWnd.ShowWindow();	
	g_hwndPrev = g_MainWnd.m_ListView.m_hWnd;	//ADD TODA

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDR_MAINFRAME);

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(g_MainWnd.m_hWnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	//ADD START TODA (t@CύXʒm from Y.Nagamidori)
	UninitUpdateNotify();
	//ADD END
	return msg.wParam;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	//L[͏
	if(message == WM_NOTIFY) {

		WPARAM wRtn = 0;
		switch (((LPNMHDR)lParam)->code) {
			//c[r[/Xgr[̃L[͂̏ꍇ
			case LVN_KEYDOWN:
				wRtn = g_MainWnd.m_ListView.OnKeyDown((NMLVKEYDOWN*)lParam);
				break;
			case TVN_KEYDOWN:
				wRtn = g_MainWnd.m_TreeView.OnKeyDown((NMTVKEYDOWN*)lParam);
				break;
		}
		//bZ[Wϊ
		if(wRtn != 0) {
			message = WM_COMMAND;
			wParam = wRtn | (wParam&0xFFFF0000);
		}
	}

	HWND hFocus = GetFocus();
	int wmId, wmEvent;
	switch (message) 
	{
		case WM_COMMAND:
		{
			wmId    = LOWORD(wParam);
			wmEvent = HIWORD(wParam);

			if (wmId >= ID_FILE_OPEN_APP && wmId < ID_FILE_OPEN_APP + MAX_OPENAPP)
			{
				g_MainWnd.m_ListView.OnFileOpenApp(wmId - ID_FILE_OPEN_APP);
				break;
			}
			if (wmId >= ID_TOOL_USERPATH_MENU && wmId < ID_TOOL_USERPATH_MENU + MAX_OPENAPP)
			{
				g_MainWnd.m_ListView.OnToolUserPath(wmId - ID_TOOL_USERPATH_MENU);
				break;
			}
			if (wmId >= ID_TOOL_FAVORITES_LNK && wmId < ID_TOOL_FAVORITES_LNK + g_MainWnd.m_ListView.m_nFavoritesCount)
			{
				g_MainWnd.m_ListView.OnToolFavoritesLnk(wmId - ID_TOOL_FAVORITES_LNK);
				break;
			}

			//^bv&z[hpO
			//g_MainWnd.m_ListView.OnSelectMenuLoop();	//DEL GORIPON
			g_MainWnd.m_TreeView.OnSelectMenuLoop();

			//bZ[WID
			wmId=g_MainWnd.m_ListView.CheckMessageID(wmId);

			switch (wmId)
			{
				//tH[JXݒ
				case ID_KEY_TAB:
				{
					if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					{
						if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
							SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
						else
							SetFocus(g_MainWnd.m_TreeView.m_hWnd);
					}
					else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
						SetFocus(g_MainWnd.m_ListView.m_hWnd);
					else
					{
						if (g_MainWnd.m_bShowFolder)
							SetFocus(g_MainWnd.m_TreeView.m_hWnd);
						else
							SetFocus(g_MainWnd.m_ListView.m_hWnd);
					}
					break;
				}
				//tH[JXݒ(t)
				case ID_KEY_SFT_TAB:
				{
					if (hFocus == g_MainWnd.m_ListView.m_hWnd)
					{
						if (g_MainWnd.m_bShowFolder)
							SetFocus(g_MainWnd.m_TreeView.m_hWnd);
						else if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
							SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
					}
					else if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
					{
						if (g_MainWnd.m_CmdBands.m_Settings.bShowAddressBar)
							SetFocus(g_MainWnd.m_CmdBands.m_hComboBox);
						else
							SetFocus(g_MainWnd.m_ListView.m_hWnd);
					}
					else
					{
						SetFocus(g_MainWnd.m_ListView.m_hWnd);
					}
					break;
				}
				//o[W
				case ID_FILE_ABOUT:
					DialogBox(g_hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
					break;
				//I
				case ID_FILE_EXIT:
					g_MainWnd.OnClose();
					break;
				//CTRLL[ON
				case ID_EDIT_CONTROL_ON:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);	//ADD GORIPON
					g_MainWnd.OnEditCtrlOn();
					break;
				//SHIFTL[ON
				case ID_EDIT_SHIFT_ON:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);	//ADD GORIPON
					g_MainWnd.OnEditShiftOn();
					break;
				//hbO&hbv[hON/OFF
				case ID_EDIT_DRAGDROP:
					g_MainWnd.OnDragDropMode();
					break;
				//؂
				case ID_EDIT_CUT:
				{
					//MOD START TODA (Nbv{[hǉ)
					if(hFocus == g_MainWnd.m_ListView.m_hWnd) {
						g_MainWnd.m_ListView.OnEditCut();
					}
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd) {
						g_MainWnd.m_TreeView.OnEditCut();
					}
					else {
						SendMessage(hFocus, WM_CUT, 0x00, 0x00);
						g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE, FALSE);
					}
					//MOD END
					break;
				}
				//Rs[
				case ID_EDIT_COPY:
				{
					//MOD START TODA (Nbv{[hǉ)
					if(hFocus == g_MainWnd.m_ListView.m_hWnd) {
						g_MainWnd.m_ListView.OnEditCopy();
					}
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd) {
						g_MainWnd.m_TreeView.OnEditCopy();
					}
					else {
						SendMessage(hFocus, WM_COPY, 0x00, 0x00);
						g_MainWnd.m_CmdBands.SetEnableEditPaste(TRUE, FALSE);
					}
					//MOD END
					break;
				}
				//\t
				case ID_EDIT_PASTE:
				{
					//MOD START TODA (Nbv{[hǉ)
					if(hFocus == g_MainWnd.m_ListView.m_hWnd ||
					   hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_ListView.OnEditPaste();
					else
						SendMessage(hFocus, WM_PASTE, 0x00, 0x00);
					//MOD END
					break;
				}
				// V[gJbg̓\t
				case ID_EDIT_PASTE_SHORTCUT:
					g_MainWnd.m_ListView.OnEditPasteShortcut();
					break;
				//t@C
				case ID_EDIT_FILESEARCH:
					g_MainWnd.m_ListView.OnFileSearch();
					break;
				//Xe[^Xo[̕\
				case ID_VIEW_STATUSBAR:
					g_MainWnd.OnViewStatusBar();
					break;
				//c[o[̕\
				case ID_VIEW_TOOLBAR:
					g_MainWnd.m_CmdBands.OnViewToolBar();
					break;
				//AhXo[̕\
				case ID_VIEW_ADDRESSBAR:
					g_MainWnd.m_CmdBands.OnViewAddressBar();
					break;
				//Xg̃X^C
				case ID_VIEW_LARGEICON:
					g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_LARGEICON);
					break;
				//\`->ACR
				case ID_VIEW_SMALLICON:
					g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_SMALLICON);
					break;
				//\`->ꗗ
				case ID_VIEW_LIST:
					g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_LIST);
					break;
				//\`->ڍ
				case ID_VIEW_REPORT:
					g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_REPORT);
					break;
				//\`->ڍ(sI)
				case ID_VIEW_REPORTLINE:
					g_MainWnd.m_ListView.OnChangeListStyle(ID_VIEW_REPORTLINE);
					break;
				//\`̕ύX
				case ID_VIEW_STYLE:
					g_MainWnd.m_ListView.OnListStyle();
					break;
				//Xg̕בւ(O)
				case ID_VIEW_SORT_NAME:
					g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_NAME);
					break;
				//Xg̕בւ()
				case ID_VIEW_SORT_EXT:
					g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_EXT);
					break;
				//Xg̕בւ(TCY)
				case ID_VIEW_SORT_SIZE:
					g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_SIZE);
					break;
				//Xg̕בւ(XV)
				case ID_VIEW_SORT_TIME:
					g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_TIME);
					break;
				//Xg̕בւ(~)
				case ID_VIEW_SORT_NOT_RAISE:
					g_MainWnd.m_ListView.OnChangeSort(ID_VIEW_SORT_NOT_RAISE);
					break;
				//ŐV̏ɍXV
				case ID_VIEW_UPDATE:
					g_MainWnd.OnViewUpdate();
					break;
				//̃tH_
				case ID_VIEW_UPFOLDER:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnViewUpFolder();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnViewUpFolder();
					break;
				}
				//tH_\ON/OFF
				case ID_VIEW_FOLDER:
					g_MainWnd.OnViewFolder();
					break;
				//Eɕׂ
				case ID_VIEW_SIDE:
//MOD START GORIPON
					//g_MainWnd.OnViewSide();
					if (g_MainWnd.m_bLandscapeMode)
						g_MainWnd.OnViewSideL();
					else
						g_MainWnd.OnViewSide();
//MOD END
					break;
//ADD START GORIPON
				//nC]\
				case ID_VIEW_HIGHRES:
					g_MainWnd.OnViewHighRes(!g_MainWnd.m_bHighRresolutionMode);
					break;
//ADD END
				//t@CJ
				case ID_FILE_OPEN:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileOpen();
					break;
				}
				//ADD START TODA (from GSFinder ver.1.99)
				//AvP[V֑
				case ID_FILE_TO_APP:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileToApp();
					break;
				}
				//ADD END
				//p[^tŊJ
				case ID_FILE_OPEN_PARAM:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileOpenParam();
					break;
				}
				//VKtH_쐬
				case ID_FILE_CREATEFOLDER:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
					g_MainWnd.m_ListView.OnFileCreateFolder();
					break;
				//V[gJbg쐬
				case ID_FILE_CREATE_SHORTCUT:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileCreateShortcut();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileCreateShortcut();
					break;
				}
				//폜
				case ID_FILE_DELETE:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd) {
						g_MainWnd.m_ListView.OnFileDelete();
					}
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd) {
						g_MainWnd.m_TreeView.OnFileDelete();
					}
					break;
				}
				//O̕ύX
				case ID_FILE_RENAME:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileRename();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileRename();
					break;
				}
				//vpeB
				case ID_FILE_PROPERTY:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileProperty();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileProperty();
					break;
				}
				//ԊOM
				case ID_FILE_IR_SEND:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileIRSend();
//DEL START GORIPON
					//else
					//if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
					//	g_MainWnd.m_TreeView.OnFileIRSend();
//DEL END
					break;
				}
				//w̃tH_փV[gJbg쐬
 				case ID_FILE_SHORTCUT_FOLDER:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileShortcutFolder();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileShortcutFolder();
					break;
				}
				//wtH_Ƀt@CRs[
				case ID_FILE_COPY_FOLDER:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileCopyFolder();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileCopyFolder();
					break;
				}
				//wtH_Ƀt@Cړ
				case ID_FILE_MOVE_FOLDER:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileMoveFolder();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileMoveFolder();
					break;
				}
				//k
				case ID_FILE_COMPRESS:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileCompress();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFileCompress();
					break;
				}	
				//
				case ID_FILE_UNCOMPRESS:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileUnCompress();
					break;
				}
//ADD START GORIPON
				//[M
				case ID_FILE_MAIL_SEND:
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFileMailSend();
					break;
//ADD END
				//ORs[
				case ID_EDIT_COPY_FILE_NAME:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnEditCopyFileName();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnEditCopyFileName();
					break;
				}
				//pXRs[
				case ID_EDIT_COPY_FILE_PATH:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnEditCopyFilePath();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnEditCopyFilePath();
					break;
				}
				//SđI
				case ID_EDIT_SELECTALL:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
					ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, LVIS_SELECTED, LVIS_SELECTED);
					break;
				//I
				case ID_EDIT_NOTSEL_ALL:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
					ListView_SetItemState(g_MainWnd.m_ListView.m_hWnd, -1, 0, LVIS_SELECTED);
					break;
				//I̐؂ւ
				case ID_EDIT_SELECT_SWITCH:
					SetFocus(g_MainWnd.m_ListView.m_hWnd);
					g_MainWnd.m_ListView.OnEditSelectSwitch();
					break;
				//c[j[
				//lbg[Nڑ̊蓖
				case ID_TOOL_NETWORK_COM:
					g_MainWnd.OnNetworkDriveConnect();
					break;
				//lbg[Nڑ̐ؒf
				case ID_TOOL_NETWORK_DCOM:
					g_MainWnd.OnNetworkDriveDisconnect();
					break;
				//ActiveSync
				case ID_TOOL_ACTIVESYNC:
					g_MainWnd.OnToolActivesync();
					break;
				//PCN
				case ID_TOOL_PCLINK:
					g_MainWnd.OnToolPclink();
					break;
				//ԊOM
				case ID_FILE_IRRECEIVE:
					g_MainWnd.OnToolIRRecive();
					break;
				//IvV
				case ID_TOOL_OPTION:
				{
					COptionDlg od;
					od.ShowOptionDlg();
					break;
				}
				//i
				case ID_GO_FRONT:
					g_MainWnd.m_ListView.OnGoFront();
					break;
				//߂
				case ID_GO_BACK:
					g_MainWnd.m_ListView.OnGoBack();
					break;
//ADD START GORIPON
				//tH_\/t@C\ֈړ
				case ID_FOCUS_MOVE:
					if (g_MainWnd.m_CmdBands.m_bFocuaMoveList)
						SetFocus(g_MainWnd.m_ListView.m_hWnd);
					else
						SetFocus(g_MainWnd.m_TreeView.m_hWnd);
					break;
//ADD END
				//Cɓ֒ǉ
				case ID_FAVORITES_ADD:
				{
					if(hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnFavoritesAdd();
					else
					if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnFavoritesAdd();
					break;
				}
				//Cɓ̐
				case ID_FAVORITES_ARG:
					g_MainWnd.m_ListView.OnFavoritesOrganize();
					break;
				//c[{^hbv_E
				case IDC_BTN_GOTOFOLDER:
					g_MainWnd.m_ListView.OnGotoFolderDropDown();
					break;
				//}ChLg
				case ID_TOOL_MYDOCUMENTS:
					g_MainWnd.m_ListView.OnViewUpdate(g_MainWnd.m_szMyDocumentPath);
					break;
				//X^[gj[
				case ID_TOOL_STARTMENU:
					g_MainWnd.m_ListView.OnViewUpdate(g_MainWnd.m_szStartMenuPath);
					break;
				//fXNgbv
				case ID_TOOL_DESKTOP:
					g_MainWnd.m_ListView.OnViewUpdate(g_MainWnd.m_szDesktopPath);
					break;
				//}CRs[^
				case ID_TOOL_MYDEVICE:
					g_MainWnd.m_ListView.OnViewUpdate(_T(""));
					break;
				//[U[pX
				case ID_TOOL_USERPATH:
					g_MainWnd.m_ListView.OnUserPath();
					break;
			}

			//^bv&z[hp㏈
			//g_MainWnd.m_ListView.OnSelectMenuLoop();	//DEL GORIPON
			g_MainWnd.m_TreeView.OnSelectMenuLoop();

			switch (wmEvent)
			{
				//R{{bNX
				case CBN_SELENDOK:
				{
					HWND hwndComboBox = (HWND) lParam;
					if (hwndComboBox == g_MainWnd.m_CmdBands.m_hComboBox)
					{
						g_MainWnd.m_ListView.OnSelEndOK();
					}
					break;
				}
				default:
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		}
		//c[r[/Xgr[Cxg
		case WM_NOTIFY:
		{
			//MOD START TODA (from GSFinder ver.1.99)
			LPNMHDR pNmHdr = (LPNMHDR)lParam;
			switch (pNmHdr->code)
			{

			//^bvAhz[h
			case GN_CONTEXTMENU:
					if(g_bDraging) break;

					if (hFocus == g_MainWnd.m_ListView.m_hWnd)
						g_MainWnd.m_ListView.OnTapAndHold((NMRGINFO*)lParam);
					else
					if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
						g_MainWnd.m_TreeView.OnTapAndHold();
					return TRUE;
			//Xg_uNbN
			case NM_DBLCLK:
				if (hFocus == g_MainWnd.m_ListView.m_hWnd) {
					g_MainWnd.m_ListView.OnFileOpen();
				}
				break;
			//XgVONbN
			case NM_CLICK:
				//^bv&z[h
				g_MainWnd.m_TreeView.OnTapHoldCancel();
				//g_MainWnd.m_ListView.OnTapHoldCancel();	//DEL GORIPON

				//^bv&z[h̏ꍇ͉Ȃ
//MOD START GORIPON
				//if(g_MainWnd.m_ListView.m_bHolding ||
				//   g_MainWnd.m_TreeView.m_bHolding) break;
				if(g_MainWnd.m_TreeView.m_bHolding) break;
//MOD END

				//VONbNŎsw莞
				if (g_MainWnd.m_ListView.m_Settings.bSingleClick &&
					pNmHdr->hwndFrom == g_MainWnd.m_ListView.m_hWnd)
				{
					//MOD START TODA (from GSFinder ver.1.99)
					if (!(GET_KEYSTATE(VK_CONTROL)&0x8000) &&
						!(GET_KEYSTATE(VK_SHIFT)&0x8000) &&
						!(GET_KEYSTATE(VK_MENU)&0x8000) && 
						!g_bIgureClick)
					//MOD END
					{
						//IACe1݂̂̏ꍇ
						if (1 == ListView_GetSelectedCount(
									g_MainWnd.m_ListView.m_hWnd))
						{
							g_MainWnd.m_ListView.OnFileOpen();
							break;
						}
					}
					g_bIgureClick = FALSE;	//ADD TODA (from GSFinder ver.1.99)
				}

				//ENbN(Alt+NbN)ł͂Ȃꍇ
				if (!(!(GET_KEYSTATE(VK_CONTROL)&0x8000) &&
					  !(GET_KEYSTATE(VK_SHIFT)&0x8000) &&
					   (GET_KEYSTATE(VK_MENU)&0x8000)))
				{
					break;
				}
				//ENbN̏ꍇNM_RCLICK̏p(breakȂ)

			//ENbN
			case NM_RCLICK:
				//^bv&z[h
				g_MainWnd.m_TreeView.OnTapHoldCancel();
				//g_MainWnd.m_ListView.OnTapHoldCancel();	//DEL GORIPON

				//^bv&z[h̏ꍇ͉Ȃ
//MOD START GORIPON
				//if(g_MainWnd.m_ListView.m_bHolding ||
				//   g_MainWnd.m_TreeView.m_bHolding) break;
				if(g_MainWnd.m_TreeView.m_bHolding) break;
//MOD END

				//ENbNj[\
				if (hFocus == g_MainWnd.m_ListView.m_hWnd) {
					LPNMLISTVIEW lpnmlv = (LPNMLISTVIEW)lParam;
					g_MainWnd.m_ListView.OnRClick(lpnmlv->ptAction.x, lpnmlv->ptAction.y);
				}
				else
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					DWORD dwPos = GetMessagePos();
					g_MainWnd.m_TreeView.OnRClick(LOWORD(dwPos), HIWORD(dwPos), TRUE);
				}
				break;

			//EnterL[
			case NM_RETURN:
//DEL START GORIPON
				//if (hFocus == g_MainWnd.m_ListView.m_hWnd)
				//{
				//	if (GET_KEYSTATE(VK_MENU)&0x8000)
				//		g_MainWnd.m_ListView.OnFileProperty();
				//	else
				//		g_MainWnd.m_ListView.OnFileOpen();
				//}
				//else
//DEL END
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd)
				{
					if (GET_KEYSTATE(VK_MENU)&0x8000)
						g_MainWnd.m_TreeView.OnFileProperty();
				}
				break;

			//tH[JXݒ莞
			case NM_SETFOCUS:
				g_MainWnd.OnSetFocus((HWND)pNmHdr->hwndFrom);
				break;
			//tH[JXݒ莞
			case NM_KILLFOCUS:
				if (hFocus == g_MainWnd.m_TreeView.m_hWnd) {
					g_MainWnd.m_TreeView.OnKillFocus();
				}
				break;
			//O̕ύXJn
			case LVN_BEGINLABELEDIT:
				//^bv&z[h
				//g_MainWnd.m_ListView.OnTapHoldCancel();	//DEL GORIPON
				g_MainWnd.m_ListView.m_bEditing = TRUE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteBef();	//ADD TODA
				break;
			//O̕ύXI
			case LVN_ENDLABELEDIT:
				//^bv&z[h
				//g_MainWnd.m_ListView.OnTapHoldCancel();	//DEL GORIPON
				g_MainWnd.m_ListView.m_bEditing = FALSE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteAft();	//ADD TODA
				return g_MainWnd.m_ListView.OnEndLabelEdit((LV_DISPINFO*)lParam);
			//ACeI
			case LVN_ITEMCHANGED:
				if(g_bDraging) break;

				if(hFocus == g_MainWnd.m_ListView.m_hWnd)
					g_MainWnd.m_ListView.OnItemChanged();
				break;
			//JNbN
			case LVN_COLUMNCLICK:
				g_MainWnd.m_ListView.OnColumnClick((LPNMLISTVIEW)lParam);
				break;
			//ACRXV
			case LVN_GETDISPINFO:
				//ACRxǂݍ
				g_MainWnd.m_ListView.OnGetDispInfo((NMLVDISPINFO*)lParam);
				break;
			//hbO̊Jn
			case LVN_BEGINDRAG:
				//^bv&z[h
				//g_MainWnd.m_ListView.OnTapHoldCancel();	//DEL GORIPON
				g_bDraging = TRUE;
				g_MainWnd.OnBeginDrag((LPNMHDR)lParam);
				break;
			//hbO̊Jn
			case TVN_BEGINDRAG:
				//^bv&z[h
				g_MainWnd.m_TreeView.OnTapHoldCancel();
				g_bDraging = TRUE;
				g_MainWnd.OnBeginDrag((LPNMHDR)lParam);
				break;
			//O̕ύXJn
			case TVN_BEGINLABELEDIT:
				//^bv&z[h
				g_MainWnd.m_TreeView.OnTapHoldCancel();
				g_MainWnd.m_TreeView.m_bEditing = TRUE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteBef();	//ADD TODA
				g_MainWnd.m_TreeView.GetCurrentFolder();
				break;
			//O̕ύXI
			case TVN_ENDLABELEDIT:
				//^bv&z[h
				g_MainWnd.m_TreeView.OnTapHoldCancel();
				g_MainWnd.m_TreeView.m_bEditing = FALSE;
				g_MainWnd.m_CmdBands.SetEnableEditPasteAft();	//ADD TODA
				return g_MainWnd.m_TreeView.OnEndLabelEdit((TV_DISPINFO*)lParam);
			// tH[JXݒ肳ꂽꍇ
			case TVN_SELCHANGED:
				if(hFocus == g_MainWnd.m_TreeView.m_hWnd)
					g_MainWnd.m_TreeView.OnSelChanged((NMTREEVIEW*)lParam);
				break;
			//c[WJ
			case TVN_ITEMEXPANDING:
				g_MainWnd.m_TreeView.OnItemExpanding((NMTREEVIEW*)lParam);
				break;
			//c[WJI
			case TVN_ITEMEXPANDED:
				g_MainWnd.m_TreeView.OnItemExpanded((NMTREEVIEW*)lParam);
				break;
			//ADD START TODA (from GSFinder ver.1.99)
			case LVN_MARQUEEBEGIN:
				g_bIgureClick = TRUE;
				break;
			//ADD END
			default:
			   return DefWindowProc(hWnd, message, wParam, lParam);

			}
			break;
			//MOD END



		}
		//EBhE
		case WM_CREATE:
			g_MainWnd.OnCreate();
			break;
		//EBhEN[Y
		case WM_CLOSE:
			g_MainWnd.OnClose();
			break;
		//EBhEj
		case WM_DESTROY:
			g_MainWnd.OnDestroy();
			break;
		//EBhETCYύX
		case WM_SIZE:
			//R}ho[Xe[^Xo[̃CAEgύX
			g_MainWnd.RecalcBarLayout(wParam, lParam);
			//MOD START TODA (^XN؂ւ̃c[o[\ُ)
			//EBhẼCAEgύX
			g_MainWnd.RecalcLayout();
			//MOD END
			break;
		//EBhẼANeBu/ANeBu
		case WM_ACTIVATE:
			if(LOWORD(wParam) == WA_INACTIVE && g_bDraging)
			{
				g_MainWnd.OnDropCansel();
				g_bDraging = FALSE;
			}
			//MOD START TODA (from GSFinder ver.1.99)
			g_MainWnd.OnActivate(LOWORD(wParam));
			//MOD END
			break;
		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hWnd, wParam, lParam, &g_sai);
			g_MainWnd.OnSettingChange(wParam);
			break;
		// J[h̎F
		case WM_DEVICECHANGE:
			g_MainWnd.OnDeviceChange(TRUE);
			break;
		//Np[^L
		case WM_COPYDATA:
		{
			COPYDATASTRUCT* pcds = (COPYDATASTRUCT*)lParam;
			if (pcds->dwData == WM_DROPFILES) {
				DWORD dwAttr = GetFileAttributes((LPTSTR)pcds->lpData);
				if (dwAttr != 0xFFFFFFFF && (dwAttr & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY) {
					g_MainWnd.m_ListView.OnViewUpdate((LPCTSTR)pcds->lpData);
				}
			}
			break;
		}
		//Splitter
		//}EX{^Jn
		case WM_LBUTTONDOWN:
			SetCapture(hWnd);
			g_bMoving = TRUE;
//MOD START GORIPON
			//if(g_MainWnd.m_bViewSide) {
			//	g_nStartPos = LOWORD(lParam);
			//	g_nLastWidth = g_MainWnd.m_nTreeViewWidth;
			//} else {
			//	g_nStartPos = HIWORD(lParam);
			//	g_nLastHeight = g_MainWnd.m_nTreeViewHeight;
			//}
			if(g_MainWnd.m_bLandscapeMode?g_MainWnd.m_bViewSideL:g_MainWnd.m_bViewSide)
			{
				g_nStartPos = LOWORD(lParam);
				g_nLastWidth = (g_MainWnd.m_bLandscapeMode? g_MainWnd.m_nTreeViewWidthL:g_MainWnd.m_nTreeViewWidth);
			}
			else
			{
				g_nStartPos = HIWORD(lParam);
				g_nLastHeight = (g_MainWnd.m_bLandscapeMode? g_MainWnd.m_nTreeViewHeightL:g_MainWnd.m_nTreeViewHeight);
			}
//MOD END
			break;
		//}EXړ
		case WM_MOUSEMOVE:
			if (g_bMoving)
				g_MainWnd.OnMouseMove(lParam, g_nStartPos, g_nLastWidth, g_nLastHeight);
			if(g_bDraging) {
				POINT pt={LOWORD(lParam), HIWORD(lParam)};
				g_MainWnd.OnMouseMove(pt);
			}
			break;
		//}EX{^I
		case WM_LBUTTONUP:
			ReleaseCapture();
			if(g_bMoving)
			{
				ListView_Arrange(g_MainWnd.m_ListView.m_hWnd, LVA_DEFAULT);
				InvalidateRect(g_MainWnd.m_hWnd, NULL, FALSE);
			}
			if(g_bDraging)
				g_MainWnd.OnLButtopUp();
			g_bMoving = FALSE;
			g_bDraging = FALSE;
			break;
		//tH[JXݒ
		case WM_SETFOCUS:
			SetFocus(g_MainWnd.m_ListView.m_hWnd);
			break;
		//}EX{^ENbN
		case WM_RBUTTONDOWN:
			MessageBox(NULL,_T("CLICK"),_T("TEST"),MB_OK);
			break;
//ADD START GORIPON
		//|bvAbvj[I[v
		case WM_ENTERMENULOOP:
			g_MainWnd.m_ListView.m_bThroughContextMenu = TRUE;
			if (g_MainWnd.m_bNumberShortcut)
				g_MainWnd.ChangeInputMode(INPUTMODE_HAN_NUMERIC);
			break;
//ADD END
		//|bvAbvj[N[Y
		case WM_EXITMENULOOP:
			//g_MainWnd.m_ListView.OnExitMenuLoop();	//DEL GORIPON
			g_MainWnd.m_TreeView.OnExitMenuLoop();
//ADD START GORIPON
			if (g_MainWnd.m_bNumberShortcut)
				g_MainWnd.RestoreInputMode();
//ADD END
			break;
		//ADD START TODA (t@CύXʒm from Y.Nagamidori)
		case WM_UPDATENOTIFY:
		{
			MSG msg;
			while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
			g_MainWnd.OnDeviceChange(FALSE);
			break;
		}
		//ADD END
		//^C}ʒm
		case WM_TIMER:
			if (wParam == ID_TIMER_TVSELECTED)
				g_MainWnd.m_TreeView.OnKillFocus();
			if(wParam == ID_TIMER_DEVICECHANGE)
				g_MainWnd.OnDeviceChange(FALSE, FALSE);
			//ȊOdef
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			SHINITDLGINFO shidi;
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);

			//o[Wԍ̐ݒ
			DWORD size;
			TCHAR szTemp[1024];
			GetModuleFileName(NULL, szTemp, MAX_PATH);
			size = GetFileVersionInfoSize(szTemp, NULL);
			if (size)
			{
				TCHAR *pv = new TCHAR[size/sizeof(TCHAR)];
				if (GetFileVersionInfo(szTemp, 0, size, pv))
				{
					UINT len, v1, v2, v3, v4;
					TCHAR *lpszTemp;
					VerQueryValue(pv, _T("\\StringFileInfo\\041104e4\\ProductVersion"), (LPVOID*)&lpszTemp, &len);
					swscanf(lpszTemp, _T("%d, %d, %d, %d"), &v1, &v2, &v3, &v4);
					wsprintf(szTemp, _T("Ver.%d.%d.%d.%d"), v1, v2, v3, v4);
					SetWindowText(GetDlgItem(hDlg, IDC_VERSION), szTemp);
				}
				delete pv;
			}

			//TCY (Edit)
			RECT rc;
			POINT pt;
			GetWindowRect(GetDlgItem(hDlg, IDC_EDIT_MEMORY), &rc);
			pt.x = rc.left; pt.y = rc.top;
			ScreenToClient(hDlg, &pt);
			//ADD START TODA
			DWORD dwX = GetSystemMetrics(SM_CXSCREEN);
			DWORD dwY = GetSystemMetrics(SM_CYSCREEN);
			if(VGACheck())
			{
				dwX -= 65;
				dwY -= 420;
			}
			else
			{
				dwX -= 32;
				dwY -= 210;
			}
			//ADD END
			MoveWindow(GetDlgItem(hDlg, IDC_EDIT_MEMORY), pt.x, pt.y, dwX, dwY, TRUE); //MOD TODA
			ULARGE_INTEGER nFreeBytesAvailableToCaller;
			ULARGE_INTEGER nTotalNumberOfBytes;
			ULARGE_INTEGER nTotalNumberOfFreeBytes;

			//gp󋵂̕\
			//TCHAR szTemp[64];	//DEL GORIPON
//MOD START GORIPON
			//TCHAR szText[1024] = IDS_MEMORYSTATUS;
			TCHAR szText[1024];
			wcscpy(szText, GetStringTable(IDS_MEMORYSTATUS));
//MOD END
			/////////////////////////////////////////////////////
			//vO
//MOD START GORIPON
			//wcscat(szText, IDS_FMT_PROGMEM);
			wcscat(szText, GetStringTable(IDS_FMT_PROGMEM));
//MOD END
			MEMORYSTATUS ms;
			ms.dwLength = sizeof(ms);
			GlobalMemoryStatus(&ms);
			SetFormatSize(ms.dwAvailPhys, szTemp, _T("%s KB"), _T("%s MB"));
			wcscat(szText, szTemp);
			wcscat(szText, _T(" / "));
			SetFormatSize(ms.dwTotalPhys, szTemp, _T("%s KB"), _T("%s MB"));
			wcscat(szText, szTemp);

			/////////////////////////////////////////////////////
			//IuWFNgXgA
			if (GetDiskFreeSpaceEx(_T("\\"), &nFreeBytesAvailableToCaller, &nTotalNumberOfBytes, &nTotalNumberOfFreeBytes))
			{
//MOD START GORIPON
				//wcscat(szText, IDS_FMT_DATAMEM);
				wcscat(szText, GetStringTable(IDS_FMT_DATAMEM));
//MOD END
				int	nTemp = (int)nTotalNumberOfFreeBytes.QuadPart;
				SetFormatSize(nTemp, szTemp, _T("%s KB"), _T("%s MB"));
				wcscat(szText, szTemp);
				wcscat(szText, _T(" / "));
				nTemp = (int)nTotalNumberOfBytes.QuadPart;
				SetFormatSize(nTemp, szTemp, _T("%s KB"), _T("%s MB"));
				wcscat(szText, szTemp);
			}
			/////////////////////////////////////////////////////
			//Xg[WJ[h
			TCHAR szPath[MAX_PATH] = _T("\\*.*");
			WIN32_FIND_DATA wfd;
			HANDLE hFind = FindFirstFile(szPath, &wfd);
			if (hFind != INVALID_HANDLE_VALUE) {
				do {
					if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) &&
						(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY)) {
						wsprintf(szPath, _T("\\%s\\"), wfd.cFileName);
						if (GetDiskFreeSpaceEx(szPath, &nFreeBytesAvailableToCaller, &nTotalNumberOfBytes, &nTotalNumberOfFreeBytes)) {
							wsprintf(szTemp, _T("\r\n%s : "), wfd.cFileName);
							wcscat(szText, szTemp);
							int	nTemp = (int)nTotalNumberOfFreeBytes.QuadPart;
							SetFormatSize(nTemp, szTemp, _T("%s KB"), _T("%s MB"));
							wcscat(szText, szTemp);
							wcscat(szText, _T(" / "));
							nTemp = (int)nTotalNumberOfBytes.QuadPart;
							SetFormatSize(nTemp, szTemp, _T("%s KB"), _T("%s MB"));
							wcscat(szText, szTemp);
						}
					}
				}
				while (FindNextFile(hFind, &wfd));
				FindClose(hFind);
			}

			SetWindowText(GetDlgItem(hDlg, IDC_EDIT_MEMORY), szText);
			return TRUE;
		}
		case WM_COMMAND:
			if ((LOWORD(wParam) == IDOK) || (LOWORD(wParam) == IDCANCEL))
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}

///////////////////////////////////////////////////////////////
DWORD GetVersion()
{
	static DWORD ver = 0;
	if(ver == 0)
	{
		TCHAR szVer[16];
		OSVERSIONINFO osinf;
		GetVersionEx(&osinf);
		wsprintf(szVer, _T("%d%02d"), osinf.dwMajorVersion, osinf.dwMinorVersion);
		ver = wcstol(szVer, 0, 10);
	}
	return ver;
}

///////////////////////////////////////////////////////////////
BOOL VGACheck()
{
	static int nMode=0;

	if(nMode == 0 && GetVersion() >= 421)
	{
		nMode = 2;
		//VGA[hȂ̂肷
		int nMenu = GetSystemMetrics(SM_CYMENU);
		int nWidth  = GetSystemMetrics(SM_CXSCREEN);
		int nHeight = GetSystemMetrics(SM_CYSCREEN);

		if((nMenu == 52) &&
		   (nWidth == 480 && nHeight == 640 ||
			nWidth == 640 && nHeight == 480))
			nMode = 1;
	}

	//VGȀꍇ
	if(nMode == 1) return TRUE;

	//VGAȊȌꍇ
	return FALSE;
}

///////////////////////////////////////////////////////////////
void CenterWindow(HWND hWnd)
{
	RECT rctDesktop, rctWnd;
	GetWindowRect(g_MainWnd.m_hWnd, &rctDesktop);
	GetWindowRect(hWnd, &rctWnd);

	int nX = ((rctDesktop.right - rctDesktop.left)-(rctWnd.right - rctWnd.left))/2;
	int nY = ((rctDesktop.bottom - rctDesktop.top)-(rctWnd.bottom - rctWnd.top))/2;
	if (nY < 26) nY = 26;

	SetWindowPos(hWnd, HWND_TOP, nX, nY, 0, 0, SWP_NOSIZE|SWP_NOZORDER);
}

////////////////////////////////////////////////////////////////
void SetKickExt(LPTSTR lpszFileName)
{
	LPTSTR lpszTemp = wcsrchr(lpszFileName, _T('.'));
	if (lpszTemp)
		*lpszTemp = NULL;
}

////////////////////////////////////////////////////////////////
void SetExtFromFileName(LPTSTR lpszFileName, LPTSTR lpszFileNameWithExt)
{
	LPTSTR lpszTemp = wcsrchr(lpszFileNameWithExt, _T('.'));
	if (lpszTemp)
		wcscat(lpszFileName, lpszTemp);
}

////////////////////////////////////////////////////////////////
DWORD GetIMStatus()
{
	SIPINFO si;
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	SipGetInfo(&si);
	return si.fdwFlags;
}

////////////////////////////////////////////////////////////////
void SetFormatInteger(LPTSTR lpszInt, UINT nSize)
{
	LPTSTR lpszTemp = new TCHAR[nSize];
	memset(lpszTemp, 0, sizeof(TCHAR)*nSize);
	GetNumberFormat(LOCALE_USER_DEFAULT, 0, lpszInt, NULL, lpszTemp, nSize);
	memset(lpszInt, 0, sizeof(TCHAR)*nSize);

	LPTSTR lpszSep = wcschr(lpszTemp, g_szDecSep[0]);
	if (lpszSep)
		wcsncpy(lpszInt, lpszTemp, lpszSep-lpszTemp);
	else
		wcscpy(lpszInt, lpszTemp);
	delete[] lpszTemp;
}

////////////////////////////////////////////////////////////////
void SetFormatDouble(LPTSTR lpszDouble, UINT nSize)
{
	LPTSTR lpszTemp = new TCHAR[nSize];
	memset(lpszTemp, 0, sizeof(TCHAR)*nSize);
	GetNumberFormat(LOCALE_USER_DEFAULT, 0, lpszDouble, NULL, lpszTemp, nSize);
	memset(lpszDouble, 0, sizeof(TCHAR)*nSize);
	wcscpy(lpszDouble, lpszTemp);
	delete[] lpszTemp;
}

////////////////////////////////////////////////////////////////
void SetFormatDateTime(SYSTEMTIME* lpst, LPTSTR lpszBuff, UINT nSize, BOOL bToday)
{
	//MOD START TODA (gp/\@w)
	memset(lpszBuff, 0x00, sizeof(TCHAR)*nSize);

	if(bToday)
	{
		SYSTEMTIME sys;
		GetLocalTime(&sys);

		//ȊȌꍇ͓t\ ̏ꍇ͎ԕ\
		if(lpst->wYear  != sys.wYear  ||
		   lpst->wMonth != sys.wMonth ||
		   lpst->wDay   != sys.wDay   )
			GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, lpst, NULL, lpszBuff, nSize);
		else
			GetTimeFormat(LOCALE_USER_DEFAULT, 0, lpst, NULL, lpszBuff, nSize);
	}
	else
	{
		//t/ԕ\
		GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, lpst, NULL, lpszBuff, nSize);
		wcscat(lpszBuff, _T(" "));
		GetTimeFormat(LOCALE_USER_DEFAULT, 0, lpst, NULL, (lpszBuff+wcslen(lpszBuff)), (nSize-wcslen(lpszBuff)));
	}
	//MOD END
}

////////////////////////////////////////////////////////////////
UINT GetFileAndFolderCountInFolder(LPTSTR lpszPath)
{	
	UINT nFileCount = 0;
	TCHAR szTemp[MAX_PATH+4];
	wsprintf(szTemp, _T("%s\\*.*"), lpszPath);

	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		BOOL bRet = TRUE;
		do
		{
			if ((finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY)
			{
				LPTSTR lpszChildPath = new TCHAR[wcslen(lpszPath)+wcslen(finddata.cFileName)+2];
				wsprintf(lpszChildPath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				nFileCount += GetFileAndFolderCountInFolder(lpszChildPath);
				nFileCount += 1;
				delete[] lpszChildPath;
			}
			else
				nFileCount += 1; //t@C
		}
		while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	return nFileCount;
}

////////////////////////////////////////////////////////////////
UINT GetFileAndFolderCount(LPCTSTR lpszPath, LISTITEMINFO* lpliinfo, int nCount)
{
	UINT nFileCount = 0;
	for (int i=0; i<nCount; i++)
	{
		//TCY擾AJEgJn
		if (lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			TCHAR szPath[MAX_PATH];
			wsprintf(szPath, _T("%s\\%s"), lpszPath, lpliinfo[i].szName);
			nFileCount += GetFileAndFolderCountInFolder(szPath);
			nFileCount += 1;
		}
		else if (lpliinfo[i].nItem == LIST_ITEM_FILE)
			nFileCount += 1;
	}
	return nFileCount;
}

////////////////////////////////////////////////////////////////
//tH_̃N`FbN
BOOL IsFolderShortcut(LPCTSTR lpszPath, LPCTSTR lpszFileName)
{
//	TCHAR szBuf[MAX_PATH] = _T(""); //DEL TODA
	TCHAR szPath[MAX_PATH] = _T("");

//MOD START TODA (wcscmp -> wcsicmp, szExt -> szBuf)
//	wcscpy(szExt, lpszFileName);
//	wcsupr(szExt);
	LPTSTR lpszExt = wcsrchr(lpszFileName, _T('.'));
	if (lpszExt != NULL)
	{
		if (wcsicmp(lpszExt, _T(".LNK"))==0)
		{
			//Nt@CƔF
			TCHAR szBuf[MAX_PATH] = _T("");			//ADD TODA
			memset(szBuf, 0, sizeof(szBuf));
			wsprintf(szBuf, _T("%s\\%s"), lpszPath, lpszFileName);
			if (SHGetShortcutTarget(szBuf, szPath, MAX_PATH))
			{
				LPCTSTR lpszStart = szPath;
				if (szPath[0] == _T('\"'))
				{
					lpszStart++;
					memset(szBuf, 0, sizeof(szBuf));
					LPCTSTR lpszEnd = wcsrchr(lpszStart, _T('\"'));
					if (lpszEnd)
						wcsncpy(szBuf, lpszStart, lpszEnd-lpszStart);
					else
						wcsncpy(szBuf, lpszStart, wcslen(lpszStart)-1);
				}

				DWORD dwAttr = GetFileAttributes(szBuf);
				if ((dwAttr & FILE_ATTRIBUTE_DIRECTORY) == FILE_ATTRIBUTE_DIRECTORY && dwAttr != 0xFFFFFFFF)
					return TRUE; //tH_̃NƔF
			}
		}
	}
//MOD END
	return FALSE;
}

////////////////////////////////////////////////////////////////
int CALLBACK PropSheetCallback(HWND hwndDlg, UINT message, LPARAM lParam)
{
	switch(message) 
	{
		case PSCB_INITIALIZED:
		{
			HWND hwndChild = GetWindow(hwndDlg, GW_CHILD);
			while (hwndChild)
			{
				TCHAR szTemp[32];
				GetClassName(hwndChild, szTemp, 32);
				if (wcscmp(szTemp, _T("SysTabControl32"))==0)
					break;
				hwndChild = GetWindow(hwndChild, GW_HWNDNEXT);
			}
			if (hwndChild)
			{
				DWORD dwStyle = GetWindowLong(hwndChild, GWL_STYLE) | TCS_BOTTOM;
				::SetWindowLong(hwndChild, GWL_STYLE, dwStyle);
			}
//ADD START GORIPON
			//̃j[o[ǉ
			SHMENUBARINFO mbi;
			memset(&mbi, 0, sizeof(SHMENUBARINFO));
			mbi.cbSize = sizeof(SHMENUBARINFO);
			mbi.hwndParent = hwndDlg;
			mbi.nToolBarId = IDR_PROPSHEET;
			mbi.hInstRes = g_hInst;
			mbi.nBmpId = 0;
			mbi.cBmpImages = 0;
			SHCreateMenuBar(&mbi);
//ADD END
			break;
		}
		case PSCB_GETVERSION:
			return COMCTL32_VERSION;
			break;
		default:
			break;
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgPaintProc(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
//MOD START GORIPON
	////ADD START TODA
	//DWORD bottom = 0;
	//if(VGACheck())
	//	bottom = 50;
	//else
	//	bottom = 24;
	////ADD END
	DWORD bottom = (DWORD)(24 * g_MainWnd.m_fpHighResolutionScale);
//MOD END
	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hDlg, &ps);
	POINT pt[2] = {{0, bottom},{GetSystemMetrics(SM_CXSCREEN),bottom}};	//MOD TODA (24 -> bottom)
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	EndPaint(hDlg, &ps);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgPaintProc2(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
//MOD START GORIPON
	//DWORD bottom1 = 0;
	//DWORD bottom2 = 0;
	//DWORD bottom3 = 0;
	//if(VGACheck())
	//{
	//	bottom1 = 50;		//foCXɏC by kawa
	//	bottom2 = 90;       //
	//	bottom3 = 190;      //
	//}
	//else
	//{
	//	bottom1 = 25;       //
	//	bottom2 = 43;       //
	//	bottom3 = 95;       //
	//}
	DWORD bottom1 = (DWORD)(24 * g_MainWnd.m_fpHighResolutionScale);
	DWORD bottom2 = (DWORD)(42 * g_MainWnd.m_fpHighResolutionScale);
	DWORD bottom3 = (DWORD)(102 * g_MainWnd.m_fpHighResolutionScale);
//MOD END

	PAINTSTRUCT ps;
	HDC hDC = BeginPaint(hDlg, &ps);
	POINT pt[2] = {{0, bottom1},{GetSystemMetrics(SM_CXSCREEN),bottom1}};
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	
	HPEN hPen = CreatePen(PS_SOLID, 1, RGB(192, 192, 192));
	HPEN hPenOld = (HPEN)SelectObject(hDC, hPen);
	int nWidth = GetSystemMetrics(SM_CXSCREEN);
	pt[0].y = pt[1].y = bottom2;
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	pt[0].y = pt[1].y = bottom3;
	Polyline(hDC, pt, sizeof(pt)/sizeof(POINT));
	SelectObject(hDC, hPenOld);
	DeleteObject(hPen);
	EndPaint(hDlg, &ps);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////
BOOL DefDlgCtlColorStaticProc(HWND hDlg, WPARAM wParam, LPARAM lParam)
{
	HDC hDC = (HDC)wParam;
	if (GetDlgCtrlID((HWND)lParam)==IDC_TITLE	||
		GetDlgCtrlID((HWND)lParam)==IDC_TITLE2	||
		GetDlgCtrlID((HWND)lParam)==IDC_TITLE3)
	{
		SetBkMode(hDC, TRANSPARENT);
		SetTextColor(hDC, GetSysColor(COLOR_HIGHLIGHT));
		return (long)GetStockObject(WHITE_BRUSH);
	}
	else
		return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////
void SetFormatSize(DWORD dwSize, TCHAR szBuff[64], LPTSTR lpszFmtKB, LPTSTR lpszFmtMB)
{
	double fSize;
	TCHAR szSize[64];
	if (dwSize < 1024000)
		fSize = (double)dwSize/1024;	
	else
		fSize = (double)dwSize/1048576;
	wsprintf(szSize, _T("%f"), fSize);
	SetFormatDouble(szSize, 64);
		
	if (dwSize < 1024000)
		wsprintf(szBuff, lpszFmtKB, szSize);
	else
		wsprintf(szBuff, lpszFmtMB, szSize);
}

//ADD START TODA
//////////////////////////////////////////////////////////////////////////////////////
#define KEY_MYCOMPUTER _T("{000214A0-0000-0000-C000-000000000046}")
LPCTSTR GetRootName()
{
//MOD START GORIPON
	//if (!*g_szRootName) {
	//	wcscpy(g_szRootName, IDS_ROOT_FOLDER_NAME);
	//}
	if (!wcslen(g_szRootName))
		wcscpy(g_szRootName, GetStringTable(IDS_ROOT_FOLDER_NAME));
//MOD END
	return g_szRootName;
}

//////////////////////////////////////////////////////////////////////////////////////
int AddRootIcon(HIMAGELIST hImageList)
{
//MOD START GORIPON nC]Ή
	//int nRet = -1;
	//HICON hIcon = (HICON)LoadImage(g_hInst, (LPCTSTR)IDI_ROOT, IMAGE_ICON, 16, 16, 0);
	//nRet = ImageList_AddIcon(hImageList, hIcon);
	int in = (g_MainWnd.m_bHighRresolutionMode||!g_MainWnd.m_bHighDpiHardware)? IDI_ROOT_S:IDI_ROOT_M;
	HICON hIcon = LoadIcon(g_hInst, (LPCTSTR)in);
	int nRet = ImageList_AddIcon(hImageList, hIcon);
//MOD END
	DeleteObject(hIcon);
	return nRet;
}

//////////////////////////////////////////////////////////////////////////////////////
HFONT MyCreateFont(int nHeight, BYTE dwCharSet, LPTSTR lpszName)
{
	LOGFONT logfont;
	logfont.lfHeight = nHeight;								//tHg
	logfont.lfWidth = 0;									//
	logfont.lfEscapement = 0;								//eLXg̊px
	logfont.lfOrientation = 0;								//x[XCƂƂ̊px
	logfont.lfWeight = FW_DONTCARE;							//tHg̏dij
	logfont.lfItalic = FALSE;								//C^bN
	logfont.lfUnderline = FALSE;							//A_[C
	logfont.lfStrikeOut = FALSE;							//ł
	logfont.lfCharSet = dwCharSet;							//Zbg
	logfont.lfOutPrecision = OUT_DEFAULT_PRECIS;			//o͐x
	logfont.lfClipPrecision = CLIP_DEFAULT_PRECIS;			//NbsOx
	logfont.lfQuality = DEFAULT_QUALITY;					//o͕i
//	logfont.lfQuality = ANTIALIASED_QUALITY;				//o͕i
	logfont.lfPitchAndFamily= DEFAULT_PITCH|FF_DONTCARE;	//sb`ƃt@~[
	if (lpszName)	//ADD GORIPON
		wcscpy(logfont.lfFaceName, lpszName);				//̖

	return (CreateFontIndirect(&logfont));
}
//ADD END

//ADD START TODA (t@CύXʒm from Y.Nagamidori)
//////////////////////////////////////////////////////////////////////////////////////
BOOL g_bNotifyExit = FALSE;
BOOL g_bEnableNotify = FALSE;
HANDLE g_hNotifyThread = NULL;
HANDLE g_hUpdateNotify = INVALID_HANDLE_VALUE;
HANDLE g_hEventBreak = NULL;
DWORD g_dwNotifyThreadId = 0;
TCHAR g_szNotifyDir[MAX_PATH] = {0};
CRITICAL_SECTION g_csec;
////////////////////////////////////////////////////////////////
DWORD CALLBACK UpdateNotifyThreadProc(LPVOID pParam)
{
	DWORD dwRet;
	while (!g_bNotifyExit) {
		EnterCriticalSection(&g_csec);
		if (g_bEnableNotify) {
			g_hUpdateNotify = FindFirstChangeNotification(g_szNotifyDir, FALSE, 
											FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME);
		}
		LeaveCriticalSection(&g_csec);
		if (g_hUpdateNotify == INVALID_HANDLE_VALUE) {
			WaitForSingleObject(g_hEventBreak, INFINITE);
			ResetEvent(g_hEventBreak);
			continue;
		}

		if (WaitForSingleObject(g_hEventBreak, 5000) == WAIT_OBJECT_0) {
			ResetEvent(g_hEventBreak);
			FindCloseChangeNotification(g_hUpdateNotify);
			g_hUpdateNotify = INVALID_HANDLE_VALUE;
			continue;
		}

		HANDLE handles[] = {g_hEventBreak, g_hUpdateNotify};
		dwRet = WaitForMultipleObjects(sizeof(handles) / sizeof(HANDLE), handles, FALSE, INFINITE);
		if (dwRet - WAIT_OBJECT_0 == 0)
			ResetEvent(g_hEventBreak);
		else {
			EnterCriticalSection(&g_csec);
			//if (g_bEnableNotify) {
			PostMessage(g_MainWnd.m_hWnd, WM_UPDATENOTIFY, 0, 0);
			//}
			LeaveCriticalSection(&g_csec);
		}
		FindCloseChangeNotification(g_hUpdateNotify);
		g_hUpdateNotify = INVALID_HANDLE_VALUE;
	}

	if (g_hUpdateNotify != INVALID_HANDLE_VALUE) {
		FindCloseChangeNotification(g_hUpdateNotify);
		g_hUpdateNotify = INVALID_HANDLE_VALUE;
	}
	return 0;
}
////////////////////////////////////////////////////////////////
void InitUpdateNotify()
{
	InitializeCriticalSection(&g_csec);
	g_hEventBreak = CreateEvent(0, TRUE, FALSE, NULL);
	g_hNotifyThread = CreateThread(NULL, 0, UpdateNotifyThreadProc, NULL, 0, &g_dwNotifyThreadId);
}
////////////////////////////////////////////////////////////////
void EnableUpdateNotify()
{
	MSG msg;
	EnterCriticalSection(&g_csec);
	g_bEnableNotify = TRUE;
	while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}
////////////////////////////////////////////////////////////////
void DisableUpdateNotify()
{
	MSG msg;
	EnterCriticalSection(&g_csec);
	g_bEnableNotify = FALSE;
	while (PeekMessage(&msg, g_MainWnd.m_hWnd, WM_UPDATENOTIFY, WM_UPDATENOTIFY, PM_REMOVE));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}
////////////////////////////////////////////////////////////////
void SetUpdateNotify(LPCTSTR pszDir)
{
	if (wcsicmp(pszDir, g_szNotifyDir) == 0)
		return;

	EnterCriticalSection(&g_csec);
	wcscpy(g_szNotifyDir, pszDir);
	if (!wcslen(g_szNotifyDir))
		wcscpy(g_szNotifyDir, _T("\\"));
	SetEvent(g_hEventBreak);
	LeaveCriticalSection(&g_csec);
}
////////////////////////////////////////////////////////////////
void UninitUpdateNotify()
{
	g_bNotifyExit = TRUE;
	SetEvent(g_hEventBreak);
	WaitForSingleObject(g_hNotifyThread, INFINITE);
	DeleteCriticalSection(&g_csec);
	CloseHandle(g_hEventBreak);
}
//ADD END
//ADD START GORIPON
////////////////////////////////////////////////////////////////
LPWSTR GetStringTable(int ids)
{
	if (!LoadString(g_hInst, ids, s_szStrBuf, 256))
		wcscpy(s_szStrBuf, _T(""));
	return s_szStrBuf;
}
////////////////////////////////////////////////////////////////
LPWSTR DupStringTable(int ids)
{
	return _wcsdup(GetStringTable(ids));
}
////////////////////////////////////////////////////////////////
VOID FreeStringTable(LPWSTR lpszStr)
{
	if (lpszStr != s_szStrBuf)
		free(lpszStr);
}
//ADD END