///////////////////////////////////////////////////////////////
//UserPathDlg.cpp
//[UpX̓o^ҏW

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "UserPathDlg.h"

///////////////////////////////////////////////////////////////
//PROTOTYPE
LRESULT CALLBACK UserPathDlgProc(HWND,UINT,WPARAM,LPARAM);

///////////////////////////////////////////////////////////////
//O[oϐ
CUserPathDlg	*pusrDlg;

///////////////////////////////////////////////////////////////
CUserPathDlg::CUserPathDlg(HWND hWnd, HINSTANCE hInst)
{
	pusrDlg = this;

	//p[^̕ۑ
	m_hparWnd = hWnd;
	m_hInst = hInst;

	//Rg[̏
	InitCommonControls();

	//oϐ̏
	m_bEditing = FALSE;
}

///////////////////////////////////////////////////////////////
CUserPathDlg::~CUserPathDlg()
{
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::Open()
{
//DEL START GORIPON
//	//SIPI[v
//	BOOL bSetSip = FALSE;
//	SIPINFO si;
//	memset(&si, 0, sizeof(SIPINFO));
//	si.cbSize = sizeof(SIPINFO);
//	SipGetInfo(&si);
//	if ((si.fdwFlags&SIPF_ON)!=SIPF_ON)
//	{
//		SipShowIM(SIPF_ON);
//		bSetSip = TRUE;
//	}
//DEL END
	//EBhE쐬
	DialogBox(m_hInst,
			  (LPCTSTR)IDD_USERPATH_DLG,
			  m_hparWnd,
			  (DLGPROC)UserPathDlgProc);

	//SIPN[Y
	//if (bSetSip)	//DEL GORIPON
		SipShowIM(SIPF_OFF);

	return;
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnInit()
{
	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = m_hWnd;
	SHInitDialog(&shidi);

//ADD START GORIPON
	//OK̃j[o[ǉ
	SHMENUBARINFO mbi;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = m_hWnd;
	mbi.nToolBarId = IDR_USERPATH;
	mbi.hInstRes = g_hInst;
	mbi.nBmpId = 0;
	mbi.cBmpImages = 0;	
	SHCreateMenuBar(&mbi);

	//TCY (TreeView)
	OnSize();
//ADD END

	//EBhE^Cg
//MOD START GORIPON
	//SetWindowText(m_hWnd, IDS_TITLE_USERPATHDLG);
	LPTSTR lpszText = DupStringTable(IDS_TITLE_USERPATHDLG);
	SetWindowText(m_hWnd, lpszText);
	FreeStringTable(lpszText);
//MOD END

	//Jwb_̍쐬
	RECT rc;
	GetClientRect(m_hList, &rc);
	
	LVCOLUMN lvclm;
	lvclm.mask = LVCF_FMT|LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;
	lvclm.fmt = LVCFMT_LEFT;
	lvclm.cx = rc.right - rc.left;
//MOD START GORIPON
	//lvclm.pszText = IDS_COLUMN_USERPATH;
	lvclm.pszText = DupStringTable(IDS_COLUMN_USERPATH);
//MOD END
	lvclm.cchTextMax = 0;
	lvclm.iSubItem = 0;
	ListView_InsertColumn(m_hList, 0, &lvclm);
	FreeStringTable(lvclm.pszText);	//ADD GORIPON

	//Oo^pXǉ
	for(int i=0; i<g_MainWnd.m_ListView.m_nOpenPthInfoCount; i++)
	{
		//ACe̒ǉ
		LVITEM lvitem;
		lvitem.mask = LVIF_TEXT;
		lvitem.iItem = i;
		lvitem.iSubItem = 0;
		lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[i]->lpszPath;
		ListView_InsertItem(m_hList, &lvitem);

	} //End of for

	//{^̏ݒ
	SetButton();

	//tH[JXXg֐ݒ
	SetFocus(m_hList);
}

//ADD START GORIPON
///////////////////////////////////////////////////////////////
void CUserPathDlg::OnSize()
{
	RECT rcw,rc;
	POINT pt;
	HWND hlv;

	GetWindowRect(m_hWnd, &rcw);

	//TCY (TreeView)
	hlv = GetDlgItem(m_hWnd, IDC_LIST_PATH);
	GetWindowRect(hlv, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rcw), RECT_HEIGHT(&rcw)-pt.y, TRUE);

	//ʒu (Button)
	hlv = GetDlgItem(m_hWnd, IDDOWNMOVE);
	GetWindowRect(hlv, &rc);
	pt.x = 0;//dummy
	pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	pt.x = rcw.right;
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDUPMOVE);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDEDIT);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDDELETE);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hlv = GetDlgItem(m_hWnd, IDADD);
	GetWindowRect(hlv, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hlv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
}
//ADD END

///////////////////////////////////////////////////////////////
void CUserPathDlg::SetButton()
{
	//ǉ{^
	if(g_MainWnd.m_ListView.m_nOpenPthInfoCount >= MAX_OPENAPP)
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE)|WS_DISABLED);
	}
	else
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDADD), GWL_STYLE)&~WS_DISABLED);
	}

	//폜{^
	if(g_MainWnd.m_ListView.m_nOpenPthInfoCount <= 0)
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE)|WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE)|WS_DISABLED);
//ADD START GORIPON
		SetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE)|WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE)|WS_DISABLED);
//ADD END
	}
	else
	{
		SetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDELETE), GWL_STYLE)&~WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDEDIT), GWL_STYLE)&~WS_DISABLED);
//ADD START GORIPON
		SetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDUPMOVE), GWL_STYLE)&~WS_DISABLED);
		SetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE,
			GetWindowLong(GetDlgItem(m_hWnd, IDDOWNMOVE), GWL_STYLE)&~WS_DISABLED);
//ADD END
	}
	
	//{^ĕ`
	InvalidateRect(GetDlgItem(m_hWnd, IDADD), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDADD));
	InvalidateRect(GetDlgItem(m_hWnd, IDDELETE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDDELETE));
	InvalidateRect(GetDlgItem(m_hWnd, IDEDIT), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDEDIT));
//ADD START GORIPON
	InvalidateRect(GetDlgItem(m_hWnd, IDUPMOVE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDUPMOVE));
	InvalidateRect(GetDlgItem(m_hWnd, IDDOWNMOVE), NULL, TRUE);
	UpdateWindow(GetDlgItem(m_hWnd, IDDOWNMOVE));
//ADD END
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnAdd()
{
	TCHAR szPath[MAX_PATH];
	wcscpy(szPath, g_MainWnd.m_ListView.m_szCurrentFolder);
//MOD START GORIPON
	//if((!wcslen(szPath)) || (wcscmp(IDS_SEARCH_FOLDER_NAME, szPath)==0))
	if((!wcslen(szPath)) || (wcscmp(GetStringTable(IDS_SEARCH_FOLDER_NAME), szPath)==0))
//MOD END
		wcscpy(szPath, GetRootName());

	//ACe̒ǉ
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = g_MainWnd.m_ListView.m_nOpenPthInfoCount;
	lvitem.iSubItem = 0;
	lvitem.pszText = szPath;
	ListView_InsertItem(m_hList, &lvitem);
	
	//e[uփpXǉ
	AddPath(lvitem.iItem, lvitem.pszText);

	//ACeҏWԂɂ
	SetFocus(m_hList);
	ListView_EditLabel(m_hList, lvitem.iItem);

	//{^̐ݒ
	SetButton();
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnDelete()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL | LVNI_SELECTED);
	if(nItem == -1)
		return;

	//ACe폜
	SetFocus(m_hList);
	ListView_DeleteItem(m_hList, nItem);

	//e[ũpX폜
	DelPath(nItem);

	//{^̐ݒ
	SetButton();
}

//ADD START GORIPON
///////////////////////////////////////////////////////////////
void CUserPathDlg::OnUpMove()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL|LVNI_SELECTED);
	if(nItem == -1 || nItem == 0)
		return;

	//ACe폜
	ListView_DeleteItem(m_hList, nItem);

	//ACe̒ǉ
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = nItem-1;
	lvitem.iSubItem = 0;
	lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[nItem]->lpszPath;
	ListView_InsertItem(m_hList, &lvitem);

	//tH[JXړ
	ListView_SetItemState(m_hList, nItem-1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);

	//e[ũpXړ
	MovPath(nItem, -1);
}

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnDownMove()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL|LVNI_SELECTED);
	if(nItem == -1 || nItem == (ListView_GetItemCount(m_hList)-1))
		return;

	//ACe폜
	ListView_DeleteItem(m_hList, nItem);

	//ACe̒ǉ
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = nItem+1;
	lvitem.iSubItem = 0;
	lvitem.pszText = g_MainWnd.m_ListView.m_lpOpenPthInfo[nItem]->lpszPath;
	ListView_InsertItem(m_hList, &lvitem);

	//tH[JXړ
	ListView_SetItemState(m_hList, nItem+1, LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);

	//e[ũpXړ
	MovPath(nItem, +1);
}
//ADD END

///////////////////////////////////////////////////////////////
void CUserPathDlg::OnEdit()
{
	//IACe
	int nItem = ListView_GetNextItem(m_hList, -1, LVNI_ALL | LVNI_SELECTED);
	if(nItem == -1)
		return;

	//ACeҏWԂɂ
	SetFocus(m_hList);
	ListView_EditLabel(m_hList, nItem);
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::OnEndLabelEdit(LV_DISPINFO* pdi)
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pdi;

	int nIndex = pDispInfo->item.iItem;
	if (!pDispInfo->item.pszText) return FALSE;

	//G[`FbN
	if (wcschr(pDispInfo->item.pszText, _T('/'))!=NULL || wcschr(pDispInfo->item.pszText, _T(':'))!=NULL || wcschr(pDispInfo->item.pszText, _T(','))!=NULL || wcschr(pDispInfo->item.pszText, _T(';'))!=NULL || wcschr(pDispInfo->item.pszText, _T('*'))!=NULL || wcschr(pDispInfo->item.pszText, _T('?'))!=NULL || wcschr(pDispInfo->item.pszText, _T('<'))!=NULL || wcschr(pDispInfo->item.pszText, _T('>'))!=NULL || wcschr(pDispInfo->item.pszText, _T('|'))!=NULL)
	{
		//G[̏ꍇ
//MOD START GORIPON
		//MessageBox(g_MainWnd.m_hWnd, IDS_MSG_CANNOTUSECHAR, NULL, MB_OK|MB_ICONSTOP);
		MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_CANNOTUSECHAR), NULL, MB_OK|MB_ICONSTOP);
//MOD END
		SetFocus(m_hList);
		ListView_EditLabel(m_hList, nIndex);
		return FALSE;
	}
	else
	{
		TCHAR szPath[MAX_PATH];
		wcscpy(szPath, pDispInfo->item.pszText);
		if(!wcslen(szPath))
			wcscpy(szPath, GetRootName());

		//݂邩̊mF
		DWORD dwAttr = GetFileAttributes(szPath);
		if (dwAttr == 0xFFFFFFFF || !(dwAttr & FILE_ATTRIBUTE_DIRECTORY)) {
//MOD START GORIPON
			//MessageBox(g_MainWnd.m_hWnd, IDS_MSG_NOTFOUND_PATH, NULL, MB_OK|MB_ICONSTOP);
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
//MOD END
			SetFocus(m_hList);
			ListView_EditLabel(m_hList, nIndex);
			return FALSE;
		}

		//̏ꍇ
//ADD START GORIPON
		//\폜(j[ŕ\ȂȂ̂邽)
		while (szPath[_tcslen(szPath)-1] == _T('\\'))
			szPath[_tcslen(szPath)-1] = _T('\0');
//ADD END
		ListView_SetItemText(m_hList, pDispInfo->item.iItem, 0, szPath);
		ModPath(pDispInfo->item.iItem, szPath);
	}

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::AddPath(int nIndex, LPTSTR lpszPath)
{
	//f[^̍쐬
	OPENAPPINFO *pup = new OPENAPPINFO;
	pup->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(pup->lpszPath, lpszPath);
	g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = pup;
	g_MainWnd.m_ListView.m_nOpenPthInfoCount++;

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::ModPath(int nIndex, LPTSTR lpszPath)
{
	//f[^̍폜
	OPENAPPINFO* pup= g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (pup)
	{
		delete pup->lpszPath;
		delete pup;
	}

	//f[^̍č쐬
	pup = new OPENAPPINFO;
	pup->lpszPath = new TCHAR[wcslen(lpszPath)+1];
	wcscpy(pup->lpszPath, lpszPath);
	g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = pup;

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::DelPath(int nIndex)
{
	//f[^̍폜
	OPENAPPINFO* pup= g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (pup)
	{
		delete pup->lpszPath;
		delete pup;
		g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = NULL;
	}
	
	//㑱f[^Oֈړ
	for(int i=nIndex; i<g_MainWnd.m_ListView.m_nOpenPthInfoCount; i++)
	{
		g_MainWnd.m_ListView.m_lpOpenPthInfo[i] =
						g_MainWnd.m_ListView.m_lpOpenPthInfo[i+1];
		g_MainWnd.m_ListView.m_lpOpenPthInfo[i+1] = NULL;

	} // End of for

	g_MainWnd.m_ListView.m_nOpenPthInfoCount--;
	return TRUE;
}

//ADD START GORIPON
///////////////////////////////////////////////////////////////
BOOL CUserPathDlg::MovPath(int nIndex, int nDirection)
{
	//wf[^̈ړ
	OPENAPPINFO* ptmp = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex];
	if (nDirection < 0)
	{
		//
		if (nIndex > 0)
		{
			//Ώۃf[^1Õf[^ւ
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex-1];
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex-1] = ptmp;
			return TRUE;
		}
	}
	else
	{
		//
		if (nIndex < (g_MainWnd.m_ListView.m_nOpenPthInfoCount-1))
		{
			//Ώۃf[^1̃f[^ւ
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex] = g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex+1];
			g_MainWnd.m_ListView.m_lpOpenPthInfo[nIndex+1] = ptmp;
			return TRUE;
		}
	}
	return FALSE;
}
//ADD END

///////////////////////////////////////////////////////////////
LRESULT CALLBACK UserPathDlgProc(
		HWND hDlg,
		UINT message,
		WPARAM wParam,
		LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pusrDlg->m_hWnd = hDlg;
			pusrDlg->m_hList = GetDlgItem(hDlg, IDC_LIST_PATH);
			pusrDlg->OnInit();
			break;
		}
//ADD START GORIPON
		case WM_SIZE:
			pusrDlg->OnSize();
			break;
//ADD END
		case WM_NOTIFY:
		{
			LPNMHDR pNMHDR = (LPNMHDR)lParam;
			switch (pNMHDR->code)
			{
				//O̕ύXJn
				case LVN_BEGINLABELEDIT:
				{
					pusrDlg->m_bEditing = TRUE;
					break;
				}
				//O̕ύXI
				case LVN_ENDLABELEDIT:
				{
					LV_DISPINFO* pdi = (LV_DISPINFO*) lParam;
					pusrDlg->m_bEditing = FALSE;
					return pusrDlg->OnEndLabelEdit(pdi);
				}
			}
			break;
		}
		case WM_COMMAND:
		{
			if(pusrDlg->m_bEditing) break;

			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
				case IDADD:
				{
					pusrDlg->OnAdd();
					break;
				}
				case IDDELETE:
				{
					pusrDlg->OnDelete();
					break;
				}
				case IDEDIT:
				{
					pusrDlg->OnEdit();
					break;
				}
//ADD START GORIPON
				case IDUPMOVE:
					pusrDlg->OnUpMove();
					break;
				case IDDOWNMOVE:
					pusrDlg->OnDownMove();
					break;
//ADD END
				case IDOK:
				case IDCANCEL:
				{
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
				}
			}
			break;
		}
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}