///////////////////////////////////////////////////////////////
//Compress.cpp
//t@Ck/

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "ListView.h"
#include "Compress.h"

////////////////////////////////////////////////////////////////
BOOL MakeSureDirectoryPathExists(LPTSTR DirPath)
{

	LPTSTR lpszTerm = (LPTSTR)DirPath;
	do {
		
		//pX̋؂蕶(\)T
		lpszTerm = wcschr(lpszTerm+1, _T('\\'));
		if (lpszTerm) {

			//؂܂ł̕Rs[
			TCHAR szPath[MAX_PATH];
			*lpszTerm = 0;
			wsprintf(szPath, _T("%s"), DirPath); 
			*lpszTerm = _T('\\');
			
			//fBNgȂꍇ͍쐬
			if (GetFileAttributes(szPath) == 0xFFFFFFFF) {
				if (!CreateDirectory(szPath, NULL)) {
					return FALSE;
				}
			}
		}

	} while(lpszTerm); //End of do
	
	return TRUE;
}

////////////////////////////////////////////////////////////////
CCompress::CCompress()
{
	HMODULE hDLL=0;

	//LHÃI[v
	m_bLhaChk = FALSE;
	hDLL = OpenDLL(COMPDLL_MODE_LHA);
	if(hDLL)
	{
		m_bLhaChk =TRUE;
		//LHÃN[Y
		CloseDLL(hDLL);
	}

	//ZIP̃I[v
	m_bZipChk = FALSE;
	hDLL = OpenDLL(COMPDLL_MODE_ZIP);
	if(hDLL)
	{
		m_bZipChk =TRUE;
		//ZIP̃N[Y
		CloseDLL(hDLL);
	}
}

////////////////////////////////////////////////////////////////
CCompress::~CCompress()
{
}

////////////////////////////////////////////////////////////////
HMODULE CCompress::OpenDLL(int nMode)
{
	//k.DLL̃[h
    HMODULE hDLL = ::LoadLibrary(
		nMode==COMPDLL_MODE_LHA?_T("unlha.dll"):_T("unzip.dll"));
	
	if(!hDLL)
	{
		return 0;
	}
	return hDLL;
}

////////////////////////////////////////////////////////////////
void CCompress::CloseDLL(HMODULE hDLL)
{
	//k.DLL̃t[
	if(hDLL)
		::FreeLibrary(hDLL);
}

////////////////////////////////////////////////////////////////
//DEL START GORIPON
//int CCompress::ExLha(LPTSTR lpszCmdLine)
//{
//	//vOpXJgpX̎擾
//	TCHAR szPath[MAX_PATH];
//	GetModuleFileName(NULL, szPath, sizeof(szPath));
//	LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
//	if (lpszTemp) *lpszTemp = 0x00;
//
//	//st@C쐬
//	TCHAR szProc[MAX_PATH];
//	wsprintf(szProc, _T("%s\\exLha.exe"), szPath);
//
//	//st@C݂ꍇ
//	if (GetFileAttributes(szProc) != 0xFFFFFFFF)
//	{
//		//_uNH[e[V̕t^
//		TCHAR szParam[1024];
//		wsprintf(szParam, _T("\"%s\""), lpszCmdLine);
//
//		//vZX̐
//		STARTUPINFO info;
//		PROCESS_INFORMATION pinfo;
//		memset(&info, 0x00, sizeof(info));
//		info.cb = sizeof(info);
//		info.wShowWindow = SW_SHOWNORMAL;	
//		if(CreateProcess(szProc,szParam,NULL,NULL,FALSE,0,NULL,NULL,&info,&pinfo))
//		{
//			//vȌI҂
//			WaitForSingleObject(pinfo.hProcess, INFINITE);
//			return 1;
//		}
//	}
//
//	//ss̏ꍇ
//	return 0;
//}
//DEL END

////////////////////////////////////////////////////////////////
BOOL CCompress::RunCompress(
	LPTSTR			lpszCurrentFolder,
	LPTSTR			lpszFileName,
	DWORD			nCompDLL,
	BOOL			bMoveDir)
{
	TCHAR szOutBuf[1024];
	TCHAR szSaveFile[MAX_PATH];
	TCHAR szExtName[16];

	if(wcslen(lpszFileName) == 0) return FALSE;

	//kt@C擾
	memset(szSaveFile, 0x00, sizeof(szSaveFile));
	lstrcpy(szExtName, nCompDLL==COMPDLL_MODE_LHA?_T("lzh"):_T("zip"));

	//kt@Cp_CAOݒ
	OPENFILENAME ofn;
	memset(&ofn, 0x00, sizeof(ofn));
	ofn.lStructSize		= sizeof(ofn);
	ofn.hwndOwner		= g_MainWnd.m_hWnd;
	ofn.lpstrFile		= szSaveFile;
	ofn.lpstrInitialDir	= lpszCurrentFolder;
	ofn.nMaxFile		= sizeof(szSaveFile)/sizeof(TCHAR);
	ofn.lpstrDefExt		= szExtName;
	ofn.Flags			= OFN_LONGNAMES | OFN_OVERWRITEPROMPT;
	ofn.lpfnHook		= NULL;
//MOD START GORIPON
	ofn.lpstrTitle		= DupStringTable(IDS_TITLE_COMPDLG);
	ofn.lpstrFilter		= DupStringTable(nCompDLL==COMPDLL_MODE_LHA?IDS_FILTER_COMPDLG1:IDS_FILTER_COMPDLG2);
	//'/''\0'ɒu
	while (TCHAR *lptcSl = wcsrchr(ofn.lpstrFilter, _T('/')))
		*lptcSl = _T('\0');
//MOD END

	//ۑ_CAOI[v
	BOOL (*gsGetSaveFileName)(OPENFILENAME*) = NULL;
	HINSTANCE hInst = LoadLibrary(_T("gsgetfile.dll"));
	if (hInst) {
		(FARPROC&)gsGetSaveFileName = GetProcAddress(hInst, _T("gsGetSaveFileName"));
	}
	else
		ofn.lpstrInitialDir	= NULL;

	BOOL fRet;
	if (gsGetSaveFileName)
		fRet = gsGetSaveFileName(&ofn);
	else
		fRet = GetSaveFileName(&ofn);

	if (hInst) FreeLibrary(hInst);
//ADD START GORIPON
	FreeStringTable((LPWSTR)ofn.lpstrTitle);
	FreeStringTable((LPWSTR)ofn.lpstrFilter);
//ADD END
	if (!fRet) return FALSE;

	//l
	int nLen = 16 + wcslen(szSaveFile) + wcslen(lpszCurrentFolder) + wcslen(lpszFileName);
	LPTSTR lpszCmdLine = new TCHAR[nLen+1];
	memset(lpszCmdLine, 0x00, sizeof(TCHAR)*(nLen+1));

	//R}hC쐬
	wsprintf(lpszCmdLine, _T("a \"%s\" \"%s\\\" %s"),
					szSaveFile, lpszCurrentFolder, lpszFileName);	

	//DLL̃[h
	HMODULE hDLL = OpenDLL(nCompDLL);
	if(!hDLL)
	{
		MessageBox(g_MainWnd.m_hWnd,
			GetStringTable(nCompDLL==COMPDLL_MODE_LHA?IDS_MSG_COMPERROR1:IDS_MSG_COMPERROR2),	//MOD GORIPON
			NULL, MB_OK|MB_ICONSTOP);

		return FALSE;
	}

	//t@Ck(ꎞt@C쐬)
	memset(szOutBuf, 0x00, sizeof(szOutBuf));
	UNFUNC unXX = (UNFUNC)::GetProcAddress(hDLL, nCompDLL==COMPDLL_MODE_LHA?_T("Unlha"):_T("UnZip"));
	if(unXX)
	{
		//DLĽĂяo
		int ret = (*unXX)(NULL, lpszCmdLine, szOutBuf, sizeof(szOutBuf));

		//DLL̃N[Y
		CloseDLL(hDLL);

		if(ret != 0)
		{
//MOD START GORIPON
			MessageBox(g_MainWnd.m_hWnd, szOutBuf, NULL, MB_OK|MB_ICONSTOP);
//MOD END
			return FALSE;
		}
	}

	//i[ֈړ
	if(bMoveDir)
	{
		//pX̋؂蕶(\)T
		LPTSTR lpszTerm = wcsrchr(szSaveFile, _T('\\'));
		if (lpszTerm) {
			*(lpszTerm) = 0;
			g_MainWnd.m_ListView.LoadFolderItem(szSaveFile);
		}
	}

	//
	delete[] lpszCmdLine;

	//I
	return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL CCompress::OnFileCompress(
		LPTSTR						szCurrentFolder,
		int							nCount,
		struct _tagListItemInfo*	pliinfo,
		DWORD						nCompDLL,
		BOOL						bMoveDir,
		BOOL						bAutoUnComp,
		LPTSTR						szEditPath)
{
	//ACeʂ̃TCY擾
	int nLen=0;
	int cnt;
	for(cnt=0; cnt<nCount; cnt++)
	{
		//Ώۃt@C̃Xg쐬
		//fBNg̏ꍇ
		if (pliinfo[cnt].nItem & LIST_ITEM_FOLDER)
		{
			nLen += (6 + wcslen(pliinfo[cnt].szPath) + wcslen(pliinfo[cnt].szName));
		}
		//t@C̏ꍇ
		else if (pliinfo[cnt].nItem & LIST_ITEM_FILE)
		{
			nLen += (4 + wcslen(pliinfo[cnt].szPath) + wcslen(pliinfo[cnt].szName));
		}
	
	} //End of for

	//l
	LPTSTR lpszPath = new TCHAR[nLen+1];
	memset(lpszPath, 0x00, sizeof(TCHAR)*(nLen+1));

	//ACeʂ̏s
	for(cnt=0; cnt<nCount; cnt++)
	{
		//݃`FbN
		TCHAR szTemp[MAX_PATH];
		wsprintf(szTemp, _T("%s\\%s"), pliinfo[cnt].szPath, pliinfo[cnt].szName);
		
		//G[
		if (GetFileAttributes(szTemp) == 0xFFFFFFFF) continue;
		
		//Ώۃt@C̃Xg쐬
		//fBNg̏ꍇ
		if (pliinfo[cnt].nItem & LIST_ITEM_FOLDER)
		{
			wsprintf(szTemp, _T("\"%s\\%s\\*\" "), pliinfo[cnt].szPath, pliinfo[cnt].szName);
			lstrcat(lpszPath, szTemp);
		}
		//t@C̏ꍇ
		else if (pliinfo[cnt].nItem & LIST_ITEM_FILE)
		{
			wsprintf(szTemp, _T("\"%s\\%s\" "), pliinfo[cnt].szPath, pliinfo[cnt].szName);
			lstrcat(lpszPath, szTemp);
		}
	
	} //End of for

	//k
//	BOOL bRtn = RunCompress((bAutoUnComp?szCurrentFolder:szEditPath), lpszPath, nCompDLL, bMoveDir);
	BOOL bRtn = RunCompress(szCurrentFolder, lpszPath, nCompDLL, bMoveDir);

	//̉
	delete[] lpszPath;

	return bRtn;
}

////////////////////////////////////////////////////////////////
BOOL CCompress::RunUnCompress(
		LPTSTR		lpszCurrentFolder,
		LPTSTR		lpszFileName,
		LPTSTR		lpszToFolder,
		DWORD		nCompDLL,
		BOOL		bMoveDir,
		BOOL		bMakeDir)
{
	TCHAR szCmdLine[(MAX_PATH*2)+16];
	TCHAR szLoadFile[MAX_PATH];
	TCHAR szCompFolder[MAX_PATH];

	if(wcslen(lpszFileName) == 0) return FALSE;

	//t@Ci[fBNg쐬(u\vt^)
	if(bMakeDir)
	{
		//쐬
		wsprintf(szCompFolder, _T("%s\\%s\\"), lpszToFolder, lpszFileName);
		LPTSTR lpszTemp = wcsrchr(szCompFolder, _T('.'));
		if(lpszTemp) {
			*lpszTemp = _T('\\');
			*(lpszTemp+1) = 0;
		}
	} else {
		//̂܂
		wsprintf(szCompFolder, _T("%s\\"), lpszToFolder);
	}

	//R}hC쐬
	wsprintf(szLoadFile, _T("%s\\%s"), lpszCurrentFolder, lpszFileName);
	wsprintf(szCmdLine, _T("e \"%s\" \"%s\""), szLoadFile, szCompFolder);	

	//i[fBNg쐬
	if (GetFileAttributes(szCompFolder) == 0xFFFFFFFF) {
		if(!MakeSureDirectoryPathExists(szCompFolder)) {
			MessageBox(g_MainWnd.m_hWnd, GetStringTable(IDS_MSG_COMPERROR5), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
			return FALSE;
		}
	}

	//DLL̃[h
	HMODULE hDLL = OpenDLL(nCompDLL);
	if(!hDLL)
	{
		MessageBox(g_MainWnd.m_hWnd,
			GetStringTable(nCompDLL==COMPDLL_MODE_LHA?IDS_MSG_COMPERROR1:IDS_MSG_COMPERROR2),	//MOD GORIPON
			NULL, MB_OK|MB_ICONSTOP);

		return FALSE;
	}

	//t@C
	TCHAR szOutBuf[1024];
	memset(szOutBuf, 0x00, sizeof(szOutBuf));
	UNFUNC unXX = (UNFUNC)::GetProcAddress(hDLL, nCompDLL==COMPDLL_MODE_LHA?_T("Unlha"):_T("UnZip"));
	if(unXX)
	{
		//DLĽĂяo
		int ret = (*unXX)(NULL, szCmdLine, szOutBuf, sizeof(szOutBuf));

		//DLL̃N[Y
		CloseDLL(hDLL);

		if(ret != 0) {
//MOD START GORIPON
			MessageBox(g_MainWnd.m_hWnd, szOutBuf, NULL, MB_OK|MB_ICONSTOP);
//MOD END
			return FALSE;
		}
	}

	//c[r[XV
	szCompFolder[wcslen(szCompFolder)-1] = 0;
	if(bMoveDir)
		//i[ֈړ
		g_MainWnd.m_ListView.LoadFolderItem(szCompFolder);
	else
	{
		//ړȂ
		//pX̋؂蕶(\)T
		LPTSTR lpszTerm = wcsrchr(szCompFolder, _T('\\'));
		if (lpszTerm) {
			*(lpszTerm) = 0;
			g_MainWnd.m_TreeView.SetCurrentFolder(szCompFolder);
		}
	}

	return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL CCompress::OnFileUnCompress(
		LPTSTR						szCurrentFolder,
		int							nCount,
		struct _tagListItemInfo*	pliinfo,
		DWORD						nCompDLL,
		BOOL						bMoveDir,
		BOOL						bMakeDir,
		BOOL						bAutoUnComp,
		LPTSTR						szEditPath)
{
	TCHAR szPath[MAX_PATH];
	memset(szPath, 0x00, sizeof(szPath));

	BOOL bRtn = FALSE;

	//ACeʂ̏s
	for(int cnt=0; cnt<nCount; cnt++)
	{
		//݃`FbN
		TCHAR szTemp[MAX_PATH];
		wsprintf(szTemp, _T("%s\\%s"), pliinfo[cnt].szPath, pliinfo[cnt].szName);
		//G[
		if (GetFileAttributes(szTemp) == 0xFFFFFFFF) continue;
		
		//fBNg̏ꍇ
		if (pliinfo[cnt].nItem & LIST_ITEM_FOLDER)
		{
			wsprintf(szTemp, _T("\"%s\\%s\\*\" "), pliinfo[cnt].szPath, pliinfo[cnt].szName);
		}
		//t@C̏ꍇ
		else if (pliinfo[cnt].nItem & LIST_ITEM_FILE)
		{
			//gq擾
			LPTSTR lpszExt = wcsrchr(pliinfo[cnt].szName, _T('.'));
			if (lpszExt == NULL) continue;
//			TCHAR szExt[6];
//			wcscpy(szExt, lpszExt);
//			wcsupr(szExt);

			//𓀃t@C̊i[ꏊ
			LPTSTR lpszTemp = (bAutoUnComp?pliinfo[cnt].szPath:szEditPath);

			//gq`FbN{kt@C
			//LHA`̏ꍇ
			if(wcsicmp(lpszExt, _T(".LZH"))==0 && g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_LHA))
			{
				if(RunUnCompress(pliinfo[cnt].szPath,
					pliinfo[cnt].szName, lpszTemp, COMPDLL_MODE_LHA, bMoveDir, bMakeDir))
					bRtn = TRUE;
			}
			//ZIP`̏ꍇ
			else if(wcsicmp(lpszExt, _T(".ZIP"))==0 && g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_ZIP))
			{
				if(RunUnCompress(pliinfo[cnt].szPath,
				   pliinfo[cnt].szName, lpszTemp, COMPDLL_MODE_ZIP, bMoveDir, bMakeDir))
					bRtn = TRUE;
			}
		}

	} //End of for

	return bRtn;
}

////////////////////////////////////////////////////////////////
BOOL CCompress::IsCompress(DWORD nCompDLL)
{
	if(nCompDLL == COMPDLL_MODE_LHA && m_bLhaChk)
		return TRUE;
	if(nCompDLL == COMPDLL_MODE_ZIP && m_bZipChk)
		return TRUE;
	return FALSE;
}

////////////////////////////////////////////////////////////////
BOOL CCompress::IsUnCompress()
{
	if(m_bLhaChk || m_bZipChk)
		return TRUE;
	return FALSE;
}
////////////////////////////////////////////////////////////////