//FolderDlgPPC.cpp
#include "GSFinder.h"
#include "FolderDlgPPC.h"

//ADD START GORIPON
WNDPROC	Org_FolderDlgTreeViewProc = NULL;
///////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderDlgTreeViewProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
		case WM_KEYUP:
			switch (wParam)
			{
			case VK_RIGHT:
				HTREEITEM hItem = TreeView_GetSelection(hWnd);
				if(hItem)
				{
					RECT rc;
					TreeView_GetItemRect(hWnd, hItem, &rc, TRUE);
					PostMessage(hWnd, WM_LBUTTONDBLCLK, 0, MAKELPARAM(rc.left+1, rc.top+1));
				}
				return 0;
			}
			break;
	}
	return CallWindowProc((WNDPROC)Org_FolderDlgTreeViewProc, hWnd, message, wParam, lParam);
}
//ADD END

CFolderDlg* pfd;
///////////////////////////////////////////////////////////////
void CFolderDlg::CreateNewFolder(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	TCHAR szPath[MAX_PATH] = _T("");
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szName[MAX_PATH] = _T("");
	
	HTREEITEM hTreeItem = TreeView_GetSelection(hTV);
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hTreeItem;
	TreeView_GetItem(hTV, &tvi);
	if (wcscmp(szName, GetRootName()) != 0)
	{
		wcscpy(szPath, szName);
		hTreeItem = TreeView_GetParent(hTV, hTreeItem);
		while (hTreeItem)
		{
			tvi.hItem = hTreeItem;
			TreeView_GetItem(hTV, &tvi);
			if (wcscmp(szName, GetRootName()) != 0)
				wsprintf(szTemp, _T("%s\\%s"), szName, szPath);
			else
				wsprintf(szTemp, _T("\\%s"), szPath);
			wcscpy(szPath, szTemp);
			hTreeItem = TreeView_GetParent(hTV, hTreeItem);
		}
	}
	else
		wcscpy(szPath, _T(""));

	int nCount = 1;
	BOOL bCreate = FALSE;
	TCHAR szNewFolderName[MAX_PATH];
	while (!bCreate)
	{
		TCHAR szNewFolderPath[MAX_PATH] = _T("");
		wsprintf(szNewFolderName, GetStringTable(nCount>1?IDS_FMT_NEWFOLDERNAME1:IDS_FMT_NEWFOLDERNAME), nCount);	//MOD GORIPON
		wsprintf(szNewFolderPath, _T("%s\\%s"), szPath, szNewFolderName);

		bCreate = CreateDirectory(szNewFolderPath, NULL);
		nCount++;
		if (nCount > 1024)
		{
			MessageBox(hDlg, GetStringTable(IDS_MSG_CANNOTCREATEFOLDER), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
			return;
		}
	}

	HTREEITEM hParent = TreeView_GetSelection(hTV);
	TVINSERTSTRUCT tvis;
	tvis.hParent = hParent;
	tvis.hInsertAfter = TVI_SORT;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvis.item.pszText = szNewFolderName;
	tvis.item.iImage = 1;
	tvis.item.iSelectedImage = 1;
	hTreeItem = TreeView_InsertItem(hTV, &tvis);
	TreeView_Expand(hTV, hParent, TVE_EXPAND);
	TreeView_SelectItem(hTV, hTreeItem);
	SetFocus(hTV);

	m_bRefresh = TRUE;
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnInitDialog(HWND hDlg)
{
	HWND hTreeView = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	m_bRefresh = FALSE;
	m_hImageList = NULL;
	HICON hIcon;

	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = hDlg;
	SHInitDialog(&shidi);

//ADD START GORIPON
	//j[o[ǉ
	SHMENUBARINFO mbi;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hDlg;
	mbi.nToolBarId = IDR_FOLDER;
	mbi.hInstRes = g_hInst;
	mbi.nBmpId = 0;
	mbi.cBmpImages = 0;
	SHCreateMenuBar(&mbi);

	//c[r[̃vV[Wo^(EL[c[WJp)
	Org_FolderDlgTreeViewProc = (WNDPROC)GetWindowLong(hTreeView, GWL_WNDPROC);
	SetWindowLong(hTreeView, GWL_WNDPROC, (DWORD)FolderDlgTreeViewProc);
//ADD END

	SendMessage(hTreeView, CCM_SETVERSION, COMCTL32_VERSION, 0);

	if (wcslen(m_lpszTitle))
	{
		SetWindowText(hDlg, m_lpszTitle);
		SetDlgItemText(hDlg, IDC_TITLE, m_lpszTitle);
	}

	//TCY (TreeView)
//MOD START GORIPON (nC]Ή)
	OnSize(hDlg);
//MOD END

	//C[WXg쐬
//MOD START GORIPON (nC]Ή)
	if (g_MainWnd.m_bHighDpiHardware)
	{
		m_hImageList = ImageList_Create(32, 32, ILC_COLOR|ILC_MASK, 1, 2);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DeleteObject(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
	}
	else
	{
		m_hImageList = ImageList_Create(16, 16, ILC_COLOR|ILC_MASK, 1, 2);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROOT_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DeleteObject(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDERO_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
		hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_S);
		ImageList_AddIcon(m_hImageList, hIcon);
		DestroyIcon(hIcon);
	}
//MOD END
	TreeView_SetImageList(hTreeView, m_hImageList, TVSIL_NORMAL);
	SetWindowLong(hTreeView, GWL_STYLE, GetWindowLong(hTreeView, GWL_STYLE)|TVS_HASBUTTONS|TVS_HASLINES|TVS_SHOWSELALWAYS);

	//tH_ǂݍ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	TVINSERTSTRUCT tvis;
	tvis.hParent = NULL;
	tvis.hInsertAfter = TVI_SORT;
	tvis.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
	tvis.item.pszText = (LPTSTR)GetRootName();
	tvis.item.iImage = 0;
	tvis.item.iSelectedImage = 0;
	tvis.item.cChildren = 1;
	HTREEITEM hRoot = TreeView_InsertItem(hTreeView, &tvis);
	TreeView_Expand(hTreeView, hRoot, TVE_EXPAND);

	//JgtH_Zbg
	SetCurrentFolder(hTreeView, m_lpszPath);

	SipShowIM(SIPF_OFF);
	SetCursor(hCursor);
}
///////////////////////////////////////////////////////////////
void CFolderDlg::OnOK(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);

	TCHAR szPath[MAX_PATH] = _T("");
	TCHAR szTemp[MAX_PATH] = _T("");
	TCHAR szName[MAX_PATH] = _T("");
	
	HTREEITEM hTreeItem = TreeView_GetSelection(hTV);
	GetTree(hTV, hTreeItem, m_lpszPath);
	EndDialog(hDlg, IDOK);
}
//ADD START GORIPON
///////////////////////////////////////////////////////////////
void CFolderDlg::OnSize(HWND hDlg)
{
	//TCY (TreeView)
	RECT rc;
	POINT pt;
	HWND htv;

	htv = GetDlgItem(hDlg, IDC_TREE_FOLDER);
	GetWindowRect(htv, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(hDlg, &pt);
	GetWindowRect(hDlg, &rc);
	MoveWindow(htv, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc)-pt.y, TRUE);
}
//ADD END
///////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	switch (message)
	{
		case WM_INITDIALOG:
		{
			pfd->OnInitDialog(hDlg);
			return TRUE;
		}
//ADD START GORIPON
		case WM_SIZE:
			pfd->OnSize(hDlg);
			break;
//ADD END
		case WM_COMMAND:
		{
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
				case IDOK :
				{
					pfd->OnOK(hDlg);
					return TRUE;
				}
				case IDCANCEL:
				{
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
				}
				case ID_CREATE_FOLDER:
				{
					pfd->CreateNewFolder(hDlg);
					return TRUE;
				}
				case ID_RENAME_FOLDER:
				{
					pfd->OnRenameFolder(hDlg);
					return TRUE;
				}
			}
			break;
		}
		case WM_NOTIFY:
		{
			NMHDR* lpnmh = (NMHDR*)lParam;
			if (lpnmh->code == TVN_ITEMEXPANDING/* && lpnmh->idFrom == IDC_TREE_FOLDER*/)
			{
				pfd->OnItemExpanding((NMTREEVIEW*)lpnmh);
				return TRUE;
			}
			if (lpnmh->code == TVN_ITEMEXPANDED/* && lpnmh->idFrom == IDC_TREE_FOLDER*/)
			{
				pfd->OnItemExpanded((NMTREEVIEW*)lpnmh);
				return TRUE;
			}
			if (lpnmh->code == GN_CONTEXTMENU && lpnmh->idFrom == IDC_TREE_FOLDER)
			{
				if (TreeView_GetSelection(GetDlgItem(hDlg, IDC_TREE_FOLDER)))
				{
					NMRGINFO* lpnmri = (NMRGINFO*)lParam;
					//MOD START TODA
//					HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, 4);
					HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, ID_POPUP_FOLDERDLG);
					//MOD END
					TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, lpnmri->ptAction.x, lpnmri->ptAction.y, 0, hDlg, NULL);
				}
				return TRUE;
			}
			break;
		}
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}
///////////////////////////////////////////////////////////////
int CFolderDlg::ShowFolderDlg(LPCTSTR szTitle, LPTSTR szPath, int nSize)
{
	pfd = this;

	m_lpszTitle = szTitle;
	m_lpszPath = szPath;
	m_nSize = nSize;

	int nRet = DialogBox(g_hInst, (LPCTSTR)IDD_FOLDER_DLG, g_MainWnd.m_hWnd, (DLGPROC)FolderDlgProc);

	pfd = NULL;

	return nRet;
}
///////////////////////////////////////////////////////////////
LRESULT CALLBACK RenameDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	switch (message)
	{
		case WM_INITDIALOG:
		{
			CenterWindow(hDlg);
			SetWindowText(GetDlgItem(hDlg, IDC_EDIT_OLDNAME), pfd->m_lpszName);
			SetWindowText(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), pfd->m_lpszName);
			SetFocus(GetDlgItem(hDlg, IDC_EDIT_NEWNAME));
			SendMessage(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), EM_SETSEL, 0, -1);
			return FALSE;
		}
		case WM_COMMAND:
		{
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// j[ڂ𕪗ޕʂɋ؂܂:
			switch (wmId)
			{
				case IDOK :
				{
					GetWindowText(GetDlgItem(hDlg, IDC_EDIT_NEWNAME), pfd->m_lpszName, MAX_PATH);
					EndDialog(hDlg, IDOK);
					return TRUE;
				}
				case IDCANCEL:
				{
					EndDialog(hDlg, IDCANCEL);
					return TRUE;
				}
			}
			break;
		}
		case WM_CLOSE:
		{
			EndDialog(hDlg, IDCANCEL);
			return TRUE;
		}
		case WM_PAINT:
			return DefDlgPaintProc(hDlg, wParam, lParam);
		case WM_CTLCOLORSTATIC:
			return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);
	}
    return FALSE;
}
///////////////////////////////////////////////////////////////
void CFolderDlg::OnRenameFolder(HWND hDlg)
{
	HWND hTV = GetDlgItem(hDlg, IDC_TREE_FOLDER);
	TCHAR szOldName[MAX_PATH] = _T("");
	TCHAR szNewName[MAX_PATH] = _T("");
	m_lpszName = szNewName;

	HTREEITEM hSelItem = TreeView_GetSelection(hTV);
	TVITEM tvi;
	tvi.mask = TVIF_TEXT | TVIF_HANDLE;
	tvi.pszText = szOldName;
	tvi.cchTextMax = MAX_PATH;
	tvi.hItem = hSelItem;
	TreeView_GetItem(hTV, &tvi);
	wcscpy(szNewName, szOldName);
	if (wcscmp(m_lpszName, GetRootName())!=0)
	{
//DEL START GORIPON
//		BOOL bSetSip = FALSE;
//		SIPINFO si;
//		memset(&si, 0, sizeof(SIPINFO));
//		si.cbSize = sizeof(SIPINFO);
//		SipGetInfo(&si);
//		if ((si.fdwFlags&SIPF_ON)!=SIPF_ON)
//		{
//			SipShowIM(SIPF_ON);
//			bSetSip = TRUE;
//		}
//DEL END
		if (DialogBox(g_hInst, (LPCTSTR)IDD_RENAME_DLG, hDlg, (DLGPROC)RenameDlgProc)==IDOK)
		{
			if (wcscmp(szOldName, szNewName)!=0)
			{
				//O̕ύX
				TCHAR szName[MAX_PATH] = _T("");
				TCHAR szPath[MAX_PATH] = _T("");
				TCHAR szTemp[MAX_PATH] = _T("");
				HTREEITEM hTreeItem = TreeView_GetParent(hTV, hSelItem);
				TVITEM tvi;
				tvi.mask = TVIF_TEXT | TVIF_HANDLE;
				tvi.pszText = szName;
				tvi.cchTextMax = MAX_PATH;
				while (hTreeItem)
				{
					tvi.hItem = hTreeItem;
					TreeView_GetItem(hTV, &tvi);
					if (wcscmp(szName, GetRootName()) != 0)
						wsprintf(szTemp, _T("%s\\%s"), szName, szPath);
					else
						wsprintf(szTemp, _T("\\%s"), szPath);
					wcscpy(szPath, szTemp);
					hTreeItem = TreeView_GetParent(hTV, hTreeItem);
				}
				wcscpy(szName, szOldName);
				wsprintf(szOldName, _T("%s%s"), szPath, szName);
				wcscpy(szName, szNewName);
				wsprintf(szNewName, _T("%s%s"), szPath, szName);
				if (MoveFile(szOldName, szNewName))
				{
					TVITEM tvi;
					tvi.mask = TVIF_TEXT | TVIF_HANDLE;
					tvi.pszText = szName;
					tvi.cchTextMax = MAX_PATH;
					tvi.hItem = hSelItem;
					TreeView_SetItem(hTV, &tvi);
					m_bRefresh = TRUE;
				}
				else
					MessageBox(hDlg, GetStringTable(IDS_MSG_CANNOTCHANGENAME1), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
			}
		}
		//if (bSetSip)	//DEL GORIPON
			SipShowIM(SIPF_OFF);
	}
	else
	{
		wcscat(m_lpszName, GetStringTable(IDS_FMT_RENAME));	//MOD GORIPON
		MessageBox(hDlg, m_lpszName, NULL, MB_OK|MB_ICONEXCLAMATION);
	}
	SetFocus(hTV);
}

///////////////////////////////////////////////////////////////
// GSFinder + TQ̃R[hĂB
// Qta񂠂肪Ɓ[II
// -- Ex.Q --
// c[ r[̍ڂ̐΃pX߂
void CFolderDlg::GetTree(HWND hwndTV, HTREEITEM hItem, LPTSTR pszKey)
{
	TCHAR szName[MAX_PATH];

    TV_ITEM tvi;
    memset (&tvi, 0, sizeof (tvi));

	// e擾
    HTREEITEM hParent;
	hParent = TreeView_GetParent (hwndTV, hItem);
    if (hParent) { 
        // ڂ̐e̐eEEE擾
        GetTree (hwndTV, hParent, pszKey);

        // ڂ̖O擾
		tvi.mask       = TVIF_TEXT;
		tvi.hItem      = hItem;
		tvi.pszText    = szName;
		tvi.cchTextMax = MAX_PATH;
		TreeView_GetItem(hwndTV, &tvi);

		// [głȂ΁
		if (wcscmp(pszKey, GetRootName()) != 0)
			lstrcat (pszKey, TEXT("\\"));
		else
			lstrcpy (pszKey, TEXT("\\"));

		// ẽpXɍ̃tH_ǉ
		lstrcat (pszKey, szName);
	} else {
        // ڂ̖O擾
		lstrcpy(pszKey, _T(""));
        szName[0]      = _T('\0');
        tvi.mask       = TVIF_TEXT | TVIF_PARAM;
        tvi.hItem      = hItem;
        tvi.pszText    = szName;
        tvi.cchTextMax = MAX_PATH;
		TreeView_GetItem(hwndTV, &tvi);
    }
}

///////////////////////////////////////////////////////////////
// CountChildren - L[̃TuL[̐𒲂ׂ
//
int CFolderDlg::CountChildren(LPTSTR pszPath, LPTSTR pszKey)
{
	int rc;
	TCHAR szName[MAX_PATH];
	HANDLE ff;
	WIN32_FIND_DATA wfd;
    DWORD dwCnt = 0;
	wsprintf (szName, _T("%s\\%s\\*.*"), pszPath, pszKey);
	
	ff = FindFirstFile( szName, &wfd );
	if (ff != INVALID_HANDLE_VALUE) {
		while (1) {
			if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				dwCnt++;
				break;
			}
			rc = FindNextFile (ff, &wfd);
			if (rc == 0)
				break;
		}
		FindClose(ff);
    }
	return dwCnt;
}

///////////////////////////////////////////////////////////////
// EnumChildren - L[̃TuL[񋓂
int CFolderDlg::EnumChildren(HWND hwndTV, HTREEITEM hParent, LPTSTR pszPath)
{
	int rc;
    DWORD nChild;
	HANDLE ff;
	WIN32_FIND_DATA wfd;
	TCHAR szName[MAX_PATH];
	TVINSERTSTRUCT tvis;
	DWORD dwCnt = 0;

	wsprintf (szName, _T("%s\\*.*"), pszPath);

	ff = FindFirstFile (szName, &wfd);
	if (ff != INVALID_HANDLE_VALUE) {
		while (1) {
			if (wcsicmp(wfd.cFileName, _T("Recycled")) != 0 &&
				(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
				// ʂ̃fBNg邩
				nChild = CountChildren (pszPath, wfd.cFileName);

				// c[ r[ Rg[ɃL[}
				tvis.hParent      = hParent;
				tvis.hInsertAfter = TVI_SORT;
				tvis.item.mask    = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
				tvis.item.pszText = wfd.cFileName;
				tvis.item.cChildren = (nChild ? 1 : 0);

				if (wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY) {
					tvis.item.iImage = 3;
					tvis.item.iSelectedImage = 3;
				}
				else if (wcsicmp(wfd.cFileName, _T("My Documents")) == 0) {
					tvis.item.iImage = 4;
					tvis.item.iSelectedImage = 4;
				}
				else {
					tvis.item.iImage = 1;
					tvis.item.iSelectedImage = 2;
				}

				TreeView_InsertItem(hwndTV, &tvis);

				dwCnt++;
			}
			rc = FindNextFile (ff, &wfd);
			if (rc == 0)
				break;
		}
		FindClose(ff);
	}

    // TuL[Ȃꍇ͓WJ{^폜
    TVITEM tvi;
	tvi.hItem = hParent;
	tvi.mask  = TVIF_CHILDREN;
    if (dwCnt == 0)
        tvi.cChildren = 0;
    else
        tvi.cChildren = 1;
	TreeView_SetItem (hwndTV, &tvi);

	// \[g
	TreeView_SortChildren(hwndTV, hParent, 0);

	return dwCnt;
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnItemExpanded(NMTREEVIEW* lpnmtv)
{
	// Ƀu`WJƂɉ߂ė񋓂̂ŃTuL[폜
	if (lpnmtv->action == TVE_COLLAPSE) {
		HTREEITEM hChild;
		HTREEITEM hNext;

		hChild = TreeView_GetChild (lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem);
		while (hChild) {
			hNext = TreeView_GetNextItem (lpnmtv->hdr.hwndFrom, hChild, TVGN_NEXT);
			TreeView_DeleteItem (lpnmtv->hdr.hwndFrom, hChild);
			hChild = hNext;
		}
	}
}

///////////////////////////////////////////////////////////////
void CFolderDlg::OnItemExpanding(NMTREEVIEW* lpnmtv)
{
	if (lpnmtv->action == TVE_EXPAND) {
		TCHAR szKey[MAX_PATH];
		//tH_擾
		GetTree (lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem, szKey);
		//qc[񋓂
		EnumChildren (lpnmtv->hdr.hwndFrom, lpnmtv->itemNew.hItem, szKey);
	}
}

void CFolderDlg::SetCurrentFolder(HWND hwndTV, LPCTSTR lpszPath)
{
	LPCTSTR lpszStart = wcschr(lpszPath, _T('\\'));
	HTREEITEM hSelectItem = TreeView_GetRoot(hwndTV);

	HTREEITEM hParent = hSelectItem;
	TreeView_Expand(hwndTV, hParent, TVE_EXPAND);

	while (lpszStart)
	{
		TCHAR szName[MAX_PATH] = _T("");
		LPCTSTR lpszEnd = wcschr(lpszStart + 1, _T('\\'));
		if (lpszEnd) {
			int len = lpszEnd - (lpszStart + 1);
			wcsncpy(szName, ++lpszStart, len);
			szName[len] = 0;
		}
		else
			wcscpy(szName, ++lpszStart);

		HTREEITEM hChild = TreeView_GetChild(hwndTV, hParent);
		while (hChild)
		{
			TCHAR szChildName[MAX_PATH] = _T("");
			TVITEM tvi;
			tvi.mask = TVIF_TEXT | TVIF_HANDLE;
			tvi.pszText = szChildName;
			tvi.cchTextMax = MAX_PATH;
			tvi.hItem = hChild;
			TreeView_GetItem(hwndTV, &tvi);
			if (wcscmp(szName, szChildName) == 0)
			{
				hSelectItem = hParent = hChild;
				TreeView_Expand(hwndTV, hParent, TVE_EXPAND);
				break;
			}

			hChild = TreeView_GetNextItem(hwndTV, hChild, TVGN_NEXT);
		}
		if (!hChild) break;

		lpszStart = wcschr(lpszStart, _T('\\'));
	}

	TreeView_SelectItem(hwndTV, hSelectItem);
}