#include "GSFinder.h"
#include "MainWnd.h"

///////////////////////////////////////////////////////////////
//EBhE NX̓o^
ATOM CMainWnd::MainWndRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC) MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= NULL;
	wc.hCursor			= 0;
	wc.hbrBackground	= CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
	wc.lpszMenuName		= 0;
	wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

///////////////////////////////////////////////////////////////
CMainWnd::CMainWnd()
{
	m_bControlKey = FALSE;
	m_bShiftKey = FALSE;

	m_bShowStatusWnd = TRUE;
	m_bContextMenu = FALSE;			//ADD TODA
	m_bFontChange = FALSE;			//ADD TODA
	m_bDragDrop = TRUE;				//MOD TODA
	m_nFontSize = 12;				//ADD TODA
	m_szFontName[0]=0x00;			//ADD TODA

	wcscpy(m_szSendAppPath, _T("\\Windows\\SendTo"));
	m_bCheckQAdd = TRUE;

	m_bShowFolder		= FALSE;	//ADD TODA
	m_nTreeViewWidth	= 100;		//ADD TODA
	m_nTreeViewHeight	= 100;		//ADD TODA
	m_bViewSide			= FALSE;	//ADD TODA

	m_dwLastSipInfo	= SIPF_OFF;

	m_hwndPrev			= NULL;
	m_nMainWndTop		= 0;		//ADD TODA
	m_nMainWndLeft		= 0;		//ADD TODA
	m_nMainWndWidth		= 640;		//ADD TODA
	m_nMainWndHeight	= 400;		//ADD TODA
	m_nMainWndStyle		= 92;		//ADD TODA
//ADD START GORIPON
	m_bNumberShortcut	= FALSE;
	m_bLandscapeMode	= FALSE;
	m_bHighRresolutionMode	= FALSE;
	m_bHighDpiHardware	= TRUE;
	m_fpHighResolutionScale	= 1.0;
	m_hFont				= NULL;
	m_bViewSideL		= FALSE;
	m_nTreeViewWidthL	= 100;
	m_nTreeViewHeightL	= 100;
	m_bIsZero3			= FALSE;
	m_bSwapMenu			= FALSE;
	m_dwInputMode		= INPUTMODE_HAN_NUMERIC;
	m_dwInitialInputMode = INPUTMODE_ZEN_HIRAGANA;
//ADD END
}

///////////////////////////////////////////////////////////////
CMainWnd::~CMainWnd()
{
//DEL START GORIPON
	//if (m_bControlKey)
	//	keybd_event(VK_CONTROL, 0x1e, KEYEVENTF_KEYUP, 1);
	//if (m_bShiftKey)
	//	keybd_event(VK_SHIFT, 0x1e, KEYEVENTF_KEYUP, 1);
//DEL END
}

///////////////////////////////////////////////////////////////
void CMainWnd::Init()
{
	//IM
	m_dwLastSipInfo = GetIMStatus();

	SaveModulePath();

//DEL START GORIPON
	////OSo[W擾
	//GetVersion();
//DEL END

	//VXepX̎擾
	GetSystemPath();

//ADD START GORIPON
	//W-ZERO3 (DLL͑݊mF݂̂ŃGNX|[g֐͖gp)
	HMODULE hDLL = LoadLibrary(_T("\\Windows\\shphonelib.dll"));
	if (hDLL)
	{
		FreeLibrary(hDLL);
		HANDLE hEv = CreateEvent(NULL,FALSE,FALSE,_T("CpStartTalking"));
		if (hEv)
		{
			m_bIsZero3 = (GetLastError() == ERROR_ALREADY_EXISTS);
			CloseHandle(hEv);
		}
	}

	//Smartphone/Standard̔
#if !defined(UNSUPPORT_SMARTPHONE)
	TCHAR szTemp[MAX_PATH];
	if (SystemParametersInfo(SPI_GETPLATFORMTYPE, MAX_PATH, szTemp, 0))
		m_bIsSmartphone = (lstrcmpi(szTemp, _T("Smartphone")) == 0);
	else
		m_bIsSmartphone = FALSE;
	if (m_bIsSmartphone)
	{
		m_CmdBands.OnViewToolBar();	//on()off
	}
#endif

	//DPIn[hEFA
	HDC hdc = GetDC(NULL);
#if !defined(UNSUPPORT_SMARTPHONE)
	if (m_bIsSmartphone)
	{
		m_bHighDpiHardware = (GetDeviceCaps(hdc, LOGPIXELSX) > 131);
		m_fpHighResolutionScale = (float)GetDeviceCaps(hdc, LOGPIXELSX) / 131;
	}
	else
#endif
	{
		m_bHighDpiHardware = (GetDeviceCaps(hdc, LOGPIXELSX) > 96);
		m_fpHighResolutionScale = (float)GetDeviceCaps(hdc, LOGPIXELSX) / 96;
	}
	ReleaseDC(0, hdc);
//ADD END

	//ݒǂݍ
	GetSettings();

	//NX̓o^
	MainWndRegisterClass(g_hInst, APP_MUTEX_NAME);

	//EBhE쐬
	m_hWnd = CreateWindow(APP_MUTEX_NAME, APP_MAINWND_TITLE, WS_VISIBLE,
				CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, g_hInst, NULL);

	//ACR̐ݒ
	SendMessage(m_hWnd, WM_SETICON , ICON_SMALL, 
				(LPARAM)LoadImage(g_hInst, MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));
	SendMessage(m_hWnd, WM_SETICON , ICON_BIG,
				(LPARAM)LoadIcon(g_hInst, MAKEINTRESOURCE(IDR_MAINFRAME)));

//ADD START GORIPON
	//̓[h𔼊pɕύX
	m_dwInitialInputMode = GetInputMode();
	SetInputMode(INPUTMODE_HAN_NUMERIC);
//ADD END
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CMainWnd::GetSystemPath()
{
//MOD START GORIPON
	//Windows
	if(!SHGetSpecialFolderPath(NULL, m_szWindowsPath, CSIDL_WINDOWS, FALSE))
		wcscpy(m_szWindowsPath, GetStringTable(IDS_WINDOWS_PATH));

	//lbg[N
	if(!SHGetSpecialFolderPath(NULL, m_szNetworkPath, CSIDL_NETWORK, FALSE))
		wcscpy(m_szNetworkPath, GetStringTable(IDS_NETWORK_PATH));
	m_lpszNetwork = wcsrchr(m_szNetworkPath, _T('\\'))+1;

	//}ChLg
	if(!SHGetSpecialFolderPath(NULL, m_szMyDocumentPath, CSIDL_PERSONAL, FALSE))
		wcscpy(m_szMyDocumentPath, GetStringTable(IDS_MYDOCUMENT_PATH));
	m_lpszMyDocument = wcsrchr(m_szMyDocumentPath, _T('\\'))+1;

	//X^[gj[
	if(!SHGetSpecialFolderPath(NULL, m_szStartMenuPath, CSIDL_STARTMENU, FALSE))
		wcscpy(m_szStartMenuPath, GetStringTable(IDS_STARTMENU_PATH));
	m_lpszStartMenu = wcsrchr(m_szStartMenuPath, _T('\\'))+1;

	//Cɓ
	if(!SHGetSpecialFolderPath(NULL, m_szFavoritesPath,	CSIDL_FAVORITES, FALSE))
		wcscpy(m_szFavoritesPath, GetStringTable(IDS_FAVORITES_PATH));
//MOD END
}
//ADD END

///////////////////////////////////////////////////////////////
void CMainWnd::OnCreate()
{
	//
	INITCOMMONCONTROLSEX	iccex;
	iccex.dwSize = sizeof (INITCOMMONCONTROLSEX);
	iccex.dwICC = ICC_BAR_CLASSES | ICC_COOL_CLASSES;
	InitCommonControlsEx (&iccex);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ShowWindow()
{
//	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));	//DEL TODA

	//ݒǂݍ
//	GetSettings();									//DEL TODA

	//qEChE
	m_CmdBands.Init(m_hWnd);
	m_CmdBands.SetCheckViewStatusWnd(m_bShowStatusWnd);
	m_CmdBands.SetCheckViewFolder(m_bShowFolder);	//ADD TODA
	m_CmdBands.SetCheckViewSide(m_bLandscapeMode?m_bViewSideL:m_bViewSide);	//MOD GORIPON
	m_CmdBands.SetCheckViewHighRes(m_bHighRresolutionMode);	//ADD GORIPON
	m_CmdBands.SetCheckDragDrop(m_bDragDrop);		//ADD TODA
	m_StatusWnd.Init(m_hWnd);
	m_ListView.Init(m_hWnd);
	m_TreeView.Init(m_hWnd);						//ADD TODA

	//tHgݒ
	SetFont();										//ADD TODA

	//\
//	::ShowWindow(m_hWnd, SW_SHOW);					//DEL TODA
//ADD START TODA
	//EBhE\
	//I[o[bvEBhE
	if(m_bOverLapped)
	{
		//EBhEԐݒ
		if(m_nMainWndStyle > 2) {
			m_nMainWndStyle -= 90;
		}
		switch(m_nMainWndStyle) {
		//ŏ
		case MAINWND_MINIMUM:
			::ShowWindow(m_hWnd, SW_SHOW);
			::ShowWindow(m_hWnd, SW_MINIMIZE);
			break;
		//ʏ
		case MAINWND_NOMAL:
			::ShowWindow(m_hWnd, SW_SHOWNORMAL);
			break;
		//ő剻
		case MAINWND_MAXIMUM:
		default:
			m_nMainWndStyle = 2;
			::ShowWindow(m_hWnd, SW_SHOW);
			::ShowWindow(m_hWnd, SW_MAXIMIZE);
			break;
		}
	//ʏEBhE
	} else {
		::ShowWindow(m_hWnd, SW_SHOW);
	}
//ADD END

	m_StatusWnd.ShowStatusWnd(m_bShowStatusWnd);

	//\TCY̒
	RecalcLayout();
	
	//tH_ǂݍ
	//ADD START TODA	
	SetFocus(m_ListView.m_hWnd);
	//ADD END
	m_ListView.InitFolderItem(m_ListView.m_szCurrentFolder);	//MOD GORIPON
//	SetCursor(hCursor);								//DEL TODA
	m_hwndPrev = m_ListView.m_hWnd;
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDestroy()
{
	PostQuitMessage(0);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnSize(int nWidth, int nHeight)
{
	//MOD START TODA (from GSFinder ver.1.99)
	//TCY𒲐
//MOD START GORIPON
	RECT rctSB, rctTB, rctAB, rctCB;
	if (m_StatusWnd.m_hWnd)
		GetWindowRect(m_StatusWnd.m_hWnd, &rctSB);
	if (m_CmdBands.m_hToolbar)
		GetWindowRect(m_CmdBands.m_hToolbar, &rctTB);
	if (m_CmdBands.m_hAddressbar)
	{
		GetWindowRect(m_CmdBands.m_hAddressbar, &rctAB);
		GetWindowRect(m_CmdBands.m_hComboBox, &rctCB);
	}
	rctSB.left = rctTB.left = rctAB.left = 0;
	rctSB.right = rctTB.right = rctAB.right = GetSystemMetrics(SM_CXSCREEN);
	if (m_CmdBands.m_Settings.bShowAddressBar)
	{
		int ss = (int)(2 * m_fpHighResolutionScale);
		MoveWindow(m_CmdBands.m_hAddressbar, 0, 0, RECT_WIDTH(&rctAB), RECT_HEIGHT(&rctAB), TRUE);
		MoveWindow(m_CmdBands.m_hComboBox, ss, ss, RECT_WIDTH(&rctAB)-ss*2, RECT_HEIGHT(&rctCB), TRUE);
	}
//MOD END
	if (m_CmdBands.m_Settings.bShowToolBar)
		MoveWindow(m_CmdBands.m_hToolbar, 0,
			nHeight - RECT_HEIGHT(&rctTB), RECT_WIDTH(&rctTB), RECT_HEIGHT(&rctTB), TRUE);
	if (m_bShowStatusWnd)
	{
		if (m_CmdBands.m_Settings.bShowToolBar)
			MoveWindow(m_StatusWnd.m_hWnd, 0,
				nHeight - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB),
				RECT_WIDTH(&rctSB), RECT_HEIGHT(&rctSB), TRUE);
		else
			MoveWindow(m_StatusWnd.m_hWnd, 0,
				nHeight - RECT_HEIGHT(&rctSB), RECT_WIDTH(&rctSB), RECT_HEIGHT(&rctSB), TRUE);
	}
	int nLVTop, nLVBottom;
	if (m_CmdBands.m_Settings.bShowAddressBar)
		nLVTop = RECT_HEIGHT(&rctAB);
	else
		nLVTop = 0;

	if (m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctSB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight + 1;
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctTB);
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctTB);
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctSB);
	//MOD END

//MOD START TODA
//	if (m_CmdBands.m_Settings.bShowAddressBar)
//		SetWindowPos(m_ListView.m_hWnd, HWND_TOP, 0, nLVTop - 2 , nWidth, nLVBottom + 3, SWP_SHOWWINDOW);
//	else
//		MoveWindow(m_ListView.m_hWnd, 0, nLVTop , nWidth, nLVBottom, TRUE);
	if (m_CmdBands.m_Settings.bShowAddressBar)
	{
		if (m_bShowFolder)
		{
//MOD START GORIPON
			if(m_bLandscapeMode?m_bViewSideL:m_bViewSide)
			{
				int ntvw = (m_bLandscapeMode? m_nTreeViewWidthL:m_nTreeViewWidth);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				SetWindowPos(m_TreeView.m_hWnd, HWND_TOP,
					0,
					nLVTop,
					ntvw,
					nLVBottom, SWP_SHOWWINDOW);
				SetWindowPos(m_ListView.m_hWnd, HWND_TOP,
					0 + (ntvw + split),
					nLVTop,
					nWidth - (ntvw + split),
					nLVBottom, SWP_SHOWWINDOW);
			}
			else
			{
				int ntvh = (m_bLandscapeMode? m_nTreeViewHeightL:m_nTreeViewHeight);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				SetWindowPos(m_TreeView.m_hWnd, HWND_TOP,
					0,
					nLVTop,
					nWidth,
					ntvh, SWP_SHOWWINDOW);
				SetWindowPos(m_ListView.m_hWnd, HWND_TOP,
					0,
					nLVTop + (ntvh + split),
					nWidth,
					nLVBottom - (ntvh + split), SWP_SHOWWINDOW);
			}
//MOD END
		}
		else
			SetWindowPos(m_ListView.m_hWnd, HWND_TOP, 0, nLVTop , nWidth, nLVBottom, SWP_SHOWWINDOW);	//MOD GORIPON
	}
	else
	{
		if (m_bShowFolder)
		{
//MOD START GORIPON
			if(m_bLandscapeMode?m_bViewSideL:m_bViewSide)
			{
				int ntvw = (m_bLandscapeMode? m_nTreeViewWidthL:m_nTreeViewWidth);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				MoveWindow(m_TreeView.m_hWnd,
					0,
					nLVTop,
					ntvw,
					nLVBottom, TRUE);
				MoveWindow(m_ListView.m_hWnd,
					0 + (ntvw + split),
					nLVTop,
					nWidth - (ntvw + split),
					nLVBottom, TRUE);
			}
			else
			{
				int ntvh = (m_bLandscapeMode? m_nTreeViewHeightL:m_nTreeViewHeight);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				MoveWindow(m_TreeView.m_hWnd,
					0,
					nLVTop,
					nWidth,
					ntvh, TRUE);
				MoveWindow(m_ListView.m_hWnd,
					0,
					nLVTop + (ntvh + split),
					nWidth,
					nLVBottom - (ntvh + split), TRUE);
			}
//MOD END
		}
		else
			MoveWindow(m_ListView.m_hWnd, 0, nLVTop , nWidth, nLVBottom, TRUE);
	}
//MOD END
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnClose()
{
	SaveSettings();
	m_CmdBands.Destroy();
	m_StatusWnd.Destroy();
	m_ListView.Destroy();
	m_TreeView.Destroy();	//ADD TODA
	DestroyWindow(m_hWnd);
	SetInputMode(m_dwInitialInputMode);	//ADD GORIPON
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnEditCtrlOn()
{
//MOD START GORIPON
	m_bShiftKey = FALSE;
	m_bControlKey = !m_bControlKey;
	m_CmdBands.SetCheckKeyOn(m_bControlKey, m_bShiftKey);
//MOD END
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnEditShiftOn()
{
//MOD START GORIPON
	m_bControlKey = FALSE;
	m_bShiftKey = !m_bShiftKey;
	m_CmdBands.SetCheckKeyOn(m_bControlKey, m_bShiftKey);
//MOD END
}
//ADD START TODA
///////////////////////////////////////////////////////////////
void CMainWnd::OnDragDropMode()
{
	m_bDragDrop = !m_bDragDrop;
	m_CmdBands.SetCheckDragDrop(m_bDragDrop);
}
//ADD END
///////////////////////////////////////////////////////////////
void CMainWnd::SaveSettings()
{
//MOD START GORIPON
	HKEY hKey;
	DWORD dwDisposition;

	//L[ݒ
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS,
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_nTreeViewWidth,m_nTreeViewWidthL;
		RegSetValueEx(hKey, _T("TreeViewWidthP"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewWidth, sizeof(DWORD));
		RegSetValueEx(hKey, _T("TreeViewWidthL"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewWidthL, sizeof(DWORD));

		//m_nTreeViewHeight,m_nTreeViewHeightL;
		RegSetValueEx(hKey, _T("TreeViewHeightP"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewHeight, sizeof(DWORD));
		RegSetValueEx(hKey, _T("TreeViewHeightL"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewHeightL, sizeof(DWORD));

		//m_bShowStatusWnd
		RegSetValueEx(hKey, _T("ShowStatusWnd"), 0, REG_DWORD, (LPBYTE)&m_bShowStatusWnd, sizeof(DWORD));

		//m_bShowFolder
		RegSetValueEx(hKey, _T("ShowFolder"), 0, REG_DWORD, (LPBYTE)&m_bShowFolder, sizeof(DWORD));

		//m_bViewSide/m_bViewSideL
		RegSetValueEx(hKey, _T("ViewSideP"), 0, REG_DWORD, (LPBYTE)&m_bViewSide, sizeof(DWORD));
		RegSetValueEx(hKey, _T("ViewSideL"), 0, REG_DWORD, (LPBYTE)&m_bViewSideL, sizeof(DWORD));

		//m_bDragDrop
		RegSetValueEx(hKey, _T("DragDrop"), 0, REG_DWORD, (LPBYTE)&m_bDragDrop, sizeof(DWORD));

		//m_bCheckQAdd
		RegSetValueEx(hKey, _T("CheckQAdd"), 0, REG_DWORD, (LPBYTE)&m_bCheckQAdd, sizeof(DWORD));

		//m_bOverLapped
		RegSetValueEx(hKey, _T("OverLapped"), 0, REG_DWORD, (LPBYTE)&m_bOverLapped, sizeof(DWORD));

		//m_bContextMenu
		RegSetValueEx(hKey, _T("ContextMenu"), 0, REG_DWORD, (LPBYTE)&m_bContextMenu, sizeof(DWORD));

		//m_bFontChange
		RegSetValueEx(hKey, _T("FontChange"), 0, REG_DWORD, (LPBYTE)&m_bFontChange, sizeof(DWORD));

		//m_nFontSize;
		RegSetValueEx(hKey, _T("FontSize"), 0, REG_DWORD, (LPBYTE)&m_nFontSize, sizeof(DWORD));

		//m_bNumberShortcut
		RegSetValueEx(hKey, _T("NumberShortcut"), 0, REG_DWORD, (LPBYTE)&m_bNumberShortcut, sizeof(DWORD));

		//m_bHighRresolutionMode
		RegSetValueEx(hKey, _T("HighResolutionMode"), 0, REG_DWORD, (LPBYTE)&m_bHighRresolutionMode, sizeof(DWORD));

		//m_bSwapMenu
		RegSetValueEx(hKey, _T("SwapMenu"), 0, REG_DWORD, (LPBYTE)&m_bSwapMenu, sizeof(DWORD));

		//m_szFontName
		RegSetValueEx(hKey, _T("FontName"), 0, REG_SZ, (LPBYTE)m_szFontName, ((wcslen(m_szFontName)+1) * sizeof(TCHAR)));

		//m_szNetworkPath
		RegSetValueEx(hKey, _T("NetworkPath"), 0, REG_SZ, (LPBYTE)m_szNetworkPath, ((wcslen(m_szNetworkPath)+1) * sizeof(TCHAR)));

		//m_szSendAppPath
		RegSetValueEx(hKey, _T("SendAppPath"), 0, REG_SZ, (LPBYTE)m_szSendAppPath, ((wcslen(m_szSendAppPath)+1) * sizeof(TCHAR)));

		RegCloseKey(hKey);
	}
//MOD END
}

///////////////////////////////////////////////////////////////
void CMainWnd::GetSettings()
{
//MOD START GORIPON
	HKEY hKey;
	DWORD dwDisposition;

	//L[l擾
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS,
				0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;
		BYTE bData[MAX_PATH*2];

		//m_nTreeViewWidth
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidth"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidth = m_nTreeViewWidthL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidthP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidth = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidthL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidthL = dwValue;

		//m_nTreeViewHeight
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeight"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeight = m_nTreeViewHeightL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeightP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeight = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeightL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeightL = dwValue;

		//m_bShowStatusWnd
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowStatusWnd"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bShowStatusWnd = dwValue;

		//m_bShowFolder
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bShowFolder = dwValue;

		//m_bViewSide/m_bViewSideL
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSide"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSide = m_bViewSideL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSideP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSide = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSideL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSideL = dwValue;

		//m_bDragDrop
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("DragDrop"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bDragDrop = dwValue;

		//m_bCheckQAdd
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("CheckQAdd"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bCheckQAdd = dwValue;

		//m_bOverLapped
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("OverLapped"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bOverLapped = dwValue;

		//m_bContextMenu
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ContextMenu"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bContextMenu = dwValue;

		//m_bFontChange
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("FontChange"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bFontChange = dwValue;

		//m_nFontSize
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("FontSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nFontSize = dwValue;

		//m_NumberShortcut
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NumberShortcut"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bNumberShortcut = dwValue;

		//m_bHighRresolutionMode
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HighResolutionMode"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bHighRresolutionMode = dwValue;

		//m_bSwapMenu
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SwapMenu"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bSwapMenu = dwValue;

		//m_szFontName
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("FontName"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szFontName, bData, dwDataSize);

		//m_szNetworkPath
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("NetworkPath"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szNetworkPath, bData, dwDataSize);

		//m_szSendAppPath
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("SendAppPath"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS) {
			memcpy(&m_szSendAppPath, bData, dwDataSize);
			if(wcslen(m_szStartMenuPath)!=0)
				m_lpszStartMenu = wcsrchr(m_szStartMenuPath, _T('\\'))+1;
		}

		RegCloseKey(hKey);
	}
//MOD END
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewStatusBar()
{
	m_bShowStatusWnd = !m_bShowStatusWnd;
	::ShowWindow(m_StatusWnd.m_hWnd, m_bShowStatusWnd?SW_SHOW:SW_HIDE);

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewStatusWnd(m_bShowStatusWnd);

	//\TCY̒
	RecalcLayout();
}
//ADD START TODA
///////////////////////////////////////////////////////////////
void CMainWnd::OnViewFolder()
{
	m_bShowFolder = !m_bShowFolder;

	if (m_bShowFolder)
		::ShowWindow(m_TreeView.m_hWnd, SW_SHOW);
	else {
		::ShowWindow(m_TreeView.m_hWnd, SW_HIDE);
		SetFocus(m_ListView.m_hWnd);
	}

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewFolder(m_bShowFolder);

	//\TCY̒
	RecalcLayout();
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnViewSide()
{
	m_bViewSide = !m_bViewSide;

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewSide(m_bViewSide);		//ADD TODA

	//\TCY̒
	RecalcLayout();
}
///////////////////////////////////////////////////////////////
//ADD GORIPON
void CMainWnd::OnViewSideL()
{
	m_bViewSideL = !m_bViewSideL;

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewSide(m_bViewSideL);

	//\TCY̒
	RecalcLayout();
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnViewHighRes(BOOL bHighRes)
{
	m_bHighRresolutionMode = bHighRes;
	ListView_EnsureVisible(m_ListView.m_hWnd, 0, TRUE);
	m_ListView.OnChangeListStyle(0);
	SetFont();
	m_ListView.SetImageList();
	m_TreeView.InitImageList();
	m_TreeView.LoadFolderTree();
	OnViewUpdate();
	m_CmdBands.SetCheckViewHighRes(bHighRes);
	ListView_EnsureVisible(m_ListView.m_hWnd, 0, TRUE);
	InvalidateRect(m_hWnd, NULL, FALSE);
}
//ADD END

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewUpdate(LPCTSTR lpszPath)
{
	//c[r[XV
	m_TreeView.LoadFolderTree();
	
	//Xgr[XV
	m_ListView.OnViewUpdate(lpszPath);

	//郁j[XV
	m_ListView.InitOpenAppMenu();

	//Cɓ胁j[XV
	m_ListView.InitFavoritesMenu();

	//ʍXV
	InvalidateRect(m_hWnd, NULL, FALSE);
}

///////////////////////////////////////////////////////////////
BOOL CMainWnd::NetworkFolderCreate(BOOL bMsg)
{
	HKEY hKey = 0;
	DWORD dwDisposition;
	DWORD dwFSRoot=0;

	//ǂݍ
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Comm\\Redir"),
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
//MOD START GORIPON
		DWORD dwValue = 0;
		DWORD dwDataSize = sizeof(dwValue);
		if (RegQueryValueEx(hKey, _T("RegisterFSRoot"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			dwFSRoot = dwValue;
//MOD END
	}

	//ݒς݂̏ꍇ
	if(dwFSRoot) return TRUE;

	//bZ[W\L̏ꍇ
	if(bMsg)
	{
//MOD START GORIPON
		TCHAR szText[256];
		wcscpy(szText, GetStringTable(IDS_MSG_NETFOLDER_YESNO));
		if(IDNO==MessageBox(m_hWnd, szText, GetStringTable(IDS_TITLE_NETFOLDER), MB_YESNO|MB_ICONQUESTION))
//MOD END
			return FALSE;
	}

	//ݒ
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Comm\\Redir"),
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		BYTE lpData[MAX_PATH*2];
		dwFSRoot = 1;
		memcpy(lpData, &dwFSRoot, sizeof(DWORD));
		RegSetValueEx(hKey, _T("RegisterFSRoot"), 0, REG_DWORD, lpData, sizeof(DWORD));

		//bZ[W\L̏ꍇ
		if(bMsg)
		{
//MOD START GORIPON
			TCHAR szText[256];
			wcscpy(szText, GetStringTable(IDS_MSG_NETFOLDER_DONE));
			MessageBox(m_hWnd, szText, GetStringTable(IDS_TITLE_NETFOLDER), MB_OK|MB_ICONWARNING);
//MOD END
		}
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnNetworkDriveConnect()
{
	//lbg[NtH_`FbN
	if(!NetworkFolderCreate(TRUE)) return;

	//p[^
	NETRESOURCE nr;
	nr.dwType = RESOURCETYPE_DISK;
	nr.lpRemoteName = NULL;
	nr.lpLocalName = NULL;
	nr.lpProvider = NULL;
	CONNECTDLGSTRUCT cs;
	cs.cbStructure = sizeof(cs);
	cs.hwndOwner = m_hWnd;
	cs.lpConnRes = &nr;
	cs.dwFlags = 0;

	//lbg[Nڑ_CAO\
	DWORD dwResult;
	if(0xFFFFFFFF != (dwResult=WNetConnectionDialog1(&cs)))
	{
		//G[
		if(dwResult != WN_SUCCESS)
			MessageBox(m_hWnd, GetStringTable(IDS_MSG_NTDRIVE_CON), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
		//펞
		else
			//\XV
			OnViewUpdate();
	}
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnNetworkDriveDisconnect()
{
	//lbg[Nؒf_CAO\
	DWORD dwResult;
	if(0xFFFFFFFF != (dwResult=WNetDisconnectDialog(m_hWnd, 0)))
	{
		//G[
		if(dwResult != ERROR_SUCCESS)
			MessageBox(m_hWnd, GetStringTable(IDS_MSG_NTDRIVE_DCON), NULL, MB_OK|MB_ICONSTOP);	//MOD GORIPON
		//펞
		else
		{
			TCHAR szPath[MAX_PATH];
			wcscpy(szPath, m_ListView.m_szCurrentFolder);

			//\tÕfBNgȂꍇAʃfBNgֈړ
			while(GetFileAttributes(szPath) == 0xFFFFFFFF) {
				LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
				if(lpszTemp) *lpszTemp = 0;
			} // End of while

			//\XV
			OnViewUpdate(szPath);
		}
	}
}
//ADD END
///////////////////////////////////////////////////////////////
void CMainWnd::OnToolPclink()
{
	SHELLEXECUTEINFO sei;
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	sei.fMask = 0;
	sei.hwnd = m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = _T("repllog.exe");
	sei.lpParameters = NULL;
	sei.lpDirectory = m_szWindowsPath;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;
	ShellExecuteEx(&sei);
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnToolActivesync() 
{
	SHELLEXECUTEINFO sei;
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	sei.fMask = 0;
	sei.hwnd = m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = _T("async.asy");
	sei.lpParameters = NULL;
	sei.lpDirectory = m_szWindowsPath;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;
	ShellExecuteEx(&sei);
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnToolIRRecive()
{
	//MOD START TODA (from GSFinder ver.1.99)
	SHELLEXECUTEINFO sei;
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	sei.fMask = 0;
	sei.hwnd = this->m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpParameters = NULL;
	sei.lpDirectory = m_szWindowsPath;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;

	if (GetFileAttributes(_T("\\Windows\\beam.exe")) != 0xFFFFFFFF)
		sei.lpFile = _T("beam.exe");
	else 
		sei.lpFile = _T("irsquirt.exe");

	ShellExecuteEx(&sei);
	//MOD END
}
///////////////////////////////////////////////////////////////
void CMainWnd::SaveModulePath()
{
	TCHAR szPath[MAX_PATH];
	GetModuleFileName(g_hInst, szPath, MAX_PATH);
	HKEY hKey = 0;
	DWORD dwDisposition;
	//MOD START TODA (from GSFiner ver.1.99)
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_GSF, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	//MOD END
	{
		BYTE lpData[MAX_PATH*2];
		memcpy(lpData, &szPath, sizeof(szPath));
		RegSetValueEx(hKey, _T("Path"), 0, REG_SZ, lpData, sizeof(szPath));

		RegCloseKey(hKey);
	}
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnActivate(int nActive)
{
	if (nActive == WA_INACTIVE)	{
		m_hwndPrev = GetFocus();
		m_dwLastSipInfo = GetIMStatus();	//DEL GORIPON
		SaveInputMode();					//ADD GORIPON
		SetInputMode(INPUTMODE_ZEN_HIRAGANA);
	}
	else if (nActive == WA_ACTIVE) {
		SetFocus(m_hwndPrev);
		//DEL START TODA (from GSFiner ver.1.99)
		//DWORD dwStatus = GetIMStatus();
		//if (m_dwLastSipInfo != dwStatus)
		//DEL END
		RecalcLayout();
		RestoreInputMode();					//ADD GORIPON
	}
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnSettingChange(int nFlag)
{
    if (nFlag == SPI_SETSIPINFO)
		RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CMainWnd::RecalcLayout()
{
	SIPINFO si;
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	if (SIPGETINFO(&si)) {	//MOD GORIPON
		if (si.fdwFlags & SIPF_ON) {
			OnSize(RECT_WIDTH(&si.rcVisibleDesktop), RECT_HEIGHT(&si.rcVisibleDesktop));

			//IĂ̂悤ɂ
			for (int i = 0; i < ListView_GetItemCount(m_ListView.m_hWnd); i++)
			{
				if (ListView_GetItemState(m_ListView.m_hWnd, i, LVIS_FOCUSED) == LVIS_FOCUSED)
				{
					ListView_EnsureVisible(m_ListView.m_hWnd, i, FALSE);
					break;
				}
			}
		}
		else
		{
			//ADD START TODA (j[̍𓮓IɎ擾)
			DWORD y = GetSystemMetrics(SM_CYMENU) + 3;
			//ADD END
			OnSize(RECT_WIDTH(&si.rcVisibleDesktop), RECT_HEIGHT(&si.rcVisibleDesktop) - (int)(y * m_fpHighResolutionScale));	//MOD GORIPON (nC]Ή)
		}
	}
	m_dwLastSipInfo = si.fdwFlags;
//ADD START GORIPON
	m_bLandscapeMode = GetSystemMetrics(SM_CYSCREEN)<GetSystemMetrics(SM_CXSCREEN);
	m_CmdBands.SetCheckViewSide(m_bLandscapeMode?m_bViewSideL:m_bViewSide);
//ADD END
}

//ADD START TODA
///////////////////////////////////////////////////////////////
void CMainWnd::RecalcBarLayout(WPARAM wParam, LPARAM lParam)
{
	//R}ho[̃TCY
	if(m_CmdBands.m_Settings.bShowToolBar ||
	   m_CmdBands.m_Settings.bShowAddressBar)
		SendMessage(m_CmdBands.m_hWnd, WM_SIZE, wParam, lParam);
	//Xe[^Xo[̃TCY
	if(m_bShowStatusWnd) {
		SendMessage(m_StatusWnd.m_hWnd, WM_SIZE, wParam, lParam);
		m_StatusWnd.OnSize(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));	//MOD GORIPON
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnMouseMove(LPARAM lParam, int nStartPos, int nLastWidth, int nLastHeight)
{
	//MOD START TODA (ړ͈͐ݒ from Y.Nagamidori)
	if(m_bLandscapeMode?m_bViewSideL:m_bViewSide)	//MOD GORIPON
	{
		int x = GET_X_LPARAM(lParam);	//MOD GORIPON

		//ړ͈͐ݒ(/)
		int min = 20;
		int max = GetSystemMetrics(SM_CXSCREEN) - 20;

		//ړ͈̓`FbN
		if (x > min && x < max)
		{
//MOD START GORIPON
			int ntvw = nLastWidth + (x - nStartPos);
			if (m_bLandscapeMode)
				m_nTreeViewWidthL = ntvw;
			else
				m_nTreeViewWidth = ntvw;
//MOD END
			RecalcLayout();
		}
	}
	else
	{
		int y = GET_Y_LPARAM(lParam);	//MOD GORIPON

		//c[r[̍W擾()
		RECT rc;
		POINT pt;
		GetWindowRect(m_TreeView.m_hWnd, &rc);
		pt.x = rc.right;
		pt.y = rc.top;
		ScreenToClient(m_hWnd, &pt);
		int min = pt.y + 20;

		//Xgr[̍W擾()
		GetWindowRect(m_ListView.m_hWnd, &rc);
		pt.x = rc.right;
		pt.y = rc.bottom;
		ScreenToClient(m_hWnd, &pt);
		int max = pt.y - 20;

		//ړ͈̓`FbN
		if (y > min && y < max)
		{
//MOD START GORIPON
			int ntvh = nLastHeight + (y - nStartPos);
			if (m_bLandscapeMode)
				m_nTreeViewHeightL = ntvh;
			else
				m_nTreeViewHeight = ntvh;
//MOD END
			RecalcLayout();
		}
	}
	//MOD END
}
///////////////////////////////////////////////////////////////
//ADD END

//ADD START TODA
///////////////////////////////////////////////////////////////
HIMAGELIST CMainWnd::ListViewImageCreate(LPNMLISTVIEW lpNMLV)
{
	HWND hList = m_ListView.m_hWnd;

	//C[WXg쐬
	POINT ptImg;
	HIMAGELIST hDrag = ListView_CreateDragImage(hList, lpNMLV->iItem, &ptImg);

	//hbOJn
	if(ImageList_BeginDrag(hDrag, 0, 0, 0))
	{
		ImageList_DragEnter(NULL, lpNMLV->ptAction.x, lpNMLV->ptAction.y);
		return hDrag;
	}

	//G[
	return 0;
}

///////////////////////////////////////////////////////////////
HIMAGELIST CMainWnd::TreeViewImageCreate(LPNMTREEVIEW lpNMTV)
{
	HWND hTree = m_TreeView.m_hWnd;

	//C[WXg쐬
	HIMAGELIST hDrag = TreeView_CreateDragImage(hTree, lpNMTV->itemNew.hItem);

	//hbOJn
	if(ImageList_BeginDrag(hDrag, 0, 0, 0))
	{
		ClientToScreen(hTree, &(lpNMTV->ptDrag));
		ImageList_DragEnter(NULL, lpNMTV->ptDrag.x, lpNMTV->ptDrag.y);
		return hDrag;
	}

	//G[
	return 0;
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageLeave()
{
	//ړÕC[WXgj
	ImageList_DragLeave(NULL);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageMove(POINT ptWnd)
{
	//C[WXgړʒu֕`
	ClientToScreen(m_hWnd, &ptWnd);
	ImageList_DragMove(ptWnd.x, ptWnd.y);
	ImageList_DragEnter(NULL, ptWnd.x, ptWnd.y);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageDestory(HIMAGELIST hDrag)
{
	//C[WXgj
	ImageList_DragLeave(NULL);
	ImageList_EndDrag();
	ImageList_Destroy(hDrag);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnBeginDrag(NMHDR* lpNMH)
{
	m_hDragWnd = lpNMH->hwndFrom;

	//}EXLv`Jn
	SetCapture(m_hWnd);

	//Xgr[̃hbOhbvs
	if(!m_bDragDrop && m_hDragWnd == m_ListView.m_hWnd)
	{
		if(!m_ListView.m_nSelectItem)
		{
			m_ListView.m_nSelectStart = ((LPNMLISTVIEW)lpNMH)->iItem;
			m_bSelectFlg = TRUE;
			return;
		}
	}
	m_bSelectFlg = FALSE;

	//hbÕC[WXg쐬
	if(m_hDragWnd == m_ListView.m_hWnd) {
		m_hDragImg = ListViewImageCreate((LPNMLISTVIEW)lpNMH);
	}
	else
	if(m_hDragWnd == m_TreeView.m_hWnd) {
		LPNMTREEVIEW lpnmv = (LPNMTREEVIEW)lpNMH;
		m_hDragImg = TreeViewImageCreate(lpnmv);
		m_hDragTree = lpnmv->itemNew.hItem;
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnMouseMove(POINT ptWnd)
{
	//hbOhbvs
	if(m_bSelectFlg)
	{
		m_ListView.OnMouseMoveArea(ptWnd);
		return;
	}

	//ÕC[WXg\폜
	ImageLeave();
	
	//hbÕtH[JX
	m_ListView.OnMouseMove(ptWnd);
	m_TreeView.OnMouseMove(ptWnd);

	//̍WŃC[WXg\
	ImageMove(ptWnd);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnLButtopUp()
{
	//}EXLv`I
	ReleaseCapture();

	//hbOhbvs
	if(m_bSelectFlg) return;

	//C[WXg폜
	ImageDestory(m_hDragImg);

	//hbv̏
	if(!m_TreeView.OnLButtonUp(m_hDragWnd)) {
		m_TreeView.OnDropCansel();
	} else {
		return;
	}
	if(!m_ListView.OnLButtonUp(m_hDragWnd)) {
		m_ListView.OnDropCansel();
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDropCansel()
{
	//}EXLv`I
	ReleaseCapture();

	//hbOhbvs
	if(m_bSelectFlg) return;

	//C[WXg폜
	ImageDestory(m_hDragImg);

	//hbOACẽLZ
	m_ListView.OnDropCansel();
	m_TreeView.OnDropCansel();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnSetFocus(HWND hWnd)
{
	static HWND hfcsWnd = 0;
	
	//tH[JXEBhEςꍇ̂
//	if(hWnd != hfcsWnd) {
		if (hWnd == m_TreeView.m_hWnd)
			m_TreeView.OnSetFocus();
		else
			m_ListView.OnSetFocus();

		//Vnhۑ
		hfcsWnd = hWnd;
//	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDeviceChange(BOOL bDevice, BOOL bStart)
{
	static BOOL bNoUpdate = FALSE;

	if(bStart)
	{
		KillTimer(m_hWnd, ID_TIMER_DEVICECHANGE);
		SetTimer(m_hWnd, ID_TIMER_DEVICECHANGE, TIMER_DEVICECHANGE_INT, NULL);	//MOD GORIPON
		if(bDevice) bNoUpdate = TRUE;
	}
	else
	{
		KillTimer(m_hWnd, ID_TIMER_DEVICECHANGE);

		//c[r[̍XV([gẑ)
		m_TreeView.SetCurrentFolder(_T(""), TRUE, FALSE);

		//Xgr[̍XV
		TCHAR szPath[MAX_PATH];
		wcscpy(szPath, m_ListView.m_szCurrentFolder);

		//XVtOOFFyуpXȂꍇ
		if(!bNoUpdate || GetFileAttributes(szPath) == 0xFFFFFFFF)
		{
			//\tÕfBNgȂꍇAʃfBNgֈړ
			while(GetFileAttributes(szPath) == 0xFFFFFFFF) {
				LPTSTR lpszTemp = wcsrchr(szPath, _T('\\'));
				if(lpszTemp)
					*lpszTemp = 0;
				else
					break;
			} // End of while

			//Xgr[̍XV([gֈړ)
			m_ListView.LoadFolderItem(szPath);
		}
		else
		//[g̏ꍇ
		if(!wcslen(szPath) || wcsicmp(szPath, GetRootName()) == 0)
		{
			//Xgr[̍XV
			m_ListView.LoadFolderItem(_T(""));
		}

		bNoUpdate = FALSE;
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnBeginLabelEdit()
{
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnEndLabelEdit()
{
}

///////////////////////////////////////////////////////////////
void CMainWnd::SetFont()
{
//MOD START GORIPON (nC]Ή)
	int nHeight,nFontSize;
	HDC hDC;
	TEXTMETRIC tm;

	if (m_hFontFix)
	{
		if (m_hFontFix != m_hFont)
			DeleteObject(m_hFontFix);
		m_hFontFix = NULL;
	}
	if(m_hFont)
	{
		DeleteObject(m_hFont);
		m_hFont = NULL;
	}

	if(!m_bFontChange)
	{
		m_hFont = m_hFontFix = (HFONT)::GetStockObject(SYSTEM_FONT);
		if (m_bHighRresolutionMode && m_bHighDpiHardware)
		{
			hDC = GetDC(m_hWnd);
			GetTextMetrics(hDC, &tm);
			nHeight = (int)((float)tm.tmHeight / m_fpHighResolutionScale);
			ReleaseDC(m_hWnd, hDC);
			m_hFont = MyCreateFont(nHeight, 0, NULL);
		}
	}
	else
	{
		hDC = GetDC(m_hWnd);
		GetTextMetrics(hDC, &tm);
		nFontSize = (m_bHighRresolutionMode && m_bHighDpiHardware)? (int)((float)m_nFontSize / m_fpHighResolutionScale): m_nFontSize;
		nHeight = (nFontSize * GetDeviceCaps(hDC, LOGPIXELSY)) / 72;
		ReleaseDC(m_hWnd, hDC);
		m_hFont = MyCreateFont(nHeight, DEFAULT_CHARSET, m_szFontName);
		m_hFontFix = MyCreateFont(tm.tmHeight, DEFAULT_CHARSET, m_szFontName);
	}

	SendMessage(m_ListView.m_hWnd, WM_SETFONT, (WPARAM)m_hFont, MAKELPARAM(TRUE, 0));
	SendMessage(m_TreeView.m_hWnd, WM_SETFONT, (WPARAM)m_hFont, MAKELPARAM(TRUE, 0));
	SendMessage(m_StatusWnd.m_hWnd, WM_SETFONT, (WPARAM)m_hFontFix, MAKELPARAM(TRUE, 0));
	SendMessage(m_CmdBands.m_hComboBox, WM_SETFONT, (WPARAM)m_hFontFix, MAKELPARAM(TRUE, 0));

	InvalidateRect(m_hWnd, NULL, FALSE);
//MOD END
}
//ADD END
//ADD START GORIPON
///////////////////////////////////////////////////////////////
void CMainWnd::SetInputMode(int Mode)
{
	HKEY hKeyPs;
	DWORD dwValue;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY_PHONESTAT, 0, KEY_ALL_ACCESS, &hKeyPs) == ERROR_SUCCESS)
	{
		dwValue = Mode;
		RegSetValueEx(hKeyPs, _T("Status22"), 0, REG_DWORD, (LPBYTE)&dwValue, sizeof(DWORD));
		RegCloseKey(hKeyPs);
	}
}
///////////////////////////////////////////////////////////////
DWORD CMainWnd::GetInputMode()
{
	HKEY hKeyPs;
	DWORD dwSize, dwValue;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY_PHONESTAT, 0, KEY_ALL_ACCESS, &hKeyPs) == ERROR_SUCCESS)
	{
		dwSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKeyPs, _T("Status22"), NULL, NULL, (LPBYTE)&dwValue, &dwSize) != ERROR_SUCCESS)
			dwValue = INPUTMODE_HAN_NUMERIC;	//ERROR
		RegCloseKey(hKeyPs);
		return dwValue;
	}
	return INPUTMODE_HAN_NUMERIC;	//ERROR
}
///////////////////////////////////////////////////////////////
void CMainWnd::SaveInputMode()
{
	m_dwInputMode = GetInputMode();
}
///////////////////////////////////////////////////////////////
void CMainWnd::RestoreInputMode()
{
	SetInputMode(m_dwInputMode);
}
//ADD END