#include "GSFinder.h"
#include "StatusWnd.h"

/*///////////////////////////////////////////////////////////////
CStatusWnd::CStatusWnd()
{
}

///////////////////////////////////////////////////////////////
CStatusWnd::~CStatusWnd()
{
}*/

///////////////////////////////////////////////////////////////
void CStatusWnd::Init(HWND hwndParent)
{
//MOD START GORIPON
	DWORD dwStyle = WS_CHILD | WS_VISIBLE | CCS_NOPARENTALIGN;
//MOD END
	m_hWnd = CreateStatusWindow(dwStyle, _T(""), hwndParent, 0);

	//ɕ
	RECT rct;
	GetWindowRect(m_hWnd, &rct);

	MoveWindow(m_hWnd, 0, 0, GetSystemMetrics(SM_CXSCREEN), rct.bottom - rct.top, TRUE);

	int nWidth[2];
	nWidth[0] = (rct.right-rct.left)/2;
	nWidth[1] = rct.right-rct.left;
	SendMessage(m_hWnd, SB_SETPARTS, 2, (LPARAM)nWidth);
}

///////////////////////////////////////////////////////////////
void CStatusWnd::ShowStatusWnd(BOOL fShow)
{
	ShowWindow(m_hWnd, fShow?SW_SHOW:SW_HIDE);
}

///////////////////////////////////////////////////////////////
void CStatusWnd::Destroy()
{
	//DestroyWindow(m_hWnd);	//DEL GORIPON (eEChEDestroyWindowőp)
}

///////////////////////////////////////////////////////////////
void CStatusWnd::SetSimpleText(LPCTSTR lpszText)
{
	//
	RECT rct;
	GetWindowRect(m_hWnd, &rct);
	int nWidth;
	nWidth = rct.right-rct.left;
	SendMessage(m_hWnd, SB_SETPARTS, 1, (LPARAM)&nWidth);

	//eLXg\
	SendMessage(m_hWnd, SB_SETTEXT, 0, (LPARAM)lpszText);
	UpdateWindow(m_hWnd);
}
///////////////////////////////////////////////////////////////
void CStatusWnd::SetTwoPaneText(LPCTSTR lpszText1, LPCTSTR lpszText2)
{
	//
	RECT rct;
	GetWindowRect(m_hWnd, &rct);
	int nWidth[2];
	nWidth[0] = (rct.right-rct.left)/2;
	nWidth[1] = rct.right-rct.left;
	SendMessage(m_hWnd, SB_SETPARTS, sizeof(nWidth)/sizeof(int), (LPARAM)nWidth);

	//eLXg\
	SendMessage(m_hWnd, SB_SETTEXT, 0, (LPARAM)lpszText1);
	SendMessage(m_hWnd, SB_SETTEXT, 1, (LPARAM)lpszText2);
	UpdateWindow(m_hWnd);
}
///////////////////////////////////////////////////////////////
void CStatusWnd::SetThreePaneText(LPCTSTR lpszText1, LPCTSTR lpszText2, LPCTSTR lpszText3)
{
	//
	RECT rct;
	GetWindowRect(m_hWnd, &rct);
	int nWidth[3];
	nWidth[0] = (rct.right-rct.left)/2;
	nWidth[1] = ((rct.right-rct.left)*3)/4;
	nWidth[2] = rct.right-rct.left;
	SendMessage(m_hWnd, SB_SETPARTS, sizeof(nWidth)/sizeof(int), (LPARAM)nWidth);

	//eLXg\
	SendMessage(m_hWnd, SB_SETTEXT, 0, (LPARAM)lpszText1);
	SendMessage(m_hWnd, SB_SETTEXT, 1, (LPARAM)lpszText2);
	SendMessage(m_hWnd, SB_SETTEXT, 2, (LPARAM)lpszText3);
	UpdateWindow(m_hWnd);
}
//ADD START TODA
///////////////////////////////////////////////////////////////
void CStatusWnd::OnSize(int nWidth, int Height) {
	//擾
	int parts = SendMessage(m_hWnd, SB_GETPARTS, 0, 0);
	
	//TCYvZ
	int aWidths[3];
	switch(parts) {
	case 1:
		aWidths[0] = nWidth;
		break;
	case 2:
		aWidths[0] = nWidth/2;
		aWidths[1] = nWidth;
		break;
	case 3:
		aWidths[0] = nWidth/2;
		aWidths[1] = (nWidth*3)/4;
		aWidths[2] = nWidth;
		break;
	}

	//TCYĐݒ
	SendMessage(m_hWnd, SB_SETPARTS, parts, (LPARAM)aWidths);
}
//ADD END
///////////////////////////////////////////////////////////////