///////////////////////////////////////////////////////////////
//FileImageList.cpp
//t@C̃ACRǗ

#include "GSFinder.h"
#include "FileImageList.h"


///////////////////////////////////////////////////////////////
int MyAddResizeSpIcon(HIMAGELIST, HWND, HICON, BOOL);

///////////////////////////////////////////////////////////////
CFileImageList::CFileImageList()
{
	m_hImageList = NULL;
	m_bLargeIcon = FALSE;
}

///////////////////////////////////////////////////////////////
CFileImageList::~CFileImageList()
{
}

///////////////////////////////////////////////////////////////
//MOD START GORIPON (nC]Ή)
void CFileImageList::InitImageList(BOOL bLarge)
{
	//C[WXg̏
	if (m_hImageList) Destroy();

	HICON hIcon;
	if (g_MainWnd.m_bHighDpiHardware)
	{
		if (!bLarge)
		{
			if (g_MainWnd.m_bHighRresolutionMode)
			{
				m_hImageList = ImageList_Create((int)((float)GetSystemMetrics(SM_CXSMICON)/g_MainWnd.m_fpHighResolutionScale), (int)((float)GetSystemMetrics(SM_CYSMICON)/g_MainWnd.m_fpHighResolutionScale), ILC_COLOR | ILC_MASK, 3, 3);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_S);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
			}
			else
			{
				m_hImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), ILC_COLOR | ILC_MASK, 3, 3);
#if !defined(PPCONLY)
				if (g_MainWnd.m_bIsSmartphone && !g_MainWnd.m_bDisableResizeSpIcon)
				{
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_M);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, FALSE);
					DestroyIcon(hIcon);
				}
				else
#endif
				{
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_M);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
				}
			}
			m_bLargeIcon = FALSE;
		}
		else
		{
			if (g_MainWnd.m_bHighRresolutionMode)
			{
				m_hImageList = ImageList_Create((int)((float)GetSystemMetrics(SM_CXICON)/g_MainWnd.m_fpHighResolutionScale), (int)((float)GetSystemMetrics(SM_CYICON)/g_MainWnd.m_fpHighResolutionScale), ILC_COLOR | ILC_MASK, 3, 3);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
				hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_M);
				ImageList_AddIcon(m_hImageList, hIcon);
				DestroyIcon(hIcon);
			}
			else
			{
				m_hImageList = ImageList_Create(GetSystemMetrics(SM_CXICON), GetSystemMetrics(SM_CYICON), ILC_COLOR | ILC_MASK, 3, 3);
#if !defined(PPCONLY)
				if (g_MainWnd.m_bIsSmartphone && !g_MainWnd.m_bDisableResizeSpIcon)
				{
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_L);
					MyAddResizeSpIcon(m_hImageList, g_MainWnd.m_hWnd, hIcon, TRUE);
					DestroyIcon(hIcon);
				}
				else
#endif
				{
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
					hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_L);
					ImageList_AddIcon(m_hImageList, hIcon);
					DestroyIcon(hIcon);
				}
			}
			m_bLargeIcon = TRUE;
		}
	}
	else
	{
		if (!bLarge)
		{
			m_hImageList = ImageList_Create(GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), ILC_COLOR | ILC_MASK, 3, 3);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_S);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			m_bLargeIcon = FALSE;
		}
		else
		{
			m_hImageList = ImageList_Create(GetSystemMetrics(SM_CXICON), GetSystemMetrics(SM_CYICON), ILC_COLOR | ILC_MASK, 3, 3);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FOLDER_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_TEMP_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_MYDOCUMENTS_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_START_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_FILE_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_ROM_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_NETFOLDER_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			hIcon = LoadIcon(g_hInst, (LPCTSTR)IDI_COMPRESS_M);
			ImageList_AddIcon(m_hImageList, hIcon);
			DestroyIcon(hIcon);
			m_bLargeIcon = TRUE;
		}
	}
}
//MOD END

///////////////////////////////////////////////////////////////
void CFileImageList::Destroy()
{
	while (!m_IndexBuff.IsEmpty())
	{
		IMAGELISTINDEX* pIndex = (IMAGELISTINDEX*)m_IndexBuff.RemoveAt(0);
		if (pIndex != NULL)
			delete pIndex;
	}
	ImageList_RemoveAll(m_hImageList);
	ImageList_Destroy(m_hImageList);
	m_hImageList = NULL;	//ADD GORIPON
}

///////////////////////////////////////////////////////////////
BOOL SeekIndexCallback(LPARAM lParamItem, LPARAM lParamFind)
{
	IMAGELISTINDEX* pIndex = (IMAGELISTINDEX*)lParamItem;
	LPTSTR pszExt = (LPTSTR)lParamFind;
	if (wcsicmp(pszExt, pIndex->szExt)==0)
		return FALSE;
	else
		return TRUE;
}

//MOD START GORIPON
///////////////////////////////////////////////////////////////
int MyAddIcon(HIMAGELIST hImageList, HWND hWnd, HICON hIcon, BOOL bLarge)
{
	int ix = GetSystemMetrics(bLarge?SM_CXICON:SM_CXSMICON);
	int iy = GetSystemMetrics(bLarge?SM_CYICON:SM_CYSMICON);
	int ixs = (int)((float)ix / g_MainWnd.m_fpHighResolutionScale + 0.5);
	int iys = (int)((float)iy / g_MainWnd.m_fpHighResolutionScale + 0.5);
	HDC hDC = GetDC(hWnd);
	HDC hMemDC = CreateCompatibleDC(hDC);
	HDC hMemDC2 = CreateCompatibleDC(hDC);
	HBITMAP hBitmap = CreateCompatibleBitmap(hDC, ixs, iys);
	HBITMAP hBitmap2 = CreateCompatibleBitmap(hDC, ix, iy);
	ReleaseDC(hWnd, hDC);

	SelectObject(hMemDC, hBitmap);
	SelectObject(hMemDC2, hBitmap2);
	BitBlt(hMemDC2, 0, 0, ix, iy, NULL, 0, 0, WHITENESS);
	DrawIcon(hMemDC2, 0, 0, hIcon);
	StretchBlt(hMemDC, 0, 0, ixs, iys, hMemDC2, 0, 0, ix, iy, SRCCOPY);

	DeleteDC(hMemDC);
	DeleteDC(hMemDC2);

	int nIndex = ImageList_AddMasked(hImageList, hBitmap, RGB(255, 0, 255));	//Ȃ悤_~[̃}[^w

	DeleteObject(hBitmap);
	DeleteObject(hBitmap2);

	return nIndex;
}
//MOD END

//ADD START GORIPON
///////////////////////////////////////////////////////////////
int MyAddResizeSpIcon(HIMAGELIST hImageList, HWND hWnd, HICON hIcon, BOOL bLarge)
{
	int ix = bLarge?64:32;
	int iy = bLarge?64:32;
	int ixs = GetSystemMetrics(bLarge?SM_CXICON:SM_CXSMICON);
	int iys = GetSystemMetrics(bLarge?SM_CYICON:SM_CYSMICON);
	HDC hDC = GetDC(hWnd);
	HDC hMemDC = CreateCompatibleDC(hDC);
	HDC hMemDC2 = CreateCompatibleDC(hDC);
	HBITMAP hBitmap = CreateCompatibleBitmap(hDC, ixs, iys);
	HBITMAP hBitmap2 = CreateCompatibleBitmap(hDC, ix, iy);
	ReleaseDC(hWnd, hDC);

	SelectObject(hMemDC, hBitmap);
	SelectObject(hMemDC2, hBitmap2);
	BitBlt(hMemDC2, 0, 0, ix, iy, NULL, 0, 0, WHITENESS);
	DrawIcon(hMemDC2, 0, 0, hIcon);
	StretchBlt(hMemDC, 0, 0, ixs, iys, hMemDC2, 0, 0, ix, iy, SRCCOPY);

	DeleteDC(hMemDC);
	DeleteDC(hMemDC2);

	int nIndex = ImageList_AddMasked(hImageList, hBitmap, RGB(255, 0, 255));	//Ȃ悤_~[̃}[^w

	DeleteObject(hBitmap);
	DeleteObject(hBitmap2);

	return nIndex;
}
//ADD END

///////////////////////////////////////////////////////////////
int CFileImageList::GetImageListIndex(LPCTSTR lpszFileName, LPCTSTR lpszPath, DWORD dwAttr)
{
	TCHAR szExt[MAX_PATH];
	int nIndex;

	if (dwAttr == 0)
		return 0;

	if (FILE_ATTRIBUTE_DIRECTORY == (dwAttr & FILE_ATTRIBUTE_DIRECTORY)) {
		//MOD TODA
//		if (wcsicmp(lpszFileName, _T("My Documents")) == 0)
		if (wcsicmp(lpszFileName, g_MainWnd.m_lpszMyDocument) == 0)
			return 2;

		//ADD START TODA (from GSFinder ver.1.99)
		if (wcsicmp(lpszFileName, g_MainWnd.m_lpszStartMenu) == 0)
			return 3;
		//ADD END

		//ADD START TODA
		if (wcsicmp(lpszFileName, g_MainWnd.m_lpszNetwork) == 0)
			return 6;
		//ADD END

		return (dwAttr & FILE_ATTRIBUTE_TEMPORARY) ? 1 : 0;
	}
	
	if (g_MainWnd.m_ListView.m_ImageListSettings.bNotLoadROMIcon)
	{
		if (dwAttr & FILE_ATTRIBUTE_INROM)
			return 5;
	}

	//t@C̃ACRǂݍ܂Ȃ
	if (g_MainWnd.m_ListView.m_ImageListSettings.bNotLoadFileIcon)
		return 4;

	LPTSTR lpszExt = wcsrchr(lpszFileName, _T('.'));
	if (lpszExt == NULL)
		wcscpy(szExt, _T("\\\\\\"));
	else if (wcsicmp(lpszExt, _T(".EXE")) == 0 || wcsicmp(lpszExt, _T(".LNK")) == 0)
		wsprintf(szExt, _T("%s\\%s"), lpszPath, lpszFileName);
	//ADD START TODA (kt@CΉ)
	else if(wcsicmp(lpszExt, _T(".LZH")) == 0 || wcsicmp(lpszExt, _T(".ZIP")) == 0)
	{
		if(g_MainWnd.m_ListView.m_ImageListSettings.bNotLoadCompIcon)
			return 7;
		
		if(g_MainWnd.m_ListView.m_Settings.bDblClick)
		{
			if(g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_LHA) && wcsicmp(lpszExt, _T(".LZH")) == 0)
				return 7;
			if(g_MainWnd.m_Compress.IsCompress(COMPDLL_MODE_ZIP) && wcsicmp(lpszExt, _T(".ZIP")) == 0)
				return 7;
		}
		wcscpy(szExt, lpszExt);
	}
	//ADD END
	else
		wcscpy(szExt, lpszExt);

	//ADD START TODA (from Y.Nagamidori)
	// lbg[NtH_̏ꍇ
	if (lpszExt && wcsicmp(lpszExt, _T(".LNK")) == 0) {
		TCHAR szTarget[MAX_PATH];
		SHGetShortcutTarget(szExt, szTarget, MAX_PATH);
		LPTSTR p = szTarget;
		if (*p == _T('\"')) p++;
		if (*p == _T('\\') && *(p + 1) == _T('\\') && !wcschr(p + 2, _T('\\')))
			return 6;
	}
	//ADD END

	//CfbNX̌
	nIndex = m_IndexBuff.Find(SeekIndexCallback, 0, (DWORD)szExt);
	if (nIndex >= 0)
	{
		IMAGELISTINDEX* pRet = (IMAGELISTINDEX*)m_IndexBuff.GetAt(nIndex);
		return pRet->nIndex;
	}

	//ADD START TODA
	//hbO̓ACRo^͂Ȃ(ACRߏԂ̈)
	if(g_bDraging) return 4;
	//ADD END

	TCHAR szFileName[MAX_PATH];
	SHFILEINFO shfi;
	wsprintf(szFileName, _T("%s\\%s"), lpszPath, lpszFileName);

//ADD START GORIPON (nC]Ή)
	if (g_MainWnd.m_bHighRresolutionMode && g_MainWnd.m_bHighDpiHardware)
	{
		SHGetFileInfo(szFileName, NULL, &shfi, sizeof(shfi), m_bLargeIcon?SHGFI_LARGEICON|SHGFI_ICON:SHGFI_SMALLICON|SHGFI_ICON);
		nIndex = MyAddIcon(m_hImageList, g_MainWnd.m_ListView.m_hWnd, shfi.hIcon, m_bLargeIcon);
	}
	else
//ADD END
	{
		SHGetFileInfo(szFileName, NULL, &shfi, sizeof(shfi), m_bLargeIcon?SHGFI_LARGEICON|SHGFI_ICON:SHGFI_SMALLICON|SHGFI_ICON);
		nIndex = ImageList_AddIcon(m_hImageList, shfi.hIcon);
	}
	if (nIndex == -1)
		return 4;	//MOD GORIPON

	//ADD START TODA
	DestroyIcon(shfi.hIcon);
	//ADD END

	IMAGELISTINDEX* pIndex = new IMAGELISTINDEX;
	memset(pIndex, 0, sizeof(IMAGELISTINDEX));
	pIndex->nIndex = nIndex;
	wcscpy(pIndex->szExt, szExt);
	m_IndexBuff.Insert((DWORD)pIndex);
	return nIndex;
}

///////////////////////////////////////////////////////////////
void CFileImageList::RefreshIcon(LPCTSTR lpszPath)
{
	if (g_MainWnd.m_ListView.m_ImageListSettings.bNotLoadFileIcon) return;

	TCHAR szFileName[MAX_PATH] = _T("");
	TCHAR szParent[MAX_PATH] = _T("");

	LPTSTR lpszTemp = wcsrchr(lpszPath, _T('\\'));
	if (lpszTemp)
		wcsncpy(szParent, lpszPath, lpszTemp-lpszPath);
	else
		wcscpy(szParent, _T(""));

	lpszTemp = wcsrchr(lpszPath, _T('\\'));
	if (lpszTemp)
		wcscpy(szFileName, ++lpszTemp);
	else
		wcscpy(szFileName, lpszPath);

	int nIndex = GetImageListIndex(szFileName, szParent, GetFileAttributes(szFileName));
	
	if (nIndex <= 7)	//MOD TODA (5 -> 7)
		return;

	SHFILEINFO shfi;
	SHGetFileInfo(lpszPath, NULL, &shfi, sizeof(shfi), m_bLargeIcon?SHGFI_LARGEICON | SHGFI_ICON:SHGFI_SMALLICON | SHGFI_ICON);
	ImageList_ReplaceIcon(m_hImageList, nIndex, shfi.hIcon);
}
///////////////////////////////////////////////////////////////