///////////////////////////////////////////////////////////////
//MainWnd.cpp
//CEChE - CMainWnd

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "MainWnd.h"

///////////////////////////////////////////////////////////////
//EBhE NX̓o^
ATOM CMainWnd::MainWndRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC) MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= NULL;
	wc.hCursor			= 0;
	wc.hbrBackground	= CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
	wc.lpszMenuName		= 0;
	wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}

///////////////////////////////////////////////////////////////
CMainWnd::CMainWnd()
{
	m_bControlKey = FALSE;
	m_bShiftKey = FALSE;

	m_bShowStatusWnd = TRUE;
	m_bContextMenu = FALSE;
	m_bFontChange = FALSE;
	m_bDragDrop = TRUE;
	m_nFontSize = 12;
	m_szFontName[0] = _T('\0');

	m_szSendAppPath[0] = _T('\0');
	m_szShellNewPath[0] = _T('\0');
	m_bCheckQAdd = TRUE;
	m_bSendMulti = FALSE;

	m_bShowFolder		= FALSE;
	m_nTreeViewWidthP	= 100;
	m_nTreeViewHeightP	= 100;
	m_bViewSideP			= FALSE;

	m_dwLastSipInfo	= SIPF_OFF;

	m_hwndPrev			= NULL;
	m_nMainWndTop		= 0;
	m_nMainWndLeft		= 0;
	m_nMainWndWidth		= 640;
	m_nMainWndHeight	= 400;
	m_nMainWndStyle		= 92;
	m_bNumberShortcut	= FALSE;
	m_bLandscapeMode	= FALSE;
	m_bHighRresolutionMode	= FALSE;
	m_bSwapMenu			= FALSE;
	m_bEdgeLoop			= TRUE;
	m_bVirtualListView	= FALSE;
	m_bXcrawlPageMove	= TRUE;
	m_bHighDpiHardware	= TRUE;
	m_fpHighResolutionScale	= 1.0;
	m_hFont				= NULL;
	m_bViewSideL		= FALSE;
	m_nTreeViewWidthL	= 100;
	m_nTreeViewHeightL	= 100;
	m_bIsZero3			= FALSE;
	m_dwInputMode		= INPUTMODE_HAN_NUMERIC;
	m_dwInitialInputMode = INPUTMODE_ZEN_HIRAGANA;
}

///////////////////////////////////////////////////////////////
CMainWnd::~CMainWnd()
{
}

///////////////////////////////////////////////////////////////
void CMainWnd::Init()
{
	TCHAR szTemp[MAX_PATH];

	//IM
	m_dwLastSipInfo = GetIMStatus();

	SaveModulePath();

	//VXepX̎擾
	GetSystemPath();

	//W-ZERO3V[Y
	SystemParametersInfo(SPI_GETOEMINFO, MAX_PATH, szTemp, 0);
	m_bIsZero3
		= _tcsstr(szTemp, _T("WS003SH")) || _tcsstr(szTemp, _T("WS004SH"))
		|| _tcsstr(szTemp, _T("WS007SH")) || _tcsstr(szTemp, _T("WS011SH"))
		|| _tcsstr(szTemp, _T("WS020SH"));

	//Smartphone/Standard̔
	if (SystemParametersInfo(SPI_GETPLATFORMTYPE, MAX_PATH, szTemp, 0))
		m_bIsSmartphone = (_tcsicmp(szTemp, _T("Smartphone")) == 0);
	else
		m_bIsSmartphone = FALSE;
	if (m_bIsSmartphone)
		m_CmdBands.OnViewToolBar();	//on()off

	m_bDisableResizeSpIcon = FALSE;

	//DPIn[hEFA
	HDC hdc = GetDC(NULL);
	m_bHighDpiHardware = (GetDeviceCaps(hdc, LOGPIXELSX) > 96);
	m_fpHighResolutionScale = (float)GetDeviceCaps(hdc, LOGPIXELSX) / 96;
	ReleaseDC(0, hdc);

	//ݒǂݍ
	GetSettings();

	//NX̓o^
	MainWndRegisterClass(g_hInst, APP_CLASS_NAME);

	//EBhE쐬
	m_hWnd = CreateWindow(APP_CLASS_NAME, APP_MAINWND_TITLE, WS_VISIBLE,
				CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, g_hInst, NULL);

	//ACR̐ݒ
	SendMessage(m_hWnd, WM_SETICON , ICON_SMALL, 
				(LPARAM)LoadImage(g_hInst, MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));
	SendMessage(m_hWnd, WM_SETICON , ICON_BIG,
				(LPARAM)LoadIcon(g_hInst, MAKEINTRESOURCE(IDR_MAINFRAME)));

	//̓[h𔼊pɕύX
	m_dwInitialInputMode = GetInputMode();
	SetInputMode(INPUTMODE_HAN_NUMERIC);
}

///////////////////////////////////////////////////////////////
void CMainWnd::GetSystemPath()
{
	//Windows
	if (!SHGetSpecialFolderPath(NULL, m_szWindowsPath, CSIDL_WINDOWS, FALSE))
		_tcscpy(m_szWindowsPath, GetResourceString(IDS_WINDOWS_PATH));

	//lbg[N
	if (!SHGetSpecialFolderPath(NULL, m_szNetworkPath, CSIDL_NETWORK, FALSE))
		_tcscpy(m_szNetworkPath, GetResourceString(IDS_NETWORK_PATH));
	m_lpszNetwork = _tcsrchr(m_szNetworkPath, _T('\\'))+1;

	//}ChLg
	if (!SHGetSpecialFolderPath(NULL, m_szMyDocumentPath, CSIDL_PERSONAL, FALSE))
		_tcscpy(m_szMyDocumentPath, GetResourceString(IDS_MYDOCUMENT_PATH));
	m_lpszMyDocument = _tcsrchr(m_szMyDocumentPath, _T('\\'))+1;

	//X^[gj[
	if (!SHGetSpecialFolderPath(NULL, m_szStartMenuPath, CSIDL_STARTMENU, FALSE))
		_tcscpy(m_szStartMenuPath, GetResourceString(IDS_STARTMENU_PATH));
	m_lpszStartMenu = _tcsrchr(m_szStartMenuPath, _T('\\'))+1;

	//Cɓ
	if (!SHGetSpecialFolderPath(NULL, m_szFavoritesPath,	CSIDL_FAVORITES, FALSE))
		_tcscpy(m_szFavoritesPath, GetResourceString(IDS_FAVORITES_PATH));

	//SendTo/ShellNew
	GetModuleFileName(NULL, m_szSendAppPath, MAX_PATH);
	_tcscpy(m_szShellNewPath, m_szSendAppPath);
	_tcscpy(_tcsrchr(m_szSendAppPath, _T('\\')), _T("\\SendTo"));
	_tcscpy(_tcsrchr(m_szShellNewPath, _T('\\')), _T("\\ShellNew"));
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnCreate()
{
	//
	INITCOMMONCONTROLSEX	iccex;
	iccex.dwSize = sizeof (INITCOMMONCONTROLSEX);
	iccex.dwICC = ICC_BAR_CLASSES | ICC_COOL_CLASSES;
	InitCommonControlsEx (&iccex);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ShowWindow()
{
	//qEChE
	m_CmdBands.Init(m_hWnd);
	m_CmdBands.SetCheckViewStatusWnd(m_bShowStatusWnd);
	m_CmdBands.SetCheckViewFolder(m_bShowFolder);
	m_CmdBands.SetCheckViewSide(m_bLandscapeMode? m_bViewSideL: m_bViewSideP);
	m_CmdBands.SetCheckViewHighRes(m_bHighRresolutionMode);
	m_CmdBands.SetCheckDragDrop(m_bDragDrop);
	m_StatusWnd.Init(m_hWnd);
	m_ListView.Init(m_hWnd);
	m_TreeView.Init(m_hWnd);

	//tHgݒ
	SetFont();

	//\
	//EBhE\
	if (m_bOverLapped)
	{
		//I[o[bvEBhE
		//EBhEԐݒ
		if (m_nMainWndStyle > 2)
		{
			m_nMainWndStyle -= 90;
		}
		switch (m_nMainWndStyle)
		{
		case MAINWND_MINIMUM:
			//ŏ
			::ShowWindow(m_hWnd, SW_SHOW);
			::ShowWindow(m_hWnd, SW_MINIMIZE);
			break;

		case MAINWND_NOMAL:
			//ʏ
			::ShowWindow(m_hWnd, SW_SHOWNORMAL);
			break;

		//case MAINWND_MAXIMUM:
		default:
			//ő剻
			m_nMainWndStyle = 2;
			::ShowWindow(m_hWnd, SW_SHOW);
			::ShowWindow(m_hWnd, SW_MAXIMIZE);
			break;
		}
	}
	else
	{
		//ʏEBhE
		::ShowWindow(m_hWnd, SW_SHOW);
	}

	m_StatusWnd.ShowStatusWnd(m_bShowStatusWnd);

	//\TCY̒
	RecalcLayout();
	
	//tH_ǂݍ
	SetFocus(m_ListView.m_hWnd);
	m_ListView.InitFolderItem(m_ListView.m_szCurrentFolder);//(WS007SHɂāuڍׁv\Ńt@C̕ƎNɗĂւ̑Ώ)
	m_hwndPrev = m_ListView.m_hWnd;
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDestroy()
{
	PostQuitMessage(0);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnSize(int nWidth, int nHeight)
{
	//TCY𒲐
	RECT rctSB, rctTB, rctAB, rctCB;
	if (m_StatusWnd.m_hWnd)
		GetWindowRect(m_StatusWnd.m_hWnd, &rctSB);
	if (m_CmdBands.m_hToolbar)
		GetWindowRect(m_CmdBands.m_hToolbar, &rctTB);
	if (m_CmdBands.m_hAddressbar)
	{
		GetWindowRect(m_CmdBands.m_hAddressbar, &rctAB);
		GetWindowRect(m_CmdBands.m_hComboBox, &rctCB);
	}
	rctSB.left = rctTB.left = rctAB.left = 0;
	rctSB.right = rctTB.right = rctAB.right = GetSystemMetrics(SM_CXSCREEN);
	if (m_CmdBands.m_Settings.bShowAddressBar)
	{
		int ss = (int)(2 * m_fpHighResolutionScale + 0.5);
		MoveWindow(m_CmdBands.m_hAddressbar, 0, 0, RECT_WIDTH(&rctAB), RECT_HEIGHT(&rctAB), TRUE);
		MoveWindow(m_CmdBands.m_hComboBox, ss, ss, RECT_WIDTH(&rctAB) - ss * 2, RECT_HEIGHT(&rctCB), TRUE);
	}

	if (m_CmdBands.m_Settings.bShowToolBar)
		MoveWindow(m_CmdBands.m_hToolbar, rctTB.left, nHeight - RECT_HEIGHT(&rctTB), RECT_WIDTH(&rctTB), RECT_HEIGHT(&rctTB), TRUE);
	if (m_bShowStatusWnd)
	{
		if (m_CmdBands.m_Settings.bShowToolBar)
			MoveWindow(m_StatusWnd.m_hWnd, rctSB.left, nHeight - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB), RECT_WIDTH(&rctSB), RECT_HEIGHT(&rctSB), TRUE);
		else
			MoveWindow(m_StatusWnd.m_hWnd, rctSB.left, nHeight - RECT_HEIGHT(&rctSB), RECT_WIDTH(&rctSB), RECT_HEIGHT(&rctSB), TRUE);
	}
	int nLVTop, nLVBottom;
	if (m_CmdBands.m_Settings.bShowAddressBar)
		nLVTop = RECT_HEIGHT(&rctAB);
	else
		nLVTop = 0;

	if (m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctSB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight + 1;
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctAB) - RECT_HEIGHT(&rctTB);
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		!m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctTB);
	else if (m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctSB) - RECT_HEIGHT(&rctTB);
	else if (!m_CmdBands.m_Settings.bShowToolBar &&
		m_bShowStatusWnd &&
		!m_CmdBands.m_Settings.bShowAddressBar)
		nLVBottom = nHeight - RECT_HEIGHT(&rctSB);

	if (m_CmdBands.m_Settings.bShowAddressBar)
	{
		if (m_bShowFolder)
		{
			if (m_bLandscapeMode? m_bViewSideL: m_bViewSideP)
			{
				int ntvw = (m_bLandscapeMode? m_nTreeViewWidthL: m_nTreeViewWidthP);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				SetWindowPos(m_TreeView.m_hWnd, HWND_TOP,
					0,
					nLVTop,
					ntvw,
					nLVBottom, SWP_SHOWWINDOW);
				SetWindowPos(m_ListView.m_hWnd, HWND_TOP,
					0 + (ntvw + split),
					nLVTop,
					nWidth - (ntvw + split),
					nLVBottom, SWP_SHOWWINDOW);
			}
			else
			{
				int ntvh = (m_bLandscapeMode? m_nTreeViewHeightL: m_nTreeViewHeightP);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				SetWindowPos(m_TreeView.m_hWnd, HWND_TOP,
					0,
					nLVTop,
					nWidth,
					ntvh, SWP_SHOWWINDOW);
				SetWindowPos(m_ListView.m_hWnd, HWND_TOP,
					0,
					nLVTop + (ntvh + split),
					nWidth,
					nLVBottom - (ntvh + split), SWP_SHOWWINDOW);
			}
		}
		else
			SetWindowPos(m_ListView.m_hWnd, HWND_TOP, 0, nLVTop , nWidth, nLVBottom, SWP_SHOWWINDOW);
	}
	else
	{
		if (m_bShowFolder)
		{
			if (m_bLandscapeMode? m_bViewSideL: m_bViewSideP)
			{
				int ntvw = (m_bLandscapeMode? m_nTreeViewWidthL: m_nTreeViewWidthP);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				MoveWindow(m_TreeView.m_hWnd,
					0,
					nLVTop,
					ntvw,
					nLVBottom, TRUE);
				MoveWindow(m_ListView.m_hWnd,
					0 + (ntvw + split),
					nLVTop,
					nWidth - (ntvw + split),
					nLVBottom, TRUE);
			}
			else
			{
				int ntvh = (m_bLandscapeMode? m_nTreeViewHeightL: m_nTreeViewHeightP);
				int split = (int)(APP_SPLIT_SIZE * m_fpHighResolutionScale);
				MoveWindow(m_TreeView.m_hWnd,
					0,
					nLVTop,
					nWidth,
					ntvh, TRUE);
				MoveWindow(m_ListView.m_hWnd,
					0,
					nLVTop + (ntvh + split),
					nWidth,
					nLVBottom - (ntvh + split), TRUE);
			}
		}
		else
			MoveWindow(m_ListView.m_hWnd, 0, nLVTop , nWidth, nLVBottom, TRUE);
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnClose()
{
	SaveSettings();
	m_CmdBands.Destroy();
	m_StatusWnd.Destroy();
	m_ListView.Destroy();
	m_TreeView.Destroy();
	DestroyWindow(m_hWnd);
	SetInputMode(m_dwInitialInputMode);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnEditCtrlOn()
{
	m_bShiftKey = FALSE;
	m_bControlKey = !m_bControlKey;
	m_CmdBands.SetCheckKeyOn(m_bControlKey, m_bShiftKey);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnEditShiftOn()
{
	m_bControlKey = FALSE;
	m_bShiftKey = !m_bShiftKey;
	m_CmdBands.SetCheckKeyOn(m_bControlKey, m_bShiftKey);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDragDropMode()
{
	m_bDragDrop = !m_bDragDrop;
	m_CmdBands.SetCheckDragDrop(m_bDragDrop);
}

///////////////////////////////////////////////////////////////
void CMainWnd::SaveSettings()
{
	HKEY hKey;
	DWORD dwDisposition;

	//L[ݒ
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS,
			0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_nTreeViewWidthP,m_nTreeViewWidthL;
		RegSetValueEx(hKey, _T("TreeViewWidthP"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewWidthP, sizeof(DWORD));
		RegSetValueEx(hKey, _T("TreeViewWidthL"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewWidthL, sizeof(DWORD));

		//m_nTreeViewHeightP,m_nTreeViewHeightL;
		RegSetValueEx(hKey, _T("TreeViewHeightP"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewHeightP, sizeof(DWORD));
		RegSetValueEx(hKey, _T("TreeViewHeightL"), 0, REG_DWORD, (LPBYTE)&m_nTreeViewHeightL, sizeof(DWORD));

		//m_bShowStatusWnd
		RegSetValueEx(hKey, _T("ShowStatusWnd"), 0, REG_DWORD, (LPBYTE)&m_bShowStatusWnd, sizeof(DWORD));

		//m_bShowFolder
		RegSetValueEx(hKey, _T("ShowFolder"), 0, REG_DWORD, (LPBYTE)&m_bShowFolder, sizeof(DWORD));

		//m_bViewSideP/m_bViewSideL
		RegSetValueEx(hKey, _T("ViewSideP"), 0, REG_DWORD, (LPBYTE)&m_bViewSideP, sizeof(DWORD));
		RegSetValueEx(hKey, _T("ViewSideL"), 0, REG_DWORD, (LPBYTE)&m_bViewSideL, sizeof(DWORD));

		//m_bDragDrop
		RegSetValueEx(hKey, _T("DragDrop"), 0, REG_DWORD, (LPBYTE)&m_bDragDrop, sizeof(DWORD));

		//m_bCheckQAdd
		RegSetValueEx(hKey, _T("CheckQAdd"), 0, REG_DWORD, (LPBYTE)&m_bCheckQAdd, sizeof(DWORD));

		//m_bCheckSendMulti
		RegSetValueEx(hKey, _T("SendMulti"), 0, REG_DWORD, (LPBYTE)&m_bSendMulti, sizeof(DWORD));

		//m_bOverLapped
		RegSetValueEx(hKey, _T("OverLapped"), 0, REG_DWORD, (LPBYTE)&m_bOverLapped, sizeof(DWORD));

		//m_bContextMenu
		RegSetValueEx(hKey, _T("ContextMenu"), 0, REG_DWORD, (LPBYTE)&m_bContextMenu, sizeof(DWORD));

		//m_bFontChange
		RegSetValueEx(hKey, _T("FontChange"), 0, REG_DWORD, (LPBYTE)&m_bFontChange, sizeof(DWORD));

		//m_nFontSize;
		RegSetValueEx(hKey, _T("FontSize"), 0, REG_DWORD, (LPBYTE)&m_nFontSize, sizeof(DWORD));

		//m_bNumberShortcut
		RegSetValueEx(hKey, _T("NumberShortcut"), 0, REG_DWORD, (LPBYTE)&m_bNumberShortcut, sizeof(DWORD));

		//m_bHighRresolutionMode
		RegSetValueEx(hKey, _T("HighResolutionMode"), 0, REG_DWORD, (LPBYTE)&m_bHighRresolutionMode, sizeof(DWORD));

		////m_bDisableResizeSpIcon
		////BݒȂ̂œǂݍ݂͂邪ۑ͂Ȃ
		//RegSetValueEx(hKey, _T("DisableResizeSpIcon"), 0, REG_DWORD, (LPBYTE)&m_bDisableResizeSpIcon, sizeof(DWORD));

		//m_bSwapMenu
		RegSetValueEx(hKey, _T("SwapMenu"), 0, REG_DWORD, (LPBYTE)&m_bSwapMenu, sizeof(DWORD));

		//m_bXcrawlPageMove
		RegSetValueEx(hKey, _T("XcrawlPageMove"), 0, REG_DWORD, (LPBYTE)&m_bXcrawlPageMove, sizeof(DWORD));

		//m_bEdgeLoop
		RegSetValueEx(hKey, _T("EdgeLoop"), 0, REG_DWORD, (LPBYTE)&m_bEdgeLoop, sizeof(DWORD));

		//m_bVirtualListView
		RegSetValueEx(hKey, _T("VirtualListView"), 0, REG_DWORD, (LPBYTE)&m_bVirtualListView, sizeof(DWORD));

		//m_szFontName
		RegSetValueEx(hKey, _T("FontName"), 0, REG_SZ, (LPBYTE)m_szFontName, ((_tcslen(m_szFontName)+1) * sizeof(TCHAR)));

		//m_szNetworkPath
		RegSetValueEx(hKey, _T("NetworkPath"), 0, REG_SZ, (LPBYTE)m_szNetworkPath, ((_tcslen(m_szNetworkPath)+1) * sizeof(TCHAR)));

		//m_szSendAppPath
		RegSetValueEx(hKey, _T("SendAppPath"), 0, REG_SZ, (LPBYTE)m_szSendAppPath, ((_tcslen(m_szSendAppPath)+1) * sizeof(TCHAR)));

		//m_szShellNewPath
		RegSetValueEx(hKey, _T("ShellNewPath"), 0, REG_SZ, (LPBYTE)m_szShellNewPath, ((_tcslen(m_szShellNewPath)+1) * sizeof(TCHAR)));

		RegCloseKey(hKey);
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::GetSettings()
{
	HKEY hKey;
	DWORD dwDisposition;

	//L[l擾
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS,
				0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;
		BYTE bData[MAX_PATH * 2];

		//m_nTreeViewWidthP
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidth"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidthP = m_nTreeViewWidthL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidthP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidthP = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewWidthL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewWidthL = dwValue;

		//m_nTreeViewHeightP
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeight"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeightP = m_nTreeViewHeightL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeightP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeightP = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("TreeViewHeightL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nTreeViewHeightL = dwValue;

		//m_bShowStatusWnd
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowStatusWnd"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bShowStatusWnd = dwValue;

		//m_bShowFolder
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowFolder"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bShowFolder = dwValue;

		//m_bViewSideP/m_bViewSideL
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSide"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSideP = m_bViewSideL = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSideP"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSideP = dwValue;
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ViewSideL"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bViewSideL = dwValue;

		//m_bDragDrop
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("DragDrop"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bDragDrop = dwValue;

		//m_bCheckQAdd
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("CheckQAdd"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bCheckQAdd = dwValue;

		//m_bCheckSendMulti
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SendMulti"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bSendMulti = dwValue;

		//m_bOverLapped
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("OverLapped"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bOverLapped = dwValue;

		//m_bContextMenu
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ContextMenu"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bContextMenu = dwValue;

		//m_bFontChange
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("FontChange"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bFontChange = dwValue;

		//m_nFontSize
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("FontSize"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_nFontSize = dwValue;

		//m_bNumberShortcut
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("NumberShortcut"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bNumberShortcut = dwValue;

		//m_bHighRresolutionMode
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("HighResolutionMode"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bHighRresolutionMode = dwValue;

		//m_bDisableResizeSpIcon
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("DisableResizeSpIcon"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bDisableResizeSpIcon = dwValue;

		//m_bSwapMenu
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("SwapMenu"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bSwapMenu = dwValue;

		//m_bXcrawlPageMove
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("XcrawlPageMove"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bXcrawlPageMove = dwValue;

		//m_bEdgeLoop
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("EdgeLoop"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bEdgeLoop = dwValue;

		//m_bVirtualListView
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("VirtualListView"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_bVirtualListView = dwValue;

		//m_szFontName
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("FontName"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szFontName, bData, dwDataSize);

		//m_szNetworkPath
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("NetworkPath"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szNetworkPath, bData, dwDataSize);

		//m_szSendAppPath
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("SendAppPath"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szSendAppPath, bData, dwDataSize);

		//m_szShellNewPath
		dwDataSize = sizeof(bData);
		if (RegQueryValueEx(hKey, _T("ShellNewPath"), 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
			memcpy(&m_szShellNewPath, bData, dwDataSize);

		RegCloseKey(hKey);
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewStatusBar()
{
	m_bShowStatusWnd = !m_bShowStatusWnd;
	::ShowWindow(m_StatusWnd.m_hWnd, m_bShowStatusWnd? SW_SHOW: SW_HIDE);

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewStatusWnd(m_bShowStatusWnd);

	//\TCY̒
	RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewFolder()
{
	m_bShowFolder = !m_bShowFolder;

	if (m_bShowFolder)
		::ShowWindow(m_TreeView.m_hWnd, SW_SHOW);
	else
	{
		::ShowWindow(m_TreeView.m_hWnd, SW_HIDE);
		SetFocus(m_ListView.m_hWnd);
	}

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewFolder(m_bShowFolder);

	//\TCY̒
	RecalcLayout();

	//Xgr[XV
	m_ListView.OnViewUpdate();
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnViewSide()
{
	m_bViewSideP = !m_bViewSideP;

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewSide(m_bViewSideP);

	//\TCY̒
	RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewSideL()
{
	m_bViewSideL = !m_bViewSideL;

	//j[Ƀ`FbN
	m_CmdBands.SetCheckViewSide(m_bViewSideL);

	//\TCY̒
	RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewHighRes(BOOL bHighRes)
{
	m_bHighRresolutionMode = bHighRes;
	ListView_EnsureVisible(m_ListView.m_hWnd, 0, TRUE);
	m_ListView.OnChangeListStyle(0);
	SetFont();
	m_ListView.SetImageList();
	m_TreeView.InitImageList();
	m_TreeView.LoadFolderTree();
	OnViewUpdate();
	m_CmdBands.SetCheckViewHighRes(bHighRes);
	ListView_EnsureVisible(m_ListView.m_hWnd, 0, TRUE);
	InvalidateRect(m_hWnd, NULL, FALSE);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnViewUpdate(LPCTSTR lpszPath)
{
	//c[r[XV
	m_TreeView.LoadFolderTree();
	
	//Xgr[XV
	m_ListView.OnViewUpdate(lpszPath);

	//郁j[XV
	m_ListView.InitOpenAppMenu();

	//Cɓ胁j[XV
	m_ListView.InitFavoritesMenu();

	//VK쐬j[XV
	m_ListView.InitShellNewMenu();

	//ʍXV
	InvalidateRect(m_hWnd, NULL, FALSE);
}

///////////////////////////////////////////////////////////////
BOOL CMainWnd::NetworkFolderEnable(BOOL bEnable, BOOL bMsg)
{
	HKEY hKey;
	DWORD dwDisposition;
	DWORD dwFSRoot;

	//ǂݍ
	hKey = NULL;
	dwFSRoot = 0;
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Comm\\Redir"), 0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwValue = 0;
		DWORD dwDataSize = sizeof(dwValue);
		if (RegQueryValueEx(hKey, _T("RegisterFSRoot"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			dwFSRoot = dwValue;
	}

	if (bEnable)
	{
		//ݒς݂̏ꍇ
		if (dwFSRoot)
			return TRUE;

		//bZ[W\L̏ꍇ
		if (bMsg)
		{
			if (IDNO == MessageBox(m_hWnd, GetResourceString(IDS_MSG_NETFOLDER_CREATE), GetResourceString(IDS_TITLE_NETFOLDER), MB_YESNO|MB_ICONQUESTION))
				return FALSE;
		}

		//ݒ
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Comm\\Redir"), 0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
		{
			dwFSRoot = 1;
			RegSetValueEx(hKey, _T("RegisterFSRoot"), 0, REG_DWORD, (BYTE*)&dwFSRoot, sizeof(DWORD));
			if (bMsg)
			{
				//bZ[W\L̏ꍇ
				MessageBox(m_hWnd, GetResourceString(IDS_MSG_NETFOLDER_DONE), GetResourceString(IDS_TITLE_NETFOLDER), MB_OK|MB_ICONWARNING);
			}
		}
	}
	else
	{
		if (!dwFSRoot)
		{
			//ݒς݂̏ꍇ
			return TRUE;
		}

		if (bMsg)
		{
			//bZ[W\L̏ꍇ
			if (IDNO == MessageBox(m_hWnd, GetResourceString(IDS_MSG_NETFOLDER_DELETE), GetResourceString(IDS_TITLE_NETFOLDER), MB_YESNO|MB_ICONQUESTION))
				return FALSE;
		}

		//ݒ
		if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Comm\\Redir"), 0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
		{
			dwFSRoot = 0;
			RegSetValueEx(hKey, _T("RegisterFSRoot"), 0, REG_DWORD, (BYTE*)&dwFSRoot, sizeof(DWORD));
			if (bMsg)
			{
				//bZ[W\L̏ꍇ
				MessageBox(m_hWnd, GetResourceString(IDS_MSG_NETFOLDER_DONE), GetResourceString(IDS_TITLE_NETFOLDER), MB_OK|MB_ICONWARNING);
			}
		}
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnNetworkDriveConnect()
{
	//lbg[NtH_`FbN
	if (!NetworkFolderEnable(TRUE))
		return;

	//p[^
	NETRESOURCE nr;
	nr.dwType = RESOURCETYPE_DISK;
	nr.lpRemoteName = NULL;
	nr.lpLocalName = NULL;
	nr.lpProvider = NULL;
	CONNECTDLGSTRUCT cs;
	cs.cbStructure = sizeof(cs);
	cs.hwndOwner = m_hWnd;
	cs.lpConnRes = &nr;
	cs.dwFlags = 0;

	//lbg[Nڑ_CAO\
	DWORD dwResult;
	if (0xFFFFFFFF != (dwResult=WNetConnectionDialog1(&cs)))
	{
		if (dwResult != WN_SUCCESS)
		{
			//G[
			MessageBox(m_hWnd, GetResourceString(IDS_MSG_NTDRIVE_CON), NULL, MB_OK|MB_ICONSTOP);
		}
		else
		{
			//펞
			//\XV
			OnViewUpdate();
		}
	}
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnNetworkDriveDisconnect()
{
	WIN32_FIND_DATA finddata;
	TCHAR szNetwork[MAX_PATH * 2];
	HANDLE hFind;

	_tcscpy(szNetwork, m_szNetworkPath);
	_tcscat(szNetwork, _T("\\*.*"));
	hFind = FindFirstFile(szNetwork, &finddata);
	if (hFind == INVALID_HANDLE_VALUE)
		NetworkFolderEnable(FALSE);
	else
	{
		//
		FindClose(hFind);

		//lbg[Nؒf_CAO\
		DWORD dwResult;
		if (0xFFFFFFFF != (dwResult=WNetDisconnectDialog(m_hWnd, RESOURCETYPE_ANY)))
		{
			//G[
			if (dwResult != ERROR_SUCCESS)
				MessageBox(m_hWnd, GetResourceString(IDS_MSG_NTDRIVE_DCON), NULL, MB_OK|MB_ICONSTOP);
			//펞
			else
			{
				TCHAR szPath[MAX_PATH];
				_tcscpy(szPath, m_ListView.m_szCurrentFolder);

				//\tÕfBNgȂꍇAʃfBNgֈړ
				while (GetFileAttributes(szPath) == 0xFFFFFFFF)
				{
					LPTSTR lpszTemp = _tcsrchr(szPath, _T('\\'));
					if (lpszTemp) *lpszTemp = 0;
				} // End of while

				//\XV
				OnViewUpdate(szPath);
			}
		}
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnToolActivesync() 
{
	SHELLEXECUTEINFO sei;
	ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	//sei.fMask = 0;
	sei.hwnd = m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = _T("async.asy");
	//sei.lpParameters = NULL;
	sei.lpDirectory = m_szWindowsPath;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;
	ShellExecuteEx(&sei);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnToolIRRecive()
{
	SHELLEXECUTEINFO sei;
	ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	//sei.fMask = 0;
	sei.hwnd = this->m_hWnd;
	sei.lpVerb = _T("open");
	//sei.lpParameters = NULL;
	sei.lpDirectory = m_szWindowsPath;
	sei.nShow = SW_SHOW;
	sei.hInstApp = g_hInst;

	if (GetFileAttributes(_T("\\Windows\\beam.exe")) != 0xFFFFFFFF)
		sei.lpFile = _T("beam.exe");
	else 
		sei.lpFile = _T("irsquirt.exe");

	ShellExecuteEx(&sei);
}

///////////////////////////////////////////////////////////////
void CMainWnd::SaveModulePath()
{
	TCHAR szPath[MAX_PATH];
	GetModuleFileName(g_hInst, szPath, MAX_PATH);
	HKEY hKey = 0;
	DWORD dwDisposition;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_GSF, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		BYTE lpData[MAX_PATH*2];
		memcpy(lpData, &szPath, sizeof(szPath));
		RegSetValueEx(hKey, _T("Path"), 0, REG_SZ, lpData, sizeof(szPath));

		RegCloseKey(hKey);
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnActivate(int nActive)
{
	if (nActive == WA_INACTIVE)
	{
		m_hwndPrev = GetFocus();
		m_dwLastSipInfo = GetIMStatus();
		SaveInputMode();
		SetInputMode(m_dwInitialInputMode);
	}
	else if (nActive == WA_ACTIVE)
	{
		SetFocus(m_hwndPrev);
		RecalcLayout();
		m_dwInitialInputMode = GetInputMode();
		RestoreInputMode();
	}
}
///////////////////////////////////////////////////////////////
void CMainWnd::OnSettingChange(int nFlag)
{
    if (nFlag == SPI_SETSIPINFO)
		RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CMainWnd::RecalcLayout()
{
	SIPINFO si;
	memset(&si, 0, sizeof(si));
	si.cbSize = sizeof(si);
	if (SipGetInfo(&si))
	{
		//SIP(PocketPC/Professional/Classic)
		if (si.fdwFlags & SIPF_ON)
			OnSize(RECT_WIDTH(&si.rcVisibleDesktop), RECT_HEIGHT(&si.rcVisibleDesktop) - (int)(2 * m_fpHighResolutionScale));
		else
		{
			int y = GetSystemMetrics(SM_CYMENU);
			OnSize(RECT_WIDTH(&si.rcVisibleDesktop), RECT_HEIGHT(&si.rcVisibleDesktop) - (int)((y + 4) * m_fpHighResolutionScale));
		}
	}
	else
	{
		//SIPȂ(Smartphone/Standard)
		int y = GetSystemMetrics(SM_CYMENU);
		OnSize(GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYFULLSCREEN) + (int)(y * m_fpHighResolutionScale));
	}
	m_dwLastSipInfo = si.fdwFlags;

	//IĂ̂悤ɂ
	int nItem = ListView_GetNextItem(m_ListView.m_hWnd, -1, LVNI_ALL|LVNI_FOCUSED);
	if (nItem >= 0)
		ListView_EnsureVisible(m_ListView.m_hWnd, nItem, FALSE);

	m_bLandscapeMode = GetSystemMetrics(SM_CYSCREEN)<GetSystemMetrics(SM_CXSCREEN);
	m_CmdBands.SetCheckViewSide(m_bLandscapeMode? m_bViewSideL: m_bViewSideP);
}

///////////////////////////////////////////////////////////////
void CMainWnd::RecalcBarLayout(WPARAM wParam, LPARAM lParam)
{
	//R}ho[̃TCY
	if (m_CmdBands.m_Settings.bShowToolBar ||
	   m_CmdBands.m_Settings.bShowAddressBar)
		SendMessage(m_CmdBands.m_hWnd, WM_SIZE, wParam, lParam);
	//Xe[^Xo[̃TCY
	if (m_bShowStatusWnd)
	{
		SendMessage(m_StatusWnd.m_hWnd, WM_SIZE, wParam, lParam);
		m_StatusWnd.OnSize(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnMouseMove(LPARAM lParam, int nStartPos, int nLastWidth, int nLastHeight)
{
	if (m_bLandscapeMode? m_bViewSideL: m_bViewSideP)
	{
		int x = GET_X_LPARAM(lParam);

		//ړ͈͐ݒ(/)
		int min = 20;
		int max = GetSystemMetrics(SM_CXSCREEN) - 20;

		//ړ͈̓`FbN
		if (x > min && x < max)
		{
			int ntvw = nLastWidth + (x - nStartPos);
			if (m_bLandscapeMode)
				m_nTreeViewWidthL = ntvw;
			else
				m_nTreeViewWidthP = ntvw;
			RecalcLayout();
		}
	}
	else
	{
		int y = GET_Y_LPARAM(lParam);

		//c[r[̍W擾()
		RECT rc;
		POINT pt;
		GetWindowRect(m_TreeView.m_hWnd, &rc);
		pt.x = rc.right;
		pt.y = rc.top;
		ScreenToClient(m_hWnd, &pt);
		int min = pt.y + 20;

		//Xgr[̍W擾()
		GetWindowRect(m_ListView.m_hWnd, &rc);
		pt.x = rc.right;
		pt.y = rc.bottom;
		ScreenToClient(m_hWnd, &pt);
		int max = pt.y - 20;

		//ړ͈̓`FbN
		if (y > min && y < max)
		{
			int ntvh = nLastHeight + (y - nStartPos);
			if (m_bLandscapeMode)
				m_nTreeViewHeightL = ntvh;
			else
				m_nTreeViewHeightP = ntvh;
			RecalcLayout();
		}
	}
}

///////////////////////////////////////////////////////////////
HIMAGELIST CMainWnd::ListViewImageCreate(LPNMLISTVIEW lpNMLV)
{
	HWND hList = m_ListView.m_hWnd;

	//C[WXg쐬
	POINT ptImg;
	HIMAGELIST hDrag = ListView_CreateDragImage(hList, lpNMLV->iItem, &ptImg);

	//hbOJn
	if (ImageList_BeginDrag(hDrag, 0, 0, 0))
	{
		ImageList_DragEnter(NULL, lpNMLV->ptAction.x, lpNMLV->ptAction.y);
		return hDrag;
	}

	//G[
	return 0;
}

///////////////////////////////////////////////////////////////
HIMAGELIST CMainWnd::TreeViewImageCreate(LPNMTREEVIEW lpNMTV)
{
	HWND hTree = m_TreeView.m_hWnd;

	//C[WXg쐬
	HIMAGELIST hDrag = TreeView_CreateDragImage(hTree, lpNMTV->itemNew.hItem);

	//hbOJn
	if (ImageList_BeginDrag(hDrag, 0, 0, 0))
	{
		ClientToScreen(hTree, &(lpNMTV->ptDrag));
		ImageList_DragEnter(NULL, lpNMTV->ptDrag.x, lpNMTV->ptDrag.y);
		return hDrag;
	}

	//G[
	return 0;
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageLeave()
{
	//ړÕC[WXgj
	ImageList_DragLeave(NULL);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageMove(POINT ptWnd)
{
	//C[WXgړʒu֕`
	ClientToScreen(m_hWnd, &ptWnd);
	ImageList_DragMove(ptWnd.x, ptWnd.y);
	ImageList_DragEnter(NULL, ptWnd.x, ptWnd.y);
}

///////////////////////////////////////////////////////////////
void CMainWnd::ImageDestory(HIMAGELIST hDrag)
{
	//C[WXgj
	ImageList_DragLeave(NULL);
	ImageList_EndDrag();
	ImageList_Destroy(hDrag);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnBeginDrag(NMHDR* lpNMH)
{
	m_hDragWnd = lpNMH->hwndFrom;

	//}EXLv`Jn
	SetCapture(m_hWnd);

	//Xgr[̃hbOhbvs
	if (!m_bDragDrop && m_hDragWnd == m_ListView.m_hWnd)
	{
		if (!m_ListView.m_nSelectItem)
		{
			m_ListView.m_nSelectStart = ((LPNMLISTVIEW)lpNMH)->iItem;
			m_bSelectFlg = TRUE;
			return;
		}
	}
	m_bSelectFlg = FALSE;

	//hbÕC[WXg쐬
	if (m_hDragWnd == m_ListView.m_hWnd)
		m_hDragImg = ListViewImageCreate((LPNMLISTVIEW)lpNMH);
	else if (m_hDragWnd == m_TreeView.m_hWnd)
	{
		LPNMTREEVIEW lpnmv = (LPNMTREEVIEW)lpNMH;
		m_hDragImg = TreeViewImageCreate(lpnmv);
		m_hDragTree = lpnmv->itemNew.hItem;
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnMouseMove(POINT ptWnd)
{
	//hbOhbvs
	if (m_bSelectFlg)
	{
		m_ListView.OnMouseMoveArea(ptWnd);
		return;
	}

	//ÕC[WXg\폜
	ImageLeave();
	
	//hbÕtH[JX
	m_ListView.OnMouseMove(ptWnd);
	m_TreeView.OnMouseMove(ptWnd);

	//̍WŃC[WXg\
	ImageMove(ptWnd);
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnLButtopUp()
{
	//}EXLv`I
	ReleaseCapture();

	//hbOhbvs
	if (m_bSelectFlg) return;

	//C[WXg폜
	ImageDestory(m_hDragImg);

	//hbv̏
	if (!m_TreeView.OnLButtonUp(m_hDragWnd))
	{
		m_TreeView.OnDropCansel();
	}
	else
	{
		return;
	}
	if (!m_ListView.OnLButtonUp(m_hDragWnd))
	{
		m_ListView.OnDropCansel();
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDropCansel()
{
	//}EXLv`I
	ReleaseCapture();

	//hbOhbvs
	if (m_bSelectFlg) return;

	//C[WXg폜
	ImageDestory(m_hDragImg);

	//hbOACẽLZ
	m_ListView.OnDropCansel();
	m_TreeView.OnDropCansel();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnSetFocus(HWND hWnd)
{
	//tH[JXEBhEςꍇ̂
	if (hWnd == m_TreeView.m_hWnd)
		m_TreeView.OnSetFocus();
	else if (hWnd == m_ListView.m_hWnd)
		m_ListView.OnSetFocus();
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnDeviceChange(BOOL bDevice, BOOL bStart)
{
	static BOOL bNoUpdate = FALSE;

	if (bStart)
	{
		KillTimer(m_hWnd, ID_TIMER_DEVICECHANGE);
		SetTimer(m_hWnd, ID_TIMER_DEVICECHANGE, TIMER_DEVICECHANGE_INT, NULL);
		if (bDevice) bNoUpdate = TRUE;
	}
	else
	{
		KillTimer(m_hWnd, ID_TIMER_DEVICECHANGE);

		//c[r[̍XV([gẑ)
		m_TreeView.SetCurrentFolder(_T(""), TRUE, FALSE);

		//Xgr[̍XV
		TCHAR szPath[MAX_PATH];
		_tcscpy(szPath, m_ListView.m_szCurrentFolder);

		//XVtOOFFyуpXȂꍇ
		if (!bNoUpdate || GetFileAttributes(szPath) == 0xFFFFFFFF)
		{
			//\tÕfBNgȂꍇAʃfBNgֈړ
			while (GetFileAttributes(szPath) == 0xFFFFFFFF)
			{
				LPTSTR lpszTemp = _tcsrchr(szPath, _T('\\'));
				if (lpszTemp)
					*lpszTemp = 0;
				else
					break;
			} // End of while

			//Xgr[̍XV([gֈړ)
			m_ListView.LoadFolderItem(szPath);
		}
		else if (!_tcslen(szPath) || _tcsicmp(szPath, GetRootName()) == 0)
		{
			//[g̏ꍇ
			//Xgr[̍XV
			m_ListView.LoadFolderItem(_T(""));
		}

		bNoUpdate = FALSE;
	}
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnBeginLabelEdit()
{
}

///////////////////////////////////////////////////////////////
void CMainWnd::OnEndLabelEdit()
{
}

///////////////////////////////////////////////////////////////
void CMainWnd::SetFont()
{
	int nHeight;
	float fpFontSize;
	HDC hDC;
	TEXTMETRIC tm;

	if (m_hFontFix)
	{
		if (m_hFontFix != m_hFont)
			DeleteObject(m_hFontFix);
		m_hFontFix = NULL;
	}
	if (m_hFont)
	{
		DeleteObject(m_hFont);
		m_hFont = NULL;
	}

	if (!m_bFontChange)
	{
		m_hFont = m_hFontFix = (HFONT)::GetStockObject(SYSTEM_FONT);
		if (m_bHighRresolutionMode && m_bHighDpiHardware)
		{
			hDC = GetDC(m_hWnd);
			GetTextMetrics(hDC, &tm);
			nHeight = (int)((float)tm.tmHeight / m_fpHighResolutionScale + 0.5);
			ReleaseDC(m_hWnd, hDC);
			m_hFont = MyCreateFont(nHeight, 0, NULL);
		}
	}
	else
	{
		hDC = GetDC(m_hWnd);
		GetTextMetrics(hDC, &tm);
		fpFontSize = (m_bHighRresolutionMode && m_bHighDpiHardware)? ((float)m_nFontSize / m_fpHighResolutionScale): (float)m_nFontSize;
		nHeight = (int)((fpFontSize * GetDeviceCaps(hDC, LOGPIXELSY)) / 72 + 0.5);
		ReleaseDC(m_hWnd, hDC);
		m_hFont = MyCreateFont(nHeight, DEFAULT_CHARSET, m_szFontName);
		m_hFontFix = MyCreateFont(tm.tmHeight, DEFAULT_CHARSET, m_szFontName);
	}

	SendMessage(m_ListView.m_hWnd, WM_SETFONT, (WPARAM)m_hFont, MAKELPARAM(TRUE, 0));
	SendMessage(m_TreeView.m_hWnd, WM_SETFONT, (WPARAM)m_hFont, MAKELPARAM(TRUE, 0));
	SendMessage(m_StatusWnd.m_hWnd, WM_SETFONT, (WPARAM)m_hFontFix, MAKELPARAM(TRUE, 0));
	SendMessage(m_CmdBands.m_hComboBox, WM_SETFONT, (WPARAM)m_hFontFix, MAKELPARAM(TRUE, 0));

	InvalidateRect(m_hWnd, NULL, FALSE);
}

///////////////////////////////////////////////////////////////
void CMainWnd::SetInputMode(int Mode)
{
	HKEY hKeyPs;
	DWORD dwValue;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY_PHONESTAT, 0, KEY_ALL_ACCESS, &hKeyPs) == ERROR_SUCCESS)
	{
		dwValue = Mode;
		RegSetValueEx(hKeyPs, _T("Status22"), 0, REG_DWORD, (LPBYTE)&dwValue, sizeof(DWORD));
		RegCloseKey(hKeyPs);
	}
}

///////////////////////////////////////////////////////////////
DWORD CMainWnd::GetInputMode()
{
	HKEY hKeyPs;
	DWORD dwSize, dwValue;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY_PHONESTAT, 0, KEY_ALL_ACCESS, &hKeyPs) == ERROR_SUCCESS)
	{
		dwSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKeyPs, _T("Status22"), NULL, NULL, (LPBYTE)&dwValue, &dwSize) != ERROR_SUCCESS)
			dwValue = INPUTMODE_HAN_NUMERIC;//ERROR
		RegCloseKey(hKeyPs);

		return dwValue;
	}

	return INPUTMODE_HAN_NUMERIC;//ERROR
}

///////////////////////////////////////////////////////////////
void CMainWnd::SaveInputMode()
{
	m_dwInputMode = GetInputMode();
}

///////////////////////////////////////////////////////////////
void CMainWnd::RestoreInputMode()
{
	SetInputMode(m_dwInputMode);
}
