///////////////////////////////////////////////////////////////
//Association.cpp
//֘At - CApplicationList, CAssociation

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "Association.h"
#include "FolderDlgPPC.h"

///////////////////////////////////////////////////////////////
//EBhEvV[W(vȎI)
LRESULT CALLBACK ChooseProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CAssociation* pca = (CAssociation*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCAssociatioñCX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pca = (CAssociation*)lParam;
		//
		pca->m_hWnd = hDlg;
		pca->m_hListView = GetDlgItem(hDlg, IDC_LIST_APP);
		pca->OnInitChoose();
		break;

	case WM_SIZE:
		pca->OnSizeChoose();
		break;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDOK:
				//OK{^
				pca->OnOKChoose();
				EndDialog(hDlg, (INT)TRUE);
				return TRUE;

			case IDCANCEL:
				//LZ{^
				EndDialog(hDlg, (INT)FALSE);
				return TRUE;

			case IDC_BTN_BROWSE:
				//Qƃ{^
				pca->OnBrowseChoose();
				break;

			default:
				break;
			}
		}
		break;

	case WM_DESTROY:
		pca->OnEndChoose();
		break;

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

	return FALSE;
}
///////////////////////////////////////////////////////////////
//EBhEvV[W(t@C̎ރIvV)
LRESULT CALLBACK PPOptionFiletypeProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CAssociation* pca = (CAssociation*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//CAssociatioñCX^X𐶐USERDATAɊi[
		pca = new CAssociation(g_MainWnd.m_hWnd, g_hInst);
		SetWindowLong(hDlg, GWL_USERDATA, (LONG)pca);
		//
		pca->m_hWnd = hDlg;
		pca->m_hListView2 = GetDlgItem(hDlg, IDC_LIST_TYPE);
		pca->OnInitFiletype();
		break;

	case WM_SIZE:
		pca->OnSizeFiletype();
		break;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDC_BTN_NEW:
				//VK{^
				pca->OpenNewFiletype();
				pca->OnClickFiletype();
				break;

			case IDC_BTN_DEL:
				//폜{^
				pca->OpenDeleteFiletype();
				pca->OnClickFiletype();
				break;

			case IDC_BTN_DETAIL:
				//ڍאݒ{^
				pca->OpenDetailSetting();
				pca->OnClickFiletype();
				break;

			default:
				break;
			}
		}
		break;

	case WM_NOTIFY:
		{
			LPNMHDR pNmHdr = (LPNMHDR)lParam;
			switch (pNmHdr->code)
			{
			case NM_CLICK:
				//VONbN
				pca->OnClickFiletype();
				break;

			case NM_DBLCLK:
			case NM_RCLICK:
				//_uNbN/ENbN
				pca->OpenDetailSetting();
				break;

			case LVN_COLUMNCLICK:
				//JNbN
				pca->OnColumnClick((LPNMLISTVIEW)lParam);
				break;

			case LVN_ITEMCHANGED:
				//IĂACeς
				pca->OnClickFiletype();
				break;

			default:
				break;
			}
		}
		break;

	case WM_DESTROY:
		pca->OnEndFiletype();
		delete pca;
		break;

	case WM_PAINT:
		return DefDlgPaintProc(hDlg, wParam, lParam);

	case WM_CTLCOLORSTATIC:
		return DefDlgCtlColorStaticProc(hDlg, wParam, lParam);

	default:
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
//EBhEvV[W(t@C̎ރIvV-VK)
LRESULT CALLBACK NewFiletypeProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CAssociation* pca = (CAssociation*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCAssociatioñCX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pca = (CAssociation*)lParam;
		//
		pca->OnInitNewFiletype(hDlg);
		break;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDOK:
				{
					//OK{^
					BOOL bRtn = pca->OnOKNewFiletype(hDlg);
					EndDialog(hDlg, (INT)bRtn);
					SetFocus(pca->m_hWnd);
				}
				return TRUE;

			case IDCANCEL:
				//LZ{^
				EndDialog(hDlg, (INT)FALSE);
				SetFocus(pca->m_hWnd);
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_DESTROY:
		break;

	default:
		break;
	}

	return FALSE;
}

///////////////////////////////////////////////////////////////
//EBhEvV[W(t@C̎ރIvV-ڍאݒ)
LRESULT CALLBACK DetailFiletypeProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CAssociation* pca = (CAssociation*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCAssociatioñCX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pca = (CAssociation*)lParam;
		//
		pca->OnInitDetailSetting(hDlg);
		break;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDC_BTN_CHANGE:
				//ύX{^
				pca->OnChangeDetailSetting(hDlg);
				break;

			case IDOK:
				{
					//OK{^
					BOOL bRtn = pca->OnOKDetailSetting(hDlg);
					if (bRtn)
						EndDialog(hDlg, (INT)TRUE);
					return bRtn;
				}
				//break;

			case IDCANCEL:
				//LZ{^
				EndDialog(hDlg, (INT)FALSE);
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_DESTROY:
		break;

	default:
		break;
	}
	return FALSE;
}

///////////////////////////////////////////////////////////////
int CALLBACK SortFileExt(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	CApplicationList* pList1 = (CApplicationList*)lParam1;
	CApplicationList* pList2 = (CApplicationList*)lParam2;

	BOOL bRaise = (BOOL)lParamSort;

	return bRaise? _tcsicmp(pList1->getExt(), pList2->getExt()): _tcscmp(pList2->getExt(), pList1->getExt());
}

///////////////////////////////////////////////////////////////
int CALLBACK SortAppName(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
	CApplicationList* pList1 = (CApplicationList*)lParam1;
	CApplicationList* pList2 = (CApplicationList*)lParam2;

	BOOL bRaise = (BOOL)lParamSort;

	return bRaise? _tcsicmp(pList1->getAppName(), pList2->getAppName()): _tcscmp(pList2->getAppName(), pList1->getAppName());
}

///////////////////////////////////////////////////////////////
CApplicationList::CApplicationList()
{
}

///////////////////////////////////////////////////////////////
CApplicationList::CApplicationList(LPTSTR szExt, LPTSTR szKeyName, LPTSTR szAppName, LPTSTR szAppPath, LPTSTR szCommand, LPTSTR szIconPath, int IconID, int ImageIndex, CApplicationList* AlPrev)
{
	lpszExt = NULL;
	lpszKeyName = NULL;
	lpszAppName = NULL;
	lpszAppPath = NULL;
	lpszCommand = NULL;
	lpszIconPath = NULL;
	setExt(szExt);
	setKeyName(szKeyName);
	setAppName(szAppName);
	setAppPath(szAppPath);
	setCommand(szCommand);
	setIconPath(szIconPath);
	setIconID(IconID);
	setImageIndex(ImageIndex);
	nIconID = IconID;
	nImageIndex = ImageIndex;
	lpNext = NULL;
	if (AlPrev)
		AlPrev->lpNext = this;
}

///////////////////////////////////////////////////////////////
CApplicationList::~CApplicationList()
{
	delete[] lpszExt;
	delete[] lpszKeyName;
	delete[] lpszAppName;
	delete[] lpszAppPath;
	delete[] lpszCommand;
	delete[] lpszIconPath;
	delete lpNext;
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getExt()
{
	return lpszExt? lpszExt: _T("");
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getKeyName()
{
	return lpszKeyName? lpszKeyName: _T("");
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getAppName()
{
	return lpszAppName? lpszAppName: _T("");
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getAppPath()
{
	return lpszAppPath? lpszAppPath: _T("");
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getCommand()
{
	return lpszCommand? lpszCommand: _T("");
}

///////////////////////////////////////////////////////////////
LPTSTR CApplicationList::getIconPath()
{
	return lpszIconPath? lpszIconPath: _T("");
}

///////////////////////////////////////////////////////////////
int CApplicationList::getIconID()
{
	return nIconID;
}

///////////////////////////////////////////////////////////////
int CApplicationList::getImageIndex()
{
	return nImageIndex;
}

///////////////////////////////////////////////////////////////
CApplicationList* CApplicationList::getNext()
{
	return lpNext;
}

///////////////////////////////////////////////////////////////
void CApplicationList::setExt(LPTSTR szExt)
{
	delete[] lpszExt;
	if (szExt && _tcslen(szExt))
	{
		lpszExt = new TCHAR[_tcslen(szExt) + 1];
		_tcscpy(lpszExt, szExt);
	}
	else
	{
		lpszExt = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setKeyName(LPTSTR szKeyName)
{
	delete[] lpszKeyName;
	if (szKeyName && _tcslen(szKeyName))
	{
		lpszKeyName = new TCHAR[_tcslen(szKeyName) + 1];
		_tcscpy(lpszKeyName, szKeyName);
	}
	else
	{
		lpszKeyName = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setAppName(LPTSTR szAppName)
{
	delete[] lpszAppName;
	if (szAppName && _tcslen(szAppName))
	{
		lpszAppName = new TCHAR[_tcslen(szAppName) + 1];
		_tcscpy(lpszAppName, szAppName);
	}
	else
	{
		lpszAppName = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setAppPath(LPTSTR szAppPath)
{
	delete[] lpszAppPath;
	if (szAppPath && _tcslen(szAppPath))
	{
		lpszAppPath = new TCHAR[_tcslen(szAppPath) + 1];
		_tcscpy(lpszAppPath, szAppPath);
	}
	else
	{
		lpszAppPath = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setCommand(LPTSTR szCommand)
{
	delete[] lpszCommand;
	if (szCommand && _tcslen(szCommand))
	{
		lpszCommand = new TCHAR[_tcslen(szCommand) + 1];
		_tcscpy(lpszCommand, szCommand);
	}
	else
	{
		lpszCommand = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setIconPath(LPTSTR szIconPath)
{
	delete[] lpszIconPath;
	if (szIconPath && _tcslen(szIconPath))
	{
		lpszIconPath = new TCHAR[_tcslen(szIconPath) + 1];
		_tcscpy(lpszIconPath, szIconPath);
	}
	else
	{
		lpszIconPath = NULL;
	}
}

///////////////////////////////////////////////////////////////
void CApplicationList::setIconID(int IconID)
{
	nIconID = IconID;
}

///////////////////////////////////////////////////////////////
void CApplicationList::setImageIndex(int ImageIndex)
{
	nImageIndex = ImageIndex;
}

///////////////////////////////////////////////////////////////
void CApplicationList::setNext(CApplicationList* Next)
{
	lpNext = Next;
}

///////////////////////////////////////////////////////////////
CAssociation::CAssociation(HWND hWnd, HINSTANCE hInst)
{
	//oϐ
	m_lpAppList = NULL;
	m_hImageList = 0;
	m_nbSortRaise = TRUE;

	//p[^̕ۑ
	m_hparWnd = hWnd;
	m_hInst = hInst;
}

///////////////////////////////////////////////////////////////
CAssociation::~CAssociation()
{
}

///////////////////////////////////////////////////////////////
void CAssociation::CreateAppList()
{
	//O쐬Xg̍폜
	DeleteAppList();

	CApplicationList* lpList = NULL;
	for (int i=0; ;i++)
	{
		TCHAR szTemp[MAX_PATH];
		TCHAR szSubKey[MAX_PATH];
		TCHAR szAppName[MAX_PATH];
		TCHAR szAppPath[MAX_PATH];
		TCHAR szCommand[MAX_PATH];
		DWORD dwDataSize;

		//L[̎擾
		dwDataSize = sizeof(szSubKey)/sizeof(TCHAR);
		if (ERROR_SUCCESS != RegEnumKeyEx(HKEY_CLASSES_ROOT, i, szSubKey, &dwDataSize, NULL, NULL, NULL, NULL))
			break;

		HKEY hKeyWk = 0;
		//L[gq̏ꍇ
		if (szSubKey[0] == _T('.'))
		{
			//vȂꍇ͖
			if (0 != _tcsicmp(szSubKey, m_lpszExt))
				continue;
			
			//֘AtAvP[V()擾
			//HKEY_CLASSES_ROOT-gq-()
			if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szSubKey, 0, 0, &hKeyWk))
				continue;

			m_szExtType[0] = _T('\0');
			dwDataSize = sizeof(m_szExtType);
			if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(m_szExtType), &dwDataSize))
			{
				RegCloseKey(hKeyWk);
				continue;
			}
			RegCloseKey(hKeyWk);
		}

		//L[l̎擾
		TCHAR szBuf[MAX_PATH];
		_stprintf(szBuf, _T("%s\\Shell\\Open\\Command"), szSubKey);

		//R}hC擾
		//HKEY_CLASSES_ROOT-AvP[V-Shell-Open-Command-()
		if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szBuf, 0, 0, &hKeyWk))
			continue;

		dwDataSize = sizeof(szTemp);
		if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szTemp), &dwDataSize))
		{
			RegCloseKey(hKeyWk);
			continue;
		}
		RegCloseKey(hKeyWk);

		//AvP[V
		//HKEY_CLASSES_ROOT-AvP[V-()
		hKeyWk = 0;
		if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szSubKey, 0, 0, &hKeyWk))
			continue;

		dwDataSize = sizeof(szAppName);
		if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szAppName), &dwDataSize))
		{
			RegCloseKey(hKeyWk);
			continue;
		}
		RegCloseKey(hKeyWk);

		//o^
		LPTSTR lpszStart = szTemp;
		LPTSTR lpszEnd;
		if (lpszStart[0] == _T('\"'))
		{
			lpszStart++;
			lpszEnd=_tcschr(lpszStart, _T('\"'));
			if (!lpszEnd)
				continue;
		}
		else
			lpszEnd=_tcschr(lpszStart, _T(' '));
		if (lpszEnd)
		{
			*lpszEnd=0;
			lpszEnd++;
		}
		else
			lpszEnd=_T("");

		//]ȋ󔒂폜
		while (*lpszEnd == _T(' '))
		{
			lpszEnd++;
		}
		_tcscpy(szCommand, lpszEnd);
		_tcscpy(szAppPath, lpszStart);

		//pXȂꍇ"\Windows"tH_Ƃ
		if (0 != _tcslen(szAppPath) && !_tcschr(szAppPath, _T('\\')))
		{
			TCHAR szAppBuf[MAX_PATH];
			_tcscpy(szAppBuf, szAppPath);
			_stprintf(szAppPath, _T("%s\\%s"), g_MainWnd.m_szWindowsPath, szAppBuf);
		}
		//AvP[VȂꍇ͖
		if (GetFileAttributes(szAppPath) == 0xFFFFFFFF)
			continue;

		//擾f[^i[ & Xg̘A
		lpList = new CApplicationList(NULL,szSubKey,szAppName,szAppPath,szCommand,NULL,0,0,lpList);

		//擪AhXۑ
		if (!m_lpAppList) m_lpAppList = lpList;
	}

	return;
}

///////////////////////////////////////////////////////////////
void CAssociation::CreateAppList2()
{
	//O쐬Xg̍폜
	DeleteAppList();

	CApplicationList* lpList = NULL;
	for (int i=0; ;i++)
	{
		TCHAR szTemp[MAX_PATH];
		TCHAR szSubKey[MAX_PATH];
		TCHAR szExt[MAX_PATH];
		TCHAR szAppName[MAX_PATH];
		TCHAR szAppPath[MAX_PATH];
		TCHAR szCommand[MAX_PATH];
		TCHAR szIconPath[MAX_PATH];
		DWORD dwDataSize;
		int nIconID;

		//L[̎擾
		dwDataSize = sizeof(szSubKey)/sizeof(TCHAR);
		if (ERROR_SUCCESS != RegEnumKeyEx(HKEY_CLASSES_ROOT, i, szSubKey, &dwDataSize, NULL, NULL, NULL, NULL))
			break;

		//L[gqȊȌꍇ͖
		if (szSubKey[0] != _T('.'))
			continue;

		HKEY hKeyWk = 0;
		//֘AtAvP[V()擾
		//HKEY_CLASSES_ROOT-gq-()
		if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szSubKey, 0, 0, &hKeyWk))
			continue;
		_tcscpy(szExt, szSubKey);

		dwDataSize = sizeof(szSubKey);
		if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szSubKey), &dwDataSize))
		{
			RegCloseKey(hKeyWk);
			continue;
		}
		RegCloseKey(hKeyWk);

		//L[l̎擾
		TCHAR szBuf[MAX_PATH];
		_stprintf(szBuf, _T("%s\\Shell\\Open\\Command"), szSubKey);

		//R}hC擾
		//HKEY_CLASSES_ROOT-AvP[V-Shell-Open-Command-()
		if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szBuf, 0, 0, &hKeyWk))
			continue;

		dwDataSize = sizeof(szTemp);
		if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szTemp), &dwDataSize))
		{
			RegCloseKey(hKeyWk);
			continue;
		}
		RegCloseKey(hKeyWk);

		//AvP[V
		//HKEY_CLASSES_ROOT-AvP[V-()
		hKeyWk = 0;
		if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, szSubKey, 0, 0, &hKeyWk))
			continue;

		dwDataSize = sizeof(szAppName);
		if (ERROR_SUCCESS != RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szAppName), &dwDataSize))
		{
			RegCloseKey(hKeyWk);
			continue;
		}
		RegCloseKey(hKeyWk);

		//ACRID(\[XID)
		//HKEY_CLASSES_ROOT-AvP[V-DefaultIcon
		_stprintf(szBuf, _T("%s\\DefaultIcon"), szSubKey);
		hKeyWk = 0;
		szIconPath[0] = _T('\0');
		nIconID = 0;
		if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT, szBuf, 0, 0, &hKeyWk))
		{
			TCHAR szIconBuf[MAX_PATH];
			dwDataSize = sizeof(szIconBuf);
			if (ERROR_SUCCESS == RegQueryValueEx(hKeyWk, _T(""), 0, NULL, LPBYTE(szIconBuf), &dwDataSize))
			{
				LPTSTR lpszTemp = _tcsrchr(szIconBuf, _T(','));
				if (lpszTemp)
				{
					*lpszTemp = _T('\0');
					_tcscpy(szIconPath, szIconBuf);
					nIconID = _tcstol((lpszTemp+1), 0, 10);
				}
			}
			RegCloseKey(hKeyWk);
		}

		//o^
		LPTSTR lpszStart = szTemp;
		LPTSTR lpszEnd;
		if (lpszStart[0] == _T('\"'))
		{
			lpszStart++;
			lpszEnd = _tcschr(lpszStart, _T('\"'));
			if (!lpszEnd)
				continue;
		}
		else
			lpszEnd = _tcschr(lpszStart, _T(' '));
		if (lpszEnd)
		{
			*lpszEnd = _T('\0');
			lpszEnd++;
		}
		else
			lpszEnd = _T("");


		//]ȋ󔒂폜
		while (*lpszEnd == _T(' '))
		{
			lpszEnd++;
		}
		_tcscpy(szCommand, lpszEnd);
		_tcscpy(szAppPath, lpszStart);

		//pXȂꍇ"\Windows"tH_Ƃ
		if (0 != _tcslen(szAppPath) && !_tcschr(szAppPath, _T('\\')))
		{
			TCHAR szAppBuf[MAX_PATH];
			_tcscpy(szAppBuf, szAppPath);
			_stprintf(szAppPath, _T("%s\\%s"), g_MainWnd.m_szWindowsPath, szAppBuf);
		}
		if (0 != _tcslen(szIconPath) && !_tcschr(szIconPath, _T('\\')))
		{
			TCHAR szAppBuf[MAX_PATH];
			_tcscpy(szAppBuf, szIconPath);
			_stprintf(szIconPath, _T("%s\\%s"), g_MainWnd.m_szWindowsPath, szAppBuf);
		}
		//AvP[VȂꍇ͖
		if (GetFileAttributes(szAppPath) == 0xFFFFFFFF)
			continue;

		//擾f[^i[ & Xg̘A
		lpList = new CApplicationList(szExt+1,szSubKey,szAppName,szAppPath,szCommand,szIconPath,nIconID,0,lpList);

		//擪AhXۑ
		if (!m_lpAppList)
			m_lpAppList = lpList;
	}

	return;
}

///////////////////////////////////////////////////////////////
void CAssociation::DeleteAppList()
{
	delete m_lpAppList;
	m_lpAppList = NULL;

	return;
}

///////////////////////////////////////////////////////////////
BOOL CAssociation::SetApplication(LPTSTR lpszPath, LPTSTR lpszKeyName, LPTSTR lpszAppName, LPTSTR lpszParam, LPTSTR lpszIconPath, int nIconID)
{
	//EBhEYtH_̏ꍇ̓pX폜
	TCHAR szPath[MAX_PATH];
	_tcscpy(szPath, lpszPath);
	LPTSTR lpszTemp = _tcsrchr(szPath, _T('\\'));
	if (lpszTemp)
	{
		*lpszTemp = _T('\0');
		if (0 == _tcsicmp(g_MainWnd.m_szWindowsPath, szPath))
			lpszPath = ++lpszTemp;
	}

	//L[쐬
	TCHAR szKeyName[MAX_PATH];
	memset(szKeyName, 0, sizeof(szKeyName));
	if (lpszKeyName)
		_tcscpy(szKeyName, lpszKeyName);
	else
	{
		//pX̕
		LPTSTR lpszStart = _tcsrchr(lpszPath, _T('\\'));
		if (!lpszStart)
			lpszStart = lpszPath;
		else
			lpszStart++;

		LPTSTR lpszEnd = _tcsrchr(lpszStart, _T('.'));
		if (lpszEnd)
			_tcsncpy(szKeyName, lpszStart, (lpszEnd-lpszStart));
		else
			_tcscpy(szKeyName, lpszStart);
	}

	//AvP[V
	TCHAR szAppName[MAX_PATH];
	memset(szAppName, 0, sizeof(szAppName));
	_tcscpy(szAppName, (lpszAppName? lpszAppName: szKeyName));

	//R}hC
	TCHAR szCommand[MAX_PATH];
	lpszTemp = _tcschr(lpszPath, _T(' '));
	if (lpszTemp)
	{
		//R}hC쐬("t@C" "%1")
		_stprintf(szCommand, _T("\"%s\" %s"),
			lpszPath, (lpszParam? lpszParam: _T("\"%1\"")));
	}
	else
	{
		//R}hC쐬(t@C "%1")
		_stprintf(szCommand, _T("%s %s"),
			lpszPath, (lpszParam? lpszParam: _T("\"%1\"")));
	}

	//ftHgACR
	TCHAR szDefaultIcon[MAX_PATH];
	_stprintf(szDefaultIcon, _T("%s,%d"), (lpszIconPath? lpszIconPath: lpszPath), nIconID);

	HKEY hKey;
	DWORD dwDisposition;
	//WXgo^
	//WXg[L[̃I[v1
	//HKEY_CLASSES_ROOT-L[
	if (ERROR_SUCCESS != RegCreateKeyEx(HKEY_CLASSES_ROOT, szKeyName, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition))
		return FALSE;

	//WXg̓o^1
	//HKEY_CLASSES_ROOT-L[-()"AvP[V"
	RegSetValueEx(hKey, _T(""), 0, REG_SZ, (LPBYTE)szAppName, ((_tcslen(szAppName)+1)  * sizeof(TCHAR)));

	//WXgL[̃N[Y1
	RegCloseKey(hKey);

	//WXg[L[̃I[v2
	//HKEY_CLASSES_ROOT-L[-Shell-Open-Command
	TCHAR szBuf[MAX_PATH];
	_stprintf(szBuf, _T("%s\\Shell\\Open\\Command"), szKeyName);
	if (ERROR_SUCCESS != RegCreateKeyEx(HKEY_CLASSES_ROOT, szBuf, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition))
		return FALSE;

	//WXg̓o^2
	//HKEY_CLASSES_ROOT-L[-Shell-Open-Command-()"R}h"
	RegSetValueEx(hKey, _T(""), 0, REG_SZ, (LPBYTE)szCommand, ((_tcslen(szCommand)+1)  * sizeof(TCHAR)));

	//WXgL[̃N[Y2
	RegCloseKey(hKey);

	//WXg[L[̃I[v3
	//HKEY_CLASSES_ROOT-L[-DefaultIcon
	_stprintf(szBuf, _T("%s\\DefaultIcon"), szKeyName);
	if (ERROR_SUCCESS != RegCreateKeyEx(HKEY_CLASSES_ROOT, szBuf, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition))
		return FALSE;

	//WXg̓o^3
	//HKEY_CLASSES_ROOT-L[-DefaultIcon-()"R}h"
	RegSetValueEx(hKey, _T(""), 0, REG_SZ, (LPBYTE)szDefaultIcon, ((_tcslen(szDefaultIcon)+1)  * sizeof(TCHAR)));

	//WXgL[̃N[Y3
	RegCloseKey(hKey);

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CAssociation::SetAssociation(LPTSTR lpszKeyName)
{
	HKEY hKey;
	DWORD dwDisposition;
	//WXg[L[̃I[v
	//HKEY_CLASSES_ROOT-gq
	if (ERROR_SUCCESS != RegCreateKeyEx(HKEY_CLASSES_ROOT, m_lpszExt, 0,
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition))
		return FALSE;

	//WXg̓o^1
	//HKEY_CLASSES_ROOT-gq-()"L["
	RegSetValueEx(hKey, _T(""), 0, REG_SZ, (LPBYTE)lpszKeyName, ((_tcslen(lpszKeyName)+1)  * sizeof(TCHAR)));

	//WXgL[̃N[Y1
	RegCloseKey(hKey);

	return TRUE;
}

///////////////////////////////////////////////////////////////
BOOL CAssociation::DeleteSubKey(LPTSTR lpszSubKey)
{
	HKEY hKey;
	//WXgL[I[v
	//HKEY_CLASSES_ROOT-wTuL[(gq)
	if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT,lpszSubKey,0,KEY_ALL_ACCESS,&hKey))
		return FALSE;

	//TuL[
	for (int i=0; ;i++)
	{
		TCHAR szSubKey[MAX_PATH];
		TCHAR szTemp[MAX_PATH];

		//TuL[̎擾
		DWORD dwDataSize = sizeof(szSubKey)/sizeof(TCHAR);
		if (ERROR_SUCCESS != RegEnumKeyEx(hKey, i, szSubKey, &dwDataSize, NULL, NULL, NULL, NULL))
			break;

		//ċNĂяo(TuL[̃TuL[폜)
		_stprintf(szTemp, _T("%s\\%s"), lpszSubKey, szSubKey);
		DeleteSubKey(szSubKey);
	}

	//WXgL[̃N[Y
	RegCloseKey(hKey);

	//WXgL[I[v
	//HKEY_CLASSES_ROOT
	if (ERROR_SUCCESS != RegOpenKeyEx(HKEY_CLASSES_ROOT, _T(""), 0, KEY_ALL_ACCESS, &hKey))
		return FALSE;

	//WXgTuL[폜
	//HKEY_CLASSES_ROOT-wTuL[(gq)
	LONG nRtn = RegDeleteKey(hKey, lpszSubKey);

	//WXgL[̃N[Y
	RegCloseKey(hKey);

	return (nRtn == ERROR_SUCCESS? TRUE: FALSE);
}

///////////////////////////////////////////////////////////////
void CAssociation::InitAppImageList(HWND hList)
{
	//C[WXg̍폜
	ImageList_RemoveAll(m_hImageList);
	ImageList_Destroy(m_hImageList);

	//C[WXg̍쐬
	int is = GetSystemMetrics(SM_CXSMICON);
	m_hImageList = ImageList_Create(is, is, ILC_COLOR|ILC_MASK, 1, 2);

	//C[WXg̐ݒ
	ListView_SetImageList(hList, m_hImageList, LVSIL_SMALL);

	CApplicationList* lpList = m_lpAppList;
	while (lpList)
	{
		//C[WXg֒ǉ
		SHFILEINFO shfi;
		SHGetFileInfo(lpList->getAppPath(), NULL, &shfi, sizeof(shfi), SHGFI_SMALLICON|SHGFI_ICON);
		lpList->setImageIndex(ImageList_AddIcon(m_hImageList, shfi.hIcon));

		DestroyIcon(shfi.hIcon);

		lpList = lpList->getNext();
	}//End of while
}

///////////////////////////////////////////////////////////////
void CAssociation::DeleteAppImageList()
{
	//C[WXg̍폜
	if (0 != m_hImageList)
	{
		ImageList_RemoveAll(m_hImageList);
		ImageList_Destroy(m_hImageList);
	}
}
///////////////////////////////////////////////////////////////
void CAssociation::LoadAppList(LPTSTR szSelectAppPath)
{
	//\
	ShowWindow(m_hListView, SW_HIDE);

	//Xg̍폜
	ListView_DeleteAllItems(m_hListView);

	//C[WXg쐬
	InitAppImageList(m_hListView);

	CApplicationList* lpList = m_lpAppList;
	for (int i=0; lpList; i++)
	{
		//ACe̒ǉ
		LVITEM lvitem;
		lvitem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		lvitem.iItem = i;
		lvitem.iSubItem = 0;
		lvitem.iImage = lpList->getImageIndex();
		lvitem.lParam = (DWORD)lpList;
		lvitem.pszText = lpList->getAppName();
		int nIndex = ListView_InsertItem(m_hListView, &lvitem);

		if ((szSelectAppPath && 0 == _tcsicmp(szSelectAppPath, lpList->getAppPath())) ||
		   (!szSelectAppPath && 0 == _tcsicmp(m_szExtType, lpList->getKeyName())))
			ListView_SetItemState(m_hListView, nIndex, LVIS_SELECTED, LVIS_SELECTED);

		lpList = lpList->getNext();
	}
	
	//ʂXN[IACe\
	int nItem = ListView_GetNextItem(m_hListView, -1, LVNI_ALL|LVNI_SELECTED);
	if (nItem >= 0)
		ListView_EnsureVisible(m_hListView, nItem, FALSE);

	//\
	ShowWindow(m_hListView, SW_SHOW);

	SetFocus(m_hListView);
}

///////////////////////////////////////////////////////////////
void CAssociation::LoadAppList2()
{
	//\
	ShowWindow(m_hListView2, SW_HIDE);

	//Xg̍폜
	ListView_DeleteAllItems(m_hListView2);

	//C[WXg쐬
	InitAppImageList(m_hListView2);

	CApplicationList* lpList = m_lpAppList;
	for (int i=0; lpList; i++)
	{
		//ACe̒ǉ
		LVITEM lvitem;
		lvitem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		lvitem.iItem = i;
		lvitem.iSubItem = 0;
		lvitem.iImage = lpList->getImageIndex();
		lvitem.lParam = (DWORD)lpList;
		lvitem.pszText = lpList->getExt();
		int nIndex = ListView_InsertItem(m_hListView2, &lvitem);
		ListView_SetItemText(m_hListView2, nIndex, 1, lpList->getAppName());
		
		lpList = lpList->getNext();
	}

	//\
	ShowWindow(m_hListView2, SW_SHOW);

	SetFocus(m_hListView2);
}

///////////////////////////////////////////////////////////////
CApplicationList* CAssociation::GetSelectItem(HWND hList, int nSubItem, int nType)
{
	//IACe
	int nItem = ListView_GetNextItem(hList, -1, LVNI_ALL|LVNI_SELECTED);
	if (nItem == -1)
		return NULL;

	//ACe擾
	TCHAR szBuf[MAX_PATH];
	ListView_GetItemText(hList, nItem, nSubItem, szBuf, sizeof(szBuf));

	//AvP[VI
	nItem = -1;
	CApplicationList* lpList = m_lpAppList;
	for (int i=0; lpList; i++)
	{
		if (nType == FINDTYPE_APPNAME &&
		   0 == _tcscmp(szBuf, lpList->getAppName()))
		{
			nItem = i;
			break;
		}
		if (nType == FINDTYPE_EXT &&
		   0 == _tcscmp(szBuf, lpList->getExt()))
		{
			nItem = i;
			break;
		}
		lpList = lpList->getNext();
	}//End of for

	//ACeȂ(oO)
	if (-1 == nItem) return NULL;

	return lpList;
}

///////////////////////////////////////////////////////////////
int CAssociation::OpenChoose(LPTSTR lpszPath, LPTSTR lpszName, BOOL bReg, BOOL bOpen)
{
	//p[^̕ۑ
	if (lpszPath)
		_tcscpy(m_szCurrent, lpszPath);
	else
		m_szCurrent[0] = _T('\0');
	_tcscpy(m_szName, lpszName);
	m_lpszExt = _tcsrchr(m_szName, _T('.'));
	m_bReg = bReg;
	m_bOpen = bOpen;

	//gq̎擾Ɏs
	if (!m_lpszExt)
		return FALSE;

	//EBhE쐬
	int rtn =  DialogBoxParam(m_hInst, (LPCTSTR)IDD_CHOOSE_DLG,
				m_hparWnd, (DLGPROC)ChooseProc, LPARAM(this));

	return rtn;
}

///////////////////////////////////////////////////////////////
void CAssociation::OnInitChoose()
{
	SHINITDLGINFO shidi;
	shidi.dwMask = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIZEDLGFULLSCREEN;
	shidi.hDlg = m_hWnd;
	SHINITDIALOG(&shidi);

	if (!g_MainWnd.m_bIsSmartphone)	//Smartphone/Standard̏ꍇPPC2SPLIBɔĈŕsv
	{
		//j[o[ǉ
		SHMENUBARINFO mbi;
		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize = sizeof(SHMENUBARINFO);
		mbi.hwndParent = m_hWnd;
		mbi.nToolBarId = IDR_CHOOSEPROG;
		mbi.hInstRes = g_hInst;
		mbi.nBmpId = 0;
		mbi.cBmpImages = 0;
		SHCreateMenuBar(&mbi);
	}

	//TCY (ListView)
	OnSizeChoose();

	//EBhE^Cg
	SetWindowText(m_hWnd, APP_MAINWND_TITLE);

	//EBhE
	//Jwb_̍쐬
	RECT rc;
	GetClientRect(m_hListView, &rc);
	
	LVCOLUMN lvclm;
	lvclm.mask = LVCF_FMT|LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;
	lvclm.fmt = LVCFMT_LEFT;
	lvclm.cx = rc.right - rc.left;
	lvclm.pszText = _T("");
	lvclm.cchTextMax = 0;
	lvclm.iSubItem = 0;
	ListView_InsertColumn(m_hListView, 0, &lvclm);

	//֘At`FbNݒ
	if (m_bReg)
	{
		HWND hChk = GetDlgItem(m_hWnd, IDC_CHK_ASSOCIATION);
		SendMessage(hChk, BM_SETCHECK, (m_bReg? 1: 0), 0);
		EnableWindow(hChk, FALSE);
	}

	//AvP[VXg쐬
	CreateAppList();

	//Xgr[ݒ
	LoadAppList();
}

///////////////////////////////////////////////////////////////
void CAssociation::OnEndChoose()
{
	//C[WXg폜
	DeleteAppImageList();
	
	//AvP[VXg폜
	DeleteAppList();
}

///////////////////////////////////////////////////////////////
void CAssociation::OnBrowseChoose()
{
	TCHAR szFile[MAX_PATH] = _T("");
	
	//tH_/t@Cw_CAOI[v
	CFolderDlg fd;
	int nRet = fd.ShowFileDlg(GetResourceString(IDS_OPEN_APP), szFile, sizeof(szFile), _T("*.exe"));
	if (nRet == IDOK)
	{
		//AvP[V̓o^
		if (!SetApplication(szFile))
			return;

		//AvP[VXg쐬
		CreateAppList();

		//Xgr[ݒ
		LoadAppList(szFile);
	}
	return;
}

///////////////////////////////////////////////////////////////
void CAssociation::OnOKChoose()
{
	//IACe擾
	CApplicationList* lpList = GetSelectItem(m_hListView, 0);

	//ACeȂ(oO)
	if (!lpList) return;

	//֘At
	if (IsDlgButtonChecked(m_hWnd, IDC_CHK_ASSOCIATION))
		SetAssociation(lpList->getKeyName());

	//I[v`FbN(֘At݂̂̏ꍇ̓I[vȂ)
	if (!m_bOpen) return;

	//I[vt@C쐬
	TCHAR szPath[MAX_PATH];
	if (0 != _tcslen(m_szCurrent))
		_stprintf(szPath, _T("%s\\%s"), m_szCurrent, m_szName);
	else
		_stprintf(szPath, _T("\\%s"), m_szName);

	//p[^̕ҏW
	TCHAR szBuf[MAX_PATH];
	LPTSTR lpszTemp = _tcsstr(lpList->getCommand(), _T("%1"));
	if (lpszTemp)
	{
		*(lpszTemp+1) = _T('s');
		_stprintf(szBuf, lpList->getCommand(), szPath);
	}
	else
		_tcscpy(szBuf, lpList->getCommand());

	//AvP[V̋N
	SHELLEXECUTEINFO sei;
	ZeroMemory(&sei, sizeof(SHELLEXECUTEINFO));
	sei.cbSize = sizeof(SHELLEXECUTEINFO);
	sei.hwnd = g_MainWnd.m_hWnd;
	sei.lpVerb = _T("open");
	sei.lpFile = lpList->getAppPath();
	sei.lpParameters = szBuf;
	sei.nShow = SW_SHOW;
	ShellExecuteEx(&sei);
}

///////////////////////////////////////////////////////////////
void CAssociation::OnInitFiletype()
{
	//J[\ɂ
	HCURSOR hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));

	//EBhE
	//Xgr[̍sI
	ListView_SetExtendedListViewStyle(m_hListView2,
		(ListView_GetExtendedListViewStyle(m_hListView2)|LVS_EX_FULLROWSELECT));

	//Jwb_̍쐬
	RECT rc;
	GetClientRect(m_hListView2, &rc);
	
	LVCOLUMN lvclm;
	lvclm.mask = LVCF_FMT|LVCF_WIDTH|LVCF_TEXT|LVCF_SUBITEM;
	lvclm.fmt = LVCFMT_LEFT;
	lvclm.cx = (int)(80*g_MainWnd.m_fpHighResolutionScale);
	lvclm.pszText = GetResourceString(IDS_COLUMN_OPT_EXT);
	lvclm.cchTextMax = 0;
	lvclm.iSubItem = 0;
	ListView_InsertColumn(m_hListView2, 0, &lvclm);
	lvclm.fmt = LVCFMT_LEFT;
	lvclm.cx = RECT_WIDTH(&rc) - (int)(80*g_MainWnd.m_fpHighResolutionScale);
	lvclm.pszText = GetResourceString(IDS_COLUMN_OPT_TYPE);
	lvclm.cchTextMax = 1;
	lvclm.iSubItem = 1;
	ListView_InsertColumn(m_hListView2, 1, &lvclm);

	//TCY
	OnSizeFiletype();

	//AvP[VXg쐬
	CreateAppList2();

	//Xgr[ݒ
	LoadAppList2();

	//{^ݒ
	OnClickFiletype();

	//J[\ɖ߂
	SetCursor(hCursor);
}

///////////////////////////////////////////////////////////////
void CAssociation::OnEndFiletype()
{
	//C[WXg폜
	DeleteAppImageList();
	
	//AvP[VXg폜
	DeleteAppList();
}

///////////////////////////////////////////////////////////////
void CAssociation::OnClickFiletype()
{
	if (ListView_GetSelectedCount(m_hListView2))
	{
		EnableWindow(GetDlgItem(m_hWnd, IDC_BTN_DEL), TRUE);
		EnableWindow(GetDlgItem(m_hWnd, IDC_BTN_DETAIL), TRUE);
	}
	else
	{
		EnableWindow(GetDlgItem(m_hWnd, IDC_BTN_DEL), FALSE);
		EnableWindow(GetDlgItem(m_hWnd, IDC_BTN_DETAIL), FALSE);
	}
}

///////////////////////////////////////////////////////////////
void CAssociation::OnChangeFiletype(LPTSTR lpszExt)
{
	TCHAR szExt[MAX_PATH];

	if (lpszExt)
		_tcscpy(szExt, lpszExt);
	else
	{
		//IACe擾
		CApplicationList* lpList = GetSelectItem(m_hListView2, 1);

		//ACeȂ(oO)
		if (!lpList) return;

		_stprintf(szExt, _T(".%s"), lpList->getExt());
	}

	//AvP[VI_CAO쐬
	CAssociation Dlg(m_hparWnd, m_hInst);
	int nRtn = Dlg.OpenChoose(_T(""), szExt, TRUE, FALSE);

	if (nRtn)
	{
		//AvP[VXg쐬
		CreateAppList2();

		//Xgr[ݒ
		LoadAppList2();
	}
}

///////////////////////////////////////////////////////////////
void CAssociation::OnSizeFiletype()
{
	RECT rcw, rc;
	POINT pt;
	int w, h;
	HWND hdi;

	GetWindowRect(m_hWnd, &rcw);

	//TCY (ListView)
	GetWindowRect(m_hListView2, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	w = RECT_WIDTH(&rcw);
	h = RECT_HEIGHT(&rcw) - pt.y - (int)(4*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(m_hListView2, pt.x, pt.y, w, h, TRUE);

	//TCY (ListView/Column)
	LVCOLUMN lvclm;
	lvclm.mask = LVCF_WIDTH;
	lvclm.cx = (int)(80*g_MainWnd.m_fpHighResolutionScale);
	ListView_SetColumn(m_hListView2, 0, &lvclm);
	lvclm.cx = RECT_WIDTH(&rcw) - (int)(80*g_MainWnd.m_fpHighResolutionScale);
	ListView_SetColumn(m_hListView2, 1, &lvclm);

	//ʒu (Button)
	hdi = GetDlgItem(m_hWnd, IDC_BTN_DETAIL);
	GetWindowRect(hdi, &rc);
	pt.x = 0;//dummy
	pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	pt.x = rcw.right;
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hdi, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hdi = GetDlgItem(m_hWnd, IDC_BTN_DEL);
	GetWindowRect(hdi, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hdi, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
	hdi = GetDlgItem(m_hWnd, IDC_BTN_NEW);
	GetWindowRect(hdi, &rc);
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hdi, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);
}

////////////////////////////////////////////////////////////////
void CAssociation::OnColumnClick(NMLISTVIEW* lpnmlv)
{
	m_nbSortRaise = !m_nbSortRaise;
	switch (lpnmlv->iSubItem)
	{
	case 0:
		ListView_SortItems(m_hListView2, SortFileExt, m_nbSortRaise);
		break;

	case 1:
		ListView_SortItems(m_hListView2, SortAppName, m_nbSortRaise);
		break;

	default:
		break;
	}
}

///////////////////////////////////////////////////////////////
void CAssociation::OpenNewFiletype()
{
	//EBhE쐬(gq̎擾)
	int rtn =  DialogBoxParam(m_hInst, (LPCTSTR)IDD_NEW_FILETYPE_DLG,
				m_hparWnd, (DLGPROC)NewFiletypeProc, LPARAM(this));

	//ꍇ
	if (rtn)
		OnChangeFiletype(m_szNewFileType);
	
	return;
}

///////////////////////////////////////////////////////////////
void CAssociation::OnInitNewFiletype(HWND hDlg)
{
	//EBhE^Cg
	SetWindowText(hDlg, GetResourceString(IDS_TITLE_NEWFILETYPE));

	//tH[JX̐ݒ
	SetFocus(GetDlgItem(hDlg, IDC_FITETYPE));

	//̓f[^i[̈̏
	memset(m_szNewFileType, 0, sizeof(m_szNewFileType));
}

///////////////////////////////////////////////////////////////
BOOL CAssociation::OnOKNewFiletype(HWND hDlg)
{
	//̓f[^̎擾
	TCHAR szBuf[MAX_PATH];
	GetWindowText(GetDlgItem(hDlg, IDC_FITETYPE), szBuf, sizeof(szBuf));

	//̓f[^̃`FbN
	if (!_tcslen(szBuf)) return FALSE;

	//̓f[^̊i[
	if (szBuf[0] == _T('.'))
		_tcscpy(m_szNewFileType, szBuf);
	else
		_stprintf(m_szNewFileType, _T(".%s"), szBuf);

	return TRUE;
}

///////////////////////////////////////////////////////////////
void CAssociation::OnSizeChoose()
{
	RECT rcw, rc;
	POINT pt;
	HWND hdi;

	GetWindowRect(m_hWnd, &rcw);

	//TCY (ListView)
	GetWindowRect(m_hListView, &rc);
	pt.x = rc.left; pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	MoveWindow(m_hListView, pt.x, pt.y, RECT_WIDTH(&rcw), RECT_HEIGHT(&rcw)-pt.y, TRUE);

	//ʒu (Button)
	hdi = GetDlgItem(m_hWnd, IDC_BTN_BROWSE);
	GetWindowRect(hdi, &rc);
	pt.x = 0;//dummy
	pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	pt.x = rcw.right;
	pt.x -= RECT_WIDTH(&rc)+(int)(3*g_MainWnd.m_fpHighResolutionScale);
	MoveWindow(hdi, pt.x, pt.y, RECT_WIDTH(&rc), RECT_HEIGHT(&rc), TRUE);

	//ʒu (CheckBox)
	hdi = GetDlgItem(m_hWnd, IDC_CHK_ASSOCIATION);
	GetWindowRect(hdi, &rc);
	pt.x = rc.left;//dummy
	pt.y = rc.top;
	ScreenToClient(m_hWnd, &pt);
	MoveWindow(hdi, pt.x, pt.y, RECT_WIDTH(&rcw)-pt.x, RECT_HEIGHT(&rc), TRUE);
}

///////////////////////////////////////////////////////////////
void CAssociation::OpenDeleteFiletype()
{
	//mF_CAO\
	int nRet = MessageBox(m_hWnd, GetResourceString(IDS_MSG_DELFILETYPE), GetResourceString(IDS_OPTION_FILETYPE), MB_YESNO|MB_ICONQUESTION);
	if (nRet == IDNO)
		return;

	//IACe擾
	CApplicationList* lpList = GetSelectItem(m_hListView2, 0, FINDTYPE_EXT);

	//ACeȂ(oO)
	if (!lpList) return;

	//WXgL[̍폜
	TCHAR szExt[MAX_PATH];
	_stprintf(szExt, _T(".%s"), lpList->getExt());
	if (DeleteSubKey(szExt))
	{
		//AvP[VXg쐬
		CreateAppList2();

		//Xgr[ݒ
		LoadAppList2();
	}
}

///////////////////////////////////////////////////////////////
void CAssociation::OpenDetailSetting()
{
	//IACe擾
	CApplicationList* lpList = GetSelectItem(m_hListView2, 0, FINDTYPE_EXT);

	//ACeȂ(I)
	if (!lpList) return;

	//EBhE쐬(gq̎擾)
	int rtn =  DialogBoxParam(m_hInst, (LPCTSTR)IDD_DETAIL_DLG,
				m_hparWnd, (DLGPROC)DetailFiletypeProc, LPARAM(this));

	//ꍇ
	if (rtn) 
	{
		//AvP[VXg쐬
		CreateAppList2();

		//Xgr[ݒ
		LoadAppList2();
	}
	
	return;
}

///////////////////////////////////////////////////////////////
void CAssociation::OnInitDetailSetting(HWND hDlg)
{
	//IACe擾
	m_lpActiveList = GetSelectItem(m_hListView2, 0, FINDTYPE_EXT);

	//ACeȂ(I)
	if (!m_lpActiveList) return;

	//EBhE^Cg
	SetWindowText(hDlg, GetResourceString(IDS_TITLE_DETAIL));

	//gq
	TCHAR szExt[MAX_PATH];
	_stprintf(szExt, _T(".%s"), m_lpActiveList->getExt());
	SetWindowText(GetDlgItem(hDlg, IDC_FITETYPE), szExt);

	//AvP[VpX
	SetWindowText(GetDlgItem(hDlg, IDC_APPPATH), m_lpActiveList->getAppPath());

	//AvP[V
	SetWindowText(GetDlgItem(hDlg, IDC_APPNAME), m_lpActiveList->getAppName());

	//Np[^
	SetWindowText(GetDlgItem(hDlg, IDC_COMMAND), m_lpActiveList->getCommand());

	//tH[JX̐ݒ
	SetFocus(GetDlgItem(hDlg, IDC_COMMAND));
}

///////////////////////////////////////////////////////////////
void CAssociation::OnChangeDetailSetting(HWND hDlg)
{
	TCHAR szExt[MAX_PATH];
	_stprintf(szExt, _T(".%s"), m_lpActiveList->getExt());

	//AvP[VI_CAO쐬
	CAssociation Dlg(m_hparWnd, m_hInst);
	int nRtn = Dlg.OpenChoose(_T(""), szExt, TRUE, FALSE);

	if (!nRtn) return;

	//AvP[VXg쐬
	CreateAppList2();

	//AvP[VI
	m_lpActiveList = NULL;
	CApplicationList* lpList = m_lpAppList;
	while (lpList)
	{
		if (0 == _tcsicmp((szExt+1), lpList->getExt()))
		{
			m_lpActiveList = lpList;
			break;
		}

		lpList = lpList->getNext();
	}//End of for

	//ʍĐݒ
	SetWindowText(GetDlgItem(hDlg, IDC_APPPATH), m_lpActiveList->getAppPath());
	SetWindowText(GetDlgItem(hDlg, IDC_APPNAME), m_lpActiveList->getAppName());
	SetWindowText(GetDlgItem(hDlg, IDC_COMMAND), m_lpActiveList->getCommand());
	SetFocus(GetDlgItem(hDlg, IDC_COMMAND));
}

///////////////////////////////////////////////////////////////
BOOL CAssociation::OnOKDetailSetting(HWND hDlg)
{
	//AvP[V擾
	TCHAR szAppName[MAX_PATH];
	GetWindowText(GetDlgItem(hDlg, IDC_APPNAME), szAppName, sizeof(szAppName));
	
	//Np[^擾
	TCHAR szCommand[MAX_PATH];
	GetWindowText(GetDlgItem(hDlg, IDC_COMMAND), szCommand, sizeof(szCommand));

	//p[^͕s̏ꍇ
	if (0 == _tcslen(szAppName) || 0 == _tcslen(szCommand))
	{
		//ʍĐݒ
		SetWindowText(GetDlgItem(hDlg, IDC_APPNAME), m_lpActiveList->getAppName());
		SetWindowText(GetDlgItem(hDlg, IDC_COMMAND), m_lpActiveList->getCommand());
		SetFocus(GetDlgItem(hDlg, IDC_COMMAND));

		//G[bZ[W
		MessageBox(m_hWnd, GetResourceString(IDS_MSG_NOTFOUND_PATH), NULL, MB_OK|MB_ICONSTOP);
		return FALSE;
	}

	//p[^̕ύXꍇ
	if ((0 != _tcscmp(szAppName, m_lpActiveList->getAppName())) ||
	   (0 != _tcscmp(szCommand, m_lpActiveList->getCommand())))
		//WXgύX
		SetApplication(m_lpActiveList->getAppPath(), m_lpActiveList->getKeyName(), szAppName, szCommand, m_lpActiveList->getIconPath(), m_lpActiveList->getIconID());

	return TRUE;
}
