#ifndef __OBJECT_CODEC_H__
#define __OBJECT_CODEC_H__

#include "Object.h"
#include "Codec.h"

namespace Gura {

//-----------------------------------------------------------------------------
// Class_Codec
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Codec : public Class {
public:
	Class_Codec(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Codec
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Codec : public Object {
public:
	Gura_DeclareObjectAccessor(Codec)
private:
	String _encoding;
	Codec_Encoder *_pEncoder;
	Codec_Decoder *_pDecoder;
public:
	inline Object_Codec(Environment &env) :
			Object(env.LookupClass(VTYPE_Codec)), _pEncoder(NULL), _pDecoder(NULL) {}
	inline Object_Codec(Class *pClass) :
			Object(pClass), _pEncoder(NULL), _pDecoder(NULL) {}
	inline const char *GetEncoding() const { return _encoding.c_str(); }
	inline Codec_Encoder *GetEncoder() { return _pEncoder; }
	inline Codec_Decoder *GetDecoder() { return _pDecoder; }
	virtual ~Object_Codec();
	virtual Object *Clone() const;
	bool InstallCodec(Signal sig, const char *encoding, bool processEOLFlag);
	void ReleaseCodec();
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
