#ifndef __OBJECT_ENVIRONMENT_H__
#define __OBJECT_ENVIRONMENT_H__

#include "Object.h"
#include "Environment.h"

namespace Gura {

//-----------------------------------------------------------------------------
// Class_Environment / Object_Environment
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Environment : public Class {
public:
	Class_Environment(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Environment : public Object {
public:
	Gura_DeclareObjectAccessor(Environment)
private:
	Environment _env;
public:
	inline Object_Environment(Environment &env) :
						Object(env.LookupClass(VTYPE_Environment)), _env(env) {}
	inline Object_Environment(Class *pClass, Environment &env) :
						Object(pClass), _env(env) {}
	Object_Environment(const Object_Environment &obj);
	inline Environment &GetEnv() { return _env; }
	virtual ~Object_Environment();
	virtual Object *Clone() const;
	virtual Value DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value DoPropSet(Signal sig, const Symbol *pSymbol,
										const Value &value, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
