#ifndef __OBJECT_EXPR_H__
#define __OBJECT_EXPR_H__

#include "Object.h"

namespace Gura {

//-----------------------------------------------------------------------------
// Class_Expr / Object_Expr
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Expr : public Class {
public:
	Class_Expr(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Expr : public Object {
public:
	class Iterator_Each : public Iterator {
	private:
		Environment _env;
		Expr_Container *_pExprContainer;
		ExprList::iterator _ppExpr;
	public:
		inline Iterator_Each(Environment &env, Expr_Container *pExprContainer) :
						Iterator(false), _env(env), _pExprContainer(pExprContainer),
						_ppExpr(pExprContainer->GetExprList().begin()) {}
		virtual ~Iterator_Each();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	Gura_DeclareObjectAccessor(Expr)
private:
	Expr *_pExpr;
public:
	inline Object_Expr(Environment &env, Expr *pExpr) :
						Object(env.LookupClass(VTYPE_Expr)), _pExpr(pExpr) {}
	inline Object_Expr(Class *pClass, Expr *pExpr) :
						Object(pClass), _pExpr(pExpr) {}
	Object_Expr(const Object_Expr &obj);
	virtual ~Object_Expr();
	virtual Object *Clone() const;
	inline Expr *GetExpr() { return _pExpr; }
	inline const Expr *GetExpr() const { return _pExpr; }
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
