#ifndef __OBJECT_STRUCT_H__
#define __OBJECT_STRUCT_H__

#include "Object.h"

namespace Gura {

//-----------------------------------------------------------------------------
// Class_Struct / Object_Struct
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Struct : public Class {
public:
	Class_Struct(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Struct : public Object {
public:
	Gura_DeclareObjectAccessor(Struct)
public:
	inline Object_Struct(Class *pClass) : Object(pClass) {}
	inline Object_Struct(Environment &env) : Object(env.LookupClass(VTYPE_Struct)) {}
	Object_Struct(const Object_Struct &obj);
	virtual ~Object_Struct();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	const DeclarationList &GetDeclList() const;
};

}

#endif
