#ifndef __OBJECT_WIN32OLE_H__
#define __OBJECT_WIN32OLE_H__

#include "Object.h"

namespace Gura {

//-----------------------------------------------------------------------------
// Class_Win32Ole
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Win32Ole : public Class {
public:
	Class_Win32Ole(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Win32Ole declaration
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Win32Ole : public Object {
public:
	class IteratorEx : public Iterator {
	private:
		Object_Win32Ole *_pObj;
		IEnumVARIANT *_pEnum;
		bool _validFlag;
		Value _value;
	public:
		inline IteratorEx(Object_Win32Ole *pObj, IEnumVARIANT *pEnum) :
				Iterator(false), _pObj(pObj), _pEnum(pEnum), _validFlag(false) {}
		virtual ~IteratorEx();
		virtual bool DoNext(Environment &env, Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	class DLLDECLARE Callable : public ICallable {
	private:
		String _name;
		Object_Win32Ole *_pObj;
		DISPID _dispid;
	public:
		inline Callable(Object_Win32Ole *pObj) : _pObj(pObj) {}
		HRESULT Setup(const char *name);
		virtual Value DoCall(Environment &env, Signal sig, Args &argsExpr);
	};
private:
	IDispatch *_pDispatch;
	Callable _callable;
public:
	Gura_DeclareObjectAccessor(Win32Ole)
public:
	inline Object_Win32Ole(Environment &env) :
		Object(env.LookupClass(VTYPE_Win32Ole)), _pDispatch(NULL), _callable(this) {}
	inline Object_Win32Ole(Environment &env, IDispatch *pDispatch) :
		Object(env.LookupClass(VTYPE_Win32Ole)), _pDispatch(pDispatch), _callable(this) {}
	virtual ~Object_Win32Ole();
	virtual Object *Clone() const;
	inline IDispatch *GetDispatch() { return _pDispatch; }
	bool Create(Signal sig, const char *progID);
	bool Connect(Signal sig, const char *progID);
	bool ImportConstant(Environment &env, Signal sig);
	HRESULT GetDispID(const char *name, DISPID &dispid);
	HRESULT GetDispIDOfNamedArg(
				const char *nameMethod, const char *name, DISPID &dispid);
	virtual Iterator *CreateIterator(Signal sig);
	virtual bool DoPropDir(Signal sig, SymbolSet &symbols);
	virtual Value DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value DoPropSet(Signal sig, const Symbol *pSymbol,
								const Value &value, bool &evaluatedFlag);
	virtual ICallable *GetCallable(Signal sig, const Symbol *pSymbol);
	virtual String ToString(Signal sig, bool exprFlag);
	static void SetError(Signal sig, HRESULT hr);
};

//-----------------------------------------------------------------------------
// utilities
//-----------------------------------------------------------------------------
DLLDECLARE OLECHAR *StringToBSTR(const char *psz);
DLLDECLARE String BSTRToString(const OLECHAR *bstr);

DLLDECLARE bool ValueToVariant(Signal sig, VARIANT &var, const Value &value);
DLLDECLARE void VariantToValue(Environment &env, Value &value, const VARIANT &var);

}

#endif
