#==============================================================================
# Makefile for Borland C++
#==============================================================================
GURA_VERSION = 0.1.0

LIB_GURA_D = ..\lib\libgura.bcc.lib
LIB_GURA_S = ..\lib\libgura_s.bcc.lib
DLL_GURA = ..\libgura.bcc.dll

SRCS = \
Common.cpp Parser.cpp Expr.cpp Value.cpp Iterator.cpp \
Symbol.cpp String.cpp Environment.cpp Signal.cpp Formatter.cpp Option.cpp \
Function.cpp Operator.cpp Declaration.cpp \
Algorithm.cpp Codec.cpp \
Stream.cpp Directory.cpp DateTime.cpp OAL.cpp DLLMain.cpp

SRCS = $(SRCS) Object.cpp \
Object_Function.cpp Object_String.cpp Object_Binary.cpp \
Object_List.cpp Object_Matrix.cpp Object_Dict.cpp Object_Stream.cpp \
Object_DateTime.cpp Object_TimeDelta.cpp \
Object_Expr.cpp Object_Environment.cpp Object_Error.cpp Object_URI.cpp \
Object_Struct.cpp Object_Custom.cpp Object_Iterator.cpp Object_Semaphore.cpp \
Object_Image.cpp Object_Color.cpp Object_Palette.cpp Object_Audio.cpp Object_Codec.cpp \
Object_Win32Ole.cpp

SRCS = $(SRCS) Module.cpp \
Module_basement.cpp \
Module_sys.cpp \
Module_codecs_basic\Module_codecs_basic.cpp \
Module_codecs_iso8859\Module_codecs_iso8859.cpp \
Module_codecs_japanese\Module_codecs_japanese.cpp \
Module_codecs_japanese\Conv_Japanese.cpp \
Module_fs\Module_fs.cpp \
Module_os\Module_os.cpp \
Module_path\Module_path.cpp \
Module_time\Module_time.cpp \
Module_string\Module_string.cpp \
Module_math\Module_math.cpp

OBJS = $(SRCS:.cpp=.obj)

OBJS_EXTRA = sfmt.obj

SFMTDIR = SFMT-src-1.3.3

LDFLAGS = -tWD -tWM -M -q \
-L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

CFLAGS = \
-q -I..\include -I$(MAKEDIR)\..\Include -w-8057 -w-8004 \
-DGURA_VERSION=\"$(GURA_VERSION)\" -DGURA_EXPORTS

#CFLAGS = $(CFLAGS) -DDEBUG_GURA

.cpp.obj:
	@bcc32 $(CFLAGS) -o$(<R).obj -c $<

all: program module

program: $(LIB_GURA_D)
	@cd Program_gura
	@make
	@cd ..\Program_guraw
	@make
	@cd ..

module: $(LIB_GURA_D)
	@..\gura build_modules.az install-root

$(LIB_GURA_D): $(DLL_GURA)
	@implib $@ $(DLL_GURA) >nul
	@echo $@ was created

$(LIB_GURA_S): $(OBJS) $(OBJS_EXTRA)
	@if exist $@ del $@ >nul
	@tlib $@ /P128 /a $**
	@echo $@ was created

$(DLL_GURA): $(OBJS) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -e$@ $**
	@echo $@ was created

sfmt.obj: $(SFMTDIR)\sfmt.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8027 -c -o$@ $**

clean: clean_module clean_program
	@del $(SRCS:.cpp=.obj)
	@del $(LIB_GURA_D) $(DLL_GURA) $(OBJS_EXTRA)
	@del $(DLL_GURA:.dll=.map) $(DLL_GURA:.dll=.tds)

clean_program:
	@cd Program_gura
	@make clean
	@cd ..\Program_guraw
	@make clean
	@cd ..

clean_module:
	@..\gura build_modules.az clean

#------------------------------------------------------------------------------
SVNREPO = https://svn.sourceforge.jp/svnroot/gura

ZIPSRCFILE_PRE = gura-$(GURA_VERSION)-src
ZIPBINFILE = gura-$(GURA_VERSION)-win32.zip
ZIPBINFILE_EXTRA = gura-extra-$(GURA_VERSION)-win32.zip

DISTFILES = \
gura\gura.exe \
gura\guraw.exe \
gura\libgura.bcc.dll \
gura\module\*.az \
gura\module.bcc\*.az \
gura\module.bcc\*.azd \
gura\module.bcc\net\*.az \
gura\module.bcc\net\*.azd \
gura\module.bcc\codecs\*.az \
gura\module.bcc\codecs\*.azd \
gura\test\test-*.az \
gura\test\50records-en.csv \
gura\test\50records-jp.csv \
gura\test\temperature.txt \
gura\test\chars-cp932.txt \
gura\test\chars-eucjp.txt \
gura\test\chars-utf8-jp.txt \
gura\test\chars-jis.txt \
gura\test\ipss.go.jp-report-1.csv \
gura\test\testall.bat \
gura\test\result\test-*.sample.txt \
gura\sample\cairo\cairo-*.az \
gura\sample\canvas\canvas-*.az \
gura\sample\freetype\freetype-*.az \
gura\sample\http\http-*.az \
gura\sample\http\proxy_setting.sample.az \
gura\sample\misc\*.az \
gura\sample\opengl\gl-*.az \
gura\sample\opengl\*.rgb \
gura\sample\resource\readme.txt \
gura\sample\resource\*.ico \
gura\sample\resource\*.gif \
gura\sample\resource\*.jpg \
gura\sample\resource\*.bmp \
gura\sample\resource\*.png \
gura\sample\resource\*.ttf \
gura\sample\resource\*.zip \
gura\sample\scribble\*.az \
gura\sample\sdl\sdl-*.az \
gura\sample\tk\tk-*.az \
gura\sample\win32\win32-*.az \
gura\extra\lib.win32\*.dll \
gura\extra\tcl\bin\*.dll \
gura\extra\tcl\lib\*.* \
gura\include\*.h \
gura\include\gura\*.h \
gura\lib\libgura.bcc.lib

listtag:
	svn ls $(SVNREPO)/tags

deltag:
	svn del $(SVNREPO)/tags/$(GURA_VERSION) -m ""

maketag:
	svn copy $(SVNREPO)/trunk $(SVNREPO)/tags/$(GURA_VERSION) -m "version $(GURA_VERSION) release"

distsrc:
	if exist gura-$(GURA_VERSION) rmdir /s /q gura-$(GURA_VERSION)
	svn export $(SVNREPO)/tags/$(GURA_VERSION) gura-$(GURA_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar gura-$(GURA_VERSION)
	7z a $(ZIPSRCFILE_PRE).tar.gz $(ZIPSRCFILE_PRE).tar
	del $(ZIPSRCFILE_PRE).tar
	move /Y $(ZIPSRCFILE_PRE).tar.gz ..\..
	rmdir /s /q gura-$(GURA_VERSION)

distbin:
	cd ..\..
	del $(ZIPBINFILE)
	7z a $(ZIPBINFILE) $(DISTFILES)
