//-----------------------------------------------------------------------------
// Gura sample module
//-----------------------------------------------------------------------------
#include <gura.h>

Gura_BeginModule(sample)

Gura_DeclarePrivSymbol(hoge_symbol);

//-----------------------------------------------------------------------------
// Object_Foo declaration
//-----------------------------------------------------------------------------
Gura_DeclarePrivClass(Foo);

class Object_Foo : public Object {
public:
	Gura_DeclareObjectAccessor(Foo)
public:
	inline Object_Foo() : Object(Gura_PrivClass(Foo)) {}
	inline Object_Foo(const Object_Foo &obj) : Object(obj) {}
	virtual ~Object_Foo();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
};

//-----------------------------------------------------------------------------
// Object_Foo implementation
//-----------------------------------------------------------------------------
Object_Foo::~Object_Foo()
{
}

Object *Object_Foo::Clone() const
{
	return new Object_Foo(*this);
}

String Object_Foo::ToString(Signal sig, bool exprFlag)
{
	return String("<Foo>");
}

//-----------------------------------------------------------------------------
// Gura interfaces for Object_Foo
//-----------------------------------------------------------------------------
// sample.foo#test()
Gura_DeclareMethod(Foo, test)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

Gura_ImplementMethod(Foo, test)
{
	Object_Foo *pSelf = Object_Foo::GetSelfObj(args);
	return Value(env, "foo object");
}

// implementation of class Foo
Gura_ImplementPrivClass(Foo)
{
	Gura_AssignMethod(Foo, test);
}

//-----------------------------------------------------------------------------
// Gura module functions: sample
//-----------------------------------------------------------------------------
// sample.create_foo()
Gura_DeclareFunction(create_foo)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

Gura_ImplementFunction(create_foo)
{
	return Value(new Object_Foo());
}

// result = sample.adder(num1:number, num2:number)
Gura_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

Gura_ImplementFunction(adder)
{
	return Value(args.GetNumber(0) + args.GetNumber(1));
}

// Module entry
Gura_ModuleEntry()
{
	// symbol realization
	Gura_RealizePrivSymbol(hoge_symbol);
	// class realization
	Gura_RealizePrivClass(Foo, "foo", env.LookupClass(VTYPE_Object));
	// value assignment
	Gura_AssignValue(foo, Value(env, "a value in sample module"));
	// function assignment
	Gura_AssignFunction(create_foo);
	Gura_AssignFunction(adder);
}

Gura_ModuleTerminate()
{
}

Gura_EndModule(sample, sample)

Gura_RegisterModule(sample)
