//-----------------------------------------------------------------------------
// Gura sys module
//-----------------------------------------------------------------------------
#include <gura.h>

Gura_BeginModule(sys)

//-----------------------------------------------------------------------------
// Gura module functions: sys
//-----------------------------------------------------------------------------
// sys.echo(flag:boolean)
Gura_DeclareFunction(echo)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareArg(env, "flag", VTYPE_Boolean);
	SetHelp(
	"Enables or disables echo-back functionality according to flag.");
}

Gura_ImplementFunction(echo)
{
	env.SetEchoFlag(args.GetBoolean(0));
	return Value::Null;
}

// sys.exit(status?:number)
Gura_DeclareFunction(exit)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareArg(env, "status", VTYPE_Number, OCCUR_ZeroOrOnce);
	SetHelp(
	"Terminates the program with a specified status number.");
}

Gura_ImplementFunction(exit)
{
	::exit(args.IsNumber(0)? args.GetInt(0) : 0);
	return Value::Null;
}

// sys.listcodec()
Gura_DeclareFunction(listcodec)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	SetHelp(
	"Returns a list of character codecs that are registered.");
}

Gura_ImplementFunction(listcodec)
{
	Value result;
	ValueList &valList = result.InitAsList(env);
	foreach_const (CodecFactory::List, ppCodecFactory, CodecFactory::GetList()) {
		const CodecFactory *pCodecFactory = *ppCodecFactory;
		valList.push_back(Value(env, pCodecFactory->GetName()));
	}
	return result;
}

Gura_ModuleEntry()
{
	// value assignment
	do {
		Value value;
		ValueList &valList = value.InitAsList(env);
		StringList strList;
		OAL::SetupModulePath(strList);
		foreach (StringList, pStr, strList) {
			valList.push_back(Value(env, pStr->c_str()));
		}
		Gura_AssignValue(path, value);
	} while (0);
	Gura_AssignValue(version, Value(env, GURA_VERSION));
	Gura_AssignValue(ps1, Value(env, ">>> "));
	Gura_AssignValue(ps2, Value(env, "... "));
	do {
		Value valueBuild, valuePlatform;
#if defined(_MSC_VER)
		valueBuild = Value(Gura_Symbol(msc));
		valuePlatform = Value(Gura_Symbol(windows));
#elif defined(__BORLANDC__)
		valueBuild = Value(Gura_Symbol(bcc));
		valuePlatform = Value(Gura_Symbol(windows));
#elif defined(__GNUC__) && defined(__GNUC_MINOR__)
		valueBuild = Value(Gura_Symbol(gnuc));
		valuePlatform = Value(Gura_Symbol(linux));
#else
		valueBuild = Value::Null;
		valuePlatform = Value::Null;
#endif
		Gura_AssignValue(build, valueBuild);
		Gura_AssignValue(platform, valuePlatform);
	} while (0);
	Gura_AssignValue(executable, Value(env, OAL::GetExecutable().c_str()));
	Gura_AssignValue(datadir, Value(env, OAL::GetDataDir().c_str()));
	Gura_AssignValue(libdir, Value(env, OAL::GetLibDir().c_str()));
	// function assignment
	Gura_AssignFunction(echo);
	Gura_AssignFunction(exit);
	Gura_AssignFunction(listcodec);
}

Gura_ModuleTerminate()
{
}

void Setup(Module *pModule, Signal sig, int argc, const char *argv[])
{
	Environment &env = *pModule;
	do {
		Value value;
		ValueList &valList = value.InitAsList(env);
		if (argc >= 2 && argv != NULL) {
			valList.push_back(Value(env,
					OAL::MakeAbsPath(OAL::FileSeparator, argv[1], NULL).c_str()));
			for (int i = 2; i < argc; i++) {
				const char *arg = argv[i];
				valList.push_back(Value(env, arg));
			}
		}
		env.AssignValue(Symbol::Add("argv"), value, false);
	} while (0);
	env.GetGlobal()->_pModule_sys = pModule;
}

Gura_EndModule(sys, sys)

Gura_RegisterModule(sys)
