//-----------------------------------------------------------------------------
// Gura testm module
//-----------------------------------------------------------------------------
#include <gura.h>

Gura_BeginModule(testm)

class AudioSrc {
public:
	virtual ~AudioSrc();
};

class AudioDst {
public:
	virtual ~AudioDst();
};

typedef std::vector<AudioSrc *> AudioSrcList;
typedef std::vector<AudioDst *> AudioDstList;

AudioSrc::~AudioSrc()
{
}

AudioDst::~AudioDst()
{
}

//-----------------------------------------------------------------------------
// Object_Audio declaration
//-----------------------------------------------------------------------------
Gura_DeclarePrivClass(Audio);

class Object_Audio : public Object {
private:
	AudioSrcList _audioSrcList;
	AudioDstList _audioDstList;
public:
	Gura_DeclareObjectAccessor(Audio)
public:
	inline Object_Audio() : Object(Gura_PrivClass(Audio)) {}
	virtual ~Object_Audio();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline void AddSrc(AudioSrc *pAudioSrc) { _audioSrcList.push_back(pAudioSrc); }
	inline void AddDst(AudioDst *pAudioDst) { _audioDstList.push_back(pAudioDst); }
};

//-----------------------------------------------------------------------------
// Object_Audio implementation
//-----------------------------------------------------------------------------
Object_Audio::~Object_Audio()
{
	foreach (AudioSrcList, ppAudioSrc, _audioSrcList) {
		delete *ppAudioSrc;
	}
	foreach (AudioDstList, ppAudioDst, _audioDstList) {
		delete *ppAudioDst;
	}
}

Object *Object_Audio::Clone() const
{
	return NULL;
}

String Object_Audio::ToString(Signal sig, bool exprFlag)
{
	return String("<Audio>");
}

//-----------------------------------------------------------------------------
// Gura interfaces for Object_Audio
//-----------------------------------------------------------------------------
// testm.audio#test()
Gura_DeclareMethod(Audio, test)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

Gura_ImplementMethod(Audio, test)
{
	Object_Audio *pSelf = Object_Audio::GetSelfObj(args);
	return Value(env, "Audio object");
}

// implementation of class Audio
Gura_ImplementPrivClass(Audio)
{
	Gura_AssignMethod(Audio, test);
}

//-----------------------------------------------------------------------------
// Gura module functions: testm
//-----------------------------------------------------------------------------
// testm.audio()
Gura_DeclareFunction(audio)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

Gura_ImplementFunction(audio)
{
	Object_Audio *pObjAudio = new Object_Audio();
	return Value(pObjAudio);
}

// Module entry
Gura_ModuleEntry()
{
	// class realization
	Gura_RealizePrivClass(Audio, "audio", env.LookupClass(VTYPE_Object));
	// function assignment
	Gura_AssignFunction(audio);
}

Gura_ModuleTerminate()
{
}

Gura_EndModule(testm, testm)

Gura_RegisterModule(testm)
