//-----------------------------------------------------------------------------
// Gura wav module
//-----------------------------------------------------------------------------
#include <gura.h>

Gura_BeginModule(wav)

//-----------------------------------------------------------------------------
// AudioStreamer_WAV
//-----------------------------------------------------------------------------
class AudioStreamer_WAV : public AudioStreamer {
public:
	inline AudioStreamer_WAV() : AudioStreamer("wav") {}
	virtual bool IsResponsible(Signal sig, Stream &stream);
	virtual bool Read(Environment &env, Signal sig, Object_Audio *pObjAudio, Stream &stream);
	virtual bool Write(Environment &env, Signal sig, Object_Audio *pObjAudio, Stream &stream);
public:
	static bool ReadStream(Signal sig, Object_Audio *pObjAudio, Stream &stream);
	static bool WriteStream(Signal sig, Object_Audio *pObjAudio, Stream &stream);
	static void SetError_InvalidWAVFormat(Signal sig);
};

//-----------------------------------------------------------------------------
// Gura interfaces for Object_Audio
// These methods are available after importing wav module.
//-----------------------------------------------------------------------------
// audio#wavread(stream:stream):reduce
Gura_DeclareMethod(Audio, wavread)
{
	SetMode(RSLTMODE_Reduce, FLAG_None);
	DeclareArg(env, "stream", VTYPE_Stream);
	SetHelp("Reads WAV audio from a stream.");
}

Gura_ImplementMethod(Audio, wavread)
{
	Object_Audio *pSelf = Object_Audio::GetSelfObj(args);
	if (!AudioStreamer_WAV::ReadStream(sig, pSelf, args.GetStream(0))) return Value::Null;
	return args.GetSelf();
}

// audio#wavwrite(stream:stream):reduce
Gura_DeclareMethod(Audio, wavwrite)
{
	SetMode(RSLTMODE_Reduce, FLAG_None);
	DeclareArg(env, "stream", VTYPE_Stream);
	SetHelp("Writes WAV audio to a stream.");
}

Gura_ImplementMethod(Audio, wavwrite)
{
	Object_Audio *pSelf = Object_Audio::GetSelfObj(args);
	if (!AudioStreamer_WAV::WriteStream(sig, pSelf, args.GetStream(0))) return Value::Null;
	return args.GetSelf();
}

//-----------------------------------------------------------------------------
// Gura module functions: wav
//-----------------------------------------------------------------------------
// Module entry
Gura_ModuleEntry()
{
	Gura_AssignMethodTo(VTYPE_Audio, Audio, wavread);
	Gura_AssignMethodTo(VTYPE_Audio, Audio, wavwrite);
	AudioStreamer::Register(new AudioStreamer_WAV());
}

Gura_ModuleTerminate()
{
}

//-----------------------------------------------------------------------------
// AudioStreamer_WAV
//-----------------------------------------------------------------------------
bool AudioStreamer_WAV::IsResponsible(Signal sig, Stream &stream)
{
	if (stream.IsReadable()) {
	}
	return stream.HasNameSuffix(".wav");
}

bool AudioStreamer_WAV::Read(Environment &env, Signal sig,
									Object_Audio *pObjAudio, Stream &stream)
{
	return AudioStreamer_WAV::ReadStream(sig, pObjAudio, stream);
}

bool AudioStreamer_WAV::Write(Environment &env, Signal sig,
									Object_Audio *pObjAudio, Stream &stream)
{
	return AudioStreamer_WAV::WriteStream(sig, pObjAudio, stream);
}

bool AudioStreamer_WAV::ReadStream(Signal sig, Object_Audio *pObjAudio, Stream &stream)
{
	if (!pObjAudio->CheckEmpty(sig)) return false;
	return false;
}

bool AudioStreamer_WAV::WriteStream(Signal sig, Object_Audio *pObjAudio, Stream &stream)
{
	if (!pObjAudio->CheckValid(sig)) return false;
	return false;
}

void AudioStreamer_WAV::SetError_InvalidWAVFormat(Signal sig)
{
	sig.SetError(ERR_FormatError, "invalid WAV format");
}

Gura_EndModule(wav, wav)

Gura_RegisterModule(wav)
