//-----------------------------------------------------------------------------
// Gura win32 module
//-----------------------------------------------------------------------------
#ifndef __MODULE_WIN32_H__
#define __MODULE_WIN32_H__

#include <gura.h>

Gura_BeginModule(win32)

//-----------------------------------------------------------------------------
// Object_RegKey declaration
//-----------------------------------------------------------------------------
Gura_DeclarePrivClass(RegKey);

class Object_RegKey : public Object {
private:
	HKEY _hKey;
public:
	Gura_DeclareObjectAccessor(RegKey)
public:
	inline Object_RegKey(HKEY hKey) : Object(Gura_PrivClass(RegKey)), _hKey(hKey) {}
	inline Object_RegKey(const Object_RegKey &obj) : Object(obj) {}
	virtual ~Object_RegKey();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline HKEY GetKey() { return _hKey; }
};

//-----------------------------------------------------------------------------
// Iterator_RegEnumKey declaration
//-----------------------------------------------------------------------------
class Iterator_RegEnumKey : public Iterator {
private:
	Object_RegKey *_pObjRegKey;
	REGSAM _samDesired;
	DWORD _dwIndex;
public:
	Iterator_RegEnumKey(Object_RegKey *pObjRegKey, REGSAM samDesired);
	virtual ~Iterator_RegEnumKey();
	virtual bool DoNext(Environment &env, Signal sig, Value &value);
	virtual String ToString(Signal sig) const;
};

//-----------------------------------------------------------------------------
// Iterator_RegEnumValue declaration
//-----------------------------------------------------------------------------
class Iterator_RegEnumValue : public Iterator {
private:
	Object_RegKey *_pObjRegKey;
	DWORD _dwIndex;
public:
	Iterator_RegEnumValue(Object_RegKey *pObjRegKey);
	virtual ~Iterator_RegEnumValue();
	virtual bool DoNext(Environment &env, Signal sig, Value &value);
	virtual String ToString(Signal sig) const;
};

}}

#endif
