#ifndef __ASCRIPTSHELL_H__
#define __ASCRIPTSHELL_H__

#include <wx/wx.h>
#include <wx/textctrl.h>
#include <gura.h>
#include <deque>

//-----------------------------------------------------------------------------
// GuraShell
//-----------------------------------------------------------------------------
class GuraShell : public wxTextCtrl {
private:
	typedef std::deque<wxString> LineHistory;
	class StreamEx : public Gura::Stream {
	private:
		wxString _str;
		GuraShell *_pGuraShell;
	public:
		StreamEx(Gura::Signal sig, GuraShell *pGuraShell);
		virtual const char *GetName() const;
		virtual void DoPutChar(Gura::Signal sig, char ch);
		virtual void FlushConsole();
	};
	class EvalLineThread : public wxThread {
	private:
		GuraShell *_pGuraShell;
		wxString _str;
	public:
		EvalLineThread(GuraShell *pGuraShell, const wxString &str);
		virtual ExitCode Entry();
	};
	class EvalFileThread : public wxThread {
	private:
		GuraShell *_pGuraShell;
		wxString _fileName;
	public:
		EvalFileThread(GuraShell *pGuraShell, const wxString &fileName);
		virtual ExitCode Entry();
	};
private:
	long _posLineTop;
	LineHistory _lineHistory;
	LineHistory::reverse_iterator _pLineHistory;
	StreamEx _console;
	Gura::EnvironmentRoot _env;
	Gura::Signal _sig;
	Gura::Parser _parser;
	bool _threadRunningFlag;
	bool _scrollViewFlag;
public:
	GuraShell(wxWindow *pParent, wxWindowID id, long style);
	virtual ~GuraShell();
	inline void MarkLineTop() { _posLineTop = GetLastPosition(); }
	inline long GetLineTopPoint() const { return _posLineTop; }
	inline Gura::Environment &GetEnvironment() { return _env; }
	inline Gura::Signal &GetSignal() { return _sig; }
	inline Gura::Parser &GetParser() { return _parser; }
	inline bool IsScrollView() const { return _scrollViewFlag; }
	bool IsThreadRunning() const { return _threadRunningFlag; }
	void UpdateFont();
	void UpdateColor();
	void EvalFile(const wxString &fileName);
	void EnterScrollView();
	void LeaveScrollView();
	void RunThread(wxThread *pThread);
	void NotifyEndOfThread();
private:
	DECLARE_EVENT_TABLE()
	void OnKeyDown(wxKeyEvent &event);
};

#endif
