#ifndef __CONFIG_H__
#define __CONFIG_H__

#include <wx/config.h>

namespace Config {
	inline bool WriteString(const wxString &key, const wxString &value) {
		return wxConfig::Get()->Write(key, value);
	}
	inline bool WriteLong(const wxString &key, long value) {
		return wxConfig::Get()->Write(key, value);
	}
	inline bool WriteDouble(const wxString &key, double value) {
		return wxConfig::Get()->Write(key, value);
	}
	inline bool WriteBool(const wxString &key, bool value) {
		return wxConfig::Get()->Write(key, value);
	}
	inline wxString ReadString(const wxString &key, const wxString &defaultValue) {
		return wxConfig::Get()->Read(key, defaultValue);
	}
	inline long ReadLong(const wxString &key, long defaultValue) {
		long value;
		wxConfig::Get()->Read(key, &value, defaultValue);
		return value;
	}
	inline double ReadDouble(const wxString &key, double defaultValue) {
		double value;
		wxConfig::Get()->Read(key, &value, defaultValue);
		return value;
	}
	inline bool ReadBool(const wxString &key, bool defaultValue) {
		bool value;
		wxConfig::Get()->Read(key, &value, defaultValue);
		return value;
	}
	namespace FrameMain {
		inline wxString Key(const wxString &key) { return wxT("FrameMain/") + key; }
		// FrameMain/x, FrameMain/y
		inline wxPoint ReadPosition() {
			return wxPoint(
				ReadLong(Key(wxT("x")), wxDefaultPosition.x),
				ReadLong(Key(wxT("y")), wxDefaultPosition.y));
		}
		inline void WritePosition(const wxPoint &pt) {
			WriteLong(Key(wxT("x")), pt.x);
			WriteLong(Key(wxT("y")), pt.y);
		}
		// FrameMain/width, FrameMain/height
		inline wxSize ReadSize() {
			return wxSize(
				ReadLong(Key(wxT("width")), 600),
				ReadLong(Key(wxT("height")), 500));
		}
		inline void WriteSize(const wxSize &sz) {
			WriteLong(Key(wxT("width")), sz.GetWidth());
			WriteLong(Key(wxT("height")), sz.GetHeight());
		}
	};
	namespace FrameScribble {
		inline wxString Key(const wxString &key) { return wxT("FrameScribble/") + key; }
		// FrameScribble/showflag
		inline bool ReadShowFlag() {
			return ReadBool(Key(wxT("showflag")), false);
		}
		inline void WriteShowFlag(bool showFlag) {
			WriteBool(Key(wxT("showflag")), showFlag);
		}
		// FrameScribble/x, FrameScribble/y
		inline wxPoint ReadPosition() {
			return wxPoint(
				ReadLong(Key(wxT("x")), wxDefaultPosition.x),
				ReadLong(Key(wxT("y")), wxDefaultPosition.y));
		}
		inline void WritePosition(const wxPoint &pt) {
			WriteLong(Key(wxT("x")), pt.x);
			WriteLong(Key(wxT("y")), pt.y);
		}
		// FrameScribble/width, FrameScribble/height
		inline wxSize ReadSize() {
			return wxSize(
				ReadLong(Key(wxT("width")), 600),
				ReadLong(Key(wxT("height")), 500));
		}
		inline void WriteSize(const wxSize &sz) {
			WriteLong(Key(wxT("width")), sz.GetWidth());
			WriteLong(Key(wxT("height")), sz.GetHeight());
		}
	};
	namespace GuraShell {
		inline wxString Key(const wxString &key) { return wxT("GuraShell/") + key; }
		// GuraShell/fontsize
		inline long ReadFontSize() {
			return ReadLong(Key(wxT("fontsize")), 14);
		}
		inline void WriteFontSize(long fontSize) {
			WriteLong(Key(wxT("fontsize")), fontSize);
		}
		// GuraShell/fontcolor
		inline wxString ReadFontColor() {
			return ReadString(Key(wxT("fontcolor")), wxT("#000000"));
		}
		inline void WriteFontColor(const wxString &color) {
			WriteString(Key(wxT("fontcolor")), color);
		}
		// GuraShell/backgroundcolor
		inline wxString ReadBackgroundColor() {
			return ReadString(Key(wxT("backgroundcolor")), wxT("#ffffff"));
		}
		inline void WriteBackgroundColor(const wxString &color) {
			WriteString(Key(wxT("backgroundcolor")), color);
		}
	};
};

#endif
