#include "ConfigDialog.h"
#include "Config.h"
#include "gura/Common.h"

//-----------------------------------------------------------------------------
// ConfigDialog
//-----------------------------------------------------------------------------
ConfigDialog::ConfigDialog(wxWindow *pParent, PageId pageId) :
		wxDialog(pParent, wxID_ANY, wxT("Configuration"),
						wxDefaultPosition, wxSize(400, 250))
{
	//SetIcon(wxICON(MainIcon));
	SetExtraStyle(wxWS_EX_VALIDATE_RECURSIVELY);
	wxSizer *pOuterBox = new wxBoxSizer(wxVERTICAL);
	SetSizer(pOuterBox);
	wxSizer *pVBox = new wxBoxSizer(wxVERTICAL);
	pOuterBox->Add(pVBox, wxSizerFlags(1).Expand().Border(wxALL, 4));
	wxNotebook *pNotebook = new wxNotebook(this, wxID_ANY);
	pVBox->Add(pNotebook, wxSizerFlags(1).Expand());
	pNotebook->SetPadding(wxSize(16, 4));
	pNotebook->AddPage(new Page_Terminal(pNotebook), wxT("Terminal"));
	pNotebook->SetSelection((pageId == PAGEID_Terminal)? 0 : 0);
	do {
		wxSizer *pHBox = new wxBoxSizer(wxHORIZONTAL);
		pVBox->Add(pHBox, wxSizerFlags(0).Expand().Border(wxTOP, 4));
		pHBox->AddStretchSpacer(1);
		wxWindow *pCtrl;
		pCtrl = new wxButton(this, wxID_OK, wxT("OK"),
							wxDefaultPosition, wxSize(80, 20));
		pHBox->Add(pCtrl, wxSizerFlags(0).Expand().Border(wxLEFT, 0));
		pCtrl->SetFocus();
		pCtrl = new wxButton(this, wxID_CANCEL, wxT("Cancel"),
							wxDefaultPosition, wxSize(80, 20));
		pHBox->Add(pCtrl, wxSizerFlags(0).Expand().Border(wxLEFT, 4));
	} while (0);
	CentreOnParent();
}

//-----------------------------------------------------------------------------
// ConfigDialog::Page_Terminal
//-----------------------------------------------------------------------------
ConfigDialog::Page_Terminal::Page_Terminal(wxWindow *pParent) : Page(pParent)
{
	wxSizer *pOuterBox = new wxBoxSizer(wxVERTICAL);
	SetSizer(pOuterBox);
	wxSizer *pVBox = new wxBoxSizer(wxVERTICAL);
	pOuterBox->Add(pVBox, wxSizerFlags(1).Expand().Border(wxALL, 8));
	do {
		wxSizer *pHBox = new wxBoxSizer(wxHORIZONTAL);
		pVBox->Add(pHBox, wxSizerFlags(0).Expand());
		do {
			wxStaticText *pCtrl = new wxStaticText(this, wxID_ANY,
					wxT("Font Size:"), wxDefaultPosition, wxSize(120, -1));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
		} while (0);
		do {
			static const int pointTbl[] = { 6, 8, 10, 12, 14, 18, 22, 27 };
			wxComboBox *pCtrl = new wxComboBox(this, wxID_ANY, wxT(""),
						wxDefaultPosition, wxSize(60, -1), 0, NULL, wxCB_READONLY,
						wxGenericValidator(&_fontSize));
			for (int i = 0; i < NUMBEROF(pointTbl); i++) {
				pCtrl->Append(wxString::Format(wxT("%d"), pointTbl[i]));
			}
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
		} while (0);
	} while (0);
	do {
		wxSizer *pHBox = new wxBoxSizer(wxHORIZONTAL);
		pVBox->Add(pHBox, wxSizerFlags(0).Expand().Border(wxTOP, 4));
		do {
			wxStaticText *pCtrl = new wxStaticText(this, wxID_ANY,
					wxT("Font Color:"), wxDefaultPosition, wxSize(120, -1));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
		} while (0);
		do {
			wxTextCtrl *pCtrl = new wxTextCtrl(this, wxID_ANY, wxT(""),
					wxDefaultPosition, wxSize(100, -1), 0,
					wxGenericValidator(&_fontColor));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
			_pTextFontColor = pCtrl;
		} while (0);
		do {
			wxButton *pCtrl = new wxButton(this, ID_BTN_FontColor, wxT("Choose"),
					wxDefaultPosition, wxSize(60, -1));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center().Border(wxLEFT, 4));
		} while (0);
	} while (0);
	do {
		wxSizer *pHBox = new wxBoxSizer(wxHORIZONTAL);
		pVBox->Add(pHBox, wxSizerFlags(0).Expand().Border(wxTOP, 4));
		do {
			wxStaticText *pCtrl = new wxStaticText(this, wxID_ANY,
					wxT("Background Color:"), wxDefaultPosition, wxSize(120, -1));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
		} while (0);
		do {
			wxTextCtrl *pCtrl = new wxTextCtrl(this, wxID_ANY, wxT(""),
					wxDefaultPosition, wxSize(100, -1), 0,
					wxGenericValidator(&_backgroundColor));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center());
			_pTextBackgroundColor = pCtrl;
		} while (0);
		do {
			wxButton *pCtrl = new wxButton(this, ID_BTN_BackgroundColor, wxT("Choose"),
					wxDefaultPosition, wxSize(60, -1));
			pHBox->Add(pCtrl, wxSizerFlags(0).Center().Border(wxLEFT, 4));
		} while (0);
	} while (0);
}

bool ConfigDialog::Page_Terminal::TransferDataToWindow()
{
	_fontSize = wxString::Format(wxT("%d"), Config::GuraShell::ReadFontSize());
	_fontColor = Config::GuraShell::ReadFontColor();
	_backgroundColor = Config::GuraShell::ReadBackgroundColor();
	return wxWindow::TransferDataToWindow();
}

bool ConfigDialog::Page_Terminal::TransferDataFromWindow()
{
	if (!wxWindow::TransferDataFromWindow()) return false;
	do {
		long val;
		_fontSize.ToLong(&val);
		Config::GuraShell::WriteFontSize(val);
	} while (0);
	Config::GuraShell::WriteFontColor(_fontColor);
	Config::GuraShell::WriteBackgroundColor(_backgroundColor);
	return true;
}

void ConfigDialog::Page_Terminal::ShowColourDialog(wxTextCtrl *pText)
{
	wxColourDialog dlg(this);
	if (dlg.ShowModal() == wxID_OK) {
		wxColour &color = dlg.GetColourData().GetColour();
		pText->SetValue(color.GetAsString(wxC2S_HTML_SYNTAX));
	}
}

BEGIN_EVENT_TABLE(ConfigDialog::Page_Terminal, ConfigDialog::Page)
	EVT_BUTTON(ID_BTN_FontColor,		ConfigDialog::Page_Terminal::OnButton_FontColor)
	EVT_BUTTON(ID_BTN_BackgroundColor,	ConfigDialog::Page_Terminal::OnButton_BackgroundColor)
END_EVENT_TABLE()

void ConfigDialog::Page_Terminal::OnButton_FontColor(wxCommandEvent &event)
{
	ShowColourDialog(_pTextFontColor);
}

void ConfigDialog::Page_Terminal::OnButton_BackgroundColor(wxCommandEvent &event)
{
	ShowColourDialog(_pTextBackgroundColor);
}
