#==============================================================================
# Makefile for Borland C++
#==============================================================================
!if !$d(GURADIR)
GURADIR = ..\..
!endif

WXDIR = $(GURADIR)\extra\wxMSW-2.8.11

TARGET = $(GURADIR)\gurashell.exe
SRCS = Application.cpp FrameMain.cpp FrameScribble.cpp PanelScribble.cpp
SRCS = $(SRCS) GuraShell.cpp ConfigDialog.cpp
SRCS = $(SRCS) Module_scribble.cpp
RCFILE = GuraShell.rc

#------------------------------------------------------------------------------
CFLAGS = -v -P -Od -a8 -g0 -D__WXMSW__ -DNOPCH -w-8057 -I. \
	-I$(MAKEDIR)\..\Include \
	-I$(WXDIR)\lib\bcc_lib\msw \
	-I$(WXDIR)\include \
	-I$(GURADIR)\include

RCFLAGS = -32 -r -d__WXMSW__  \
	-i$(MAKEDIR)\..\include \
	-i$(WXDIR)\lib\bcc_lib\msw \
	-i$(WXDIR)\include

LDFLAGS = -Tpe -q -v -aa \
	-L$(MAKEDIR)\..\Lib \
	-L$(MAKEDIR)\..\Lib\psdk \
	-L$(WXDIR)\lib\bcc_lib

OBJS = $(SRCS:.cpp=.obj)

RESFILE = $(RCFILE:.rc=.res)

LIBS = $(GURADIR)\lib\libgura.bcc.lib

LIBS_EX = wxbase28.lib wxmsw28_adv.lib wxmsw28_core.lib wxmsw28_html.lib \
	wxtiff.lib wxjpeg.lib wxpng.lib wxzlib.lib wxregex.lib wxexpat.lib \
	ole2w32.lib oleacc.lib odbc32.lib import32.lib cw32mt.lib

.cpp.obj:
	@bcc32 -q -c $(CFLAGS) -o$@ $<

.rc.res:
	@brcc32 $(RCFLAGS) -fo$@ $<

all: $(TARGET)

$(TARGET): $(OBJS) $(LIBS) $(RESFILE)
	@ilink32 $(LDFLAGS) $(LIBPATHFLAGS) c0w32.obj $(OBJS),$@,,$(LIBS) $(LIBS_EX),,$(RESFILE)
	@echo $@ was created

clean:
	@del $(TARGET) $(OBJS) $(RESFILE) \
		$(TARGET:.exe=.tds) $(TARGET:.exe=.map) \
		$(TARGET:.exe=.ils) $(TARGET:.exe=.ilf) \
		$(TARGET:.exe=.ild) $(TARGET:.exe=.ilc) \
		$(TARGET:.exe=.tr2) $(TARGET:.exe=.td2)
