#include "PanelScribble.h"

//-----------------------------------------------------------------------------
// PanelScribble
//-----------------------------------------------------------------------------
PanelScribble::PanelScribble(wxWindow *pParent, wxWindowID id, long style) :
	wxPanel(pParent, id, wxDefaultPosition, wxDefaultSize,
				style | wxTAB_TRAVERSAL | wxWANTS_CHARS),
	_pBmpSurface(new wxBitmap(1, 1))
{
}

BEGIN_EVENT_TABLE(PanelScribble, wxPanel)
	EVT_SIZE(PanelScribble::OnSize)
	EVT_ERASE_BACKGROUND(PanelScribble::OnEraseBackground)
	EVT_PAINT(PanelScribble::OnPaint)
	EVT_KEY_DOWN(PanelScribble::OnKeyDown)
	EVT_KEY_UP(PanelScribble::OnKeyUp)
END_EVENT_TABLE()

void PanelScribble::OnSize(wxSizeEvent &event)
{
	wxSize size = GetClientSize();
	delete _pBmpSurface;
	_pBmpSurface = new wxBitmap(size.GetWidth(), size.GetHeight());
	wxMemoryDC dcMem(*_pBmpSurface);
	dcMem.SetBrush(*wxWHITE_BRUSH);
	dcMem.Clear();
}

void PanelScribble::OnEraseBackground(wxEraseEvent &event)
{
}

void PanelScribble::OnPaint(wxPaintEvent &event)
{
	wxPaintDC dc(this);
	if (_pBmpSurface != NULL) {
		dc.DrawBitmap(*_pBmpSurface, 0, 0);
	}
}

void PanelScribble::OnKeyDown(wxKeyEvent &event)
{
	_keyCodesPressed.insert(event.GetKeyCode());
}

void PanelScribble::OnKeyUp(wxKeyEvent &event)
{
	_keyCodesPressed.erase(event.GetKeyCode());
}
