#ifndef __OBJECT_AUDIO_H__
#define __OBJECT_AUDIO_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Audio
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Audio : public Class {
public:
	Class_Audio(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Audio
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Audio : public Object {
public:
	enum Format {
		FORMAT_None,
		FORMAT_U8, FORMAT_S8,
		FORMAT_U16LE, FORMAT_S16LE, FORMAT_U16BE, FORMAT_S16BE,
	};
public:
	inline static Object_Audio *GetSelfObj(Args &args) {
		return dynamic_cast<Object_Audio *>(args.GetSelfObj());
	}
private:
	Format _format;
	size_t _nChannels;
	size_t _nLen;
	Object *_pObjRef;
	void *_buff;
	OAL::LargeMemory _largeMem;
public:
	inline Object_Audio(Environment &env, Format format, size_t nChannels) :
				Object(env.LookupClass(VTYPE_Audio)), _format(format), _nChannels(nChannels),
				_nLen(0), _pObjRef(NULL), _buff(NULL) {}
	inline Object_Audio(Class *pClass, Format format, size_t nChannels) :
				Object(pClass), _format(format), _nChannels(nChannels),
				_nLen(0), _pObjRef(NULL), _buff(NULL) {}
	virtual ~Object_Audio();
	virtual Object *Clone() const;
	inline bool IsValid() const { return _buff != NULL; }
	inline Format GetFormat() const { return _format; }
	inline size_t GetChannels() const { return _nChannels; }
	inline size_t GetLength() const { return _nLen; }
	inline size_t GetBytesPerData() const {
		return (_format == FORMAT_U8 || _format == FORMAT_S8)? 1 : 2;
	}
	bool CheckEmpty(Signal sig) const;
	bool CheckValid(Signal sig) const;
	void ReferenceBuffer(Object *pObjRef, void *buff, size_t nLen);
	bool AllocBuffer(Signal sig, size_t nLen);
	void FreeBuffer();
	static Format SymbolToFormat(Signal sig, const Symbol *pSymbol);
	static const Symbol *FormatToSymbol(Format format);
	virtual Value DoPropGet(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value DoPropSet(Signal sig, const Symbol *pSymbol,
									const Value &value, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
