#ifndef __OBJECT_STREAM_H__
#define __OBJECT_STREAM_H__

#include "Object.h"
#include "Stream.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Stream
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Stream : public Class {
public:
	Class_Stream(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Stream
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Stream : public Object {
public:
	class IteratorLine : public Iterator {
	private:
		Object_Stream *_pObj;
		int _nLinesMax;
		bool _includeEOLFlag;
		int _nLines;
	public:
		inline IteratorLine(Object_Stream *pObj, int nLinesMax, bool includeEOLFlag) :
			Iterator(pObj->GetStream().IsInfinite()), _pObj(pObj), _nLinesMax(nLinesMax),
			_includeEOLFlag(includeEOLFlag), _nLines(0) {}
		virtual ~IteratorLine();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_Stream *GetSelfObj(Args &args) {
		return dynamic_cast<Object_Stream *>(args.GetSelfObj());
	}
protected:
	std::auto_ptr<Stream> _pStream;
public:
	inline Object_Stream(Environment &env, Stream *pStream) :
						Object(env.LookupClass(VTYPE_Stream)), _pStream(pStream) {}
	inline Object_Stream(Class *pClass, Stream *pStream) :
						Object(pClass), _pStream(pStream) {}
	inline Stream &GetStream() { return *_pStream; }
	virtual String ToString(Signal sig, bool exprFlag);
};

//-----------------------------------------------------------------------------
// StreamFactory
//-----------------------------------------------------------------------------
class DLLDECLARE StreamFactory {
public:
	typedef std::vector<StreamFactory *> List;
private:
	static List *_pList;
public:
	virtual bool IsResponsible(Signal sig, const char *name) = 0;
	virtual Object_Stream *DoOpen(Environment &env, Signal sig,
			const char *name, const char *mode, const char *encoding) = 0;
public:
	static void Register(StreamFactory *pStreamFactory);
	static Object_Stream *Open(Environment &env, Signal sig,
			const char *name, const char *mode = "r", const char *encoding = "utf-8");
	static StreamFactory *FindResponsible(Signal sig, const char *name);
};

}

#endif
