#pragma once
#include "GVONoncopyable.h"
#include "GVOVector.h"
#include "GVOImage.h"

class GVOConfig;
class GVOWorldMap;
class GVOTexture;
class GVOShipRouteList;

class GVORenderer :private GVONoncopyable {
private:
	const GVOWorldMap * m_worldMap;	//!<@brief En}
	GVOTexture * m_worldMapTexture;	//!<@brief En}eNX`[

	HDC m_hdcPrimary;
	HGLRC m_hglrc;
	GVOImage m_backBuffer;

	SIZE m_viewSize;
	double m_viewScale;

	POINT m_focusPointInWorldCoord;		//!<@brief ʒɈʒusNZ̐EW
	POINT m_shipPointInWorld;			//!<@brief D̈ʒu
	bool m_shipVectorLineEnabled;		//!<@brief jH`tO
	bool m_speedMeterEnabled;			//!<@brief xv`tO
	bool m_traceShipEnabled;			//!<@brief DʒuǏ]tO

public:
	GVORenderer() :
		m_hdcPrimary(),
		m_viewSize(),
		m_viewScale(1.0),
		m_focusPointInWorldCoord(),
		m_shipPointInWorld(),
		m_shipVectorLineEnabled( true ),
		m_speedMeterEnabled( true ),
		m_traceShipEnabled( true )
	{
	}
	~GVORenderer()
	{
	}

	void setup( const GVOConfig * config, HDC hdcPrimary, const GVOWorldMap * worldMap );
	void teardown();

	void setViewSize( const SIZE& viewSize );

	bool zoomIn();
	bool zoomOut();
	void resetViewScale();

	inline double viewScale() const
	{
		return m_viewScale;
	}

	//!@note hbOp
	void offsetFocusInViewCoord( const POINT& offset );

	//!@brief D̏Ԃݒ肷
	void setShipPositionInWorld( const POINT& shipPositionInWorld );

	void enableTraceShip( bool enabled )
	{
		m_traceShipEnabled = enabled;
	}

	void setVisibleShipRoute( bool visible )
	{
		m_shipVectorLineEnabled = visible;
	}

	void render( const GVOVector& shipVector, double shipVelocity, const GVOShipRouteList * shipRouteList );

	void enableSpeedMeter( bool enabled )
	{
		m_speedMeterEnabled = enabled;
	}
private:
	//!@brief ݒŏ
	void setConfig( const GVOConfig * config );
	void setupGL();
	void setWorldMap( const GVOWorldMap * worldMap );
	SIZE scaledMapSize() const;
	POINT mapOriginInView() const;
	POINT drawOffsetFromWorldCoord( const POINT&worldCoord ) const;
	void renderMap( const GVOVector& shipVector, const GVOShipRouteList * shipRouteList );
	void renderShipRouteList(int width, int height, const GVOShipRouteList * shipRouteList );
	void renderSpeedMeter( double shipVelocity );
	void renderTexture( float w, float h );
	void renderTexture( float x, float y, float w, float h );
	inline POINT viewCenterPoint() const
	{
		POINT p = {
			m_viewSize.cx / 2,
			m_viewSize.cy / 2
		};
		return p;
	}
};
