#include "stdafx.h"
#include "GVONavish.h"
#include "GVOGameProcess.h"
#include "GVOWorldMap.h"
#include "GVOSurveyCoordExtractor.h"


// 摜̓fobOpBGVOGameProcess
//#define GVO_ANALYZE_DEBUG

namespace {
#ifdef GVO_ANALYZE_DEBUG
	LPCWSTR const k_debugImageFileName = L"..\\debug.png";
#endif

	LPWSTR const k_gvoWindowClassName = L"Greate Voyages Online Game MainFrame";
	LPWSTR const k_gvoWindowCaption = L"qC Online";

	const POINT k_surveyCoordOffsetFromRightBottom = { 70, 273 };
	const SIZE k_surveyCoordSize = { 60, 11 };
};



void GVOGameProcess::clear()
{
	if ( m_process ) {
		::CloseHandle( m_process );
		m_process = NULL;
	}
	m_window = NULL;
}


void GVOGameProcess::setConfig( const GVOConfig& config )
{
	m_surveyCoord = config.m_initialSurveyCoord;
}

bool GVOGameProcess::updateState()
{
#ifdef GVO_ANALYZE_DEBUG
	{
		static bool done = false;
		if ( !done ) {
			done = true;
		}
		else {
			return false;
		}

		static GVOImage debugImage;
		if ( !debugImage.bitmapHandle() ) {
			if ( !debugImage.loadFromFile( ::g_makeFullPath( k_debugImageFileName ) ) ) {
				::MessageBox( NULL, L"fobOC[WȂ", L"[", MB_ICONERROR );
				exit( 0 );
			}
		}
		HDC hdc = ::GetWindowDC( ::GetDesktopWindow() );
		HDC hdcMem = ::CreateCompatibleDC( hdc );
		::SaveDC( hdcMem );
		::SelectObject( hdcMem, debugImage.bitmapHandle() );
		grabImage( hdcMem, POINT(), debugImage.size() );

		::RestoreDC( hdcMem, -1 );
		::DeleteDC( hdcMem );
		::ReleaseDC( NULL, hdc );

		updateSurveyCoord();
		return true;
	}
#endif
	if ( !m_window ) {
		m_window = ::FindWindow( k_gvoWindowClassName, k_gvoWindowCaption );
	}
	if ( m_window ) {
		if ( !m_process ) {
			DWORD pid = 0;
			::GetWindowThreadProcessId( m_window, &pid );
			m_process = ::OpenProcess( SYNCHRONIZE, FALSE, pid );
		}

		RECT rc;
		POINT clientOrg = { 0 };
		::ClientToScreen( m_window, &clientOrg );
		::GetClientRect( m_window, &rc );
		SIZE size;
		size.cx = rc.right;
		size.cy = rc.bottom;

		HDC hdc = ::GetDC( ::GetDesktopWindow() );
		if ( !hdc ) {
			return false;
		}
		grabImage( hdc, clientOrg, size );
		::ReleaseDC( ::GetDesktopWindow(), hdc );
		m_timeStamp = ::timeGetTime();

		if ( !updateSurveyCoord() ) {
			return false;
		}
		return true;
	}
	return false;
}

void GVOGameProcess::grabImage( HDC hdc, const POINT& offset, const SIZE& size )
{
	if ( !m_surveyCoordImage.bitmapHandle() ) {
		m_surveyCoordImage.createDIBImage( k_surveyCoordSize );
	}

	HDC hdcMem = ::CreateCompatibleDC( hdc );
	::SaveDC( hdcMem );

	const int leftEdge = offset.x;
	const int rightEdge = leftEdge + size.cx;
	const int topEdge = offset.y;
	const int bottomEdge = offset.y + size.cy;

	// ʍWLv`
	const int xSurvey = rightEdge - k_surveyCoordOffsetFromRightBottom.x;
	const int ySurvey = bottomEdge - k_surveyCoordOffsetFromRightBottom.y;
	::SelectObject( hdcMem, m_surveyCoordImage.bitmapHandle() );
	::BitBlt( hdcMem, 0, 0, k_surveyCoordSize.cx, k_surveyCoordSize.cy, hdc, xSurvey, ySurvey, SRCCOPY );
	::GdiFlush();

	::RestoreDC( hdcMem, -1 );
	::DeleteDC( hdcMem );
}

bool GVOGameProcess::updateSurveyCoord()
{
	bool succeeded = false;
	GVOSurveyCoordExtractor extractor( m_surveyCoordImage );

	const std::vector<int>& values = extractor.extractNumbers();
	if ( values.size() == 2 ) {
		m_surveyCoord.x = values[0];
		m_surveyCoord.y = values[1];
		succeeded = true;
	}
	return succeeded;
}
