#pragma once
#include "GVONoncopyable.h"
#include "GVOVector.h"
#include "GVOImage.h"

class GVOConfig;
class GVOWorldMap;

class GVORenderer :private GVONoncopyable {
private:
	const GVOWorldMap * m_worldMap;	//!<@brief En}
	GVOImage m_mapImage;			//!<@brief En}摜q

	HDC m_hdcPrimary;
	GVOImage m_backBuffer;

	SIZE m_viewSize;
	double m_viewScale;

	POINT m_focusPointInWorldCoord;		//!<@brief ʒɈʒusNZ̐EW
	POINT m_shipPointInWorld;			//!<@brief D̈ʒu
	bool m_positionUpdated;				//!<@brief D̈ʒuXV
	POINT m_previousDrawPointInWorld;	//!<@brief O̕`ʒu
	bool m_linkRoute;					//!<@brief qHqĕ`悷tO
	bool m_shipVectorLineEnabled;		//!<@brief jH`tO
	bool m_speedMeterEnabled;			//!<@brief xv`tO
	bool m_traceShipEnabled;			//!<@brief DʒuǏ]tO
	GVOVector m_shipVector;
	double m_shipVelocity;

public:
	GVORenderer() :
		m_hdcPrimary(),
		m_viewSize(),
		m_viewScale(1.0),
		m_focusPointInWorldCoord(),
		m_shipPointInWorld(),
		m_positionUpdated(),
		m_previousDrawPointInWorld(),
		m_linkRoute( true ),
		m_shipVectorLineEnabled( true ),
		m_speedMeterEnabled( true ),
		m_traceShipEnabled( true ),
		m_shipVector(),
		m_shipVelocity()
	{
	}
	~GVORenderer()
	{
	}

	void setup( HDC hdcPrimary );
	void teardown();

	void setWorldMap( const GVOWorldMap& worldMap );

	//!@brief ݒŏ
	void setConfig( const GVOConfig& config );

	void setViewSize( const SIZE& viewSize );
private:
	SIZE scaledMapSize() const;
	POINT mapOriginInView() const;

public:
	bool zoomIn();
	bool zoomOut();
	void resetViewScale();

	inline double viewScale() const
	{
		return m_viewScale;
	}

	//!@note hbOp
	void offsetFocusInViewCoord( const POINT& offset );

	//!@brief D̏Ԃݒ肷
	void updateShipState( const POINT& worldCoord, const GVOVector& shipVector, const double shipVelocity );
	void enableTraceShip( bool enabled )
	{
		m_traceShipEnabled = enabled;
	}
	void setVisibleShipRoute( bool visible )
	{
		m_shipVectorLineEnabled = visible;
	}
	void clearShipRoute();
	void render();
	void enableSpeedMeter( bool enabled )
	{
		m_speedMeterEnabled = enabled;
	}
private:
	POINT drawOffsetFromWorldCoord( const POINT&worldCoord ) const;
	void updateShipRouteMap();
	void drawMap( HDC hdc, const GVOVector& shipVector );
	void drawSpeedMeter( HDC hdc, double shipVelocity );
	inline POINT viewCenterPoint() const
	{
		POINT p = {
			m_viewSize.cx / 2,
			m_viewSize.cy / 2
		};
		return p;
	}
};
