#include <QPushButton>
#include <QMessageBox>
#include "StatisticsDlg.h"

StatisticsDlg::StatisticsDlg(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);
	QPushButton *ok = ui.buttonBox->button(QDialogButtonBox::Ok);
	ok->setDefault(true);
	ok->setFocus(Qt::OtherFocusReason);
	QPushButton *reset = ui.buttonBox->button(QDialogButtonBox::Reset);
	connect(reset, SIGNAL(clicked()), this, SLOT(onReset()));
}

StatisticsDlg::~StatisticsDlg()
{
}
void StatisticsDlg::updateText()
{
	QString text;
	emit statisticsText(text);
	setText(text);
}
void StatisticsDlg::setText(const QString &text)
{
	ui.label->setText(text);
}
void StatisticsDlg::onReset()
{
	if( QMessageBox::question(this, qApp->applicationName(), tr("Are You Sure to Clear Statistics ?"),
								QMessageBox::Yes | QMessageBox::No)
				== QMessageBox::Yes )
	{
		emit clearStatistics();
		updateText();
	}
}
