#include <QtGui>
#include <QColorDialog>
#include "SettingsDlg.h"

SettingsDlg::SettingsDlg(QWidget *parent)
	: QDialog(parent)
{
	ui.setupUi(this);
	connect(ui.humanColorButton, SIGNAL(clicked()), this, SLOT(onHumanColor()));
	connect(ui.compColorButton, SIGNAL(clicked()), this, SLOT(onCompColor()));
}

SettingsDlg::~SettingsDlg()
{

}
void SettingsDlg::onHumanColor()
{
	QColor col = QColorDialog::getColor(QColor(ui.humanColor->text()), this);
	if( col.isValid() )
		ui.humanColor->setText(col.name());
}
void SettingsDlg::onCompColor()
{
	QColor col = QColorDialog::getColor(QColor(ui.compColor->text()), this);
	if( col.isValid() )
		ui.compColor->setText(col.name());
}
QString SettingsDlg::humanColor() const
{
	return ui.humanColor->text();
}
QString SettingsDlg::compColor() const
{
	return ui.compColor->text();
}
int SettingsDlg::animationSpeed() const
{
	return ui.animationSpeed->value();
}
bool SettingsDlg::autoMoveDst() const
{
	return ui.automaticMoveToDest->isChecked();
}
bool SettingsDlg::undoAvailable() const
{
	return ui.undoAvailable->isChecked();
}

void SettingsDlg::setHumanColor(const QString &text)
{
	ui.humanColor->setText(text);
}
void SettingsDlg::setCompColor(const QString &text)
{
	ui.compColor->setText(text);
}
void SettingsDlg::setAnimationSpeed(int v)
{
	ui.animationSpeed->setValue(v);
}
void SettingsDlg::setAutoMoveDst(bool b)
{
	ui.automaticMoveToDest->setChecked(b);
}
void SettingsDlg::setUndoAvailable(bool b)
{
	ui.undoAvailable->setChecked(b);
}
