#include "spcf/core/GrammarTransition.hpp"

namespace spcf {

	class GrammarTransition_i {
	public:
		GrammarPhrasePtr phrase_;
		Grammar::State startState_;
		Grammar::State endState_;
		
	public:
		GrammarTransition_i(
			const GrammarPhrasePtr& phrase,
			const Grammar::State& startState,
			const Grammar::State& endState) : phrase_(phrase), startState_(startState), endState_(endState)
		{
		}
	};

	GrammarTransition::GrammarTransition(
		const GrammarPhrasePtr& phrase,
		const Grammar::State& startState,
		const Grammar::State& endState) : impl(new GrammarTransition_i(phrase, startState, endState))
	{
	}

	GrammarTransition::~GrammarTransition() {
		delete impl;
	}

	const GrammarPhrasePtr& GrammarTransition::getPhrase() const {
		return impl->phrase_;
	}

	const Grammar::State& GrammarTransition::getStartState() const {
		return impl->startState_;
	}

	const Grammar::State& GrammarTransition::getEndState() const {
		return impl->endState_;
	}

}  // namespace spcf
