/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarCommonImpl.cpp 52 2011-05-17 06:24:31Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#include "spcf/grammar/GrammarCommonImpl.hpp"

#include "spcf/core/GrammarPhrase.hpp"
#include "spcf/core/GrammarTransition.hpp"

using namespace std;

namespace spcf {

	class GrammarCommonImpl_i {
	public:
		string name_;
		Grammar::GrammarTransitionList transitionList_;

	public:
		GrammarCommonImpl_i(const string& name);
	};

	GrammarCommonImpl::GrammarCommonImpl(const string& name) : impl(new GrammarCommonImpl_i(name)) {
	}

	GrammarCommonImpl::~GrammarCommonImpl() {
		delete impl;
	}

	string GrammarCommonImpl::getName() {
		return impl->name_;
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const GrammarTransitionPtr& transition) {
		impl->transitionList_.push_back(transition);
		return transition;
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const std::string& phrase, const Grammar::State& startState, const Grammar::State& endState) {
		return addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(GrammarPhrasePtr(new GrammarPhrase(phrase)), startState, endState)));
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const std::string& phrase, const std::string& propertyName, const Grammar::State& startState, const Grammar::State& endState) {
		return addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(GrammarPhrasePtr(new GrammarPhrase(phrase, propertyName)), startState, endState)));
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const std::string& phrase, const std::string& propertyName, int propertyInt, const Grammar::State& startState, const Grammar::State& endState) {
		return addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(GrammarPhrasePtr(new GrammarPhrase(phrase, propertyName, propertyInt)), startState, endState)));
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const std::string& phrase, const std::string& propertyName, const std::string& propertyString, const Grammar::State& startState, const Grammar::State& endState) {
		return addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(GrammarPhrasePtr(new GrammarPhrase(phrase, propertyName, propertyString)), startState, endState)));
	}

	GrammarTransitionPtr GrammarCommonImpl::addGrammarTransition(const std::string& phrase, const std::string& propertyName, int propertyInt, const std::string& propertyString, const Grammar::State& startState, const Grammar::State& endState) {
		return addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(GrammarPhrasePtr(new GrammarPhrase(phrase, propertyName, propertyInt, propertyString)), startState, endState)));
	}

	Grammar::GrammarTransitionList::const_iterator GrammarCommonImpl::beginTransitions() {
		return impl->transitionList_.begin();
	}

	Grammar::GrammarTransitionList::const_iterator GrammarCommonImpl::endTransitions() {
		return impl->transitionList_.end();
	}

	void GrammarCommonImpl::addGrammarTransition(Grammar& grammar, const Grammar::State& prefix, const Grammar::State& startState, const Grammar::State& endState) {
		addGrammarTransition(grammar, grammar.getName(), startState, endState);
	}

	void GrammarCommonImpl::addGrammarTransition(Grammar& grammar, const Grammar::State& startState, const Grammar::State& endState) {
		for(Grammar::GrammarTransitionList::const_iterator i = grammar.beginTransitions(); i != grammar.endTransitions(); ++i) {
			const GrammarTransitionPtr& transition = *i;
			addGrammarTransition(GrammarTransitionPtr(new GrammarTransition(
				transition->getPhrase(),
				(transition->getStartState() == Grammar::START_STATE_NAME) ? startState : grammar.getName() + "." + transition->getStartState(),
				(transition->getEndState() == Grammar::FINISH_STATE_NAME) ? endState : grammar.getName() + "." + transition->getEndState())));
		}
	}

	GrammarCommonImpl_i::GrammarCommonImpl_i(const string& name) : name_(name) {
	}

}  // namespace spcf
